/*
 * Decompiled with CFR 0.152.
 */
package org.statcato.dialogs.data;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.statcato.DialogEdit;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.utils.HelperFunctions;

public class ArbitraryDataPatternDialog
extends StatcatoDialog {
    private JButton CancelButton;
    private JTextArea DataTextArea;
    private JButton OKButton;
    private JTextField RepeatItemTextField;
    private JTextField RepeatSeqTextField;
    private JTextField StoreTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public ArbitraryDataPatternDialog(Frame parent, boolean modal, Statcato app) {
        super(parent, modal);
        this.ParentSpreadsheet = app.getSpreadsheet();
        this.app = app;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.OKButton);
        this.setHelpFile("data-data-sequence");
        this.name = "Arbitrary Data Pattern";
        this.description = "For generating repeated values of an arbitrary data sequence.";
        this.helpStrings.add("Provide the column(s) in which the results should be stored.");
        this.helpStrings.add("Provide the arbitrary data sequence and the numberof times that each item and the sequence should be repeated.");
    }

    private void initComponents() {
        this.OKButton = new JButton();
        this.CancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.StoreTextField = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.DataTextArea = new JTextArea();
        this.jLabel5 = new JLabel();
        this.RepeatSeqTextField = new JTextField();
        this.RepeatItemTextField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Arbitrary Data Pattern");
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArbitraryDataPatternDialog.this.OKButtonActionPerformed(evt);
            }
        });
        this.CancelButton.setText("Cancel");
        this.CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArbitraryDataPatternDialog.this.CancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Results"));
        this.jLabel7.setText("<html>\n- Enter valid column names separated by space.<br>\nFor a continuous range of columns, separate using dash (e.g. C1-C30).<br>\n- The random sampling process is repeated for each column.\n</html>\n");
        this.jLabel1.setText("Store data pattern in:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.StoreTextField, -2, 189, -2))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.StoreTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7, -2, -1, -2).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Options"));
        this.DataTextArea.setColumns(20);
        this.DataTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.DataTextArea);
        this.jLabel5.setText("Number of times to list each value:");
        this.jLabel6.setText("Number of times to list each sequence:");
        this.jLabel2.setText("<html>\nArbitrary Data Sequence:<br>\n (separate values by space; enclose string values by double quotes \"\")\n\n</html>");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 306, -2).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.RepeatItemTextField, -2, 68, -2).addComponent(this.RepeatSeqTextField, -2, 66, -2))).addComponent(this.jLabel2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.RepeatItemTextField, this.RepeatSeqTextField);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, -1, -2).addGap(29, 29, 29).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.RepeatItemTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.RepeatSeqTextField, -2, -1, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(130, 130, 130).addComponent(this.OKButton, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CancelButton))).addContainerGap(19, Short.MAX_VALUE)));
        layout.linkSize(0, this.CancelButton, this.OKButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.CancelButton).addComponent(this.OKButton)).addGap(16, 16, 16)));
        this.pack();
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        int i;
        this.app.compoundEdit = new DialogEdit("data pattern");
        String StoreColumn = this.StoreTextField.getText();
        String str = this.DataTextArea.getText();
        if (this.countDoubleQuotes(str) % 2 != 0) {
            this.app.showErrorDialog("unmatched double quotes");
            return;
        }
        Vector<String> data = this.parseDataSequence(str);
        int repeatNum = 0;
        try {
            repeatNum = Integer.parseInt(this.RepeatItemTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter an integer for the number of repetitions for each value.");
            return;
        }
        int repeatSeq = 0;
        try {
            repeatSeq = Integer.parseInt(this.RepeatSeqTextField.getText());
        }
        catch (NumberFormatException e) {
            this.app.showErrorDialog("Enter an integer for the number of repetitions for the number pattern.");
            return;
        }
        Vector<String> Pattern = new Vector<String>();
        for (int seq = 0; seq < repeatSeq; ++seq) {
            for (i = 0; i < data.size(); ++i) {
                String value = data.elementAt(i).trim();
                for (int repeat = 0; repeat < repeatNum; ++repeat) {
                    Pattern.addElement(value);
                }
            }
        }
        Vector<Integer> nums = this.ParentSpreadsheet.getColumnNumbersFromString(StoreColumn);
        if (nums == null) {
            this.app.showErrorDialog("Invalid column(s) for storing results.");
            return;
        }
        for (i = 0; i < nums.size(); ++i) {
            this.ParentSpreadsheet.setColumn(nums.elementAt(i), Pattern);
        }
        String text = "Data sequence: " + HelperFunctions.convertVectorToString(data) + "<br>";
        text = text + "Number of times to list each number: " + repeatNum + "<br>";
        text = text + "Number of times to list each sequence: " + repeatSeq;
        this.app.addLogParagraph("Generate Arbitrary Data Sequence in " + StoreColumn, text);
        this.app.compoundEdit.end();
        this.app.addCompoundEdit(this.app.compoundEdit);
        this.setVisible(false);
    }

    Vector<String> parseDataSequence(String str) {
        Vector<String> result = new Vector<String>();
        int i = 0;
        String value = "";
        while (i < str.length()) {
            if (Character.isWhitespace(str.charAt(i))) {
                if (!value.equals("")) {
                    result.addElement(value);
                    value = "";
                }
                ++i;
                continue;
            }
            if (str.charAt(i) == '\"') {
                if (!value.equals("")) {
                    result.addElement(value);
                    value = "";
                }
                ++i;
                while (str.charAt(i) != '\"') {
                    value = value + str.charAt(i);
                    ++i;
                }
                ++i;
                if (value.equals("")) continue;
                result.addElement(value);
                value = "";
                continue;
            }
            value = value + str.charAt(i);
            ++i;
        }
        if (!value.equals("")) {
            result.addElement(value);
        }
        return result;
    }

    int countDoubleQuotes(String str) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\"') continue;
            ++count;
        }
        return count;
    }

    private void CancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

