/*
 * Decompiled with CFR 0.152.
 */
package org.statcato;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.statcato.Statcato;
import org.statcato.spreadsheet.Spreadsheet;

public class StatcatoDialog
extends JDialog {
    private static final int HELP_MSG_DELAY = 5;
    protected Statcato app;
    protected Spreadsheet ParentSpreadsheet;
    protected String helpFileName = "overview";
    protected String name = "Statcato dialog";
    protected String description = "";
    protected ArrayList<String> helpStrings;
    private JMenuItem helpMenuItem;

    public StatcatoDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        JMenuBar menu = new JMenuBar();
        this.helpMenuItem = new JMenuItem("Help");
        this.app = (Statcato)parent;
        menu.add(this.helpMenuItem);
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.setJMenuBar(menu);
        this.helpStrings = new ArrayList();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                StatcatoDialog.this.app.clearStatus();
                StatcatoDialog.this.app.clearStatusTimerList();
            }
        });
    }

    public void setDialogName(String name) {
        this.name = name;
    }

    public void setHelpFile(String name) {
        this.helpFileName = name;
        if (this.app != null) {
            this.app.addDialogHelp(this.helpMenuItem, this.helpFileName);
        }
    }

    public void updateElements() {
    }

    @Override
    public void setVisible(boolean state) {
        if (state) {
            this.ParentSpreadsheet = this.app.getSpreadsheet();
            this.updateElements();
            this.app.clearStatusTimerList();
            this.app.setStatus(this.name + " Dialog opened. " + this.description);
            int i = 1;
            for (int j = 0; j < 5; ++j) {
                for (String element : this.helpStrings) {
                    this.app.setStatusTimer(element, 5 * i);
                    ++i;
                }
                this.app.setStatusTimer("", 5 * i);
                ++i;
            }
        } else {
            this.app.clearStatus();
            this.app.clearStatusTimerList();
        }
        super.setVisible(state);
    }

    @Override
    public void dispose() {
        this.app.clearStatus();
        super.dispose();
    }

    protected void updateComboBox(JComboBox comboBox) {
        String selected = (String)comboBox.getSelectedItem();
        this.ParentSpreadsheet.populateComboBox(comboBox);
        comboBox.setSelectedItem(selected);
    }

    protected void clearMutableColumnsList(JList list) {
        DefaultListModel listModel = (DefaultListModel)list.getModel();
        listModel.clear();
    }

    protected void updateColumnsList(JList list) {
        Object[] selected = list.getSelectedValues();
        this.ParentSpreadsheet.populateColumnsList(list);
        if (selected.length > 0) {
            int[] indices = new int[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                list.setSelectedValue(selected[i], false);
                indices[i] = list.getSelectedIndex();
            }
            list.setSelectedIndices(indices);
        }
    }

    protected void updateAllColumnsList(JList list) {
        Object[] selected = list.getSelectedValues();
        this.ParentSpreadsheet.populateAllColumnsList(list);
        if (selected.length > 0) {
            int[] indices = new int[selected.length];
            for (int i = 0; i < selected.length; ++i) {
                list.setSelectedValue(selected[i], false);
                indices[i] = list.getSelectedIndex();
            }
            list.setSelectedIndices(indices);
        }
    }

    @Override
    public String toString() {
        return this.name;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 517, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 502, Short.MAX_VALUE));
        this.pack();
    }
}

