/*
 * Decompiled with CFR 0.152.
 */
package org.statcato;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.statcato.Statcato;
import org.statcato.spreadsheet.Spreadsheet;
import org.statcato.spreadsheet.SpreadsheetScrollPane;

public class DatasheetTabbedPane
extends JTabbedPane
implements MouseListener,
Serializable {
    private transient Statcato app;
    private transient MouseListener popupListener;
    private transient int[] KeyMneumonics = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};

    public DatasheetTabbedPane(Statcato mTab, MouseListener popupListener) {
        this.app = mTab;
        this.popupListener = popupListener;
        this.initialize();
        this.addMouseListener(this);
    }

    private void initialize() {
        SpreadsheetScrollPane Pane = new SpreadsheetScrollPane(this.app);
        Pane.getSpreadsheet().addMouseListener(this.popupListener);
        this.addTab("Datasheet 1", Pane);
        this.setMnemonicAt(0, 49);
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        super.addTab(title, new CloseTabIcon(extraIcon), component);
    }

    public void addDatasheet() {
        SpreadsheetScrollPane Pane = new SpreadsheetScrollPane(this.app);
        Pane.getSpreadsheet().addMouseListener(this.popupListener);
        int tabCount = this.getTabCount() + 1;
        this.addTab("Datasheet " + tabCount, Pane);
        if (tabCount <= this.KeyMneumonics.length) {
            this.setMnemonicAt(tabCount - 1, this.KeyMneumonics[tabCount - 1]);
        }
        this.setSelectedIndex(this.indexOfComponent(Pane));
        this.app.addUndoListenerToDatasheet();
    }

    public void addDatasheet(String contents, File file) {
        SpreadsheetScrollPane Pane = new SpreadsheetScrollPane(this.app);
        Pane.getSpreadsheet().addMouseListener(this.popupListener);
        int tabCount = this.getTabCount() + 1;
        if (file == null) {
            this.addTab("Datasheet " + tabCount, Pane);
        } else {
            this.addTab(file.getName(), Pane);
        }
        if (tabCount <= this.KeyMneumonics.length) {
            this.setMnemonicAt(tabCount - 1, this.KeyMneumonics[tabCount - 1]);
        }
        this.setSelectedIndex(this.indexOfComponent(Pane));
        Spreadsheet ThisSpreadsheet = Pane.getSpreadsheet();
        ThisSpreadsheet.setDataUnchangedStatus(contents);
        ThisSpreadsheet.setFile(file);
        this.app.addUndoListenerToDatasheet();
    }

    public void addDatasheet(Spreadsheet ThisSpreadsheet) {
        SpreadsheetScrollPane Pane = new SpreadsheetScrollPane(this.app, ThisSpreadsheet);
        Pane.getSpreadsheet().addMouseListener(this.popupListener);
        int tabCount = this.getTabCount() + 1;
        this.addTab("Datasheet " + tabCount, Pane);
        if (tabCount <= this.KeyMneumonics.length) {
            this.setMnemonicAt(tabCount - 1, this.KeyMneumonics[tabCount - 1]);
        }
        this.setSelectedIndex(this.indexOfComponent(Pane));
        this.app.addUndoListenerToDatasheet();
    }

    public void addDatasheets(DatasheetTabbedPane pane) {
        for (int i = 0; i < pane.getTabCount(); ++i) {
            SpreadsheetScrollPane tab = (SpreadsheetScrollPane)this.getComponentAt(i);
            Spreadsheet sheet = tab.getSpreadsheet();
            this.addDatasheet(sheet);
        }
    }

    public int closeCurrentDatasheet() {
        int i = this.getSelectedIndex();
        Object[] options = new Object[]{"Yes, close Datasheet anyway", "Cancel"};
        if (i != -1) {
            int choice;
            SpreadsheetScrollPane tab = (SpreadsheetScrollPane)this.getComponentAt(i);
            if (tab.getChangedStatus() && ((choice = JOptionPane.showOptionDialog(this, this.app.getCurrentTabTitle() + " is not yet saved.  " + "Do you want to close it anyway?", "Unsaved Datasheet...", 0, 3, null, options, options[1])) == 1 || choice == -1)) {
                this.setSelectedIndex(i);
                return -1;
            }
            this.remove(i);
        }
        if (this.getTabCount() == 0) {
            this.addDatasheet();
        }
        this.app.clearUndoManager();
        return 0;
    }

    public int closePane() {
        Object[] options = new Object[]{"Yes, close anyway", "Cancel"};
        for (int i = 0; i < this.getTabCount(); ++i) {
            SpreadsheetScrollPane tab = (SpreadsheetScrollPane)this.getComponentAt(i);
            if (!tab.getChangedStatus()) continue;
            int choice = JOptionPane.showOptionDialog(this, "There is a Datasheet that is not saved.  Do you want to close anyway?", "Unsaved Datasheet...", 0, 3, null, options, options[1]);
            if (choice == 1 || choice == -1) {
                this.setSelectedIndex(i);
                return -1;
            }
            return 0;
        }
        return 0;
    }

    public boolean getChangedStatus() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            SpreadsheetScrollPane tab = (SpreadsheetScrollPane)this.getComponentAt(i);
            if (!tab.getChangedStatus()) continue;
            return true;
        }
        return false;
    }

    public void setChangedStatus() {
        ((SpreadsheetScrollPane)this.getSelectedComponent()).getSpreadsheet().setChangedStatus();
    }

    public void setCurrentTabTitle(String title) {
        this.setTitleAt(this.getSelectedIndex(), title);
    }

    public void resetTabTitles() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            this.setTitleAt(i, "Datasheet " + (i + 1));
        }
    }

    public String getCurrentTabTitle() {
        return this.getTitleAt(this.getSelectedIndex());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        Rectangle rect = ((CloseTabIcon)this.getIconAt(tabNumber)).getBounds();
        if (rect.contains(e.getX(), e.getY())) {
            this.closeCurrentDatasheet();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;

        public CloseTabIcon(Icon fileIcon) {
            this.fileIcon = fileIcon;
            this.width = 16;
            this.height = 16;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x_pos = x;
            this.y_pos = y;
            Color col = g.getColor();
            g.setColor(Color.gray);
            int y_p = y + 2;
            g.drawLine(x + 1, y_p, x + 12, y_p);
            g.drawLine(x + 1, y_p + 13, x + 12, y_p + 13);
            g.drawLine(x, y_p + 1, x, y_p + 12);
            g.drawLine(x + 13, y_p + 1, x + 13, y_p + 12);
            g.drawLine(x + 3, y_p + 3, x + 10, y_p + 10);
            g.drawLine(x + 3, y_p + 4, x + 9, y_p + 10);
            g.drawLine(x + 4, y_p + 3, x + 10, y_p + 9);
            g.drawLine(x + 10, y_p + 3, x + 3, y_p + 10);
            g.drawLine(x + 10, y_p + 4, x + 4, y_p + 10);
            g.drawLine(x + 9, y_p + 3, x + 3, y_p + 9);
            g.setColor(col);
            if (this.fileIcon != null) {
                this.fileIcon.paintIcon(c, g, x + this.width, y_p);
            }
        }

        @Override
        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

