/*
 * Decompiled with CFR 0.152.
 */
package org.statcato;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.statcato.Statcato;
import org.statcato.StatcatoDialog;
import org.statcato.file.DownloadFile;
import org.statcato.file.ExtensionFileFilter;
import org.statcato.utils.HelperFunctions;

public class CheckUpdatesDialog
extends StatcatoDialog {
    String currentVersion;
    private JLabel CurrentVersionLabel;
    private JButton DownloadButton;
    private JButton OKButton;
    private JPanel ResultPanel;
    private JLabel thisVersionLabel;

    public CheckUpdatesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.app = (Statcato)parent;
        this.initComponents();
        this.setHelpFile("updates");
        this.name = "Check for Updates";
        this.DownloadButton.setVisible(false);
        this.currentVersion = HelperFunctions.getVersionNumberFromWeb();
        this.thisVersionLabel.setText("This is Statcato version 1.0.2.");
        if (this.currentVersion.equals("error")) {
            this.CurrentVersionLabel.setText("Error obtaining the current number from web.  Check network connection.");
        } else if (this.currentVersion.equals("1.0.2")) {
            this.CurrentVersionLabel.setText("No new updates.");
        } else if (this.currentVersion.compareTo("1.0.2") < 0) {
            this.CurrentVersionLabel.setText("No new updates - pre-release.");
        } else {
            this.CurrentVersionLabel.setText("<html>New version " + this.currentVersion + " is available.<br>" + "  Visit " + "http://www.statcato.org to obtain the latest" + " version.</html>");
            this.DownloadButton.setVisible(true);
        }
    }

    private void initComponents() {
        this.thisVersionLabel = new JLabel();
        this.ResultPanel = new JPanel();
        this.CurrentVersionLabel = new JLabel();
        this.DownloadButton = new JButton();
        this.OKButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Statcato Updates");
        this.thisVersionLabel.setText("This is Statcato version");
        this.ResultPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.CurrentVersionLabel.setText("New version");
        this.DownloadButton.setText("Download the Latest Version");
        this.DownloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckUpdatesDialog.this.DownloadButtonActionPerformed(evt);
            }
        });
        GroupLayout ResultPanelLayout = new GroupLayout(this.ResultPanel);
        this.ResultPanel.setLayout(ResultPanelLayout);
        ResultPanelLayout.setHorizontalGroup(ResultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultPanelLayout.createSequentialGroup().addContainerGap().addGroup(ResultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CurrentVersionLabel).addComponent(this.DownloadButton)).addContainerGap(79, Short.MAX_VALUE)));
        ResultPanelLayout.setVerticalGroup(ResultPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResultPanelLayout.createSequentialGroup().addGap(19, 19, 19).addComponent(this.CurrentVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 42, Short.MAX_VALUE).addComponent(this.DownloadButton).addContainerGap()));
        this.OKButton.setText("OK");
        this.OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CheckUpdatesDialog.this.OKButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.OKButton).addComponent(this.ResultPanel, -2, -1, -2).addComponent(this.thisVersionLabel)).addContainerGap(19, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.thisVersionLabel).addGap(18, 18, 18).addComponent(this.ResultPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addComponent(this.OKButton).addGap(23, 23, 23)));
        this.pack();
    }

    private void DownloadButtonActionPerformed(ActionEvent evt) {
        String fileName = "statcato_" + this.currentVersion + ".zip";
        JFileChooser fc = new JFileChooser();
        fc.setSelectedFile(new File(fileName));
        ExtensionFileFilter ZipFilter = new ExtensionFileFilter("Zip (*.zip)", "zip");
        fc.addChoosableFileFilter(ZipFilter);
        fc.setAcceptAllFileFilterUsed(false);
        int returnValue = fc.showSaveDialog(this);
        if (returnValue == 0) {
            Object[] options;
            int choice;
            File file = fc.getSelectedFile();
            String path = file.getPath();
            if (file.exists() && (choice = JOptionPane.showOptionDialog(this, "The specified file already exists.  Overwrite existing file?", "Overwrite file?", 0, 2, null, options = new Object[]{"Overwrite file", "Cancel"}, options[1])) != 0) {
                return;
            }
            DownloadFile d = new DownloadFile("http://www.statcato.org/versions/statcato_" + this.currentVersion + ".zip");
            int totalDownload = d.download(path);
            if (totalDownload <= 0) {
                JOptionPane.showMessageDialog(this, "Download failed.", "Download error", 0);
            } else {
                JOptionPane.showMessageDialog(this, "The latest version is downloaded to " + path, "Download complete", -1);
            }
        }
    }

    private void OKButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

