/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.FieldBinding;
import jas.util.UnsupportedType;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class ChoiceFieldBinding
extends FieldBinding
implements ItemListener {
    private int m_oldVal = 0;
    private Choice m_field;

    ChoiceFieldBinding(Choice field) {
        this.m_field = field;
        field.addItemListener(this);
    }

    @Override
    void set(Object value) throws UnsupportedType {
        if (!(value instanceof Integer)) {
            throw new UnsupportedType(this.m_field, value.getClass());
        }
        int x = (Integer)value;
        if (x != this.m_oldVal) {
            this.m_field.select(x);
            this.m_oldVal = x;
        }
    }

    @Override
    Object get(Class type) throws UnsupportedType {
        if (type != Integer.TYPE) {
            throw new UnsupportedType(this.m_field, type);
        }
        int x = this.m_field.getSelectedIndex();
        return new Integer(x);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int x = this.m_field.getSelectedIndex();
        if (x != this.m_oldVal) {
            this.setChanged();
        }
        this.notifyObservers();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_oldVal = this.m_field.getSelectedIndex();
    }
}

