/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import jas.hist.Rebinnable2DHistogramData;
import jas.hist.ScatterEnumeration;
import jas.hist.ScatterPlotSource;
import jas.hist.util.AbstractSlice;
import jas.hist.util.DefaultSliceParameters;
import jas.hist.util.ScatterTwoDAdapter;
import jas.hist.util.TwoDSliceAdapter;
import javax.swing.event.EventListenerList;

public class ScatterSliceAdapter
extends TwoDSliceAdapter {
    private EventListenerList listenerList = new EventListenerList();

    public ScatterSliceAdapter(Rebinnable2DHistogramData source) {
        super(source);
    }

    public ScatterSliceAdapter(ScatterPlotSource source) {
        super(new ScatterTwoDAdapter(source));
    }

    @Override
    public int addSlice(double x, double y, double width, double height, double phi) {
        if (this.scatter != null && this.scatter.hasScatterPlotData()) {
            int n = this.slices.size();
            String title = (width == Double.POSITIVE_INFINITY ? "Projection " : "Slice ") + n;
            this.slices.addElement(new Slice(title, x, y, width, height, phi));
            this.fireSliceAdded(n);
            return n;
        }
        return super.addSlice(x, y, width, height, phi);
    }

    private class Slice
    extends AbstractSlice {
        private double m_min;
        private double m_max;
        private boolean minMaxValid;

        Slice(String title, double x, double y, double width, double height, double phi) {
            super(title, width == Double.POSITIVE_INFINITY);
            this.minMaxValid = false;
            this.parm = new DefaultSliceParameters(x, y, width, height, phi){

                @Override
                protected void changed() {
                    Slice.this.sendUpdate();
                }
            };
        }

        @Override
        public void sendUpdate() {
            this.minMaxValid = false;
            super.sendUpdate();
        }

        @Override
        public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
            double[] hist = new double[bins];
            ScatterEnumeration e = ScatterSliceAdapter.this.scatter.startEnumeration();
            double sinPhi = Math.sin(this.parm.phi);
            double cosPhi = Math.cos(this.parm.phi);
            double p0 = -this.parm.x * sinPhi + this.parm.y * cosPhi;
            double q0 = this.parm.x * cosPhi + this.parm.y * sinPhi;
            double[] point = new double[2];
            while (e.getNextPoint(point)) {
                int bin;
                double p;
                double q = point[0] * cosPhi + point[1] * sinPhi;
                if (!this.projection && (Math.abs(q - q0) > this.parm.width || Math.abs((p = -point[0] * sinPhi + point[1] * cosPhi) - p0) > this.parm.height) || q < min || (bin = (int)((q - min) * (double)bins / (max - min))) >= bins) continue;
                int n = bin;
                hist[n] = hist[n] + 1.0;
            }
            double[][] result = new double[][]{hist};
            return result;
        }

        private void calcMinMax() {
            this.minMaxValid = true;
            if (this.projection) {
                ScatterEnumeration e = ScatterSliceAdapter.this.scatter.startEnumeration();
                double sinPhi = Math.sin(this.parm.phi);
                double cosPhi = Math.cos(this.parm.phi);
                double[] point = new double[2];
                double min = 0.0;
                double max = 0.0;
                boolean first = true;
                while (e.getNextPoint(point)) {
                    double q = point[0] * cosPhi + point[1] * sinPhi;
                    if (first) {
                        min = max = q;
                    } else {
                        min = Math.min(min, q);
                        max = Math.max(max, q);
                    }
                    first = false;
                }
                this.m_min = min;
                this.m_max = max;
            } else {
                double sinPhi = Math.sin(this.parm.phi);
                double cosPhi = Math.cos(this.parm.phi);
                double q0 = this.parm.x * cosPhi + this.parm.y * sinPhi;
                this.m_min = q0 - this.parm.width;
                this.m_max = q0 + this.parm.width;
            }
        }

        @Override
        public double getMin() {
            if (!this.minMaxValid) {
                this.calcMinMax();
            }
            return this.m_min;
        }

        @Override
        public double getMax() {
            if (!this.minMaxValid) {
                this.calcMinMax();
            }
            return this.m_max;
        }

        @Override
        public int getBins() {
            return 40;
        }

        @Override
        public boolean isRebinnable() {
            return true;
        }
    }
}

