/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.test;

import jas.hist.JASHist;
import jas.hist.JASHistData;
import jas.hist.test.MemoryDataSource;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.RepaintManager;

public class TestJASHistReconnect
extends MemoryDataSource {
    @Override
    public String getTitle() {
        return "Java Memory Usage TIMES TWO";
    }

    @Override
    public double[][] rebin(int nbin, double min, double max, boolean wantErrors, boolean hurry) {
        double[][] r = super.rebin(nbin, min, max, wantErrors, hurry);
        for (int i = 0; i < r.length; ++i) {
            double[] tmp = r[i];
            for (int j = 0; j < tmp.length; ++j) {
                tmp[j] = tmp[j] * 2.0;
            }
        }
        return r;
    }

    static void printDB(JComponent comp) {
        RepaintManager currentManager = RepaintManager.currentManager(comp);
        boolean manager = currentManager.isDoubleBufferingEnabled();
        boolean component = comp.isDoubleBuffered();
        System.out.println("Double-Buffered:  manager=" + manager + ",  component=" + component);
    }

    public static void main(String[] args) throws Exception {
        final JASHist plot = new JASHist();
        TestJASHistReconnect.printDB(plot);
        JASHistData data1 = plot.addData(new MemoryDataSource());
        plot.setTitle("Java Memory Usage");
        plot.setDataAreaBorderType(3);
        plot.getYAxis().setLabel("MBytes");
        plot.getXAxis().setLabel("Time (seconds)");
        plot.setAllowUserInteraction(true);
        plot.setShowLegend(0);
        TestJASHistReconnect.printDB(plot);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1010L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    TestJASHistReconnect.printDB(plot);
                }
            }
        });
        t.start();
        int reply = 0;
        while (reply == 0) {
            JOptionPane.showConfirmDialog(null, plot, "Plot Dialog", -1);
            reply = JOptionPane.showConfirmDialog(null, "Show Plot again ...", " Question Dialog", 2);
        }
        System.exit(0);
    }
}

