/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ComponentNodeTraverser;
import jas.hist.FormatNodeTraverser;
import jas.hist.StatisticsBlock;
import jas.hist.XMLPrintWriter;
import jas.util.xml.XMLNodeTraverser;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class StatsNodeTraverser
extends ComponentNodeTraverser {
    private Vector selected;
    private StatisticsBlock stats;

    StatsNodeTraverser() {
    }

    void traverse(Node node, StatisticsBlock stats) throws XMLNodeTraverser.BadXMLException {
        this.stats = stats;
        super.traverse(node, stats);
        if (this.selected != null) {
            Object[] elements = new String[this.selected.size()];
            this.selected.copyInto(elements);
            stats.setSelectedEntries((String[])elements);
        }
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("statsEntry")) {
            if (this.selected == null) {
                this.selected = new Vector();
            }
            this.selected.addElement(node.getAttribute("name"));
        } else if (name.equals("format")) {
            FormatNodeTraverser ft = new FormatNodeTraverser(node);
            this.stats.setFormat(ft.getFormat());
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("showTitles")) {
            this.stats.setShowTitles(XMLPrintWriter.convertStringToShowTitle(value));
        } else if (name.equals("alignment")) {
            this.stats.setSplitStringAlign(XMLPrintWriter.convertStringToAlignment(value));
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }
}

