/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.models.AbstractTimeBasedModel;

public class WeightedMovingAverageModel
extends AbstractTimeBasedModel {
    private double[] weights;

    public WeightedMovingAverageModel(double[] weights) {
        this.setWeights(weights);
    }

    public WeightedMovingAverageModel(String independentVariable, double[] weights) {
        super(independentVariable);
        this.setWeights(weights);
    }

    protected WeightedMovingAverageModel() {
    }

    protected WeightedMovingAverageModel(String independentVariable) {
        super(independentVariable);
    }

    protected void setWeights(double[] weights) {
        int periods = weights.length;
        double sum = 0.0;
        for (int w = 0; w < periods; ++w) {
            sum += weights[w];
        }
        boolean adjust = false;
        if (Math.abs(sum - 1.0) > TOLERANCE) {
            adjust = true;
        }
        this.weights = new double[periods];
        for (int w = 0; w < periods; ++w) {
            this.weights[w] = adjust ? weights[w] / sum : weights[w];
        }
    }

    @Override
    protected double forecast(double timeValue) throws IllegalArgumentException {
        int periods = this.getNumberOfPeriods();
        double t = timeValue;
        double timeDiff = this.getTimeInterval();
        if (timeValue - timeDiff * (double)periods < this.getMinimumTimeValue()) {
            return this.getObservedValue(t);
        }
        double forecast = 0.0;
        for (int p = periods - 1; p >= 0; --p) {
            t -= timeDiff;
            try {
                forecast += this.weights[p] * this.getObservedValue(t);
                continue;
            }
            catch (IllegalArgumentException iaex) {
                forecast += this.weights[p] * this.getForecastValue(t);
            }
        }
        return forecast;
    }

    @Override
    public int getNumberOfPredictors() {
        return 1;
    }

    @Override
    protected int getNumberOfPeriods() {
        return this.weights.length;
    }

    @Override
    public String getForecastType() {
        return "Weighted Moving Average";
    }

    @Override
    public String toString() {
        return "weighted moving average model, spanning " + this.getNumberOfPeriods() + " periods and using an independent variable of " + this.getIndependentVariable() + ".";
    }
}

