/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.input;

import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.input.AbstractBuilder;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesBuilder
extends AbstractBuilder {
    private TimeSeries timeSeries;

    public TimeSeriesBuilder(TimeSeries timeSeries) {
        if (timeSeries.getItemCount() <= 0) {
            throw new IllegalArgumentException("TimeSeries cannot be empty.");
        }
        this.timeSeries = timeSeries;
        RegularTimePeriod timePeriod = timeSeries.getTimePeriod(0);
        String name = timePeriod.getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        this.addVariable(name);
    }

    public TimeSeriesBuilder(TimeSeries timeSeries, String timeVariableName) {
        if (timeSeries.getItemCount() <= 0) {
            throw new IllegalArgumentException("TimeSeries cannot be empty.");
        }
        this.timeSeries = timeSeries;
        this.setTimeVariable(timeVariableName);
    }

    public String getTimeVariable() {
        return this.getVariableName(0);
    }

    public void setTimeVariable(String name) {
        this.setVariableName(0, name);
    }

    @Override
    public DataSet build() {
        DataSet dataSet = new DataSet();
        dataSet.setTimeVariable(this.getTimeVariable());
        int numberOfPeriods = this.timeSeries.getItemCount();
        for (int t = 0; t < numberOfPeriods; ++t) {
            dataSet.add(this.build(this.timeSeries.getDataItem(t)));
        }
        return dataSet;
    }

    private DataPoint build(TimeSeriesDataItem dataItem) {
        Observation dataPoint = new Observation(dataItem.getValue().doubleValue());
        double timeValue = dataItem.getPeriod().getMiddleMillisecond();
        dataPoint.setIndependentValue(this.getVariableName(0), timeValue);
        return dataPoint;
    }
}

