/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.Observation;

public class DataSet
extends AbstractCollection<DataPoint> {
    private Collection<DataPoint> dataPoints = new ArrayList<DataPoint>();
    private String timeVariable;
    private int periodsPerYear;

    public DataSet() {
        this.timeVariable = null;
        this.periodsPerYear = 0;
    }

    public DataSet(DataSet dataSet) {
        this(dataSet.getTimeVariable(), dataSet.getPeriodsPerYear(), dataSet.dataPoints);
    }

    public DataSet(String timeVariable, int periodsPerYear, Collection<DataPoint> c) {
        this.timeVariable = timeVariable;
        this.periodsPerYear = periodsPerYear;
        this.addAll((Collection<? extends DataPoint>)c);
    }

    @Override
    public boolean add(DataPoint obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support addition of null DataPoints");
        }
        return this.dataPoints.add(new Observation(obj));
    }

    @Override
    public boolean addAll(Collection<? extends DataPoint> c) {
        Iterator<? extends DataPoint> it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public void clear() {
        this.dataPoints.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.dataPoints.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support null DataPoint objects");
        }
        DataPoint dataPoint = (DataPoint)obj;
        for (DataPoint dp : this) {
            if (!dataPoint.equals(dp)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) throws ClassCastException, NullPointerException {
        for (DataPoint dp : c) {
            if (this.contains(dp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support null DataPoint objects");
        }
        return this.dataPoints.remove((DataPoint)obj);
    }

    @Override
    public int size() {
        return this.dataPoints.size();
    }

    @Override
    public Iterator<DataPoint> iterator() {
        return this.dataPoints.iterator();
    }

    public void sort(String independentVariable) {
        TreeMap<Double, DataPoint> sortedMap = new TreeMap<Double, DataPoint>(new Comparator<Double>(){

            @Override
            public int compare(Double o1, Double o2) {
                return o1.compareTo(o2);
            }
        });
        for (DataPoint dp : this.dataPoints) {
            sortedMap.put(new Double(dp.getIndependentValue(independentVariable)), dp);
        }
        this.dataPoints.clear();
        this.dataPoints.addAll(sortedMap.values());
    }

    public String[] getIndependentVariables() {
        int i;
        String[] names;
        ArrayList<String> variables = new ArrayList<String>();
        for (DataPoint dp : this.dataPoints) {
            names = dp.getIndependentVariableNames();
            for (i = 0; i < names.length; ++i) {
                if (variables.contains(names[i])) continue;
                variables.add(names[i]);
            }
        }
        Collections.sort(variables);
        int count = variables.size();
        names = new String[count];
        for (i = 0; i < count; ++i) {
            names[i] = (String)variables.get(i);
        }
        return names;
    }

    public void setTimeVariable(String timeVariable) {
        this.timeVariable = timeVariable;
    }

    public String getTimeVariable() {
        return this.timeVariable;
    }

    public void setPeriodsPerYear(int periodsPerYear) {
        if (periodsPerYear < 1) {
            throw new IllegalArgumentException("periodsPerYear parameter must be at least 1");
        }
        this.periodsPerYear = periodsPerYear;
    }

    public int getPeriodsPerYear() {
        return this.periodsPerYear;
    }

    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DataSet.removeAll not yet supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DataSet.retainAll not yet supported");
    }

    @Override
    public int hashCode() {
        return this.dataPoints.size() * 100 + this.getIndependentVariables().length;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        return this.equals((DataSet)obj);
    }

    public boolean equals(DataSet dataSet) {
        if (dataSet == null) {
            return false;
        }
        if (this.size() != dataSet.size()) {
            return false;
        }
        for (DataPoint dataPoint : dataSet) {
            if (this.contains(dataPoint)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        String result = "( " + lineSeparator;
        Iterator<DataPoint> it = this.dataPoints.iterator();
        while (it.hasNext()) {
            result = result + "  " + it.next().toString() + lineSeparator;
        }
        return result + ")";
    }
}

