/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.output.TimeSeriesOutputter;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesDataItem;

public class TimeSeriesOutputterTest
extends OpenForecastTestCase {
    private double TOLERANCE = 1.0E-6;

    public void testOutput() throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, InstantiationException {
        int NUMBER_OF_TIME_PERIODS = 10;
        String TIME_VARIABLE = "t";
        double[] expectedValue = new double[NUMBER_OF_TIME_PERIODS];
        Day period = new Day();
        DataSet dataSet = new DataSet();
        dataSet.setTimeVariable(TIME_VARIABLE);
        for (int d = 0; d < NUMBER_OF_TIME_PERIODS; ++d) {
            double value = d;
            Observation obs = new Observation(value);
            obs.setIndependentValue(TIME_VARIABLE, period.getMiddleMillisecond());
            dataSet.add(obs);
            period = period.next();
            expectedValue[d] = value;
        }
        TimeSeriesOutputterTest.assertEquals((String)"Checking only one independent variable exists in dataSet", (int)1, (int)dataSet.getIndependentVariables().length);
        TimeSeriesOutputterTest.assertEquals((String)"Checking dataSet has correct number of entries", (int)NUMBER_OF_TIME_PERIODS, (int)dataSet.size());
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"test"));
        TimeSeriesOutputter outputter = new TimeSeriesOutputter(timeSeries, period.getClass());
        outputter.output(dataSet);
        TimeSeriesOutputterTest.assertEquals((String)"Checking number of items in time series", (int)NUMBER_OF_TIME_PERIODS, (int)timeSeries.getItemCount());
        period = new Day();
        for (int d = 0; d < NUMBER_OF_TIME_PERIODS; ++d) {
            TimeSeriesDataItem dataItem = timeSeries.getDataItem(d);
            period = dataItem.getPeriod();
            TimeSeriesOutputterTest.assertNotNull((String)"Checking time period", (Object)period);
            long timeValue = period.getMiddleMillisecond();
            TimeSeriesOutputterTest.assertTrue((String)"Checking time periods match", ((double)timeValue >= (double)period.getFirstMillisecond() && (double)timeValue <= (double)period.getLastMillisecond() ? 1 : 0) != 0);
            TimeSeriesOutputterTest.assertEquals((String)("Checking values for period " + dataItem.getPeriod() + " match"), (double)expectedValue[d], (double)dataItem.getValue().doubleValue(), (double)this.TOLERANCE);
            period = period.next();
        }
    }

    public TimeSeriesOutputterTest(String name) {
        super(name);
    }
}

