/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class DataSetTest
extends OpenForecastTestCase {
    private static final int SIZE = 10;
    private DataSet dataSet1 = new DataSet();
    private DataSet dataSet2 = new DataSet();
    private DataSet dataSet3 = new DataSet();
    private DataSet dataSet4 = new DataSet();

    public DataSetTest(String name) {
        super(name);
    }

    public void setUp() {
        this.dataSet1 = new DataSet();
        this.dataSet2 = new DataSet();
        this.dataSet3 = new DataSet();
        this.dataSet4 = new DataSet();
        for (int count = 0; count < 10; ++count) {
            Observation dp1 = new Observation(count);
            Observation dp2 = new Observation(count);
            Observation dp3 = new Observation(count);
            Observation dp4 = new Observation(count);
            dp1.setIndependentValue("x", count);
            dp2.setIndependentValue("x", count);
            dp3.setIndependentValue("x", count);
            dp4.setIndependentValue("x", count + 1);
            this.dataSet1.add(dp1);
            this.dataSet2.add(dp2);
            this.dataSet3.add(dp3);
            this.dataSet4.add(dp4);
        }
        DataSetTest.assertTrue((String)"Checking dataSet1 contains correct number of data points", (this.dataSet1.size() == 10 ? 1 : 0) != 0);
        DataSetTest.assertTrue((String)"Checking dataSet2 contains correct number of data points", (this.dataSet2.size() == 10 ? 1 : 0) != 0);
        DataSetTest.assertTrue((String)"Checking dataSet3 contains correct number of data points", (this.dataSet3.size() == 10 ? 1 : 0) != 0);
        DataSetTest.assertTrue((String)"Checking dataSet4 contains correct number of data points", (this.dataSet4.size() == 10 ? 1 : 0) != 0);
    }

    public void tearDown() {
        this.dataSet1.clear();
        this.dataSet2.clear();
        this.dataSet3.clear();
        this.dataSet4.clear();
        this.dataSet1 = null;
        this.dataSet2 = null;
        this.dataSet3 = null;
        this.dataSet4 = null;
    }

    public void testDataSet() {
        DataSet data = new DataSet(this.dataSet1);
        DataSetTest.assertTrue((data.size() == this.dataSet1.size() ? 1 : 0) != 0);
        String[] independentVariables = data.getIndependentVariables();
        DataSetTest.assertTrue((independentVariables.length == 1 ? 1 : 0) != 0);
        DataSetTest.assertTrue((boolean)independentVariables[0].equals("x"));
        for (DataPoint dp : data) {
            double TOLERANCE;
            double value = dp.getDependentValue();
            DataSetTest.assertTrue((value > -(TOLERANCE = 0.001) && value < 10.0 + TOLERANCE ? 1 : 0) != 0);
        }
    }

    public void testDataSetEqualsMethod() {
        DataSetTest.assertTrue((String)"Checking DataSet is reflexive: dataSet1.equals(dataSet1)", (boolean)this.dataSet1.equals(this.dataSet1));
        DataSetTest.assertTrue((String)"Checking DataSet is symmetric: dataSet1.equals(dataSet2)", (this.dataSet1.equals(this.dataSet2) && this.dataSet2.equals(this.dataSet1) && !this.dataSet1.equals(this.dataSet4) && !this.dataSet4.equals(this.dataSet1) ? 1 : 0) != 0);
        DataSetTest.assertTrue((String)"Checking DataSet is transitive: x==y && y==z => x==z", (this.dataSet1.equals(this.dataSet2) && this.dataSet2.equals(this.dataSet3) == this.dataSet1.equals(this.dataSet3) && this.dataSet1.equals(this.dataSet2) && this.dataSet2.equals(this.dataSet4) == this.dataSet1.equals(this.dataSet4) ? 1 : 0) != 0);
        DataSetTest.assertTrue((String)"Checking DataSet is consistent: x==y or x!=y consistently", (this.dataSet1.equals(this.dataSet2) == this.dataSet1.equals(this.dataSet2) && this.dataSet1.equals(this.dataSet4) == this.dataSet1.equals(this.dataSet4) ? 1 : 0) != 0);
        DataSetTest.assertFalse((String)"Checking DataSet.equals() handles nulls", (boolean)this.dataSet1.equals(null));
    }

    public void testContains() {
        DataSetTest.assertTrue((String)"Checking for self-containment", (boolean)this.dataSet1.containsAll(this.dataSet1));
        DataSetTest.assertTrue((String)"Checking for containment of similar data sets (1)", (boolean)this.dataSet1.containsAll(this.dataSet2));
        DataSetTest.assertTrue((String)"Checking for containment of similar data sets (2)", (boolean)this.dataSet2.containsAll(this.dataSet1));
        DataSetTest.assertFalse((String)"Checking for non-containment", (boolean)this.dataSet1.containsAll(this.dataSet4));
        Iterator<DataPoint> it = this.dataSet1.iterator();
        DataSetTest.assertTrue((String)"Checking for valid iterator", (boolean)it.hasNext());
        DataPoint dp = it.next();
        DataSetTest.assertTrue((String)"Checking for individual DataPoint containment", (boolean)this.dataSet1.contains(dp));
        DataSetTest.assertFalse((String)"Checking for individual DataPoint non-containment", (boolean)this.dataSet4.contains(dp));
    }

    public void testHashCode() {
        DataSetTest.assertEquals((String)"Checking hash code function returns consistent value", (int)this.dataSet1.hashCode(), (int)this.dataSet1.hashCode());
        DataSetTest.assertTrue((String)"Checking ds1.equals(ds2) => hash codes are equal", (this.dataSet1.equals(this.dataSet2) && this.dataSet1.hashCode() == this.dataSet2.hashCode() || !this.dataSet1.equals(this.dataSet2) ? 1 : 0) != 0);
    }

    public void testRemove() {
        Iterator<DataPoint> it = this.dataSet1.iterator();
        DataSetTest.assertTrue((String)"Checking for valid iterator", (boolean)it.hasNext());
        int initialSize = this.dataSet1.size();
        DataPoint dp = it.next();
        DataSetTest.assertTrue((String)"Checking dataSet1 contains data point", (boolean)this.dataSet1.contains(dp));
        this.dataSet1.remove(dp);
        DataSetTest.assertEquals((String)"Checking size of data set decreased after removing a data point", (int)(initialSize - 1), (int)this.dataSet1.size());
        try {
            DataSetTest.assertTrue((String)"Checking data set changed after removeAll", (boolean)this.dataSet1.removeAll(this.dataSet1));
            DataSetTest.assertTrue((String)"Checking size of data set after removeAll", (this.dataSet1.isEmpty() && this.dataSet1.size() == 0 ? 1 : 0) != 0);
            DataSetTest.fail((String)"removeAll is not supposed to be supported yet!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRetainAll() {
        DataSetTest.assertEquals((String)"Checking dataSet1.equals(dataSet2)", (Object)this.dataSet1, (Object)this.dataSet2);
        for (int i = 0; i < 5; ++i) {
            Iterator<DataPoint> it = this.dataSet2.iterator();
            DataSetTest.assertTrue((String)"Checking for valid iterator", (boolean)it.hasNext());
            this.dataSet2.remove(it.next());
        }
        int expectedSize = this.dataSet2.size();
        try {
            this.dataSet1.retainAll(this.dataSet2);
            DataSetTest.assertEquals((String)"Checking size of dataSet1 after retaingAll", (int)expectedSize, (int)this.dataSet1.size());
            DataSetTest.assertEquals((String)"Checking size of dataSet1 and dataSet2 after retainAll", (int)this.dataSet1.size(), (int)this.dataSet2.size());
            DataSetTest.fail((String)"retainAll is not supposed to be supported yet!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testDataSetSorting() {
        DataSet data = new DataSet();
        for (int count = 0; count < 10; ++count) {
            Observation dp = new Observation(count);
            dp.setIndependentValue("x", 10 - count);
            data.add(dp);
        }
        data.sort("x");
        Iterator<DataPoint> it = data.iterator();
        double lastX = -1.0;
        while (it.hasNext()) {
            DataPoint dp = it.next();
            double valueX = dp.getIndependentValue("x");
            DataSetTest.assertTrue((valueX > lastX ? 1 : 0) != 0);
            lastX = valueX;
        }
    }
}

