/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.tests;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Forecaster;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.tests.OpenForecastTestCase;

public class BasicTest
extends OpenForecastTestCase {
    public void testDataPoint() {
        Observation dp1 = new Observation(1.0);
        dp1.setIndependentValue("x", 2.0);
        dp1.setIndependentValue("t", 3.0);
        Observation dp2 = new Observation(1.0);
        dp2.setIndependentValue("t", 3.0);
        dp2.setIndependentValue("x", 2.0);
        BasicTest.assertTrue((boolean)dp1.equals(dp2));
    }

    public void testUnknownVariableInObservation() {
        Observation observation = new Observation(5.0);
        try {
            double value = observation.getIndependentValue("y");
            BasicTest.fail((String)("Attempt to obtain the value of an unknown variable from an Observation returned a value (" + value + ") - it should have thrown an exception"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testForecast() {
        DataSet observedData = new DataSet();
        for (int count = 0; count < 10; ++count) {
            Observation dp = new Observation(count);
            dp.setIndependentValue("x", count);
            observedData.add(dp);
        }
        ForecastingModel forecaster = Forecaster.getBestForecast(observedData);
        DataSet requiredDataPoints = new DataSet();
        for (int count = 11; count < 15; ++count) {
            Observation dp = new Observation(0.0);
            dp.setIndependentValue("x", count);
            requiredDataPoints.add(dp);
        }
        forecaster.forecast(requiredDataPoints);
        double[] expectedResult = new double[]{11.0, 12.0, 13.0, 14.0};
        this.checkResults(requiredDataPoints, expectedResult);
    }

    public BasicTest(String name) {
        super(name);
    }
}

