/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.examples;

import java.awt.Container;
import java.awt.Dimension;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.ForecastingModel;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.MovingAverageModel;
import net.sourceforge.openforecast.models.NaiveForecastingModel;
import net.sourceforge.openforecast.models.PolynomialRegressionModel;
import net.sourceforge.openforecast.models.RegressionModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;

public class ForecastingChartDemo
extends ApplicationFrame {
    private TimeSeries fc;

    public ForecastingChartDemo(String title) {
        super(title);
        String chartTitle = "OpenForecast Demo";
        XYDataset dataset = this.createDataset();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)chartTitle, (String)"Date", (String)"Quarterly Sales (Units sold)", (XYDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        if (renderer instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer r = (StandardXYItemRenderer)renderer;
            r.setBaseShapesVisible(true);
            r.setShapesFilled(Boolean.TRUE);
        }
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane((Container)chartPanel);
    }

    public XYDataset createDataset() {
        TimeSeries observations = new TimeSeries((Comparable)((Object)"Quarterly Sales"), Quarter.class);
        observations.add((RegularTimePeriod)new Quarter(1, 1990), 362.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1990), 385.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1990), 432.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1990), 341.0);
        observations.add((RegularTimePeriod)new Quarter(1, 1991), 382.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1991), 409.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1991), 498.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1991), 387.0);
        observations.add((RegularTimePeriod)new Quarter(1, 1992), 473.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1992), 513.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1992), 582.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1992), 474.0);
        observations.add((RegularTimePeriod)new Quarter(1, 1993), 544.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1993), 582.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1993), 681.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1993), 557.0);
        observations.add((RegularTimePeriod)new Quarter(1, 1994), 628.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1994), 707.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1994), 773.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1994), 592.0);
        observations.add((RegularTimePeriod)new Quarter(1, 1995), 627.0);
        observations.add((RegularTimePeriod)new Quarter(2, 1995), 725.0);
        observations.add((RegularTimePeriod)new Quarter(3, 1995), 854.0);
        observations.add((RegularTimePeriod)new Quarter(4, 1995), 661.0);
        this.fc = new TimeSeries((Comparable)((Object)"Forecast values"), Quarter.class);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1990), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1990), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1990), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1990), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1991), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1991), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1991), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1991), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1992), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1992), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1992), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1992), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1993), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1993), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1993), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1993), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1994), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1994), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1994), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1994), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1995), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1995), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1995), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1995), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1996), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1996), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1996), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1996), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1997), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1997), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1997), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1997), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(1, 1998), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(2, 1998), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(3, 1998), 0.0);
        this.fc.add((RegularTimePeriod)new Quarter(4, 1998), 0.0);
        DataSet initDataSet = this.getDataSet(observations, 0, 100);
        TimeSeries naiveSeries = this.getForecastTimeSeries(new NaiveForecastingModel(), initDataSet, 1, 25, "Naive forecast");
        TimeSeries ma4Series = this.getForecastTimeSeries(new MovingAverageModel(4), initDataSet, 4, 28, "4 Period Moving Average");
        TimeSeries ma8Series = this.getForecastTimeSeries(new MovingAverageModel(8), initDataSet, 8, 32, "8 Period Moving Average");
        TimeSeries regressionSeries = this.getForecastTimeSeries(new RegressionModel("t"), initDataSet, 0, 100, "Linear regression");
        TimeSeries polyRegressSeries = this.getForecastTimeSeries(new PolynomialRegressionModel("t", 4), initDataSet, 0, 100, "4th order polynomial regression");
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(observations);
        dataset.addSeries(naiveSeries);
        dataset.addSeries(ma4Series);
        dataset.addSeries(ma8Series);
        dataset.addSeries(regressionSeries);
        dataset.addSeries(polyRegressSeries);
        return dataset;
    }

    private DataSet getDataSet(TimeSeries series, int startIndex, int endIndex) {
        DataSet dataSet = new DataSet();
        if (endIndex > series.getItemCount()) {
            endIndex = series.getItemCount();
        }
        for (int i = startIndex; i < endIndex; ++i) {
            TimeSeriesDataItem dataPair = series.getDataItem(i);
            Observation dp = new Observation(dataPair.getValue().doubleValue());
            dp.setIndependentValue("t", i);
            dataSet.add(dp);
        }
        return dataSet;
    }

    private TimeSeries getForecastTimeSeries(ForecastingModel model, DataSet initDataSet, int startIndex, int endIndex, String title) {
        model.init(initDataSet);
        DataSet fcDataSet = this.getDataSet(this.fc, startIndex, endIndex);
        model.forecast(fcDataSet);
        TimeSeries series = new TimeSeries((Comparable)((Object)title), this.fc.getTimePeriodClass());
        for (DataPoint dp : fcDataSet) {
            int index = (int)dp.getIndependentValue("t");
            series.add(this.fc.getTimePeriod(index), dp.getDependentValue());
        }
        return series;
    }

    public static void main(String[] args) {
        ForecastingChartDemo demo = new ForecastingChartDemo("Forecasting Demo: Time Series");
        demo.pack();
        demo.setVisible(true);
    }
}

