/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.loader;

import java.io.BufferedReader;
import java.io.IOException;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgPolygonSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PjProject;
import jv.project.PvViewerIf;
import vgp.tutor.loader.PgAbcLoader;

public class PjLoader
extends PjProject {
    public static final String[][] m_parmLoader = new String[][]{{"filename", "String", "vgp/tutor/loader/cube.abc", "Default geometry file"}, {"vgp.tutor.loader.indexfirstvertex", "String", "0", "Index of first vertex"}};
    static /* synthetic */ Class class$vgp$tutor$loader$PjLoader;

    public PjLoader() {
        super("File Loader Demo");
        this.setParameterInfo(m_parmLoader);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$loader$PjLoader == null ? (class$vgp$tutor$loader$PjLoader = PjLoader.class$("vgp.tutor.loader.PjLoader")) : class$vgp$tutor$loader$PjLoader)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void start() {
        PsDebug.notify((String)"called");
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null) {
            String string;
            String string2 = pvViewerIf.getParameter("filename");
            String string3 = PsUtil.getFileExtension((String)string2);
            if (string3 == null) {
                PsDebug.warning((String)("missing extension in file=" + string2));
            }
            PgJvxSrc[] pgJvxSrcArray = null;
            BufferedReader bufferedReader = PsUtil.open((String)(PsConfig.getCodeBase() + string2));
            if (bufferedReader == null) {
                PsDebug.warning((String)("could not open file = " + string2));
            } else {
                PgAbcLoader pgAbcLoader = new PgAbcLoader();
                string = pvViewerIf.getParameter("vgp.tutor.loader.indexfirstvertex");
                if (string != null) {
                    int n = Integer.parseInt(string);
                    pgAbcLoader.setFirstVertexIndex(n);
                }
                pgJvxSrcArray = pgAbcLoader.read(bufferedReader);
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (pgJvxSrcArray == null || pgJvxSrcArray[0] == null) {
                PsDebug.warning((String)("error when reading file = " + string2));
            } else {
                for (int i = 0; i < pgJvxSrcArray.length; ++i) {
                    if (string2 != null) {
                        string = PsUtil.getFileBaseName((String)string2);
                        if (pgJvxSrcArray.length == 1) {
                            pgJvxSrcArray[i].setName(string);
                        } else {
                            pgJvxSrcArray[i].setName(string + "[" + String.valueOf(i) + "]");
                        }
                    }
                    string = null;
                    switch (pgJvxSrcArray[i].getType()) {
                        case 30: {
                            string = new PgPointSet(pgJvxSrcArray[i].getDimOfVertices());
                            string.setJvx(pgJvxSrcArray[i]);
                            break;
                        }
                        case 31: {
                            string = new PgPolygon(pgJvxSrcArray[i].getDimOfVertices());
                            string.setJvx(pgJvxSrcArray[i]);
                            break;
                        }
                        case 32: {
                            string = new PgPolygonSet(pgJvxSrcArray[i].getDimOfVertices());
                            string.setJvx(pgJvxSrcArray[i]);
                            break;
                        }
                        case 33: {
                            string = new PgElementSet(pgJvxSrcArray[i].getDimOfVertices());
                            string.setJvx(pgJvxSrcArray[i]);
                            break;
                        }
                        default: {
                            PsDebug.warning((String)("geometry[" + i + "] has unknown type = " + pgJvxSrcArray[i].getType()));
                            string = pgJvxSrcArray[i];
                        }
                    }
                    this.addGeometry((PgGeometryIf)string);
                    if (i != 0) continue;
                    this.selectGeometry((PgGeometryIf)string);
                }
            }
        }
        super.start();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

