/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.key;

import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.anim.PsTimeListenerIf;
import jv.loader.PgLoader;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvViewerIf;

public class PjKeyframe
extends PjProject {
    public static final String[][] m_parmKeyframe = new String[][]{{"Model", "String", "models/cmc/Wente_Anim.*.byu", "Sequence of geometry files"}, {"Number", "String", "2", "Total number of files"}, {"Animation", "String", "Show", "Show animation dialog"}, {"Console", "String", "Hide", ""}, {"Control", "String", "Hide", ""}, {"Frame", "String", "Hide", ""}, {"Panel", "String", "Project", ""}};
    protected PsKeyframe[] m_keyframe;
    protected String m_fileName;
    protected int m_numKeys;
    protected PsAnimation m_anim;
    static /* synthetic */ Class class$vgp$tutor$key$PjKeyframe;

    public PjKeyframe() {
        super("Keyframe Animation Demo");
        this.setParameterInfo(m_parmKeyframe);
        this.m_anim = new PsAnimation();
        this.m_anim.enableKeys(true);
        this.setAnimation(this.m_anim);
        if (((Object)((Object)this)).getClass() == (class$vgp$tutor$key$PjKeyframe == null ? (class$vgp$tutor$key$PjKeyframe = PjKeyframe.class$("vgp.tutor.key.PjKeyframe")) : class$vgp$tutor$key$PjKeyframe)) {
            this.init();
        }
    }

    public void init() {
        super.init();
    }

    public void start() {
        String string;
        PsDebug.notify((String)"called");
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null) {
            this.m_fileName = pvViewerIf.getParameter("Model");
            if (this.m_fileName != null) {
                this.m_fileName = PsConfig.getCodeBase() + this.m_fileName;
            }
            string = pvViewerIf.getParameter("Number");
            this.m_numKeys = 0;
            if (string != null) {
                try {
                    this.m_numKeys = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    PsDebug.warning((String)("error parsing number of keys = " + string));
                    return;
                }
            }
            if (this.m_fileName == null) {
                this.setFileName(this.m_fileName, this.m_numKeys);
            }
        }
        if (this.load() && ((string = pvViewerIf.getParameter("Animation")) == null || string.equalsIgnoreCase("show"))) {
            this.m_anim.getAnimationPanel().setVisible(true);
        }
        super.start();
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String string, int n) {
        this.m_fileName = string;
        this.m_numKeys = n;
    }

    public boolean load() {
        int n;
        if (this.m_fileName == null) {
            PsDebug.warning((String)"missing file name to load");
            return false;
        }
        if (this.m_keyframe != null) {
            for (int i = 0; i < this.m_keyframe.length; ++i) {
                PgGeometry pgGeometry = this.m_keyframe[i].getDynamic();
                this.removeGeometry((PgGeometryIf)pgGeometry);
                this.m_anim.removeTimeListener((PsTimeListenerIf)this.m_keyframe[i]);
                this.m_keyframe[i].init();
            }
            this.m_keyframe = null;
        }
        double d = 0.0;
        double d2 = 100.0;
        double d3 = d;
        double d4 = (d2 - d) / ((double)this.m_numKeys - 1.0);
        String string = PsUtil.getFileName((String)this.m_fileName);
        String[] stringArray = PuString.splitString((String)this.m_fileName, (char)'*');
        if (stringArray == null || stringArray.length != 2) {
            PsDebug.warning((String)("wrong syntax, fileName = " + this.m_fileName));
            return false;
        }
        int n2 = String.valueOf(this.m_numKeys).length();
        int n3 = -1;
        for (n = 0; n < this.m_numKeys; ++n) {
            int n4;
            String string2 = String.valueOf(n + 1);
            for (int i = string2.length(); i < n2; ++i) {
                string2 = "0" + string2;
            }
            PgLoader pgLoader = new PgLoader();
            String string3 = stringArray[0] + string2 + stringArray[1];
            PgGeometry[] pgGeometryArray = pgLoader.loadGeometry((PgGeometry[])null, string3);
            if (pgGeometryArray == null || pgGeometryArray.length == 0) {
                PsDebug.warning((String)("failed loading file = " + string3));
                return false;
            }
            if (n == 0) {
                n3 = pgGeometryArray.length;
                this.m_keyframe = new PsKeyframe[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    this.m_keyframe[n4] = new PsKeyframe();
                }
            } else if (n3 != pgGeometryArray.length) {
                PsDebug.warning((String)("different number of geometries in file = " + string3));
                return false;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                int n5 = this.m_keyframe[n4].addKey(pgGeometryArray[n4], d3);
                if (n5 != -1) continue;
                PsDebug.warning((String)("geometry of different type: key=" + n + ", geom=" + n4));
                return false;
            }
            d3 += d4;
        }
        for (n = 0; n < n3; ++n) {
            this.m_keyframe[n].setTime(d);
            if (n3 == 1) {
                this.m_keyframe[n].setName(string);
            } else {
                this.m_keyframe[n].setName(string + "[" + n + "]");
            }
            this.m_anim.addTimeListener((PsTimeListenerIf)this.m_keyframe[n]);
            this.addGeometry((PgGeometryIf)this.m_keyframe[n].getDynamic());
        }
        this.selectGeometry((PgGeometryIf)this.m_keyframe[0].getDynamic());
        this.m_anim.setName(string);
        this.m_anim.update((Object)this.m_anim);
        return true;
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        return super.update(object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

