/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.jvfModel;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgLoader;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsUtil;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.viewer.PvDisplay;
import jv.viewer.PvViewer;
import jvx.primitive.PgCurveF;
import jvx.primitive.PgGraphF;
import jvx.primitive.PgPlotF;
import jvx.surface.PgParmSurface;

public class PaJvfModel
extends Applet
implements Runnable,
ActionListener {
    public Frame m_frame = null;
    protected PvViewer m_viewer;
    protected Button m_animButton;
    protected PsPanel m_panel;
    protected PvDisplay m_disp;
    protected String m_filename = "models/jvf/sofiaOrthocircles.jvf";
    protected Thread m_thread;
    protected boolean m_bRunning = false;
    protected boolean m_bStopped = true;
    protected PuDouble m_animParam = null;
    protected int m_direction = 1;
    protected boolean m_bSuspended = true;

    public PaJvfModel() {
        PsDebug.setNotify((boolean)true);
        this.m_panel = new PsPanel();
        this.m_animButton = new Button("Start Animation");
        this.m_animButton.addActionListener(this);
        this.m_panel.add(this.m_animButton);
    }

    public void init() {
        PgLoader pgLoader;
        PgGeometry[] pgGeometryArray;
        this.m_viewer = new PvViewer((Applet)this, this.m_frame);
        this.m_disp = (PvDisplay)this.m_viewer.getDisplay();
        String string = this.m_viewer.getParameter("model");
        if (string == null || string.equals("")) {
            string = this.m_filename;
        }
        if (string != null && !string.equals("") && !PsUtil.isAbsolutePath((String)string)) {
            string = PsConfig.getCodeBase() + string;
        }
        if ((pgGeometryArray = (pgLoader = new PgLoader()).loadGeometry(string)) == null) {
            PsDebug.warning((String)("missing JVF model, failed loading file = " + string));
        } else {
            for (int i = 0; i < pgGeometryArray.length; ++i) {
                this.m_disp.addGeometry((PgGeometryIf)pgGeometryArray[i]);
            }
            if (pgGeometryArray.length > 0) {
                this.m_disp.selectGeometry((PgGeometryIf)pgGeometryArray[0]);
            }
            Vector<PgParmSurface> vector = new Vector<PgParmSurface>();
            for (int i = 0; i < pgGeometryArray.length; ++i) {
                PgParmSurface pgParmSurface;
                Enumeration enumeration = null;
                if (pgGeometryArray[i] instanceof PgParmSurface) {
                    pgParmSurface = (PgParmSurface)pgGeometryArray[i];
                    enumeration = pgParmSurface.getFunctionExpr().getParameters();
                } else if (pgGeometryArray[i] instanceof PgCurveF) {
                    pgParmSurface = (PgCurveF)pgGeometryArray[i];
                    enumeration = pgParmSurface.getFunction().getParameters();
                } else if (pgGeometryArray[i] instanceof PgGraphF) {
                    pgParmSurface = (PgGraphF)pgGeometryArray[i];
                    enumeration = pgParmSurface.getFunction().getParameters();
                } else {
                    if (!(pgGeometryArray[i] instanceof PgPlotF)) continue;
                    pgParmSurface = (PgPlotF)pgGeometryArray[i];
                    enumeration = pgParmSurface.getFunction().getParameters();
                }
                while (enumeration.hasMoreElements()) {
                    pgParmSurface = (PsObject)enumeration.nextElement();
                    if (!vector.contains(pgParmSurface)) {
                        this.m_panel.add((Component)pgParmSurface.newInspector("_IP"));
                        vector.addElement(pgParmSurface);
                    }
                    if (this.m_animParam != null || !(pgParmSurface instanceof PuDouble)) continue;
                    this.m_animParam = (PuDouble)pgParmSurface;
                }
            }
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_disp.getCanvas(), "Center");
        this.add((Component)this.m_panel, "South");
        this.setSize(600, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_bSuspended) {
            // empty if block
        }
        System.out.println("Action!");
        boolean bl = this.m_bSuspended = !this.m_bSuspended;
        if (!this.m_bSuspended) {
            Thread thread = this.m_thread;
            synchronized (thread) {
                this.m_thread.notify();
            }
        }
    }

    public static void main(String[] stringArray) {
        PaJvfModel paJvfModel = new PaJvfModel();
        PsMainFrame psMainFrame = new PsMainFrame((Component)paJvfModel, stringArray);
        psMainFrame.pack();
        paJvfModel.m_frame = psMainFrame;
        paJvfModel.init();
        paJvfModel.start();
        psMainFrame.setSize(640, 550);
        psMainFrame.setVisible(true);
    }

    public void destroy() {
        this.m_viewer.destroy();
    }

    public boolean isRunning() {
        return this.m_bRunning;
    }

    public boolean isStopped() {
        return this.m_bStopped;
    }

    public void start() {
        if (!this.m_bStopped || this.m_bRunning) {
            return;
        }
        this.m_bRunning = true;
        this.m_thread = new Thread((Runnable)this, "JavaView: Animation");
        this.m_thread.setPriority(5);
        this.m_thread.start();
    }

    public void stop() {
        if (!this.m_bRunning) {
            return;
        }
        this.m_bRunning = false;
        this.m_thread = null;
        this.m_panel.update((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.m_animParam == null) {
            return;
        }
        this.m_bStopped = false;
        while (this.m_thread != null && this.m_bRunning) {
            double d;
            if (this.m_bSuspended) {
                Thread thread = this.m_thread;
                synchronized (thread) {
                    try {
                        while (this.m_bSuspended) {
                            this.m_thread.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if ((d = this.m_animParam.getValue() + (double)this.m_direction * this.m_animParam.getLineIncr()) <= this.m_animParam.getMin() || d >= this.m_animParam.getMax()) {
                this.m_direction = -this.m_direction;
                d = this.m_animParam.getValue() + (double)this.m_direction * this.m_animParam.getLineIncr();
            }
            this.m_disp.setEnabledRepaint(false);
            this.m_animParam.setValue(d);
            this.m_animParam.update(null);
            this.m_disp.setEnabledRepaint(true);
            this.m_disp.repaint();
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {}
        }
        this.m_bStopped = true;
    }
}

