/*
 * Decompiled with CFR 0.152.
 */
package vgp.tutor.firstProject;

import jv.geom.PgElementSet;
import jv.vecmath.PuMath;

public class MySurface
extends PgElementSet {
    protected int m_numULines;
    protected int m_numVLines;

    public MySurface() {
        super(3);
        this.init();
    }

    public synchronized void computeSurface(int n, int n2) {
        this.setNumVertices(n * n2);
        double d = Math.PI * 2 / (-1.0 + (double)n);
        double d2 = 4.0 / (-1.0 + (double)n2);
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            double d3 = d * (double)i;
            for (int j = 0; j < n2; ++j) {
                double d4 = -2.0 + d2 * (double)j;
                this.setVertex(n3, Math.cos(d3) * PuMath.cosh((double)d4), Math.sin(d3) * PuMath.cosh((double)d4), d4);
                ++n3;
            }
        }
        this.makeQuadrConn(n, n2);
        this.makeElementNormals();
        this.makeVertexNormals();
        this.m_numULines = n;
        this.m_numVLines = n2;
    }

    public void makeQuadrConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            return;
        }
        this.setDimOfElements(4);
        this.setNumElements((n - 1) * (n2 - 1));
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                this.setElement(n3, i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                ++n3;
            }
        }
        this.makeNeighbour();
    }

    public synchronized void computeAnimation(double d) {
        if (this.m_numULines < 2 || this.m_numVLines < 2) {
            return;
        }
        if (this.getNumVertices() != this.m_numULines * this.m_numVLines) {
            this.setNumVertices(this.m_numULines * this.m_numVLines);
            this.makeQuadrConn(this.m_numULines, this.m_numVLines);
            this.makeQuadrBnd(this.m_numULines, this.m_numVLines);
        }
        int n = 0;
        double d2 = Math.cos(d * Math.PI / 360.0);
        double d3 = Math.sin(d * Math.PI / 360.0);
        double d4 = Math.PI * 2 / (-1.0 + (double)this.m_numULines);
        double d5 = 4.0 / (-1.0 + (double)this.m_numVLines);
        for (int i = 0; i < this.m_numULines; ++i) {
            double d6 = d4 * (double)i;
            for (int j = 0; j < this.m_numVLines; ++j) {
                double d7 = -2.0 + d5 * (double)j;
                this.setVertex(n, d2 * Math.cos(d6) * PuMath.cosh((double)d7) + d3 * Math.sin(d6) * PuMath.sinh((double)d7), -d2 * Math.sin(d6) * PuMath.cosh((double)d7) + d3 * Math.cos(d6) * PuMath.sinh((double)d7), d2 * d7 + d3 * (d6 - Math.PI));
                ++n;
            }
        }
        this.makeElementNormals();
        this.makeVertexNormals();
    }
}

