/*
 * Decompiled with CFR 0.152.
 */
package vgp.surface.common;

import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import vgp.surface.common.PgSurfaceDescr;

public class PgSurface_OuterHyperboloid
extends PgSurfaceDescr {
    private double m_defWaist = 1.0;
    private double m_defAngle = 1.5707963267948966;
    protected PuDouble m_waist;
    protected PuDouble m_angle;
    static /* synthetic */ Class class$vgp$surface$common$PgSurface_OuterHyperboloid;

    public PgSurface_OuterHyperboloid() {
        this.setName("OuterHyperboloid");
        this.m_waist = new PuDouble("Waist Radius", (PsUpdateIf)this);
        this.m_angle = new PuDouble("Opening Angle", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$surface$common$PgSurface_OuterHyperboloid == null ? (class$vgp$surface$common$PgSurface_OuterHyperboloid = PgSurface_OuterHyperboloid.class$("vgp.surface.common.PgSurface_OuterHyperboloid")) : class$vgp$surface$common$PgSurface_OuterHyperboloid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setSize(-2.0, -Math.PI, 2.0, Math.PI);
        this.setDiscr(33, 33);
        this.m_waist.setDefBounds(0.2, 2.0, 0.02, 0.1);
        this.m_waist.setDefValue(this.m_defWaist);
        this.m_waist.init();
        this.addParameter((PsObject)this.m_waist);
        this.m_angle.setDefBounds(0.001, 3.0, 0.06283185307179587, 0.3141592653589793);
        this.m_angle.setDefValue(this.m_defAngle);
        this.m_angle.init();
        this.addParameter((PsObject)this.m_angle);
    }

    public boolean isVPeriodic() {
        return this.getVMax() - this.getVMin() >= Math.PI * 2;
    }

    public boolean update(Object object) {
        if (object == this.m_waist) {
            return super.update(null);
        }
        if (object == this.m_angle) {
            return super.update(null);
        }
        return super.update(object);
    }

    public boolean calc_f(PdVector pdVector, double d, double d2) {
        double d3;
        double d4 = 5.0;
        double d5 = this.m_angle.getValue();
        double d6 = 1.0 / Math.tan(d5 / 2.0);
        double d7 = this.m_waist.getValue();
        double d8 = Math.log(Math.sqrt(2.0 / (1.0 + d6 * d6)) / d7);
        double d9 = this.getUMax();
        if (d9 < (d3 = this.getUMin())) {
            d9 += d3;
            d3 = d9 - d3;
            d9 -= d3;
        }
        double d10 = (d - d3) / (d9 - d3);
        double d11 = 1.0 / (Math.exp(d4 * (d7 * d6 - 1.0)) + 1.0);
        if (d9 > 0.0) {
            d9 = d9 / d7 / d6 * (1.0 - d11) + (d9 + d8) * d11;
        } else if (d9 < 0.0) {
            d9 = d9 / d7 / d6 * (1.0 - d11) + (d9 - d8) * d11;
        }
        if (d3 > 0.0) {
            d3 = d3 / d7 / d6 * (1.0 - d11) + (d3 + d8) * d11;
        } else if (d3 < 0.0) {
            d3 = d3 / d7 / d6 * (1.0 - d11) + (d3 - d8) * d11;
        }
        double d12 = d3 + d10 * (d9 - d3);
        pdVector.set(PuMath.cosh((double)d12) * Math.sin(d2), PuMath.cosh((double)d12) * Math.cos(d2), PuMath.sinh((double)d12) * d6);
        pdVector.multScalar(d7);
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

