/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.anim.PsAnimation;
import jv.anim.PsTimeEvent;
import jv.anim.PsTimeListenerIf;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvPickEvent;
import jv.project.PvViewerIf;
import vgp.minimal.weier.PgWeierstrass;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PjWeierstrass
extends PjProject {
    public static final int SHOW_SURFACE = 0;
    public static final int SHOW_DOMAIN = 1;
    protected int m_visibleType = 0;
    public static final String BASE_SURFACE_NAME = "vgp.minimal.weier.PgWeierstrass_";
    protected PgWeierstrass m_geom;
    public static String[] m_surfaceFileName = new String[]{"Catenoid", "Cameloid", "CatSplit", "CatEnn", "CatEnnK", "CatEnn2Ends", "CatEnn2Twist", "Enneper", "KNoid", "KNoid2", "ScherkDoubly", "Scherk", "SchwarzD", "SchwarzD2", "SchwarzP", "SchwarzP2", "Costa", "Costa2", "Chen", "ChenGackstatter", "PlanarEnd", "Bidenoid", "CatKExp", "Schoen_I_WP", "Schoen_I_WP1", "Schoen_I_WP2", "MeeksMoebius", "MeeksMoebiusDual"};
    protected static String[] m_surfaceName = new String[]{"Catenoid - Helicoid", "Cameloid", "Catenoid - Split", "Catenoid - Enneper", "Catenoid - Enneper of Order K", "Catenoid - Enneper with 2 Ends", "Catenoid - Enneper with 2 Twisted Ends", "Enneper", "K-Noid Surface", "K-Noid Conjugate", "Scherk Doubly", "Scherk Tower", "Schwarz D patch", "Schwarz D", "Schwarz P patch", "Schwarz P", "Costa Surface", "Costa Surface (Closed)", "Chen Surface", "Chen-Gackstatter", "Planar End", "Bidenoid Surface", "Catenoid with k-Exp", "Schoen I-WP", "Schoen I-WP patch", "Schoen I-WP patch 2", "Meeks Moebius Strip", "Meeks Moebius Strip Dual"};
    protected int m_selectedIndex = 0;
    protected String m_defaultName = m_surfaceFileName[this.m_selectedIndex];
    static /* synthetic */ Class class$vgp$minimal$weier$PjWeierstrass;

    public PjWeierstrass() {
        super("Minimal Surfaces via Weierstrass");
        this.m_geom = new PgWeierstrass();
        this.m_geom.setParent((PsUpdateIf)this);
        PsAnimation psAnimation = new PsAnimation();
        psAnimation.addTimeListener((PsTimeListenerIf)this);
        psAnimation.setName("Associate Family");
        this.setAnimation(psAnimation);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PjWeierstrass == null ? (class$vgp$minimal$weier$PjWeierstrass = PjWeierstrass.class$("vgp.minimal.weier.PjWeierstrass")) : class$vgp$minimal$weier$PjWeierstrass)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addGeometry((PgGeometryIf)this.m_geom);
        this.selectGeometry((PgGeometryIf)this.m_geom);
    }

    public void start() {
        PvViewerIf pvViewerIf = this.getViewer();
        if (pvViewerIf != null && pvViewerIf.getParameter("SurfaceName") != null) {
            this.setSurfaceName(pvViewerIf.getParameter("SurfaceName"));
        } else {
            this.setSurfaceName(this.m_defaultName);
        }
        this.m_geom.update((Object)this.m_geom);
        super.start();
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_geom.update((Object)this.m_geom);
            return super.update((Object)this);
        }
        if (object == this.m_geom) {
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public boolean setTime(PsTimeEvent psTimeEvent) {
        PgWeierstrassDescr pgWeierstrassDescr = this.m_geom.getDescr();
        if (pgWeierstrassDescr != null) {
            double d = psTimeEvent.getTime();
            pgWeierstrassDescr.setConjugationAngle(d / 50.0 * Math.PI);
        }
        return true;
    }

    public boolean setSurfaceName(String string) {
        if (!this.m_geom.setSurfaceName(string, BASE_SURFACE_NAME)) {
            PsDebug.warning((String)("PjWeierstrass.setSurfaceName: even could not find default class = vgp.minimal.weier.PgWeierstrass_" + string));
            return false;
        }
        for (int i = 0; i < m_surfaceFileName.length; ++i) {
            if (!m_surfaceFileName[i].equals(string)) continue;
            this.m_selectedIndex = i;
            break;
        }
        PgWeierstrassDescr pgWeierstrassDescr = this.m_geom.getDescr();
        this.m_geom.showMarkedBnd();
        this.m_geom.generateConnectivity(pgWeierstrassDescr);
        this.m_geom.computeSurface(pgWeierstrassDescr);
        return true;
    }

    public void setVisible(int n) {
        if (this.m_visibleType == n) {
            return;
        }
        this.m_visibleType = n;
    }

    public void pickInitial(PvPickEvent pvPickEvent) {
        this.m_geom.markBnd(pvPickEvent.getElementInd());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

