/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Enneper
extends PgWeierstrassDescr {
    private final int m_defaultSymmetry = 2;
    private final double m_defaultRadius = 1.2;
    protected PuInteger m_iSymmetry;
    protected PuDouble m_dRadius;
    private int m_symmetry = 2;
    private double m_radius = 1.2;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Enneper;

    public PgWeierstrass_Enneper() {
        super(1);
        this.setName("Enneper");
        this.m_dRadius = new PuDouble("Radius", (PsUpdateIf)this);
        this.m_iSymmetry = new PuInteger("Symmetry", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Enneper == null ? (class$vgp$minimal$weier$PgWeierstrass_Enneper = PgWeierstrass_Enneper.class$("vgp.minimal.weier.PgWeierstrass_Enneper")) : class$vgp$minimal$weier$PgWeierstrass_Enneper)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 33, 1, 10);
        this.m_numLines[0].setDefValue(9);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 15, 1, 5);
        this.m_numLines[1].setDefValue(7);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_dRadius.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(1.2);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_iSymmetry.setDefBounds(2, 10, 1, 5);
        this.m_iSymmetry.setDefValue(2);
        this.m_iSymmetry.init();
        this.addParameter((PsObject)this.m_iSymmetry);
        this.setDomain(0, 0.0, 1.2, 0.0, 0.7853981633974483);
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMax(0, this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_iSymmetry) {
            this.m_symmetry = this.m_iSymmetry.getValue();
            this.setVMax(0, Math.PI / ((double)this.m_symmetry * 2.0));
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public PuComplex transform(PuComplex puComplex) {
        return PuComplex.polarToRect((double)puComplex.re, (double)puComplex.im);
    }

    public PuComplex f(PuComplex puComplex) {
        return PuComplex.ONE;
    }

    public PuComplex g(PuComplex puComplex) {
        if (puComplex.abs() == 0.0) {
            return PuComplex.ZERO;
        }
        return PuComplex.pow((PuComplex)puComplex, (double)((double)this.m_symmetry - 1.0));
    }

    public void getConnections() {
        this.connectPart(4 * this.m_symmetry - 1, 0, 0, 0);
    }

    public void getReflections() {
        for (int i = 0; i < 2 * this.m_symmetry; ++i) {
            this.reflectPart(2 * i + 1, 2 * i, 2);
            this.reflectPart(2 * i + 2, 2 * i + 1, 0);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (piVector == null && n == 0) {
            piVector2.m_data[0] = 0;
            piVector2.m_data[2] = 1;
        }
    }

    public int getNumParts() {
        return 4 * this.m_symmetry;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

