/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_CatSplit
extends PgWeierstrassDescr {
    private final double m_defaultRadius = 2.0;
    private final double m_defaultRadius1 = 2.0;
    private final double m_defaultEps = 0.7853981633974483;
    protected PuDouble m_dRadius;
    protected PuDouble m_dRadius1;
    protected PuDouble m_dEps;
    private double m_radius = 2.0;
    private double m_radius1 = 2.0;
    private double m_eps = 0.7853981633974483;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_CatSplit;

    public PgWeierstrass_CatSplit() {
        super(2, 3);
        this.setName("Catenoid Split");
        this.m_dRadius = new PuDouble("Radius Catenoid", (PsUpdateIf)this);
        this.m_dRadius1 = new PuDouble("Radius Plane", (PsUpdateIf)this);
        this.m_dEps = new PuDouble("Morphing", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_CatSplit == null ? (class$vgp$minimal$weier$PgWeierstrass_CatSplit = PgWeierstrass_CatSplit.class$("vgp.minimal.weier.PgWeierstrass_CatSplit")) : class$vgp$minimal$weier$PgWeierstrass_CatSplit)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 10);
        this.m_numLines[0].setDefValue(17);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 10);
        this.m_numLines[1].setDefValue(17);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_numLines[2].setDefBounds(3, 65, 1, 10);
        this.m_numLines[2].setDefValue(17);
        this.m_numLines[2].init();
        this.addParameter((PsObject)this.m_numLines[2]);
        this.m_dRadius.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_dRadius.setDefValue(2.0);
        this.m_dRadius.init();
        this.addParameter((PsObject)this.m_dRadius);
        this.m_dRadius1.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_dRadius1.setDefValue(2.0);
        this.m_dRadius1.init();
        this.addParameter((PsObject)this.m_dRadius1);
        this.m_dEps.setDefBounds(0.09817477042468103, 1.5707963267948966, 0.09817477042468103, 0.39269908169872414);
        this.m_dEps.setDefValue(0.7853981633974483);
        this.m_dEps.init();
        this.addParameter((PsObject)this.m_dEps);
        this.setDomain(0, -2.0, 0.0, 0.0, 1.5707963267948966);
        this.setDomain(1, 0.0, 2.0, 0.0, 1.5707963267948966);
        this.m_bMarkBnd = true;
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius) {
            this.m_radius = this.m_dRadius.getValue();
            this.setUMin(0, -this.m_radius);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius1) {
            this.m_radius1 = this.m_dRadius1.getValue();
            this.setUMax(1, this.m_radius1);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dEps) {
            this.m_eps = this.m_dEps.getValue();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public int getNumULines(int n) {
        if (n == 0) {
            return this.m_numLines[0].getValue();
        }
        return this.m_numLines[2].getValue();
    }

    public int getNumVLines(int n) {
        return this.m_numLines[1].getValue();
    }

    public PuComplex transform(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
        puComplex2 = PuComplex.moebius((double)1.0, (double)-1.0, (double)1.0, (double)1.0, (PuComplex)puComplex2);
        puComplex2.sqrt();
        puComplex2 = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.NEG_ONE, (PuComplex)PuComplex.I, (PuComplex)PuComplex.I, (PuComplex)puComplex2);
        puComplex2.sqr();
        puComplex2 = PuComplex.moebius((PuComplex)PuComplex.NEG_ONE, (PuComplex)PuComplex.I, (PuComplex)PuComplex.NEG_I, (PuComplex)PuComplex.ONE, (PuComplex)puComplex2);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)PuComplex.polarToRect((double)1.0, (double)(this.m_eps + 1.5707963267948966)), (double)1.0);
        PuComplex puComplex4 = PuComplex.sub((PuComplex)PuComplex.I, (PuComplex)PuComplex.polarToRect((double)1.0, (double)this.m_eps));
        puComplex2 = PuComplex.moebius((PuComplex)puComplex3, (PuComplex)puComplex4, (PuComplex)puComplex4, (PuComplex)puComplex3, (PuComplex)puComplex2);
        return puComplex2;
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.polarToRect((double)1.0, (double)this.m_eps);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex, (PuComplex)puComplex2);
        PuComplex puComplex4 = PuComplex.sub((PuComplex)puComplex, (PuComplex)PuComplex.conj((PuComplex)puComplex2));
        PuComplex puComplex5 = PuComplex.mult((PuComplex)puComplex3, (PuComplex)puComplex4);
        puComplex5 = PuComplex.mult((PuComplex)puComplex5, (PuComplex)PuComplex.sqr((PuComplex)PuComplex.add((PuComplex)puComplex, (double)1.0)));
        puComplex5 = PuComplex.inv((PuComplex)puComplex5);
        return puComplex5;
    }

    public PuComplex g(PuComplex puComplex) {
        return puComplex;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(0, 5, 2, 5);
            this.connectPart(1, 5, 3, 5);
        } else if (this.equals(piVector, new int[]{0, 0})) {
            this.connectPart(0, 1, 1, 3);
        }
    }

    public int getNumParts(PiVector piVector) {
        if (piVector == null) {
            return 1 + this.m_numUserReflections;
        }
        if (this.equals(piVector, 0)) {
            return 4;
        }
        return 2;
    }

    public void getReflections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.reflectPart(1, 0, 0);
            this.reflectPart(2, 0, 1);
            this.reflectPart(3, 1, 1);
        }
        if (piVector == null) {
            this.returnUserReflections();
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, new int[]{0, 0})) {
            if (n == 0) {
                piVector2.m_data[0] = 0;
                piVector2.m_data[2] = 0;
            } else if (n == 1) {
                piVector2.m_data[0] = 0;
                piVector2.m_data[2] = 0;
            }
        }
    }

    public boolean connectReflection(PiVector piVector, int n) {
        return piVector != null;
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0 || piVector != null && this.equals(piVector, 0) && n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

