/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.weier;

import jv.number.PuComplex;
import jv.number.PuDouble;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import vgp.minimal.weier.PgWeierstrassDescr;

public class PgWeierstrass_Bidenoid
extends PgWeierstrassDescr {
    private final double m_defaultRadius0 = 1.6;
    private final double m_defaultRadius1 = 5.0;
    private final double m_defaultRadius2 = 4.7;
    private final double m_defaultGr = 0.75;
    private final double m_defaultRho = 0.6;
    protected PuDouble m_dRadius0;
    protected PuDouble m_dRadius1;
    protected PuDouble m_dRadius2;
    protected PuDouble m_dGr;
    protected PuDouble m_dRho;
    private double m_radius0 = 1.6;
    private double m_radius1 = 5.0;
    private double m_radius2 = 4.7;
    private double m_gr = 0.75;
    private double m_rho = 0.6;
    private double m_rr;
    static /* synthetic */ Class class$vgp$minimal$weier$PgWeierstrass_Bidenoid;

    public PgWeierstrass_Bidenoid() {
        super(4, 4);
        this.setName("Bidenoid Surface");
        this.m_dRadius0 = new PuDouble("Domain Size 1", (PsUpdateIf)this);
        this.m_dRadius1 = new PuDouble("Domain Size 2", (PsUpdateIf)this);
        this.m_dRadius2 = new PuDouble("Domain Size 3", (PsUpdateIf)this);
        this.m_dGr = new PuDouble("gr", (PsUpdateIf)this);
        this.m_dRho = new PuDouble("rho", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$weier$PgWeierstrass_Bidenoid == null ? (class$vgp$minimal$weier$PgWeierstrass_Bidenoid = PgWeierstrass_Bidenoid.class$("vgp.minimal.weier.PgWeierstrass_Bidenoid")) : class$vgp$minimal$weier$PgWeierstrass_Bidenoid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addParameter((PsObject)this.m_conjugation);
        this.m_numLines[0].setDefBounds(3, 65, 1, 5);
        this.m_numLines[0].setDefValue(9);
        this.m_numLines[0].init();
        this.addParameter((PsObject)this.m_numLines[0]);
        this.m_numLines[1].setDefBounds(3, 65, 1, 5);
        this.m_numLines[1].setDefValue(9);
        this.m_numLines[1].init();
        this.addParameter((PsObject)this.m_numLines[1]);
        this.m_numLines[2].setDefBounds(3, 65, 1, 5);
        this.m_numLines[2].setDefValue(9);
        this.m_numLines[2].init();
        this.addParameter((PsObject)this.m_numLines[2]);
        this.m_numLines[3].setDefBounds(3, 65, 1, 5);
        this.m_numLines[3].setDefValue(17);
        this.m_numLines[3].init();
        this.addParameter((PsObject)this.m_numLines[3]);
        this.m_dRadius0.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_dRadius0.setDefValue(1.6);
        this.m_dRadius0.init();
        this.addParameter((PsObject)this.m_dRadius0);
        this.m_dRadius1.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_dRadius1.setDefValue(5.0);
        this.m_dRadius1.init();
        this.addParameter((PsObject)this.m_dRadius1);
        this.m_dRadius2.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_dRadius2.setDefValue(4.7);
        this.m_dRadius2.init();
        this.addParameter((PsObject)this.m_dRadius2);
        this.m_dGr.setDefBounds(0.0, 5.0, 0.1, 0.5);
        this.m_dGr.setDefValue(0.75);
        this.m_dGr.init();
        this.addParameter((PsObject)this.m_dGr);
        this.m_dRho.setDefBounds(0.1, 10.0, 0.1, 1.0);
        this.m_dRho.setDefValue(0.6);
        this.m_dRho.init();
        this.addParameter((PsObject)this.m_dRho);
        this.setDomain(0, 0.0, 5.0, 0.0, 1.5707963267948966);
        this.setDomain(1, 0.0, 1.5707963267948966, 0.0, 1.6);
        this.setDomain(2, 0.0, 1.5707963267948966, 0.0, 5.0);
        this.setDomain(3, 0.0, 4.7, 0.0, 1.5707963267948966);
        this.calculateRr();
    }

    public boolean update(Object object) {
        if (object == this.m_dRadius0) {
            this.m_radius0 = this.m_dRadius0.getValue();
            this.setVMax(1, this.m_radius0);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius1) {
            this.m_radius1 = this.m_dRadius1.getValue();
            this.setUMax(0, this.m_radius1);
            this.setVMax(2, this.m_radius1);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRadius2) {
            this.m_radius2 = this.m_dRadius2.getValue();
            this.setUMax(3, this.m_radius2);
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dGr) {
            this.m_gr = this.m_dGr.getValue();
            this.calculateRr();
            return this.m_parent.update((Object)this);
        }
        if (object == this.m_dRho) {
            this.m_rho = this.m_dRho.getValue();
            this.calculateRr();
            return this.m_parent.update((Object)this);
        }
        return super.update(object);
    }

    public int getNumULines(int n) {
        if (n == 0) {
            return this.m_numLines[2].getValue();
        }
        if (n == 3) {
            return this.m_numLines[3].getValue();
        }
        return this.m_numLines[0].getValue();
    }

    public int getNumVLines(int n) {
        if (n == 0 || n == 3) {
            return this.m_numLines[0].getValue();
        }
        if (n == 1) {
            return this.m_numLines[1].getValue();
        }
        return this.m_numLines[2].getValue();
    }

    public PuComplex transform(int n, PuComplex puComplex) {
        PuComplex puComplex2 = new PuComplex();
        if (n == 0 || n == 3) {
            puComplex2 = PuComplex.polarToRect((double)Math.exp(puComplex.re), (double)puComplex.im);
        } else if (n == 1 || n == 2) {
            puComplex2 = PuComplex.polarToRect((double)Math.exp(-puComplex.im), (double)puComplex.re);
        }
        puComplex2 = PuComplex.moebius((double)1.0, (double)-1.0, (double)1.0, (double)1.0, (PuComplex)puComplex2);
        puComplex2.sqrt();
        if (n == 2 || n == 3) {
            puComplex2.mult(PuComplex.NEG_I);
        }
        puComplex2 = PuComplex.moebius((PuComplex)PuComplex.ONE, (PuComplex)PuComplex.NEG_I, (PuComplex)PuComplex.NEG_I, (PuComplex)PuComplex.ONE, (PuComplex)puComplex2);
        puComplex2.mult(this.m_rho);
        return puComplex2;
    }

    private void calculateRr() {
        double d = this.m_gr * this.m_gr;
        double d2 = this.m_rho;
        if (this.m_rho < 1.0000000001 && this.m_rho > 0.9999999999) {
            d2 = 1.0000000001;
        }
        double d3 = d2 * d2;
        double d4 = Math.sqrt(4.0 + d3 * (d * d + d3 * (2.0 * d - 3.0 * d3))) - 1.0;
        this.m_rr = Math.sqrt(d4) / d2;
    }

    public PuComplex f(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sqr((PuComplex)puComplex);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)(this.m_rr * this.m_rr)), (double)1.0);
        puComplex3.div(puComplex);
        puComplex3.div(PuComplex.sub((PuComplex)puComplex2, (double)(this.m_rho * this.m_rho)));
        puComplex3.sqr();
        return puComplex3;
    }

    public PuComplex g(PuComplex puComplex) {
        PuComplex puComplex2 = PuComplex.sqr((PuComplex)puComplex);
        PuComplex puComplex3 = PuComplex.sub((PuComplex)puComplex2, (double)(this.m_gr * this.m_gr));
        PuComplex puComplex4 = PuComplex.sub((PuComplex)PuComplex.mult((PuComplex)puComplex2, (double)(this.m_rr * this.m_rr)), (double)1.0);
        PuComplex puComplex5 = PuComplex.div((PuComplex)PuComplex.mult((PuComplex)puComplex, (PuComplex)puComplex3), (PuComplex)puComplex4);
        return puComplex5;
    }

    public void getConnections(PiVector piVector) {
        if (this.equals(piVector, 0)) {
            this.connectPart(0, 3, 1, 0);
            this.connectPart(2, 0, 3, 3);
            this.connectPart(0, 0, 2, 3);
        } else if (piVector == null) {
            this.connectPart(0, 2, 1, 2);
            this.connectPart(0, 7, 2, 7);
            this.connectPart(1, 7, 3, 7);
        }
    }

    public void getReflections(PiVector piVector) {
        if (piVector == null) {
            this.reflectPart(1, 0, 1);
            this.reflectPart(2, 0, 4);
            this.reflectPart(3, 1, 4);
        }
    }

    public void getBndReflectType(PiVector piVector, int n, PiVector piVector2) {
        if (this.equals(piVector, 0)) {
            if (n == 0) {
                piVector2.m_data[2] = 0;
            } else if (n == 1) {
                piVector2.m_data[1] = 0;
                piVector2.m_data[3] = 0;
            } else if (n == 2) {
                piVector2.m_data[1] = 0;
            } else if (n == 3) {
                piVector2.m_data[0] = 0;
                piVector2.m_data[2] = 0;
            }
        }
    }

    public boolean partIsSubdivided(PiVector piVector, int n) {
        return piVector == null && n == 0;
    }

    public int getNumParts(PiVector piVector) {
        return 4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

