/*
 * Decompiled with CFR 0.152.
 */
package vgp.minimal.catenoid;

import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.number.PuDouble;
import jv.number.PuInteger;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.numeric.PnRootFinder;

public class PgCatenoid
extends PgElementSet {
    protected boolean m_bAlternate;
    protected boolean m_bTrueInterpolant;
    protected boolean m_bFixedHeight;
    protected boolean m_bSymmetric;
    protected double m_height;
    protected boolean m_bClosed;
    protected PuDouble m_delta;
    protected PuDouble m_bottomHeight;
    protected PuDouble m_radius;
    protected PuInteger m_k;
    protected PuInteger m_n;
    private double m_defDelta = 1.0;
    private double m_defBottomHeight = -1.0;
    private double m_defRadius = 1.0;
    private int m_defK = 5;
    private int m_defN = 5;
    private static PuFunction m_fx;
    static /* synthetic */ Class class$vgp$minimal$catenoid$PgCatenoid;

    public PgCatenoid() {
        super(3);
        this.setTag(10);
        this.m_delta = new PuDouble("Height Delta", (PsUpdateIf)this);
        this.m_bottomHeight = new PuDouble("Bottom Height", (PsUpdateIf)this);
        this.m_radius = new PuDouble("Waist Radius", (PsUpdateIf)this);
        this.m_k = new PuInteger("Waist Discr", (PsUpdateIf)this);
        this.m_n = new PuInteger("Profile Discr", (PsUpdateIf)this);
        if (m_fx == null) {
            m_fx = new PuFunction(1, 1);
            m_fx.addParameter("k", 4.0);
            m_fx.setExpression("1+u*u/(1+cos(2*pi/k))-cosh(u)");
        }
        if (((Object)((Object)this)).getClass() == (class$vgp$minimal$catenoid$PgCatenoid == null ? (class$vgp$minimal$catenoid$PgCatenoid = PgCatenoid.class$("vgp.minimal.catenoid.PgCatenoid")) : class$vgp$minimal$catenoid$PgCatenoid)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setDimOfElements(3);
        this.m_bFixedHeight = true;
        this.m_bSymmetric = true;
        this.m_bTrueInterpolant = false;
        this.m_bAlternate = false;
        this.m_bClosed = true;
        this.m_delta.setDefBounds(0.001, 4.5, 0.01, 0.1);
        this.m_delta.setDefValue(this.m_defDelta);
        this.m_delta.init();
        this.m_bottomHeight.setDefBounds(-10.0, 10.0, 0.01, 0.1);
        this.m_bottomHeight.setDefValue(this.m_defBottomHeight);
        this.m_bottomHeight.init();
        this.m_bottomHeight.setEnabled(!this.m_bSymmetric);
        this.m_radius.setDefBounds(0.001, 5.0, 0.01, 0.1);
        this.m_radius.setDefValue(this.m_defRadius);
        this.m_radius.init();
        this.m_k.setDefBounds(3, 30, 1, 2);
        this.m_k.setDefValue(this.m_defK);
        this.m_k.init();
        this.m_n.setDefBounds(2, 30, 1, 2);
        this.m_n.setDefValue(this.m_defN);
        this.m_n.init();
        this.updateHeight();
        this.computeSurface();
    }

    public Object clone() {
        PgCatenoid pgCatenoid = (PgCatenoid)((Object)super.clone());
        if (pgCatenoid == null) {
            return null;
        }
        pgCatenoid.m_delta = (PuDouble)this.m_delta.clone();
        pgCatenoid.m_delta.setParent((PsUpdateIf)pgCatenoid);
        pgCatenoid.m_bottomHeight = (PuDouble)this.m_bottomHeight.clone();
        pgCatenoid.m_bottomHeight.setParent((PsUpdateIf)pgCatenoid);
        pgCatenoid.m_radius = (PuDouble)this.m_radius.clone();
        pgCatenoid.m_radius.setParent((PsUpdateIf)pgCatenoid);
        pgCatenoid.m_k = (PuInteger)this.m_k.clone();
        pgCatenoid.m_k.setParent((PsUpdateIf)pgCatenoid);
        pgCatenoid.m_n = (PuInteger)this.m_n.clone();
        pgCatenoid.m_n.setParent((PsUpdateIf)pgCatenoid);
        return pgCatenoid;
    }

    public double getDelta() {
        return this.m_delta.getValue();
    }

    public void setDelta(double d) {
        this.m_delta.setValue(d);
    }

    public double getRadius() {
        return this.m_radius.getValue();
    }

    public void setRadius(double d) {
        this.m_radius.setValue(d);
    }

    public int getWaistDiscr() {
        return this.m_k.getValue();
    }

    public void setWaistDiscr(int n) {
        this.m_k.setValue(n);
    }

    public int getProfileDiscr() {
        return this.m_n.getValue();
    }

    public void setProfileDiscr(int n) {
        this.m_n.setValue(n);
        if (this.m_bFixedHeight) {
            this.m_delta.setValue(this.m_height / ((double)n - 1.0));
        } else {
            this.updateHeight();
        }
    }

    protected void updateHeight() {
        this.m_height = this.m_delta.getValue() * (double)(this.m_n.getValue() - 1);
        if (this.m_bSymmetric) {
            this.m_bottomHeight.setValue(-this.m_height / 2.0);
        }
    }

    public void optimalInterpolant() {
        m_fx.setParameter("k", (double)this.m_k.getValue());
        PdVector pdVector = PnRootFinder.findRoots((PuFunction)m_fx, (double)0.001, (double)4.5, (int)1);
        double d = pdVector.getEntry(0);
        double d2 = this.m_delta.getValue() * (double)(this.m_n.getValue() - 1);
        this.m_n.setValue(1 + (int)(d2 / d));
        double d3 = d2 / (double)(this.m_n.getValue() - 1);
        this.m_delta.setValue(d3);
        if (this.m_bSymmetric) {
            this.m_bottomHeight.setValue(-this.m_height / 2.0);
        }
    }

    public void trueInterpolant() {
        m_fx.setParameter("k", (double)this.m_k.getValue());
        PdVector pdVector = PnRootFinder.findRoots((PuFunction)m_fx, (double)0.001, (double)4.5, (int)1);
        this.m_delta.setValue(pdVector.getEntry(0));
        this.updateHeight();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_delta) {
            PsDebug.notify((String)"called with event=m_delta");
            this.updateHeight();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_bottomHeight) {
            PsDebug.notify((String)"called with event=m_bottomHeight");
            this.updateHeight();
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_radius) {
            PsDebug.notify((String)"called with event=m_radius");
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_k) {
            PsDebug.notify((String)"called with event=m_k");
            if (this.m_bTrueInterpolant) {
                if (this.m_bFixedHeight) {
                    this.optimalInterpolant();
                } else {
                    this.trueInterpolant();
                }
            }
            this.computeSurface();
            return super.update(null);
        }
        if (object == this.m_n) {
            PsDebug.notify((String)"called with event=m_n");
            if (this.m_bFixedHeight) {
                this.m_delta.setValue(this.m_height / ((double)this.m_n.getValue() - 1.0));
            } else {
                this.updateHeight();
            }
            this.computeSurface();
            return super.update(null);
        }
        if (this.getInspector("Config") == object) {
            PsDebug.notify((String)"called with event=controlPanel");
            this.computeSurface();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    public void computeSurface(int n, int n2) {
        this.setProfileDiscr(n);
        this.setWaistDiscr(n2);
        this.computeSurface();
    }

    protected void computeSurface() {
        int n;
        double d;
        int n2;
        double d2 = this.m_delta.getValue();
        int n3 = this.m_k.getValue();
        int n4 = this.m_n.getValue();
        int n5 = n3 + 1;
        int n6 = n4;
        this.setNumVertices(n5 * n6);
        double d3 = Math.PI * 2 / (double)n3;
        double[] dArray = new double[n5];
        double[] dArray2 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            d = d3 * (double)n2;
            dArray[n2] = Math.cos(d);
            dArray2[n2] = Math.sin(d);
        }
        double d4 = Math.PI / (double)n3;
        double[] dArray3 = new double[n5];
        double[] dArray4 = new double[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            d = d3 * (double)n2 + d4;
            dArray3[n2] = Math.cos(d);
            dArray4[n2] = Math.sin(d);
        }
        double[] dArray5 = new double[n6];
        double[] dArray6 = new double[n6];
        double d5 = this.m_bottomHeight.getValue();
        double d6 = Math.cos(Math.PI * 2 / (double)n3);
        double d7 = this.m_radius.getValue();
        double d8 = 1.0 + d6;
        d8 = d2 * d2 / d8;
        d8 = PuMath.acosh((double)d8);
        double d9 = d7 * PuMath.acosh((double)(1.0 + d2 * d2 / (d7 * d7 * (1.0 + d6)))) / d2;
        for (n = 0; n < n6; ++n) {
            dArray6[n] = d5 + d2 * (double)n;
            dArray5[n] = d7 * PuMath.cosh((double)(1.0 / d7 * d9 * dArray6[n]));
            PsDebug.notify((String)(" Profile[" + n + "] = (" + dArray5[n] + ", " + dArray6[n] + ")"));
        }
        int n7 = 0;
        for (n2 = 0; n2 < n5; ++n2) {
            for (n = 0; n < n6; ++n) {
                if (!this.m_bAlternate || n % 2 == 0) {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray2[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n];
                } else {
                    ((PgPointSet)this).m_vertex[n7].m_data[0] = dArray3[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[1] = dArray4[n2] * dArray5[n];
                    ((PgPointSet)this).m_vertex[n7].m_data[2] = dArray6[n];
                }
                ++n7;
            }
        }
        if (this.m_bAlternate) {
            this.makeAlternatingQuadrConn(n5, n6, false);
        } else {
            this.makeQuadrConn(n5, n6);
        }
        this.makeQuadrBnd(n5, n6);
        if (this.m_bClosed) {
            this.close();
        }
        this.fixBoundaries();
        this.makeVertexNormals();
        this.makeElementNormals();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

