/*
 * Decompiled with CFR 0.152.
 */
package vgp.iterate.juliaSet;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jv.number.PdVector_IP;
import jv.object.PsConfig;
import jv.object.PsMainFrame;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.project.PjProject_IP;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import vgp.iterate.juliaSet.PjJuliaSet;

public class PjJuliaSet_IP
extends PjProject_IP
implements ActionListener {
    protected PjJuliaSet m_pjJulia;
    protected PsPanel m_pSlider;
    protected PsPanel m_pMandelbrot;
    protected PdVector m_juliaConst = new PdVector(2);
    protected PdVector_IP m_pJuliaConst = new PdVector_IP();
    protected Panel m_pBottomButtons;
    protected Button m_bReset;
    protected Button m_bDetachMandelbrot;
    protected Color m_defColor;
    protected PsMainFrame m_frameMandelbrot;
    static /* synthetic */ Class class$vgp$iterate$juliaSet$PjJuliaSet_IP;

    public PjJuliaSet_IP() {
        this.m_pJuliaConst.setTitle("Julia Parameter c");
        this.m_pJuliaConst.setParent((PsUpdateIf)this);
        this.m_pJuliaConst.setVector(this.m_juliaConst);
        if (this.getClass() == (class$vgp$iterate$juliaSet$PjJuliaSet_IP == null ? (class$vgp$iterate$juliaSet$PjJuliaSet_IP = PjJuliaSet_IP.class$("vgp.iterate.juliaSet.PjJuliaSet_IP")) : class$vgp$iterate$juliaSet$PjJuliaSet_IP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.addTitle("");
        this.addNotice(this.getNotice());
        this.m_pMandelbrot = new PsPanel();
        this.m_pMandelbrot.setLayout(new BorderLayout());
        ((Container)((Object)this)).add((Component)this.m_pMandelbrot);
        ((Container)((Object)this)).add((Component)this.m_pJuliaConst);
        this.m_pSlider = new PsPanel();
        ((Container)((Object)this)).add((Component)this.m_pSlider);
        this.m_pBottomButtons = new Panel();
        this.m_pBottomButtons.setLayout(new FlowLayout(1));
        ((Container)((Object)this)).add(this.m_pBottomButtons);
        this.m_bDetachMandelbrot = new Button("Detach");
        this.m_bDetachMandelbrot.addActionListener(this);
        this.m_defColor = this.m_bDetachMandelbrot.getBackground();
        this.m_bReset = new Button("Reset");
        this.m_bReset.addActionListener(this);
        this.m_pBottomButtons.add(this.m_bReset);
    }

    public String getNotice() {
        String string = "Explore the space of Julia sets Iterate[z -> z^2+c] given by a complex parameter c of the Mandelbrot set. Pick c in the Mandelbrot display and watch the corresponding Julia set. Picking inside a Julia set shows the iterates of the picked point. Hint: Use mark-region to zoom into either image: keep the 'm' key pressed while dragging the region with left-mouse.";
        return string;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.setTitle(psUpdateIf.getName());
        this.m_pjJulia = (PjJuliaSet)psUpdateIf;
        this.m_pSlider.add((Component)this.m_pjJulia.m_maxIter.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjJulia.m_blockSize.getInfoPanel());
        this.m_pSlider.add((Component)this.m_pjJulia.m_hueOffset.getInfoPanel());
        PvDisplayIf pvDisplayIf = this.m_pjJulia.getDispMandelbrot();
        if (!this.m_pjJulia.hasDisplay(pvDisplayIf)) {
            this.m_pBottomButtons.add(this.m_bDetachMandelbrot);
            this.m_pMandelbrot.setPreferredSize(320, 256);
            this.m_pMandelbrot.add(pvDisplayIf.getCanvas());
            ((Container)((Object)this)).validate();
        }
    }

    public boolean update(Object object) {
        if (this.m_pjJulia == object) {
            this.m_juliaConst.set(this.m_pjJulia.m_const.re, this.m_pjJulia.m_const.im);
            this.m_pJuliaConst.update((Object)this.m_juliaConst);
            return true;
        }
        if (this.m_pJuliaConst == object) {
            this.m_pjJulia.m_const.set(this.m_juliaConst.getEntry(0), this.m_juliaConst.getEntry(1));
            this.m_pjJulia.update(this.m_pjJulia.m_const);
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_pjJulia == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_pjJulia.init();
            this.m_pjJulia.start();
            this.m_pjJulia.update(this.m_pjJulia);
        } else if (object == this.m_bDetachMandelbrot) {
            PvDisplayIf pvDisplayIf = this.m_pjJulia.getDispMandelbrot();
            Canvas canvas = pvDisplayIf.getCanvas();
            if (this.m_frameMandelbrot != null) {
                this.m_bDetachMandelbrot.setBackground(this.m_defColor);
                this.m_bDetachMandelbrot.setLabel("Detach");
                this.m_pMandelbrot.setPreferredSize(320, 256);
                this.m_pMandelbrot.add(canvas);
                ((Container)((Object)this)).validate();
                this.m_frameMandelbrot.dispose();
                this.m_frameMandelbrot = null;
            } else {
                this.m_bDetachMandelbrot.setBackground(Color.cyan);
                this.m_bDetachMandelbrot.setLabel("Attach");
                this.m_frameMandelbrot = new PsMainFrame((Component)canvas, PsConfig.getProgram(), null);
                pvDisplayIf.setFrame((Frame)this.m_frameMandelbrot);
                this.m_frameMandelbrot.setInnerBounds(50, 50, 640, 512);
                this.m_frameMandelbrot.setVisible(true);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

