/*
 * Decompiled with CFR 0.152.
 */
package vgp.imageSource;

import jv.number.PdColor;
import jv.number.PuComplex;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.vecmath.PiVector;
import jvx.imageDisplay.PiImageSource;

public class PiMandelbrot
extends PiImageSource {
    protected static final int COLOR_BLACK = 1;
    protected static final int COLOR_REDBLACK = 2;
    protected static final int COLOR_HUE = 3;
    protected static final int COLOR_HUEOFFSET = 4;
    private PiVector m_pixIter;
    protected PuInteger m_maxIter;
    private PiVector m_colMap;
    protected PuInteger m_hueOffset;
    static /* synthetic */ Class class$vgp$imageSource$PiMandelbrot;

    public PiMandelbrot() {
        this.setName("Mandelbrot");
        this.m_pixIter = new PiVector();
        this.m_maxIter = new PuInteger("Number of Iterations", (PsUpdateIf)this);
        this.m_colMap = new PiVector();
        this.m_hueOffset = new PuInteger("Hue Offset", (PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$imageSource$PiMandelbrot == null ? (class$vgp$imageSource$PiMandelbrot = PiMandelbrot.class$("vgp.imageSource.PiMandelbrot")) : class$vgp$imageSource$PiMandelbrot)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_pixIter.setSize(0);
        this.m_maxIter.setDefBounds(1, 200, 1, 5);
        this.m_maxIter.setDefValue(40);
        this.m_maxIter.init();
        this.m_colMap.setSize(this.m_maxIter.getValue() + 1);
        this.m_hueOffset.setDefBounds(0, 255, 1, 5);
        this.m_hueOffset.setDefValue(0);
        this.m_hueOffset.init();
        this.setDomainBounds(-1.0, -1.0, 1.0, 1.0);
        this.m_blockSize.setValue(1);
    }

    public boolean update(Object object) {
        if (object == this.m_maxIter) {
            this.m_colMap.setSize(this.m_maxIter.getValue() + 1);
            this.compute();
            return super.update((Object)this);
        }
        if (object == this.m_hueOffset) {
            this.computeColors();
            return super.update((Object)this);
        }
        return super.update(object);
    }

    protected boolean setImageSize(int n, int n2) {
        if (!super.setImageSize(n, n2)) {
            return false;
        }
        this.m_pixIter.setSize(this.m_imageWidth * this.m_imageHeight);
        return true;
    }

    public synchronized void compute() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_maxIter.getValue();
        int n2 = this.m_blockSize.getValue();
        double d = this.m_domainBounds.m_data[0];
        double d2 = this.m_domainBounds.m_data[2];
        double d3 = this.m_domainBounds.m_data[1];
        double d4 = this.m_domainBounds.m_data[3];
        this.compute(this.m_pixIter.m_data, this.m_imageWidth, this.m_imageHeight, n2, d, d3, d2, d4, n);
        this.computeColors();
    }

    private void compute(int[] nArray, int n, int n2, int n3, double d, double d2, double d3, double d4, int n4) {
        if (n <= 1 || n2 <= 1) {
            return;
        }
        PuComplex puComplex = new PuComplex();
        PuComplex puComplex2 = new PuComplex();
        double d5 = (double)n3 * (d3 - d) / ((double)n - 1.0);
        double d6 = (double)n3 * (d4 - d2) / ((double)n2 - 1.0);
        int n5 = 0;
        double d7 = d4 - d6 / 2.0;
        for (int i = 0; i < n2; i += n3) {
            int n6;
            int n7;
            int n8 = n5;
            double d8 = d + d5 / 2.0;
            for (n7 = 0; n7 < n; n7 += n3) {
                int n9;
                puComplex2.set(d8, d7);
                puComplex.set(d8, d7);
                n6 = 0;
                for (n9 = 0; n9 < n4; ++n9) {
                    puComplex.sqr().add(puComplex2);
                    if (!(puComplex.sqrAbs() > 4.0)) continue;
                    n6 = n9 + 1;
                    break;
                }
                n9 = Math.min(n3, n - n7);
                for (int j = 0; j < n9; ++j) {
                    nArray[n5++] = n6;
                }
                d8 += d5;
            }
            n7 = Math.min(n3, n2 - i) - 1;
            for (n6 = 0; n6 < n7; ++n6) {
                System.arraycopy(nArray, n8, nArray, n5, n);
                n5 += n;
            }
            d7 -= d6;
        }
    }

    public void computeColors() {
        if (this.m_imageWidth <= 0 || this.m_imageHeight <= 0) {
            return;
        }
        int n = this.m_hueOffset.getValue();
        int n2 = this.m_pixIter.min();
        int n3 = this.m_maxIter.getValue() + 1;
        int n4 = this.m_imageWidth * this.m_imageHeight;
        this.computeColors(this.m_pix.m_data, this.m_pixIter.m_data, n4, n2, n3, 4, n);
        super.computeColors();
    }

    private void computeColors(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n3 - n2 + 1;
        this.m_colMap.setSize(n7);
        float f = (float)(1.5707963267948966 / (double)n7);
        for (n6 = 0; n6 < n7; ++n6) {
            float f2 = (float)Math.sin(f * (float)n6);
            int n8 = (int)(205.0f * f2);
            int n9 = 0;
            if (n6 == 0) {
                n9 = -13158601;
            } else {
                int n10 = 0;
                switch (n4) {
                    case 2: {
                        n9 = 0xFF000000 | (50 + n8) % 255 << 16 | 0 | 0;
                        break;
                    }
                    case 4: {
                        n10 += n5;
                    }
                    case 3: {
                        if ((n10 += n8) > 255) {
                            n10 -= 255;
                        }
                        n9 = PdColor.hsv2rgbAsInt((int)n10, (int)255, (int)255);
                        break;
                    }
                    case 1: {
                        n9 = 0;
                    }
                }
            }
            this.m_colMap.m_data[n6] = n9;
        }
        for (n6 = 0; n6 < n; ++n6) {
            int n11 = nArray2[n6] - n2;
            nArray[n6] = this.m_colMap.m_data[n11];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

