/*
 * Decompiled with CFR 0.152.
 */
package vgp.discrete.conformal;

import java.awt.Color;
import jv.function.PuFunction;
import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.project.PvPickListenerIf;
import jv.project.PvViewerIf;
import jvx.geom.PnConjugate;
import jvx.numeric.PnDiriEnergy;
import jvx.numeric.PnEnergy;
import jvx.numeric.PnEnergyMinimizer;
import jvx.surface.PgDomain;
import jvx.surface.PgDomainDescr;
import jvx.surface.PgSurfaceGraph;

public class PjConformal
extends PjProject {
    public static final int SURFACE = 0;
    public static final int DUAL = 1;
    protected int m_activeSurface = 0;
    protected PgSurfaceGraph m_graph;
    protected PuFunction m_graphFunction;
    protected PgDomain m_domain = new PgDomain(2);
    protected PgElementSet m_scalar;
    protected PgDomainDescr m_descr;
    protected PgSurfaceGraph m_graphConj;
    protected PgElementSet m_conjDomain;
    protected PgElementSet m_conj;
    protected PgSurfaceGraph m_graphConjFull;
    protected PgElementSet m_conjDomainFull;
    protected PgElementSet m_conjFull;
    protected PgSurfaceGraph m_confMap;
    protected PgElementSet m_confReal;
    protected PgElementSet m_confImag;
    protected PgSurfaceGraph m_confMapExact;
    protected PuFunction m_confMapExactFunction;
    protected PgElementSet m_confMapDomain;
    protected PgElementSet m_confImagExact;
    protected PnEnergyMinimizer m_diri;
    protected int m_uLines = 4;
    protected int m_vLines = 4;
    static /* synthetic */ Class class$vgp$discrete$conformal$PjConformal;

    public PjConformal() {
        super("Discrete Conformal Maps");
        this.m_domain.setName("Domain");
        this.m_conjDomain = new PgElementSet(2);
        this.m_conjDomain.setName("Conjugate Domain");
        this.m_conjDomainFull = new PgElementSet(2);
        this.m_conjDomainFull.setName("Conjugate Domain Full");
        this.m_scalar = new PgElementSet(1);
        this.m_scalar.setName("Harmonic");
        this.m_conj = new PgElementSet(1);
        this.m_conj.setName("Conjugate");
        this.m_conjFull = new PgElementSet(1);
        this.m_conjFull.setName("Conjugate Full");
        this.m_confReal = new PgElementSet(1);
        this.m_confReal.setName("Real Part");
        this.m_confImag = new PgElementSet(1);
        this.m_confImag.setName("Imag Part");
        this.m_confMapDomain = new PgElementSet(2);
        this.m_confMapDomain.setName("Domain of Conformal Map");
        this.m_confImagExact = new PgElementSet(2);
        this.m_confImagExact.setName("Exact Conformal Map");
        this.m_graphFunction = new PuFunction(2, 1);
        this.m_graphFunction.setName("Real Part of Conformal Map");
        this.m_graphFunction.addUpdateListener((PsUpdateIf)this);
        this.m_confMapExactFunction = new PuFunction(2, 2);
        this.m_confMapExactFunction.setName("Exact Conformal Map");
        this.m_confMapExactFunction.addUpdateListener((PsUpdateIf)this);
        if (((Object)((Object)this)).getClass() == (class$vgp$discrete$conformal$PjConformal == null ? (class$vgp$discrete$conformal$PjConformal = PjConformal.class$("vgp.discrete.conformal.PjConformal")) : class$vgp$discrete$conformal$PjConformal)) {
            this.init();
        }
    }

    public void init() {
        this.m_domain.setDimOfElements(3);
        this.m_domain.setGlobalElementColor(Color.lightGray);
        this.m_descr = this.m_domain.getDescr();
        this.m_descr.setMaxSize(-10.0, -10.0, 10.0, 10.0);
        this.m_descr.setSize(0.0, 0.0, 1.0, 1.0);
        this.m_descr.setDiscrBounds(2, 2, 50, 50);
        this.m_descr.setDiscr(this.m_uLines, this.m_uLines);
        this.m_domain.compute();
        PnConjugate.makeNonConforming((PgElementSet)this.m_domain);
        PnConjugate.makeConforming((PgElementSet)this.m_domain);
        this.m_domain.fixBoundaries();
        this.m_scalar.setNumVertices(this.m_domain.getNumVertices());
        this.m_scalar.copyElementSet((PgElementSet)this.m_domain);
        this.m_graph = new PgSurfaceGraph(this.m_domain.getDimOfVertices() + this.m_scalar.getDimOfVertices());
        this.m_graph.setSurfaces((PgElementSet)this.m_domain, this.m_scalar);
        this.m_graph.setName("Graph");
        this.m_graph.setParent((PsUpdateIf)this);
        this.addGeometry((PgGeometryIf)this.m_domain);
        this.addGeometry((PgGeometryIf)this.m_graph);
        this.selectGeometry((PgGeometryIf)this.m_graph);
        this.m_graphFunction.setExpression("u*u*u-3*u*v*v");
        this.m_diri = new PnEnergyMinimizer();
        this.m_diri.setParent((PsUpdateIf)this);
        this.m_diri.setSurface((PgElementSet)this.m_domain, this.m_scalar);
        this.m_diri.setEnergy((PnEnergy)new PnDiriEnergy());
        this.m_conjDomain.copy((PsObject)this.m_domain);
        this.m_conjDomain.setGlobalElementColor(Color.lightGray);
        this.m_conj = PnConjugate.conjugate((PgElementSet)this.m_conj, (PgElementSet)this.m_scalar, (PgElementSet)this.m_domain);
        PnConjugate.makeNonConforming((PgElementSet)this.m_conjDomain);
        this.m_graphConj = new PgSurfaceGraph(this.m_conjDomain.getDimOfVertices() + this.m_conj.getDimOfVertices());
        this.m_graphConj.setSurfaces(this.m_conjDomain, this.m_conj);
        this.m_graphConj.setName("Graph of Conjugate");
        this.m_graphConj.setParent((PsUpdateIf)this);
        this.m_graphConj.update((Object)this.m_conj);
        this.m_conjDomainFull.copy((PsObject)this.m_domain);
        PnConjugate.makeConformingToFull((PgElementSet)this.m_conjDomainFull);
        this.m_conjDomainFull.setGlobalElementColor(Color.lightGray);
        this.m_conjFull = PnConjugate.conjugateToFull((PgElementSet)this.m_conjFull, (PgElementSet)this.m_scalar, (PgElementSet)this.m_domain);
        PnConjugate.makeConformingToFull((PgElementSet)this.m_conjFull);
        this.m_graphConjFull = new PgSurfaceGraph(this.m_conjDomainFull.getDimOfVertices() + this.m_conjFull.getDimOfVertices());
        this.m_graphConjFull.setSurfaces(this.m_conjDomainFull, this.m_conjFull);
        this.m_graphConjFull.setName("Graph of Conjugate Proof");
        this.m_graphConjFull.setParent((PsUpdateIf)this);
        this.m_graphConjFull.update((Object)this.m_conjFull);
        this.m_confReal.copy((PsObject)this.m_scalar);
        this.m_confImag.copy((PsObject)this.m_conj);
        if (this.m_confReal.isConforming()) {
            PnConjugate.makeNonConforming((PgElementSet)this.m_confReal);
        }
        if (this.m_confImag.isConforming()) {
            PnConjugate.makeNonConforming((PgElementSet)this.m_confImag);
        }
        this.m_confMap = new PgSurfaceGraph(this.m_confReal.getDimOfVertices() + this.m_confImag.getDimOfVertices());
        this.m_confMap.setSurfaces(this.m_confReal, this.m_confImag);
        this.m_confMap.setName("Discrete Conformal Map");
        this.m_confMap.setParent((PsUpdateIf)this);
        this.m_confMapDomain.copy((PsObject)this.m_domain);
        this.m_confImagExact.setGlobalElementColor(Color.lightGray);
        this.m_confImagExact.copy((PsObject)this.m_domain);
        this.m_confMapExact = new PgSurfaceGraph(this.m_confMapDomain.getDimOfVertices() + this.m_confImagExact.getDimOfVertices());
        this.m_confMapExact.setSurfaces(this.m_confMapDomain, this.m_confImagExact);
        this.m_confMapExactFunction.setExpression(0, "u*u*u-3*u*v*v");
        this.m_confMapExactFunction.setExpression(1, "3*u*u*v-v*v*v");
        this.m_confMapExact.setName("Exact Conformal Map");
        this.m_confMapDomain.setParent((PsUpdateIf)this.m_confMapExact);
        this.m_confMapExact.setParent((PsUpdateIf)this);
        this.m_confMapExact.update((Object)this.m_confMapDomain);
    }

    public void start() {
        PsDebug.notify((String)"PjConformal.start:");
        PvViewerIf pvViewerIf = this.getViewer();
        PvDisplayIf pvDisplayIf = pvViewerIf.newDisplay("Display Domain", true);
        pvDisplayIf.addPickListener((PvPickListenerIf)this);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_domain);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Display Conjugate", true);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_conjDomain);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_graphConj);
        pvDisplayIf.selectCamera(0);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Display Conjugate Proof", true);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_conjDomainFull);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_graphConjFull);
        pvDisplayIf.selectCamera(0);
        this.addDisplay(pvDisplayIf);
        pvDisplayIf = pvViewerIf.newDisplay("Display Conformal Map", true);
        pvDisplayIf.addPickListener((PvPickListenerIf)this);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_confImagExact);
        pvDisplayIf.addGeometry((PgGeometryIf)this.m_confMap);
        pvDisplayIf.selectCamera(1);
        this.addDisplay(pvDisplayIf);
        this.m_diri.minimize();
        super.start();
    }

    public boolean update(Object object) {
        PsDebug.notify((String)"PjConformal.update(): called");
        if (object == this.m_graph) {
            if (this.m_activeSurface == 0) {
                this.m_diri.setSurface((PgElementSet)this.m_domain, this.m_scalar);
            }
            this.m_conj = PnConjugate.conjugate((PgElementSet)this.m_conj, (PgElementSet)this.m_scalar, (PgElementSet)this.m_domain);
            this.m_conjDomain.copy((PsObject)this.m_domain);
            if (this.m_domain.isConforming()) {
                PnConjugate.makeNonConforming((PgElementSet)this.m_conjDomain);
            } else {
                PnConjugate.makeConforming((PgElementSet)this.m_conjDomain);
                PnConjugate.makeConforming((PgElementSet)this.m_conj);
            }
            this.m_graphConj.setSurfaces(this.m_conjDomain, this.m_conj);
            this.m_conjDomain.update((Object)this.m_conjDomain);
            this.m_conjDomainFull.copy((PsObject)this.m_domain);
            PnConjugate.makeConformingToFull((PgElementSet)this.m_conjDomainFull);
            this.m_conjFull = PnConjugate.conjugateToFull((PgElementSet)this.m_conjFull, (PgElementSet)this.m_scalar, (PgElementSet)this.m_domain);
            this.m_conjDomainFull.update((Object)this.m_conjDomainFull);
            this.m_confMapExact.compute(this.m_confMapExactFunction);
            this.m_graph.compute(this.m_graphFunction);
            this.m_graph.compute();
            this.m_confMapDomain.copy((PsObject)this.m_domain);
            this.m_confMapDomain.update((Object)this.m_confMapDomain);
            this.m_confImagExact.update((Object)this.m_confImagExact);
            super.update(null);
            return true;
        }
        if (object == this.m_graphConj) {
            if (this.m_activeSurface == 1) {
                this.m_diri.setSurface(this.m_conjDomain, this.m_conj);
            }
            if (this.m_confMap != null) {
                this.m_confReal.copy((PsObject)this.m_scalar);
                this.m_confImag.copy((PsObject)this.m_conj);
                if (this.m_confReal.isConforming()) {
                    PnConjugate.makeNonConforming((PgElementSet)this.m_confReal);
                }
                if (this.m_confImag.isConforming()) {
                    PnConjugate.makeNonConforming((PgElementSet)this.m_confImag);
                }
                this.m_confMap.setSurfaces(this.m_confReal, this.m_confImag);
                this.m_confMap.update((Object)this.m_confReal);
            }
            super.update(null);
            return true;
        }
        if (object == this.m_graphConjFull) {
            super.update(null);
            return true;
        }
        if (object == this.m_confMap) {
            super.update(null);
            return true;
        }
        if (object == this.m_confMapExact) {
            super.update(null);
            return true;
        }
        if (object == this.m_diri) {
            PsDebug.notify((String)"m_diri called");
            this.m_graph.update((Object)this.m_scalar);
            return true;
        }
        if (object == this.m_graphFunction) {
            this.m_graph.compute(this.m_graphFunction);
            this.m_graph.update((Object)this.m_graph);
            return super.update(null);
        }
        if (object == this.m_confMapExactFunction) {
            this.m_confMapExact.compute(this.m_confMapExactFunction);
            this.m_confImagExact.update((Object)this.m_confImagExact);
            return super.update(null);
        }
        return super.update(object);
    }

    public PgSurfaceGraph getActiveSurface() {
        switch (this.m_activeSurface) {
            case 0: {
                return this.m_graph;
            }
            case 1: {
                return this.m_graphConj;
            }
        }
        PsDebug.warning((String)("unknown id = " + this.m_activeSurface));
        return null;
    }

    public void setActiveSurface(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.m_activeSurface = n;
                break;
            }
            default: {
                PsDebug.warning((String)("unknown id = " + n));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

