/*
 * Decompiled with CFR 0.152.
 */
package vgp.curve.zigzag;

import java.awt.Color;
import jv.geom.PgPolygonSet;
import jv.number.PuInteger;
import jv.object.PsUpdateIf;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PvDisplayIf;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public class PjZigZag
extends PjProject {
    protected PgPolygonSet m_zShort = new PgPolygonSet(2);
    protected PgPolygonSet m_scale;
    protected PuInteger m_numLines = new PuInteger("Number of Lines", (PsUpdateIf)this);
    protected PuInteger m_angle1;
    protected PuInteger m_angle2;
    protected PuInteger m_zagLength = new PuInteger("Length of Zags", (PsUpdateIf)this);
    protected PuInteger m_delta = new PuInteger("Skipped Zags", (PsUpdateIf)this);
    protected int[] m_angle;
    protected int[] m_length;
    protected boolean m_bExt;
    protected boolean m_bZiza;
    static /* synthetic */ Class class$vgp$curve$zigzag$PjZigZag;

    public PjZigZag() {
        super("ZigZag");
        this.m_angle1 = new PuInteger("Angle of Zigs", (PsUpdateIf)this);
        this.m_angle2 = new PuInteger("Angle of Zags", (PsUpdateIf)this);
        this.m_angle = new int[2];
        this.m_length = new int[2];
        this.m_length[0] = 100;
        if (((Object)((Object)this)).getClass() == (class$vgp$curve$zigzag$PjZigZag == null ? (class$vgp$curve$zigzag$PjZigZag = PjZigZag.class$("vgp.curve.zigzag.PjZigZag")) : class$vgp$curve$zigzag$PjZigZag)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_zShort.setName("ZigZag");
        this.m_zShort.setGlobalVertexSize(0.1);
        this.m_zShort.setGlobalPolygonSize(1.0);
        this.m_zShort.setGlobalPolygonColor(Color.black);
        this.m_numLines.setDefBounds(1, 1000, 1, 10);
        this.m_numLines.setDefValue(40);
        this.m_numLines.init();
        this.m_zagLength.setDefBounds(1, 100, 1, 10);
        this.m_zagLength.setDefValue(40);
        this.m_zagLength.init();
        this.m_delta.setDefBounds(0, 10, 1, 1);
        this.m_delta.setDefValue(0);
        this.m_delta.init();
        this.m_angle1.setDefBounds(0, 180, 1, 10);
        this.m_angle1.setDefValue(45);
        this.m_angle1.init();
        this.m_angle2.setDefBounds(0, 180, 1, 10);
        this.m_angle2.setDefValue(9);
        this.m_angle2.init();
        this.m_bExt = false;
        this.m_bZiza = true;
        this.computeZigZag();
    }

    public void start() {
        this.addGeometry((PgGeometryIf)this.m_zShort);
        PvDisplayIf pvDisplayIf = this.getDisplay();
        pvDisplayIf.selectCamera(1);
        pvDisplayIf.setMajorMode(1);
        pvDisplayIf.setBackgroundColor(Color.white);
        super.start();
    }

    public boolean update(Object object) {
        if (object == this.m_numLines) {
            this.computeZigZag();
        } else if (object == this.m_zagLength) {
            this.computeZigZag();
        } else if (object == this.m_delta) {
            this.computeZigZag();
        } else if (object == this.m_angle1) {
            this.computeZigZag();
        } else if (object == this.m_angle2) {
            this.computeZigZag();
        } else if (object != this.m_zShort) {
            if (object == this) {
                this.computeZigZag();
            } else {
                return super.update(object);
            }
        }
        return true;
    }

    public void computeZigZag() {
        int n = 2 * this.m_numLines.getValue();
        double[] dArray = new double[2];
        this.m_angle[0] = this.m_angle1.getValue();
        this.m_angle[1] = this.m_angle2.getValue();
        dArray[0] = (double)this.m_angle[0] * Math.PI / 180.0;
        dArray[1] = (double)this.m_angle[1] * Math.PI / 180.0;
        this.m_length[1] = this.m_zagLength.getValue();
        int n2 = this.m_delta.getValue();
        this.m_zShort.setNumVertices(n + 1);
        this.m_zShort.setNumPolygons(this.m_numLines.getValue());
        this.m_zShort.setVertices(this.computeVertices(this.m_zShort, dArray, this.m_length));
        if (this.m_bExt) {
            this.m_zShort.setPolygons(this.showZags(this.m_zShort, n2));
        } else {
            this.m_zShort.setPolygons(this.showZigZag(this.m_zShort));
        }
        this.m_zShort.update((Object)this.m_zShort);
    }

    public PdVector[] computeVertices(PgPolygonSet pgPolygonSet, double[] dArray, int[] nArray) {
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        int n = pgPolygonSet.getNumVertices();
        for (int i = 0; i < n - 1; ++i) {
            int n2 = (int)Math.floor(i / 2);
            pdVectorArray[i + 1].m_data[0] = (double)nArray[0] / (2.0 * Math.sin(dArray[0] / 2.0)) * Math.sin(((double)n2 + 0.5) * dArray[0]) + (double)nArray[1] / (2.0 * Math.sin(dArray[1] / 2.0)) * Math.sin(((double)n2 + Math.pow(-1.0, i + 1) * 0.5) * dArray[1]) + 70.0;
            pdVectorArray[i + 1].m_data[1] = (double)(-nArray[0]) / (2.0 * Math.sin(dArray[0] / 2.0)) * Math.cos(((double)n2 + 0.5) * dArray[0]) - (double)nArray[1] / (2.0 * Math.sin(dArray[1] / 2.0)) * Math.cos(((double)n2 + Math.pow(-1.0, i + 1) * 0.5) * dArray[1]) + 374.83477;
        }
        pdVectorArray[0].m_data[0] = pdVectorArray[1].m_data[0] - (double)nArray[0];
        pdVectorArray[0].m_data[1] = pdVectorArray[1].m_data[1];
        return pdVectorArray;
    }

    public PiVector[] showZags(PgPolygonSet pgPolygonSet, int n) {
        PdVector[] pdVectorArray = pgPolygonSet.getVertices();
        PiVector[] piVectorArray = PiVector.realloc(null, (int)pgPolygonSet.getNumPolygons(), (int)2);
        int n2 = 6000;
        PdVector pdVector = new PdVector(pgPolygonSet.getDimOfVertices());
        int n3 = pgPolygonSet.getNumPolygons();
        for (int i = 0; i < n3; ++i) {
            pdVector.sub(pdVectorArray[2 * i + 2], pdVectorArray[2 * i + 1]);
            pdVector.multScalar((double)n2);
            pdVectorArray[2 * i + 2].add(pdVector);
            pdVectorArray[2 * i + 1].sub(pdVector);
            if (i % (n + 1) != 0) continue;
            piVectorArray[i].set(2 * i + 1, 2 * i + 2);
        }
        return piVectorArray;
    }

    public PiVector[] showZigZag(PgPolygonSet pgPolygonSet) {
        int n = pgPolygonSet.getNumPolygons();
        PiVector[] piVectorArray = PiVector.realloc(null, (int)n, (int)3);
        for (int i = 1; i < n + 1; ++i) {
            piVectorArray[i - 1].set(2 * i - 2, 2 * i - 1, 2 * i);
        }
        return piVectorArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

