/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.ruler;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsSlotLayout;
import jv.thirdParty.ruler.PgRuler;

public class PgRuler_CP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgRuler m_ruler;
    protected Checkbox m_cShowRuler;
    protected TextField m_tName;
    protected CheckboxGroup m_cbg;
    protected Checkbox[] m_cTickMode;
    protected Checkbox m_cName;
    protected Checkbox m_cBoundary;
    protected Checkbox m_cArrows;
    protected Checkbox m_cMajorTicks;
    protected Checkbox m_cMinorTicks;
    protected Checkbox m_cNumbers;
    protected Checkbox m_cAutoBounds;
    protected Checkbox m_cAutoTicks;
    protected PsPanel m_pTick;
    protected PsPanel m_pBounds;
    protected PsPanel m_pColor;
    protected PsPanel m_pBottomButtons;
    protected Button m_bReset;
    static /* synthetic */ Class class$jv$thirdParty$ruler$PgRuler_CP;

    public PgRuler_CP() {
        if (this.getClass() == (class$jv$thirdParty$ruler$PgRuler_CP == null ? (class$jv$thirdParty$ruler$PgRuler_CP = PgRuler_CP.class$("jv.thirdParty.ruler.PgRuler_CP")) : class$jv$thirdParty$ruler$PgRuler_CP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        String string = PsConfig.getMessage(true, 24000, "Ruler measures distances in the display.");
        PsMultiLineLabel psMultiLineLabel = new PsMultiLineLabel(string);
        this.add(psMultiLineLabel);
        PsPanel psPanel = new PsPanel(new GridLayout(1, 3));
        this.add(psPanel);
        Component component = this.getTitle("", PsConfig.getFont(3));
        psPanel.add(component);
        this.m_cShowRuler = new Checkbox(PsConfig.getMessage(true, 24000, "Show Ruler"));
        this.m_cShowRuler.addItemListener(this);
        psPanel.add(this.m_cShowRuler);
        this.m_tName = new TextField("", 7);
        this.m_tName.addActionListener(this);
        psPanel.add(this.m_tName);
        component = new PsPanel(new GridLayout(2, 3));
        ((PsPanel)component).setInsetSizeHorizontal(4);
        this.add(component);
        this.m_cName = new Checkbox(PsConfig.getMessage(24052));
        this.m_cName.addItemListener(this);
        ((Container)component).add(this.m_cName);
        this.m_cBoundary = new Checkbox(PsConfig.getMessage(24026));
        this.m_cBoundary.addItemListener(this);
        this.m_cBoundary.setEnabled(false);
        ((Container)component).add(this.m_cBoundary);
        this.m_cArrows = new Checkbox(PsConfig.getMessage(24400));
        this.m_cArrows.addItemListener(this);
        this.m_cArrows.setEnabled(false);
        ((Container)component).add(this.m_cArrows);
        this.m_cNumbers = new Checkbox(PsConfig.getMessage(24401));
        this.m_cNumbers.addItemListener(this);
        ((Container)component).add(this.m_cNumbers);
        this.m_cMajorTicks = new Checkbox(PsConfig.getMessage(24402));
        this.m_cMajorTicks.addItemListener(this);
        ((Container)component).add(this.m_cMajorTicks);
        this.m_cMinorTicks = new Checkbox(PsConfig.getMessage(24403));
        this.m_cMinorTicks.addItemListener(this);
        ((Container)component).add(this.m_cMinorTicks);
        this.addLine(1);
        PsPanel psPanel2 = new PsPanel(new GridLayout(1, 2));
        this.add(psPanel2);
        psPanel2.addSubTitle(PsConfig.getMessage(true, 24000, "Slider Bounds"));
        this.m_cAutoBounds = new Checkbox(PsConfig.getMessage(24409));
        this.m_cAutoBounds.addItemListener(this);
        this.m_pBounds = new PsPanel();
        this.add(this.m_pBounds);
        this.addLine(1);
        PsPanel psPanel3 = new PsPanel(new GridLayout(1, 2));
        this.add(psPanel3);
        psPanel3.addSubTitle(PsConfig.getMessage(24410));
        this.m_cAutoTicks = new Checkbox(PsConfig.getMessage(24411));
        this.m_cAutoTicks.addItemListener(this);
        PsPanel psPanel4 = new PsPanel(new PsSlotLayout(4));
        this.add(psPanel4);
        Label label = new Label(PsConfig.getMessage(24412));
        psPanel4.add("2", label);
        this.m_cbg = new CheckboxGroup();
        this.m_cTickMode = new Checkbox[2];
        this.m_cTickMode[0] = new Checkbox(PsConfig.getMessage(24200), this.m_cbg, true);
        this.m_cTickMode[0].addItemListener(this);
        psPanel4.add("1", this.m_cTickMode[0]);
        this.m_cTickMode[1] = new Checkbox(PsConfig.getMessage(24201), this.m_cbg, false);
        this.m_cTickMode[1].addItemListener(this);
        psPanel4.add("1", this.m_cTickMode[1]);
        this.m_pTick = new PsPanel(new GridLayout(2, 1));
        this.add(this.m_pTick);
        this.m_pColor = new PsPanel();
        this.m_pColor.addSubTitle(PsConfig.getMessage(true, 24000, "Style"));
        this.add(this.m_pColor);
        this.m_pBottomButtons = new PsPanel(new FlowLayout(1));
        this.m_bReset = new Button(PsConfig.getMessage(24104));
        this.m_bReset.addActionListener(this);
        this.m_pBottomButtons.add(this.m_bReset);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_ruler = (PgRuler)psUpdateIf;
        this.setTitle(PsConfig.getMessage(true, 24000, "Ruler"));
        int n = this.m_ruler.getHashMode();
        this.showTickSlider(n);
        this.m_pBounds.removeAll();
        this.m_pBounds.add(this.m_ruler.m_bndMin.newInspector("_IP"));
        this.m_pBounds.add(this.m_ruler.m_bndMax.newInspector("_IP"));
        this.m_pColor.add(this.m_ruler.m_edgeColor.newInspector("_IP"));
        this.m_pColor.add(this.m_ruler.m_edgeSize.newInspector("_IP"));
        this.validate();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_ruler == null) {
            PsDebug.warning("missing ruler");
            return true;
        }
        if (object == this.m_ruler) {
            PsPanel.setText(this.m_tName, this.m_ruler.getRulerName());
            PsPanel.setState(this.m_cShowRuler, this.m_ruler.isVisible());
            PsPanel.setState(this.m_cMajorTicks, this.m_ruler.isShowingMajorHashings());
            PsPanel.setState(this.m_cMinorTicks, this.m_ruler.isShowingMinorHashings());
            PsPanel.setState(this.m_cNumbers, this.m_ruler.isShowingLabels());
            PsPanel.setState(this.m_cName, this.m_ruler.isShowingRulerName());
            PsPanel.setState(this.m_cAutoBounds, this.m_ruler.isEnabledAutoBounds());
            PsPanel.setState(this.m_cAutoTicks, this.m_ruler.isEnabledAutoHashing());
            int n = this.m_ruler.getHashMode();
            if (this.m_cbg.getSelectedCheckbox() != this.m_cTickMode[n]) {
                this.m_cbg.setSelectedCheckbox(this.m_cTickMode[n]);
                this.showTickSlider(n);
            }
            return true;
        }
        return super.update(object);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PsDebug.notify("entered");
        if (this.m_ruler == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bReset) {
            this.m_ruler.init();
            this.m_ruler.update(this.m_ruler);
        } else if (object == this.m_tName) {
            this.m_ruler.setRulerName(this.m_tName.getText());
            this.m_ruler.update(this.m_ruler);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.m_ruler == null) {
            return;
        }
        Object object = itemEvent.getSource();
        if (object == this.m_cShowRuler) {
            this.m_ruler.setVisible(this.m_cShowRuler.getState());
        } else if (object == this.m_cMajorTicks) {
            this.m_ruler.showMajorHashings(this.m_cMajorTicks.getState());
        } else if (object == this.m_cMinorTicks) {
            this.m_ruler.showMinorHashings(this.m_cMinorTicks.getState());
        } else if (object == this.m_cNumbers) {
            this.m_ruler.showLabels(this.m_cNumbers.getState());
        } else if (object == this.m_cName) {
            this.m_ruler.showRulerName(this.m_cName.getState());
        } else if (object == this.m_cTickMode[0]) {
            this.showTickSlider(0);
            this.m_ruler.setHashMode(0);
        } else if (object == this.m_cTickMode[1]) {
            this.showTickSlider(1);
            this.m_ruler.setHashMode(1);
        } else if (object == this.m_cAutoBounds) {
            this.m_ruler.setEnabledAutoBounds(this.m_cAutoBounds.getState());
        } else if (object == this.m_cAutoTicks) {
            this.m_ruler.setEnabledAutoHashing(this.m_cAutoTicks.getState());
        } else {
            return;
        }
        this.m_ruler.update(this.m_ruler);
    }

    protected void showTickSlider(int n) {
        this.m_pTick.removeAll();
        if (n == 0) {
            this.m_pTick.add(this.m_ruler.m_majorHashUnits.getInfoPanel());
            this.m_pTick.add(this.m_ruler.m_minorHashUnits.getInfoPanel());
        } else {
            this.m_pTick.add(this.m_ruler.m_numMajorHashings.getInfoPanel());
            this.m_pTick.add(this.m_ruler.m_numMinorHashings.getInfoPanel());
        }
        this.validate();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

