/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.expr;

import java.io.Serializable;
import jv.number.PuComplex;
import jv.thirdParty.expr.App1;
import jv.thirdParty.expr.App2;
import jv.thirdParty.expr.Literal;
import jv.thirdParty.expr.Variable;

public abstract class Expr
implements Serializable {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int POW = 4;
    public static final int ABS = 100;
    public static final int ACOS = 101;
    public static final int ASIN = 102;
    public static final int ATAN = 103;
    public static final int ACOT = 104;
    public static final int CEIL = 105;
    public static final int COS = 106;
    public static final int EXP = 107;
    public static final int FLOOR = 108;
    public static final int LOG = 109;
    public static final int NEG = 110;
    public static final int ROUND = 111;
    public static final int SIN = 112;
    public static final int SQRT = 113;
    public static final int TAN = 114;
    public static final int COT = 115;
    public static final int SINH = 116;
    public static final int COSH = 117;
    public static final int TANH = 118;
    public static final int COTH = 119;
    public static final int ASINH = 120;
    public static final int ACOSH = 121;
    public static final int ATANH = 122;
    public static final int ACOTH = 123;
    public static final int SIGN = 124;
    public static final int ARG = 125;
    public static final int CONJ = 126;
    public static final int INV = 127;
    public static final int RE = 128;
    public static final int IM = 129;
    public static final int CMPLX = 130;
    public static final int TYPE_REAL = 0;
    public static final int TYPE_COMPLEX = 1;
    public static final int TYPE_DEPENDS = 2;
    protected PuComplex m_z;
    protected boolean m_bComplex = false;

    public boolean isComplex() {
        return this.m_bComplex;
    }

    protected static int isComplex(int n) {
        switch (n) {
            case 100: 
            case 125: 
            case 128: 
            case 129: {
                return 0;
            }
            case 130: {
                return 1;
            }
        }
        return 2;
    }

    protected static boolean isComplex(int n, Expr expr) {
        switch (Expr.isComplex(n)) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return expr.isComplex();
    }

    protected static boolean isComplex(int n, Expr expr, Expr expr2) {
        switch (Expr.isComplex(n)) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return expr.isComplex() || expr2.isComplex();
    }

    public void setComplex(boolean bl) {
        if (bl && this.m_z == null) {
            this.m_z = new PuComplex();
        }
        this.m_bComplex = bl;
    }

    public abstract PuComplex getComplexValue();

    public abstract double getValue();

    public abstract boolean contains(Variable var1);

    public static Expr make_app1(int n, Expr expr) {
        App1 app1 = new App1(n, expr);
        return expr instanceof Literal ? new Literal(((Expr)app1).getValue()) : app1;
    }

    public static Expr make_app2(int n, Expr expr, Expr expr2) {
        App2 app2 = new App2(n, expr, expr2);
        return expr instanceof Literal && expr2 instanceof Literal ? new Literal(((Expr)app2).getValue()) : app2;
    }
}

