/*
 * Decompiled with CFR 0.152.
 */
package jv.loader;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;
import jv.project.PgJvxSrc;
import jv.rsrc.PsJavaView;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgObjLoader
extends PgAbstractLoader {
    protected boolean m_bHandleVectors = false;
    protected int m_numVertices = 0;
    protected int m_numColors = 0;
    protected int m_numNormals = 0;
    protected int m_numNormalIndices = 0;
    protected int m_numTextures = 0;
    protected int m_numTextureIndices = 0;
    protected int m_numVertexVectors = 0;
    protected int m_numPolygons = 0;
    protected int m_numElements = 0;
    protected int m_numMeshType = 0;
    protected Vector m_vVertex;
    protected Vector m_vVertexColor;
    protected Vector m_vNormal;
    protected Vector m_vNormalInd;
    protected Vector m_vTexture;
    protected Vector m_vTextureInd;
    protected Vector m_vVertexVector;
    protected int[] m_meshType;
    protected int m_dimOfElements = -1;
    protected Vector m_vElement;
    protected Vector m_vElementColor;
    protected Vector m_vElementNormal;
    protected int m_dimOfPolygons = -1;
    protected Vector m_vPolygon;
    protected Vector m_vPolygonColor;
    protected PiVector m_vPolygonColorInd;
    private static final String StrNL = "\n";
    protected static boolean m_bNormals = false;
    protected static boolean m_bVertexTextures = false;
    protected static boolean m_bElementTextures = false;
    protected static boolean m_bVertexVector = false;
    protected static boolean m_bPolygonNormals = false;

    public PgJvxSrc[] read(String string) {
        BufferedReader bufferedReader = PsUtil.open(string);
        if (bufferedReader == null) {
            PsDebug.warning("could not open = " + string);
            return null;
        }
        PgJvxSrc[] pgJvxSrcArray = this.read(bufferedReader);
        if (pgJvxSrcArray != null && pgJvxSrcArray.length > 0 && pgJvxSrcArray[0] != null) {
            pgJvxSrcArray[0].setName(PsUtil.getFileBaseName(string));
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pgJvxSrcArray;
    }

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        int n;
        PdVector[] pdVectorArray;
        Object object;
        int n2;
        Enumeration enumeration;
        Object object2;
        Serializable[] serializableArray;
        if (bufferedReader == null) {
            PsDebug.warning("missing reader");
            return null;
        }
        long l = 0L;
        long l2 = 0L;
        if (PsDebug.PROFILE) {
            l = PsDebug.getTimeUsed();
        }
        boolean bl = this.parse(bufferedReader);
        if (PsDebug.PROFILE) {
            l = PsDebug.getTimeUsed() - l;
            PsDebug.message("PgObjLoader#parse-obj = " + l, true);
        }
        if (!bl) {
            PsDebug.warning("error during parsing of reader");
            return null;
        }
        if (PsDebug.PROFILE) {
            l2 = PsDebug.getTimeUsed();
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setEnabledInstanceSharing(true);
        if (this.m_numMeshType > 0 && this.m_meshType[0] == 1) {
            switch (this.m_meshType[1]) {
                case 1: {
                    pgJvxSrc.setType(32);
                    break;
                }
                case 2: {
                    pgJvxSrc.setType(33);
                    break;
                }
                case 3: {
                    pgJvxSrc.setType(34);
                    break;
                }
                default: {
                    pgJvxSrc.setType(30);
                    break;
                }
            }
        } else if (this.m_numElements > 0) {
            pgJvxSrc.setType(33);
        } else if (this.m_numPolygons > 0) {
            pgJvxSrc.setType(32);
        } else {
            pgJvxSrc.setType(30);
        }
        if (this.m_numVertices > 0) {
            serializableArray = (Color[])this.m_vVertex.elementAt(0);
            pgJvxSrc.setDimOfVertices(serializableArray.getSize());
            pgJvxSrc.setNumVertices(this.m_numVertices);
            object2 = new PdVector[this.m_numVertices];
            enumeration = this.m_vVertex.elements();
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                object2[n2] = (PdVector)enumeration.nextElement();
            }
            pgJvxSrc.setVertices((PdVector[])object2);
            this.m_vVertex = null;
        }
        if (this.m_numColors > 0 && this.m_numColors == this.m_numVertices) {
            serializableArray = new Color[this.m_numColors];
            n2 = 0;
            object2 = this.m_vVertexColor.elements();
            while (object2.hasMoreElements()) {
                serializableArray[n2++] = (Color)object2.nextElement();
            }
            pgJvxSrc.setVertexColors((Color[])serializableArray);
            pgJvxSrc.showElementColors(true);
            pgJvxSrc.showElementColorFromVertices(true);
            this.m_vVertexColor = null;
        }
        if (this.m_numNormals > 0 && this.m_numNormals == this.m_numVertices) {
            serializableArray = new PdVector[this.m_numNormals];
            n2 = 0;
            object2 = this.m_vNormal.elements();
            while (object2.hasMoreElements()) {
                serializableArray[n2++] = (PdVector)object2.nextElement();
            }
            pgJvxSrc.setVertexNormals((PdVector[])serializableArray);
            this.m_vNormal = null;
        }
        if (this.m_bHandleVectors && this.m_numVertexVectors > 0) {
            if (this.m_numVertexVectors % this.m_numVertices == 0) {
                int n3 = this.m_numVertexVectors / this.m_numVertices;
                pgJvxSrc.setNumVectorFields(n3);
                object2 = this.m_vVertexVector.elements();
                for (int i = 0; i < n3; ++i) {
                    object = (PdVector)this.m_vVertexVector.elementAt(i * this.m_numVertices);
                    pgJvxSrc.setNumVectors(i, this.m_numVertices, ((PdVector)object).getSize());
                    pdVectorArray = pgJvxSrc.getVectors(i);
                    n2 = 0;
                    for (n = 0; n < this.m_numVertices; ++n) {
                        pdVectorArray[n2++] = (PdVector)object2.nextElement();
                    }
                }
            } else {
                PsDebug.warning("numVertexVectors%numVertices!=0");
            }
            this.m_vVertexVector = null;
        }
        if (this.m_numElements > 0) {
            pgJvxSrc.setDimOfElements(this.m_dimOfElements);
            pgJvxSrc.setNumElements(this.m_numElements);
            PiVector[] piVectorArray = new PiVector[this.m_numElements];
            object2 = this.m_vElement.elements();
            for (n2 = 0; n2 < this.m_numElements; ++n2) {
                piVectorArray[n2] = (PiVector)object2.nextElement();
            }
            pgJvxSrc.setElements(piVectorArray);
            this.m_vElement = null;
        }
        if (this.m_numTextures > 0) {
            pgJvxSrc.assureElementTextures();
            PdVector[][] pdVectorArray2 = pgJvxSrc.getElementTextures();
            object2 = pgJvxSrc.getElements();
            for (n2 = 0; n2 < this.m_numElements; ++n2) {
                int n4 = ((PiVector)object2[n2]).getSize();
                object = this.m_vTextureInd.elementAt(n2);
                if (object == this) continue;
                pdVectorArray = (PdVector[])object;
                for (n = 0; n < n4; ++n) {
                    pdVectorArray2[n2][n].copyArray((PdVector)this.m_vTexture.elementAt(pdVectorArray.getEntry(n)));
                }
            }
            pgJvxSrc.setTextureImageName(PsConfig.getCodeBase() + PsConfig.getJavaViewLogo());
            pgJvxSrc.setFilterType(0);
            pgJvxSrc.setTextureSide(3);
            pgJvxSrc.setTexturePeriodic(0);
            pgJvxSrc.showElementTexture(true);
            this.m_vTexture = null;
            this.m_vTextureInd = null;
        }
        if (this.m_numPolygons > 0) {
            pgJvxSrc.setDimOfPolygons(this.m_dimOfPolygons);
            pgJvxSrc.setNumPolygons(this.m_numPolygons);
            PiVector[] piVectorArray = new PiVector[this.m_numPolygons];
            n2 = 0;
            object2 = this.m_vPolygon.elements();
            while (object2.hasMoreElements()) {
                piVectorArray[n2++] = (PiVector)object2.nextElement();
            }
            pgJvxSrc.setPolygons(piVectorArray);
            this.m_vPolygon = null;
        }
        if (this.m_vPolygonColor != null && this.m_vPolygonColor.size() > 0) {
            pgJvxSrc.assurePolygonColors();
            Color[] colorArray = new Color[this.m_numPolygons];
            n2 = 0;
            object2 = (Color)this.m_vPolygonColor.firstElement();
            for (n = 0; n < this.m_vPolygonColorInd.getEntry(0); ++n) {
                colorArray[n] = object2;
            }
            enumeration = this.m_vPolygonColor.elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Color)enumeration.nextElement();
                for (n = this.m_vPolygonColorInd.getEntry(n2); n < this.m_vPolygonColorInd.getEntry(n2 + 1); ++n) {
                    colorArray[n] = object2;
                }
                ++n2;
            }
            pgJvxSrc.setPolygonColors(colorArray);
            pgJvxSrc.showPolygonColors(true);
            this.m_vPolygonColor = null;
            this.m_vPolygonColorInd = null;
        }
        PgObjLoader.geomInitType(pgJvxSrc);
        pgJvxSrc.setEnabledInstanceSharing(false);
        if (PsDebug.PROFILE) {
            l2 = PsDebug.getTimeUsed() - l;
            PsDebug.message("PgObjLoader#assign-obj = " + l2, true);
        }
        return new PgJvxSrc[]{pgJvxSrc};
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                break;
            }
            case 33: {
                pgJvxSrc.showEdges(false);
                pgJvxSrc.showElements(true);
                break;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean parse(BufferedReader var1_1) {
        block55: {
            var2_2 = 3;
            var3_3 = 200;
            var4_4 = 4;
            var5_5 = 5;
            var6_6 = new int[var2_2];
            var7_7 = new float[var2_2];
            var8_8 = new double[var4_4];
            var9_9 = new double[var4_4];
            var10_10 = new double[var4_4];
            var11_11 = new double[var4_4];
            var12_12 = new int[var3_3];
            var13_13 = new int[var3_3];
            var14_14 = new int[var3_3];
            var15_15 = new int[var3_3];
            this.m_vVertex = new Vector<E>();
            this.m_vVertexColor = new Vector<E>();
            this.m_vNormal = new Vector<E>();
            this.m_vNormalInd = new Vector<E>();
            this.m_vTexture = new Vector<E>();
            this.m_vTextureInd = new Vector<E>();
            this.m_vVertexVector = new Vector<E>();
            this.m_vElement = new Vector<E>();
            this.m_vElementColor = new Vector<E>();
            this.m_vPolygon = new Vector<E>();
            this.m_vPolygonColor = new Vector<E>();
            this.m_vPolygonColorInd = new PiVector();
            var16_16 = new StreamTokenizer(var1_1);
            var16_16.eolIsSignificant(true);
            var16_16.parseNumbers();
            var16_16.ordinaryChars(47, 47);
            var16_16.commentChar(35);
            var16_16.commentChar(36);
            this.m_numVertices = 0;
            this.m_numNormals = 0;
            this.m_numTextures = 0;
            this.m_numElements = 0;
            try {
                var18_17 = 0;
                var19_19 = false;
                block7: while (!var19_19) {
                    block1 : switch (var16_16.nextToken()) {
                        default: {
                            PsDebug.warning("parsing broke abnormally in line=" + var16_16.lineno() + " reading st.sval=" + var16_16.sval + ", st.ttype=" + var16_16.ttype);
                            return false;
                        }
                        case 10: {
                            continue block7;
                        }
                        case -1: {
                            PsDebug.notify("eof token = " + var16_16.sval);
                            break block55;
                        }
                        case -3: {
                            if (!"f".equals(var16_16.sval) && !"fo".equals(var16_16.sval)) ** GOTO lbl114
                            if (PsJavaView.m_bOnlyVertices) {
                                var19_19 = true;
                                continue block7;
                            }
                            if (var16_16.nextToken() == 92) {
                                var16_16.nextToken();
                            } else {
                                var16_16.pushBack();
                            }
                            var17_20 = 0;
                            var20_21 = false;
                            var21_29 = false;
                            while (var16_16.nextToken() == -2) {
                                var12_12[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl91
                                if (var16_16.nextToken() != -2) ** GOTO lbl82
                                var21_29 = true;
                                var14_14[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl80
                                if (var16_16.nextToken() == -2) {
                                    var20_21 = true;
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var16_16.lineno());
                                    break;
lbl80:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
                                ** GOTO lbl92
lbl82:
                                // 1 sources

                                if (var16_16.ttype != 47) ** GOTO lbl89
                                if (var16_16.nextToken() == -2) {
                                    var20_21 = true;
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of face in line=" + var16_16.lineno());
                                    break;
lbl89:
                                    // 1 sources

                                    PsDebug.warning("parse error in face/ = " + this.m_numElements + "/" + var17_20);
                                    break;
lbl91:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
lbl92:
                                // 4 sources

                                ++var17_20;
                            }
                            if (var17_20 > 0) {
                                var22_31 = new PiVector(var17_20);
                                var22_31.copy(var12_12, var17_20);
                                this.m_vElement.addElement(var22_31);
                                if (var21_29 && !PsJavaView.m_bFilterElementTexture) {
                                    var23_32 = new PiVector(var17_20);
                                    var23_32.copy(var14_14, var17_20);
                                    this.m_vTextureInd.addElement(var23_32);
                                }
                                if (var20_21 && !PsJavaView.m_bFilterElementNormals) {
                                    var23_32 = new PiVector(var17_20);
                                    var23_32.copy(var13_13, var17_20);
                                    this.m_vNormalInd.addElement(var23_32);
                                }
                                ++this.m_numElements;
                            } else {
                                PsDebug.warning("face with no vertex in line=" + var16_16.lineno());
                            }
                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                            }
                            ** GOTO lbl270
lbl114:
                            // 1 sources

                            if (!"v".equals(var16_16.sval)) ** GOTO lbl138
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                if (var17_20 < 3) {
                                    var16_16.pushBack();
                                    var8_8[var17_20] = PuDouble.parseDouble(var16_16);
                                } else {
                                    var6_6[var17_20 - 3] = (int)var16_16.nval;
                                }
                                ++var17_20;
                            }
                            if (PsJavaView.m_bFilterVertices && ++var18_17 % 100 != 1) continue block7;
                            if (var17_20 <= 0) ** GOTO lbl136
                            ++this.m_numVertices;
                            var20_22 = new PdVector(Math.min(3, var17_20));
                            var20_22.copy(var8_8, var17_20);
                            this.m_vVertex.addElement(var20_22);
                            if (var17_20 == 6) {
                                var21_30 = new Color(var6_6[0], var6_6[1], var6_6[2]);
                                this.m_vVertexColor.addElement(var21_30);
                                ++this.m_numColors;
                                break;
                            }
                            ** GOTO lbl270
lbl136:
                            // 1 sources

                            PsDebug.warning("vertex with no coords in line=" + var16_16.lineno());
                            break;
lbl138:
                            // 1 sources

                            if ("vc".equals(var16_16.sval)) {
                                var17_20 = 0;
                                while (var16_16.nextToken() == -2) {
                                    var16_16.pushBack();
                                    var7_7[var17_20] = (float)PuDouble.parseDouble(var16_16);
                                    ++var17_20;
                                }
                                if (PsJavaView.m_bFilterVertexColors) continue block7;
                                if (var17_20 == 3) {
                                    var20_23 = new Color(var7_7[0], var7_7[1], var7_7[2]);
                                    this.m_vVertexColor.addElement(var20_23);
                                    ++this.m_numColors;
                                    break;
                                }
                                PsDebug.warning("vertex color with wrong num coords in line=" + var16_16.lineno());
                                break;
                            }
                            if ("vn".equals(var16_16.sval)) {
                                var17_20 = 0;
                                while (var16_16.nextToken() == -2) {
                                    var16_16.pushBack();
                                    var9_9[var17_20] = PuDouble.parseDouble(var16_16);
                                    ++var17_20;
                                }
                                if (PsJavaView.m_bFilterVertexNormals) continue block7;
                                if (var17_20 > 0) {
                                    var20_24 = new PdVector(var17_20);
                                    var20_24.copy(var9_9, var17_20);
                                    this.m_vNormal.addElement(var20_24);
                                    ++this.m_numNormals;
                                    break;
                                }
                                PsDebug.warning("vertex normal with no coords in line=" + var16_16.lineno());
                                break;
                            }
                            if ("vt".equals(var16_16.sval)) {
                                var17_20 = 0;
                                while (var16_16.nextToken() == -2) {
                                    var16_16.pushBack();
                                    var10_10[var17_20++] = PuDouble.parseDouble(var16_16);
                                }
                                if (PsJavaView.m_bFilterVertexTexture) continue block7;
                                if (var17_20 > 0) {
                                    var20_25 = new PdVector(var17_20);
                                    var20_25.copy(var10_10, var17_20);
                                    this.m_vTexture.addElement(var20_25);
                                    ++this.m_numTextures;
                                    break;
                                }
                                PsDebug.warning("vertex texture with no coords in line=" + var16_16.lineno());
                                break;
                            }
                            if ("vd".equals(var16_16.sval)) {
                                var17_20 = 0;
                                while (var16_16.nextToken() == -2) {
                                    var16_16.pushBack();
                                    var11_11[var17_20++] = PuDouble.parseDouble(var16_16);
                                }
                                if (var17_20 > 0) {
                                    var20_26 = new PdVector(var17_20);
                                    var20_26.copy(var11_11, var17_20);
                                    this.m_vVertexVector.addElement(var20_26);
                                    ++this.m_numVertexVectors;
                                    break;
                                }
                                PsDebug.warning("vertex user data with no values in line=" + var16_16.lineno());
                                break;
                            }
                            if (!"l".equals(var16_16.sval) && !"lo".equals(var16_16.sval)) ** GOTO lbl243
                            if (PsJavaView.m_bOnlyVertices) {
                                var19_19 = true;
                                continue block7;
                            }
                            var17_20 = 0;
                            while (var16_16.nextToken() == -2) {
                                var15_15[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl228
                                if (var16_16.nextToken() != -2) ** GOTO lbl220
                                var14_14[var17_20] = (int)var16_16.nval - 1;
                                var16_16.nextToken();
                                if (var16_16.ttype != 47) ** GOTO lbl218
                                if (var16_16.nextToken() == -2) {
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_16.lineno());
                                    break;
lbl218:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
                                ** GOTO lbl229
lbl220:
                                // 1 sources

                                if (var16_16.ttype != 47) ** GOTO lbl226
                                if (var16_16.nextToken() == -2) {
                                    var13_13[var17_20] = (int)var16_16.nval - 1;
                                } else {
                                    PsDebug.warning("parse error of polygon in line=" + var16_16.lineno());
                                    break;
lbl226:
                                    // 1 sources

                                    PsDebug.warning("parse error in polygon/ = " + this.m_numPolygons + "/" + var17_20);
                                    break;
lbl228:
                                    // 1 sources

                                    var16_16.pushBack();
                                }
lbl229:
                                // 4 sources

                                ++var17_20;
                            }
                            if (var17_20 > 0) {
                                ++this.m_numPolygons;
                                var20_27 = new PiVector(var17_20);
                                var20_27.copy(var15_15, var17_20);
                                this.m_vPolygon.addElement(var20_27);
                            } else {
                                PsDebug.warning("polygon with no vertex in line=" + var16_16.lineno());
                            }
                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                            }
                            ** GOTO lbl270
lbl243:
                            // 1 sources

                            if ("lc".equals(var16_16.sval)) {
                                if (PsJavaView.m_bOnlyVertices) continue block7;
                                var17_20 = 0;
                                while (var16_16.nextToken() == -2) {
                                    var16_16.pushBack();
                                    var7_7[var17_20] = (float)PuDouble.parseDouble(var16_16);
                                    ++var17_20;
                                }
                                if (var17_20 == 3) {
                                    var20_28 = new Color(var7_7[0], var7_7[1], var7_7[2]);
                                    if (this.m_vPolygonColorInd.getSize() <= this.m_vPolygonColor.size() + 1) {
                                        this.m_vPolygonColorInd.setSize(this.m_vPolygonColor.size() + 1000);
                                    }
                                    this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
                                    this.m_vPolygonColor.addElement(var20_28);
                                    break;
                                }
                                PsDebug.warning("polygon color with wrong num coords in line=" + var16_16.lineno());
                                break;
                            }
                            if ("mt".equals(var16_16.sval)) {
                                this.m_numMeshType = 0;
                                this.m_meshType = new int[var5_5];
                                while (var16_16.nextToken() == -2) {
                                    this.m_meshType[this.m_numMeshType] = (int)var16_16.nval;
                                    ++this.m_numMeshType;
                                }
                            } else if (!"g".equals(var16_16.sval)) break;
lbl270:
                            // 6 sources

                            while (var16_16.ttype != 10 && var16_16.ttype != -1) {
                                var16_16.nextToken();
                                break block1;
                            }
                            continue block7;
                        }
                    }
                    {
                        continue;
                        break;
                    }
                }
            }
            catch (Exception var18_18) {
                PsDebug.warning("Exception thrown in line=" + var16_16.lineno() + ", Exception = " + var18_18);
                return false;
            }
        }
        if (this.m_vPolygonColorInd.getSize() > 0) {
            this.m_vPolygonColorInd.setEntry(this.m_vPolygonColor.size(), this.m_numPolygons);
        }
        PsDebug.notify("num of lines  = " + var16_16.lineno());
        PsDebug.notify("m_numVertices = " + this.m_numVertices);
        PsDebug.notify("m_numColors   = " + this.m_numColors);
        PsDebug.notify("m_numNormals  = " + this.m_numNormals);
        PsDebug.notify("m_numTextures = " + this.m_numTextures);
        PsDebug.notify("m_numElements = " + this.m_numElements);
        PsDebug.notify("m_numPolygons = " + this.m_numPolygons);
        PsDebug.notify("... finished");
        return true;
    }

    public boolean write(Writer writer, PgJvxSrc[] pgJvxSrcArray) throws IOException {
        int n;
        if (pgJvxSrcArray == null || pgJvxSrcArray.length == 0 || pgJvxSrcArray[0] == null) {
            PsDebug.warning("missing geometry");
            return false;
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        if (this.m_geometryOption != null) {
            bl = this.m_geometryOption.get(3);
            bl2 = this.m_geometryOption.get(5);
            bl3 = this.m_geometryOption.get(6);
        }
        PgJvxSrc pgJvxSrc = pgJvxSrcArray[0];
        writer.write("# Produced with JavaView v." + PsConfig.getVersion() + StrNL);
        writer.write("# JavaView is " + PsConfig.getCopyright() + ", " + PsConfig.getHomepage() + StrNL);
        writer.write("# by " + PsConfig.getAuthors() + StrNL);
        writer.write("#     File Format = Wavefront OBJ\n");
        writer.write("#     Geometry    = " + pgJvxSrc.getName() + StrNL);
        writer.write("#     Date        = " + new Date().toString() + "\n#\n");
        int n2 = pgJvxSrc.getNumVertices();
        writer.write("#     Number of Vertices = " + n2 + StrNL);
        int n3 = pgJvxSrc.getNumElements();
        if (n3 > 0) {
            writer.write("#     Number of Elements = " + n3 + StrNL);
        }
        if ((n = pgJvxSrc.getNumPolygons()) > 0) {
            writer.write("#     Number of Polygons = " + n + StrNL);
        }
        if (bl && pgJvxSrc.getVertexNormals() != null) {
            writer.write("#     Additional: Vertex Normals\n");
        }
        if (bl2 && pgJvxSrc.getVertexTextures() != null) {
            writer.write("#     Additional: Vertex Texture Coordinates\n");
        } else if (bl2 && pgJvxSrc.getElementTextures() != null) {
            writer.write("#     Additional: Element Texture Coordinates\n");
        }
        if (bl3 && this.m_bHandleVectors && pgJvxSrc.getNumVectorFields() != 0 && pgJvxSrc.getNumVectors(0) == pgJvxSrc.getNumVertices()) {
            writer.write("#     Additional: Vertex Vector Field\n");
        }
        writer.write("#\n# End of Header\n");
        PgObjLoader.writePdVectors(writer, "Vertex", "v", n2, pgJvxSrc.getVertices());
        writer.flush();
        if (bl3 && this.m_bHandleVectors && pgJvxSrc.getNumVectorFields() != 0 && pgJvxSrc.getNumVectors(0) == pgJvxSrc.getNumVertices()) {
            PgObjLoader.writePdVectors(writer, "Vertex Vector", "vd", pgJvxSrc.getVectors(0).length, pgJvxSrc.getVectors(0));
            writer.flush();
        }
        m_bNormals = false;
        if (bl && pgJvxSrc.getVertexNormals() != null) {
            if (PgObjLoader.writePdVectors(writer, "Vertex Normal", "vn", n2, pgJvxSrc.getVertexNormals())) {
                m_bNormals = true;
            }
            writer.flush();
        }
        m_bVertexTextures = false;
        m_bElementTextures = false;
        if (bl2 && pgJvxSrc.getVertexTextures() != null) {
            if (PgObjLoader.writePdVectors(writer, "Vertex Texture", "vt", n2, pgJvxSrc.getVertexTextures())) {
                m_bVertexTextures = true;
            }
        } else if (bl2 && pgJvxSrc.getElementTextures() != null && PgObjLoader.writePdVectors(writer, "Element Texture", "vt", n3, pgJvxSrc.getElementTextures())) {
            m_bElementTextures = true;
        }
        if (pgJvxSrc.getElements() != null) {
            PgObjLoader.writeElements(writer, n3, pgJvxSrc.getElements());
            writer.flush();
        }
        m_bPolygonNormals = false;
        if (bl && pgJvxSrc.getPolygonNormals() != null && PgObjLoader.writePdVectors(writer, "Polygon Normal", "ln", n, pgJvxSrc.getPolygonNormals())) {
            m_bPolygonNormals = true;
        }
        if (pgJvxSrc.getPolygons() != null) {
            PgObjLoader.writePolygons(writer, n, pgJvxSrc.getPolygons());
        }
        writer.flush();
        return true;
    }

    protected static boolean writePdVectors(Writer writer, String string, String string2, int n, PdVector[] pdVectorArray) throws IOException {
        if (n < 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return false;
        }
        writer.write("# " + string + " List\n");
        writer.write("# Number of " + string + "s = " + n + StrNL);
        for (int i = 0; i < n; ++i) {
            writer.write(string2 + " ");
            if (pdVectorArray[i] == null) {
                return false;
            }
            int n2 = Math.min(3, pdVectorArray[i].getSize());
            for (int j = 0; j < n2; ++j) {
                if (Math.abs(pdVectorArray[i].m_data[j]) > 1.0E-10) {
                    writer.write(String.valueOf((float)pdVectorArray[i].m_data[j]));
                } else {
                    writer.write(String.valueOf(0.0f));
                }
                if (j >= n2 - 1) continue;
                writer.write(" ");
            }
            writer.write(StrNL);
        }
        return true;
    }

    protected static boolean writePdVectors(Writer writer, String string, String string2, int n, PdVector[][] pdVectorArray) throws IOException {
        if (n < 0 || pdVectorArray == null || n > pdVectorArray.length) {
            return false;
        }
        writer.write("# " + string + " List\n");
        writer.write("# Number of " + string + "s = " + n + StrNL);
        for (int i = 0; i < n; ++i) {
            if (pdVectorArray[i] == null) {
                return false;
            }
            for (int j = 0; j < pdVectorArray[i].length; ++j) {
                PdVector pdVector = pdVectorArray[i][j];
                if (pdVector == null || pdVector.m_data == null) {
                    return false;
                }
                writer.write(string2 + " ");
                for (int k = 0; k < pdVector.m_data.length; ++k) {
                    if (Math.abs(pdVector.m_data[k]) > 1.0E-10) {
                        writer.write(String.valueOf((float)pdVector.m_data[k]));
                    } else {
                        writer.write(String.valueOf(0.0f));
                    }
                    if (k >= pdVector.m_data.length - 1) continue;
                    writer.write(" ");
                }
                writer.write(StrNL);
            }
        }
        return true;
    }

    protected static boolean writeElements(Writer writer, int n, PiVector[] piVectorArray) throws IOException {
        if (n < 0 || piVectorArray == null || n > piVectorArray.length) {
            return false;
        }
        writer.write("# Face List\n");
        writer.write("# Number of Faces = " + n + StrNL);
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            writer.write("f  ");
            if (piVectorArray[i] == null) {
                return false;
            }
            for (int j = 0; j < piVectorArray[i].m_data.length; ++j) {
                int n3 = piVectorArray[i].m_data[j] + 1;
                writer.write(String.valueOf(n3));
                if (m_bVertexTextures || m_bElementTextures) {
                    if (m_bVertexTextures) {
                        writer.write("/" + n3);
                    } else {
                        writer.write("/" + n2++);
                    }
                    if (m_bNormals) {
                        writer.write("/" + n3);
                    }
                } else if (!m_bVertexTextures && !m_bElementTextures && m_bNormals) {
                    writer.write("//" + n3);
                }
                if (j >= piVectorArray[i].m_data.length - 1) continue;
                writer.write(" ");
            }
            writer.write(StrNL);
        }
        return true;
    }

    protected static boolean writePolygons(Writer writer, int n, PiVector[] piVectorArray) throws IOException {
        if (n < 0 || piVectorArray == null || n > piVectorArray.length) {
            return false;
        }
        writer.write("# Polygon List\n");
        writer.write("# Number of Polygons = " + n + StrNL);
        for (int i = 0; i < n; ++i) {
            writer.write("l  ");
            if (piVectorArray[i] == null) {
                return false;
            }
            for (int j = 0; j < piVectorArray[i].m_data.length; ++j) {
                int n2 = piVectorArray[i].m_data[j] + 1;
                writer.write(String.valueOf(n2));
                if (m_bPolygonNormals) {
                    writer.write("/" + n2);
                }
                if (j >= piVectorArray[i].m_data.length - 1) continue;
                writer.write(" ");
            }
            writer.write(StrNL);
        }
        return true;
    }
}

