/*
 * Decompiled with CFR 0.152.
 */
package jv.viewer;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import jv.anim.PsAnimation;
import jv.anim.PsKeyframe;
import jv.anim.PsTimeListenerIf;
import jv.loader.PSGr;
import jv.loader.PgFileDialog;
import jv.loader.PgLoader;
import jv.loader.PjImportModel;
import jv.loader.PjImportModel_Dialog;
import jv.loader.PsCategoryList_IP;
import jv.loader.PsXmlLoader;
import jv.loader.PvDisplayOption;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsConsole;
import jv.object.PsDebug;
import jv.object.PsDialog;
import jv.object.PsMainFrame;
import jv.object.PsObject;
import jv.object.PsPanel;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;
import jv.object.PsUtil;
import jv.objectGui.PsDropHandlerIf;
import jv.objectGui.PsDropListenerIf;
import jv.objectGui.PsImage;
import jv.objectGui.PsMultiLineLabel;
import jv.objectGui.PsToolbar;
import jv.objectGui.PsToolbarItem;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PjProject;
import jv.project.PjWorkshopIf;
import jv.project.PvDisplayHandlerIf;
import jv.project.PvDisplayIf;
import jv.project.PvViewerIf;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsJavaView;
import jv.rsrc.PsJavaView_IP;
import jv.rsrc.PsLicense;
import jv.vecmath.PdVector;
import jv.viewer.PvControl;
import jv.viewer.PvControlMenu;
import jv.viewer.PvDisplay;

public final class PvViewer
extends PsObject
implements PvViewerIf,
ActionListener,
WindowListener,
PsDropListenerIf {
    protected PsAuthorInfo m_jvAuthor;
    protected PsJavaView m_jvRsrc;
    protected PsLicense m_jvLic;
    protected Applet m_applet;
    protected Frame m_frame;
    protected String[][] m_parm;
    protected Vector m_frameVector;
    protected Vector m_frameTitle;
    protected Vector m_displayVector;
    protected PvDisplayIf m_mainDisplay;
    protected PvDisplayIf m_display;
    protected PvControl m_control;
    protected Vector m_menuBars = new Vector();
    protected transient Dialog m_help;
    protected String m_serialDirName = null;
    protected Hashtable m_geometryCategory;
    protected Hashtable m_geometryClass;
    protected Hashtable m_projectCategory;
    protected Hashtable m_projectList;
    protected Hashtable m_projectClass;
    protected Hashtable m_projectParms;
    protected PjProject m_currentProject;
    protected PgGeometryIf m_currentGeometry;
    private int m_showPanel = 22;
    private boolean m_bShowingDialog = false;
    private boolean m_bStarted = false;
    protected static boolean m_bHasArchiveJvx = false;
    private PsDialog wsDialog = null;
    private PgGeometryIf wsGeometry = null;
    private String m_thread_fileName = null;
    private PgLoader m_thread_loader = null;
    private boolean m_bEmbedded = false;

    private static String[][] getDefaultProjects() {
        String[][] stringArray = new String[][]{{PsConfig.getMessage(18000), PsConfig.getMessage(18041), "vgp.tutor.parmCurve.PjParmCurve"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "Surface Curves"), "vgp.curve.surface.PjSurfCurve"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18037), "vgp.curve.geodesic.PjGeodesic"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18038), "vgp.tutor.torusknot.PjTorusKnot"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18039), "vgp.curve.cycloid.PjCycloid"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18040), "vgp.curve.elastic.PjElasticCurve"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "Constant Length Curves"), "vgp.curve.closedpoly.PjClosedPoly"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "De Casteljau"), "vgp.curve.deCasteljau.PjDeCasteljau"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "ZigZag"), "vgp.curve.zigzag.PjZigZag"}, {PsConfig.getMessage(18000), PsConfig.getMessage(18024), "vgp.tutor.lsystem.PjLSystem"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "Curvature Circle"), "vgp.curve.curvatureCircle.PjCurvatureCircle"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "Curvature Plot"), "vgp.curve.curvaturePlot.PjCurvaturePlot"}, {PsConfig.getMessage(18000), PsConfig.getMessage(true, 18000, "Subdivision Curves"), "vgp.curve.subdivision.PjSubdivisionCurve"}, {PsConfig.getMessage(18001), PsConfig.getMessage(18042), "vgp.game.life.PjLife"}, {PsConfig.getMessage(18001), PsConfig.getMessage(18043), "vgp.game.mines.PjMinesweeper"}, {PsConfig.getMessage(18001), PsConfig.getMessage(true, 18000, "Snake Game"), "vgp.game.snake.PjSnake"}, {PsConfig.getMessage(18002), PsConfig.getMessage(true, 18000, "Mandelbrot Set"), "vgp.imageSource.PjMandelbrot"}, {PsConfig.getMessage(18002), PsConfig.getMessage(18044), "vgp.iterate.juliaSet.PjJuliaSet"}, {PsConfig.getMessage(18002), PsConfig.getMessage(true, 18000, "Pythagorean Tree"), "vgp.iterate.pythagoreanTree.PjPythagoreanTree"}, {PsConfig.getMessage(18002), PsConfig.getMessage(true, 18000, "Domain Coloring Tutor"), "vgp.imageSource.PjDomainImage"}, {PsConfig.getMessage(18002), PsConfig.getMessage(true, 18000, "DC and Sampling of Function"), "vgp.imageSource.PjFunctionGraph"}, {PsConfig.getMessage(18002), PsConfig.getMessage(true, 18000, "Image Source Tutor"), "vgp.imageSource.PjImageSource"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18010), "vgp.discrete.conformal.PjConformal"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18011), "vgp.discrete.conjugate.PjConjugate"}, {PsConfig.getMessage(18003), PsConfig.getMessage(18012), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage(18003), PsConfig.getMessage(true, 18000, "Moebius Transformations"), "vgp.surface.moebiusTransformation.PjMoebiusTransformation"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18005), "jv.loader.PjImportModel"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18013), "vgp.tutor.model.PjModel"}, {PsConfig.getMessage(18004), PsConfig.getMessage(18014), "vgp.tutor.key.PjKeyframe"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18015), "vgp.tutor.ode.PjExprOde"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18016), "vgp.discrete.harmonic.PjHarmonic"}, {PsConfig.getMessage(18006), PsConfig.getMessage(18017), "vgp.tutor.rootFinder.PjRootFinder"}, {PsConfig.getMessage(18006), PsConfig.getMessage(true, 18000, "Anisotropic Smoothing"), "vgp.numeric.smooth.PjSmooth"}, {PsConfig.getMessage(18006), PsConfig.getMessage(true, 18000, "Maximum Principle"), "vgp.discrete.maxPrinciple.PjMaxPrinciple"}, {PsConfig.getMessage(18006), PsConfig.getMessage(true, 18000, "Point Set Smoothing"), "vgp.discrete.pointCloud.PjPointCloud"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18021), "vgp.tutor.parm.PjParmSurface"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18018), "vgp.surface.common.PjSurface"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18047), "vgp.surface.rotation.PjRotation"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18019), "vgp.minimal.catenoid.PjCatenoid"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Discrete Helicoid"), "vgp.minimal.helicoid.PjHelicoid"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18020), "vgp.minimal.weier.PjWeierstrass"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18022), "vgp.discrete.platonic.PjPlatonic"}, {PsConfig.getMessage(18007), PsConfig.getMessage(18046), "vgp.surface.klein.PjKleinBottle"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Kaleidocycle"), "vgp.surface.kaleidoCycle.PjKaleidoCycle"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Schwarz Lantern"), "vgp.discrete.lantern.PjLantern"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Level Set Surface"), "vgp.volume.mc.PjMarchingCubes"}, {PsConfig.getMessage(18007), PsConfig.getMessage(true, 18000, "Unfold Surfaces"), "vgp.surface.unfold.PjUnfold"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "My First Project"), "vgp.tutor.firstProject.MyProject"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Size of Edges Demo"), "vgp.tutor.sizePolygon.PjSizePolygon"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Size of Vertices Demo"), "vgp.tutor.sizeVertex.PjSizeVertex"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Polygon Set on Torus Demo"), "vgp.tutor.polygonSet.PjPolygonSet"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Slider Demo"), "vgp.tutor.slider.PjSlider"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Pick Event Demo"), "vgp.tutor.pick.PjPickEvent"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Abc File Loader Demo"), "vgp.tutor.loader.PjLoader"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Keyframe Animation Demo"), "vgp.tutor.key.PjKeyframe"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Texture Cube Demo"), "vgp.tutor.texture.PjTextureCube"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Textured Surface Demo"), "vgp.tutor.texture.PjTexturedSurface"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Image Source Demo"), "vgp.imageSource.PjImageSource"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Domain Coloring Demo"), "vgp.imageSource.PjDomainImage"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Linear Algebra Demo"), "vgp.tutor.linear.PjLinear"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Complex Function Demo"), "vgp.tutor.complex.PjComplexFunction"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Rivara Refinement Demo"), "vgp.tutor.rivara.PjRivara"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Scalar Field Demo"), "vgp.tutor.height.PjHeight"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Events for Stereo Demo"), "vgp.tutor.eventCamera.PjEventCamera"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "4D Transformation Demo"), "vgp.tutor.transform.PjTransform"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Co-Gradient Field Demo"), "vgp.tutor.vectorField.PjVectorField"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Geodesic Flow Demo"), "vgp.tutor.flows.PjGeodesicFlow"}, {PsConfig.getMessage(18008), PsConfig.getMessage(true, 18000, "Seeds Particle Flow Demo"), "vgp.tutor.flows.PjSeeds"}, {PsConfig.getMessage(18009), PsConfig.getMessage(18034), "vgp.vector.hodge.PjHodge"}, {PsConfig.getMessage(18009), PsConfig.getMessage(18035), "vgp.vector.lic.PjLIC"}, {PsConfig.getMessage(18009), PsConfig.getMessage(true, 18000, "Parallel Translation"), "vgp.vector.translation.PjTranslation"}, {PsConfig.getMessage(18009), PsConfig.getMessage(true, 18000, "Runge Kutta Integration"), "vgp.vector.rungeKutta.PjRungeKutta"}, {PsConfig.getMessage(18009), PsConfig.getMessage(true, 18000, "Geodesic Flow"), "vgp.tutor.flows.PjGeodesicFlow"}, {PsConfig.getMessage(18009), PsConfig.getMessage(true, 18000, "Seeds Particle Flow"), "vgp.tutor.flows.PjSeeds"}};
        return stringArray;
    }

    private static String[][] getDefaultGeometries() {
        String[][] stringArray = new String[][]{{PsConfig.getMessage(15046), PsConfig.getMessage(15045), "jv.geom.PgPointSet"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15047), "jv.geom.PgPolygon"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15048), "jv.geom.PgPolygonSet"}, {PsConfig.getMessage(15038), PsConfig.getMessage(true, 15000, "Function Graph"), "jvx.curve.PgFunction"}, {PsConfig.getMessage(15038), PsConfig.getMessage(15039), "jvx.curve.PgParmCurve"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15049), "jv.geom.PgElementSet"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15030), "jvx.surface.PgDomain"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15031), "jvx.surface.PgGraph"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15041), "jvx.geom.PwPlatonic"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15042), "jvx.surface.PgParmSurface"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15050), "jvx.surface.PgGenusSurface"}, {PsConfig.getMessage(15040), PsConfig.getMessage(15028), "jvx.surface.PgSurfaceOfRotation"}, {PsConfig.getMessage(15040), PsConfig.getMessage(true, 18000, "Schwarz Lantern"), "vgp.discrete.lantern.PgLantern"}, {PsConfig.getMessage(15040), PsConfig.getMessage(true, 18000, "Discrete Catenoid"), "vgp.minimal.catenoid.PgCatenoid"}, {PsConfig.getMessage(15040), PsConfig.getMessage(true, 18000, "Discrete Helicoid"), "vgp.minimal.helicoid.PgHelicoid"}, {PsConfig.getMessage(15040), PsConfig.getMessage(true, 18000, "Klein Bottle"), "vgp.surface.common.PgKleinBottle"}, {PsConfig.getMessage(15040), PsConfig.getMessage(true, 18000, "Classic Surface"), "vgp.surface.common.PwSurface"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Circle"), "jvx.primitive.PgCircle"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "CircleF"), "jvx.primitive.PgCircleF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Curve"), "jvx.primitive.PgCurveF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Graph"), "jvx.primitive.PgGraphF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Plot"), "jvx.primitive.PgPlotF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Point"), "jvx.primitive.PgPointF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Segment"), "jvx.primitive.PgSegmentF"}, {PsConfig.getMessage(true, 15000, "Primitives"), PsConfig.getMessage(true, 15000, "Sphere"), "jvx.primitive.PgSphere"}};
        return stringArray;
    }

    public PvViewer() {
        this(null, null);
        this.m_bStarted = true;
    }

    public PvViewer(Applet applet, Frame frame) {
        this.m_applet = applet;
        this.m_frame = frame;
        PsConfig.init(applet, this, frame);
        String string = this.getParameter("jv-instDir");
        string = PsUtil.assureFileSeparator(string, true);
        if (!PuString.isEmpty(string)) {
            PsConfig.setInstBase(string);
        }
        this.m_jvRsrc = new PsJavaView();
        this.m_projectCategory = new Hashtable();
        this.m_projectClass = new Hashtable();
        this.m_projectList = new Hashtable();
        this.m_projectParms = new Hashtable();
        this.setName(PsConfig.getMessage(12015) + " " + PsConfig.getProgram());
        if (frame != null) {
            PvDisplay.setDefaultSize(frame.getSize());
        } else if (applet != null) {
            PvDisplay.setDefaultSize(applet.getSize());
        }
        if (PsDebug.isNotify()) {
            this.printParameter();
        }
        this.m_displayVector = new Vector();
        this.m_frameVector = new Vector();
        this.m_frameTitle = new Vector();
        this.init();
    }

    public void init() {
        boolean bl;
        Object object;
        String string;
        String[][] stringArray;
        Object object2;
        String string2;
        boolean bl2;
        super.init();
        if (this.m_displayVector != null && this.m_displayVector.size() > 0) {
            this.m_displayVector.removeAllElements();
        }
        if (this.m_frameVector != null && this.m_frameVector.size() > 0) {
            this.m_frameVector.removeAllElements();
            this.m_frameTitle.removeAllElements();
        }
        boolean bl3 = bl2 = !PuString.isEmpty(PsConfig.getInstBase());
        if (PsConfig.isApplication()) {
            PvDisplay.m_bLicenseChecked = true;
            PvDisplay.m_license = "license validation failed";
            if (this.m_jvLic == null) {
                this.m_jvLic = new PsLicense();
            }
            if ((string2 = this.getParameter("jv-lic")) == null) {
                string2 = "rsrc/jv-lic.lic";
            }
            if (!PsUtil.isAbsolutePath(string2 = PsUtil.assureFileSeparator(string2, false))) {
                string2 = bl2 ? PsConfig.getInstBase() + string2 : PsConfig.getCodeBase() + string2;
            }
            PsJavaView.setFullFileName(1, string2);
            try {
                File file = new File(string2);
                if (!file.exists()) {
                    PsDebug.message("Missing: license file = " + string2, false);
                    PsDebug.message("\tusing default license: type = evaluation, id = " + this.m_jvLic.getLicenseId(), false);
                    PvDisplay.m_license = "missing license, cannot find = " + string2;
                } else {
                    String string3;
                    PsDebug.message("Found: license file = " + string2, false);
                    if (!this.m_jvLic.read(string2)) {
                        PsDebug.message("\tfailed reading license file = " + string2, false);
                        PvDisplay.m_license = "void license file = " + string2;
                    }
                    object2 = this.m_jvLic.getLicenseId();
                    stringArray = this.m_jvLic.getLicenseType();
                    string = this.m_jvLic.getLicensee();
                    object = Calendar.getInstance();
                    Calendar calendar = Calendar.getInstance();
                    boolean bl4 = false;
                    boolean bl5 = true;
                    boolean bl6 = false;
                    if (object2 != null && (string3 = ((String)object2).substring(2)) != null) {
                        String[] stringArray2 = PuString.splitString(string3, '.');
                        string3 = PuString.mergeStrings(stringArray2, "");
                        long l = Long.parseLong(string3);
                        if (((String)object2).startsWith("30")) {
                            calendar.set(2003, 11, 31, 23, 59, 59);
                            bl4 = true;
                        } else if (((String)object2).startsWith("31")) {
                            calendar.set(2004, 5, 30, 23, 59, 59);
                            bl4 = l / 17L * 17L == l;
                        } else if (((String)object2).startsWith("32")) {
                            calendar.set(2004, 11, 31, 23, 59, 59);
                            bl4 = l / 23L * 23L == l;
                        } else if (((String)object2).startsWith("33")) {
                            calendar.set(2005, 5, 30, 23, 59, 59);
                            bl4 = l / 29L * 29L == l;
                        } else if (((String)object2).startsWith("34")) {
                            calendar.set(2005, 11, 31, 23, 59, 59);
                            bl4 = l / 31L * 31L == l;
                        } else if (((String)object2).startsWith("35")) {
                            calendar.set(2006, 5, 30, 23, 59, 59);
                            bl4 = l / 37L * 37L == l;
                        } else if (((String)object2).startsWith("36")) {
                            calendar.set(2006, 11, 31, 23, 59, 59);
                            bl4 = l / 41L * 41L == l;
                        } else if (((String)object2).startsWith("37")) {
                            calendar.set(2007, 5, 30, 23, 59, 59);
                            bl4 = l / 43L * 43L == l;
                        } else if (((String)object2).startsWith("38")) {
                            calendar.set(2007, 11, 31, 23, 59, 59);
                            bl4 = l / 47L * 47L == l;
                        } else if (((String)object2).startsWith("39")) {
                            calendar.set(2008, 11, 31, 23, 59, 59);
                            bl4 = l / 53L * 53L == l;
                        } else if (((String)object2).startsWith("40")) {
                            calendar.set(2009, 11, 31, 23, 59, 59);
                            bl4 = l / 59L * 59L == l;
                        } else if (((String)object2).startsWith("41")) {
                            calendar.set(2010, 11, 31, 23, 59, 59);
                            bl4 = l / 61L * 61L == l;
                        } else if (((String)object2).startsWith("42")) {
                            calendar.set(2011, 11, 31, 23, 59, 59);
                            bl4 = l / 67L * 67L == l;
                        } else if (((String)object2).startsWith("43")) {
                            calendar.set(2012, 11, 31, 23, 59, 59);
                            bl4 = l / 71L * 71L == l;
                        } else if (((String)object2).startsWith("44")) {
                            calendar.set(2013, 11, 31, 23, 59, 59);
                            bl4 = l / 73L * 73L == l;
                        } else if (((String)object2).startsWith("45")) {
                            calendar.set(2014, 11, 31, 23, 59, 59);
                            bl4 = l / 79L * 79L == l;
                        } else if (((String)object2).startsWith("46")) {
                            calendar.set(2015, 11, 31, 23, 59, 59);
                            bl4 = l / 83L * 83L == l;
                        } else if (((String)object2).startsWith("48")) {
                            calendar.set(2016, 11, 31, 23, 59, 59);
                            bl4 = l / 89L * 89L == l;
                        } else if (((String)object2).startsWith("49")) {
                            calendar.set(2017, 11, 31, 23, 59, 59);
                            bl4 = l / 97L * 97L == l;
                        } else if (((String)object2).startsWith("50")) {
                            calendar.set(2018, 11, 31, 23, 59, 59);
                            bl4 = l / 101L * 101L == l;
                        } else if (((String)object2).startsWith("51")) {
                            calendar.set(2019, 11, 31, 23, 59, 59);
                            bl4 = l / 103L * 103L == l;
                        } else if (((String)object2).startsWith("52")) {
                            calendar.set(2020, 11, 31, 23, 59, 59);
                            bl4 = l / 107L * 107L == l;
                        } else if (((String)object2).startsWith("53")) {
                            calendar.set(2021, 11, 31, 23, 59, 59);
                            bl4 = l / 109L * 109L == l;
                        } else if (((String)object2).startsWith("54")) {
                            calendar.set(2022, 11, 31, 23, 59, 59);
                            bl4 = l / 113L * 113L == l;
                        } else if (((String)object2).startsWith("55")) {
                            calendar.set(2023, 11, 31, 23, 59, 59);
                            bl4 = l / 127L * 127L == l;
                        } else if (((String)object2).startsWith("56")) {
                            calendar.set(2024, 11, 31, 23, 59, 59);
                            bl4 = l / 131L * 131L == l;
                        } else if (((String)object2).startsWith("57")) {
                            calendar.set(2025, 11, 31, 23, 59, 59);
                            bl4 = l / 137L * 137L == l;
                        } else if (((String)object2).startsWith("58")) {
                            calendar.set(2026, 11, 31, 23, 59, 59);
                            bl4 = l / 139L * 139L == l;
                        } else if (((String)object2).startsWith("59")) {
                            calendar.set(2027, 11, 31, 23, 59, 59);
                            bl4 = l / 149L * 149L == l;
                        } else if (((String)object2).startsWith("60")) {
                            calendar.set(2028, 11, 31, 23, 59, 59);
                            bl4 = l / 151L * 151L == l;
                        } else if (((String)object2).startsWith("61")) {
                            bl4 = l / 17L * 17L == l;
                            bl6 = true;
                        } else if (((String)object2).startsWith("62")) {
                            bl4 = l / 23L * 23L == l;
                            bl6 = true;
                        } else if (((String)object2).startsWith("63")) {
                            bl4 = l / 29L * 29L == l;
                            bl6 = true;
                        } else if (((String)object2).startsWith("64")) {
                            bl4 = l / 31L * 31L == l;
                            bl6 = true;
                        }
                        if (((String)object2).startsWith("4711")) {
                            bl4 = true;
                            bl5 = false;
                        } else if (bl4) {
                            bl5 = bl6 ? false : ((Calendar)object).after(calendar);
                        }
                    }
                    if (!bl4) {
                        PsDebug.message("\t!!! Void license, id = " + (String)object2, true);
                        PvDisplay.m_license = "void license id = " + (String)object2;
                    } else if (bl5) {
                        PsDebug.message("\t!!! Expired license, id = " + (String)object2, true);
                        string3 = String.valueOf(calendar.get(1)) + "-" + String.valueOf(calendar.get(2) + 1) + "-" + String.valueOf(calendar.get(5));
                        PsDebug.message("\t!!! Expiration date = " + string3, true);
                        PvDisplay.m_license = "expired license, date = " + string3;
                    } else {
                        PsDebug.message("\tlicensed to " + string, false);
                        PsDebug.message("\ttype = " + (String)stringArray + ", id = " + (String)object2, false);
                        PvDisplay.m_license = null;
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        string2 = this.getParameter("jv-rsrc");
        boolean bl7 = bl = (string2 = PsUtil.assureFileSeparator(string2, false)) != null;
        if (PsConfig.isApplication() && !bl) {
            string2 = "rsrc" + PsConfig.getFileSeparator() + "jv-rsrc.jvr";
        }
        if (string2 != null) {
            if (!PsUtil.isAbsolutePath(string2)) {
                string2 = bl2 ? PsConfig.getInstBase() + string2 : PsConfig.getCodeBase() + string2;
            }
            PsJavaView.setFullFileName(2, string2);
            if (PsJavaView.read(string2)) {
                PsDebug.message("Found: resource file = " + string2, false);
                PvDisplay.setEnabledFastClipping(PsJavaView.m_bFastClipping);
            } else if (bl) {
                PsDebug.message("Failed: loading resource file = " + string2, true);
            }
        }
        if (PsConfig.isApplication()) {
            if (PsJavaView.getAuthorInfo() == null || PsJavaView.getAuthorInfo().getNumAuthors() == 0) {
                object2 = PsLicense.getAuthorInfo();
                if (object2 != null) {
                    PsDebug.message("\tRetrieving author information from license file.", false);
                    PsJavaView.setAuthorInfo((PsAuthorInfo)object2);
                }
            } else {
                PsDebug.message("\tRetrieved author information from resource file.", false);
            }
        }
        if ("Hide".equalsIgnoreCase(this.getParameter("Console.usable"))) {
            PsJavaView.m_bConsoleUsable = false;
        }
        if ("Hide".equalsIgnoreCase(this.getParameter("Control.usable"))) {
            PsJavaView.m_bControlUsable = false;
        }
        if ("Show".equalsIgnoreCase(this.getParameter("Console"))) {
            this.showDialog(35);
        }
        if (this.m_frame != null) {
            object2 = PsImage.getImageResource(PsConfig.getImageIcon());
            if (object2 != null) {
                this.m_frame.setIconImage((Image)object2);
            }
            if ((stringArray = this.getParameter("menuBar")) == null || !stringArray.equalsIgnoreCase("hide")) {
                this.m_frame.setMenuBar(this.newMenuBar(this.m_frame));
            }
            if (!((string = this.getParameter("toolBar")) != null && string.equalsIgnoreCase("hide") || (object = this.newToolbar(this.m_frame)) == null)) {
                this.m_frame.add((Component)object, "North");
            }
            if ((object = this.getParameter("statusBar")) == null || !((String)object).equalsIgnoreCase("hide")) {
                this.m_frame.add((Component)PsDebug.getStatusPanel(), "South");
            }
        }
        if (this.m_frame != null) {
            this.addFrame(this.m_frame);
        }
        if (this.m_geometryCategory != null) {
            this.m_geometryCategory.clear();
        }
        if (this.m_geometryClass != null) {
            this.m_geometryClass.clear();
        }
        if (this.m_projectCategory != null) {
            this.m_projectCategory.clear();
        }
        if (this.m_projectClass != null) {
            this.m_projectClass.clear();
        }
        if (this.m_projectList != null) {
            this.m_projectList.clear();
        }
        if (this.m_projectParms != null) {
            this.m_projectParms.clear();
        }
        if (PsConfig.hasArchive(2)) {
            object2 = this.getParameter("menu-new-project");
            stringArray = PvViewer.getDefaultProjects();
            if (stringArray != null && (PsConfig.isApplication() || object2 != null && ((String)object2).equalsIgnoreCase("enable"))) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addProject(stringArray[i][0], stringArray[i][1], stringArray[i][2], null);
                }
            }
        }
        if ((object2 = PvViewer.getDefaultGeometries()) != null) {
            boolean bl8 = PsConfig.hasArchive(1);
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (!bl8 && ((String)object2[i][2]).startsWith("jvx.")) continue;
                this.addGeometry((String)object2[i][0], (String)object2[i][1], (String)object2[i][2]);
            }
        }
    }

    public Applet getApplet() {
        return this.m_applet;
    }

    public Frame getFrame() {
        return this.m_frame;
    }

    public String getParameter(String string) {
        String string2;
        int n;
        string = string.toLowerCase();
        if (this.m_parm == null && this.m_applet != null) {
            this.m_parm = this.m_applet.getParameterInfo();
            if (this.m_parm != null) {
                for (n = 0; n < this.m_parm.length; ++n) {
                    this.m_parm[n][0] = this.m_parm[n][0].toLowerCase();
                }
                if (!PsConfig.isApplication()) {
                    for (n = 0; n < this.m_parm.length; ++n) {
                        string2 = this.m_applet.getParameter(this.m_parm[n][0]);
                        if (string2 == null) continue;
                        this.m_parm[n][2] = string2;
                    }
                } else {
                    for (n = 0; n < this.m_parm.length; ++n) {
                        string2 = System.getProperty(this.m_parm[n][0]);
                        if (string2 == null) continue;
                        this.m_parm[n][2] = string2;
                    }
                }
            }
        }
        if (this.m_parm == null && this.m_currentProject != null) {
            this.m_parm = this.m_currentProject.getParameterInfo();
            if (this.m_parm != null) {
                for (n = 0; n < this.m_parm.length; ++n) {
                    this.m_parm[n][0] = this.m_parm[n][0].toLowerCase();
                }
                if (!PsConfig.isApplication()) {
                    for (n = 0; n < this.m_parm.length; ++n) {
                        string2 = this.m_applet.getParameter(this.m_parm[n][0]);
                        if (string2 == null) continue;
                        this.m_parm[n][2] = string2;
                    }
                } else {
                    for (n = 0; n < this.m_parm.length; ++n) {
                        string2 = System.getProperty(this.m_parm[n][0]);
                        if (string2 == null) continue;
                        this.m_parm[n][2] = string2;
                    }
                }
            }
        }
        if (this.m_parm != null) {
            for (n = 0; n < this.m_parm.length; ++n) {
                if (!this.m_parm[n][0].equalsIgnoreCase(string)) continue;
                return this.m_parm[n][2].trim();
            }
        }
        PsDebug.notify("parameter = " + string + " not in applet info");
        if (!PsConfig.isApplication() && this.m_applet != null && (string2 = this.m_applet.getParameter(string)) != null) {
            PsDebug.notify("Parameter = " + string + ", Value = " + string2 + " found in HTML page");
            return string2;
        }
        if (PsConfig.isApplication() && (string2 = System.getProperty(string)) != null) {
            if (string2.startsWith("\"")) {
                string2 = string2.substring(1);
            }
            if (string2.endsWith("\"")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            PsDebug.notify("Parameter = " + string + ", Value = " + string2 + " found in argument list");
            return string2;
        }
        PsDebug.notify("missing parameter = " + string);
        return null;
    }

    public void printParameter() {
        if (this.m_parm == null) {
            this.getParameter("Nothing");
        }
        if (this.m_parm == null) {
            PsDebug.message("empty parameter list.");
            return;
        }
        PsDebug.message("parameter list:");
        for (int i = 0; i < this.m_parm.length; ++i) {
            PsDebug.message("\t Parameter = " + this.m_parm[i][0] + ", Value = " + this.getParameter(this.m_parm[i][0]));
        }
    }

    public boolean addGeometry(String string, String string2, String string3) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_geometryCategory == null) {
            this.m_geometryCategory = new Hashtable();
        }
        if (this.m_geometryClass == null) {
            this.m_geometryClass = new Hashtable();
        }
        if (this.m_geometryClass.containsKey(string2)) {
            PsDebug.warning("geometry name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_geometryClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_geometryCategory.put(string2, string);
        this.m_geometryClass.put(string2, string3);
        return true;
    }

    public PgGeometryIf getGeometry(String string) {
        PgGeometryIf pgGeometryIf = null;
        String string2 = (String)this.m_geometryClass.get(string);
        if (string2 == null) {
            PsDebug.warning("missing class, could not create instance of " + string);
            return null;
        }
        if (string2.startsWith("jvx.") && !PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar, could not create instance of class = " + string2);
            return null;
        }
        if (string2.startsWith("jvx.geom.PwPlatonic") || string2.startsWith("vgp.surface.common.PwSurface")) {
            PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance(string2);
            if (pjWorkshopIf != null) {
                pjWorkshopIf.setDisplay(this.m_display);
                pgGeometryIf = pjWorkshopIf.getGeometry();
                PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
                if (psDialog != null) {
                    psDialog.addActionListener(this);
                    psDialog.setParent(pjWorkshopIf);
                    psDialog.update(pjWorkshopIf);
                    ((Component)psDialog).setVisible(true);
                }
                this.wsDialog = psDialog;
                this.wsGeometry = pgGeometryIf;
            }
        } else {
            pgGeometryIf = (PgGeometryIf)PsUtil.newInstance(string2);
            if (pgGeometryIf != null) {
                pgGeometryIf.setName(string + "[" + PsObject.getNumObjects() + "]");
            }
        }
        if (pgGeometryIf == null) {
            PsDebug.warning("could not create instance of class = " + string2);
            return null;
        }
        return pgGeometryIf;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != null) {
            if (object == this.wsDialog) {
                if (actionEvent.getID() == 1 && this.m_display != null && this.wsGeometry != null) {
                    this.m_display.removeGeometry(this.wsGeometry);
                    this.m_display.update(this.m_display);
                }
                this.wsDialog = null;
                this.wsGeometry = null;
            } else if (object instanceof PsToolbarItem) {
                int n = actionEvent.getID();
                if (this.m_display != null) {
                    boolean bl = true;
                    switch (n) {
                        case 29: {
                            this.m_display.setMajorMode(6);
                            break;
                        }
                        case 23: {
                            this.m_display.setMajorMode(0);
                            break;
                        }
                        case 28: {
                            this.m_display.setMajorMode(5);
                            break;
                        }
                        case 24: {
                            this.m_display.setMajorMode(1);
                            break;
                        }
                        case 25: {
                            this.m_display.setMajorMode(2);
                            break;
                        }
                        case 26: {
                            this.m_display.setMajorMode(3);
                            break;
                        }
                        case 27: {
                            this.m_display.setMajorMode(4);
                            break;
                        }
                        case 32: {
                            this.m_display.showGrid(!this.m_display.isShowingGrid());
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (bl) {
                        ((Component)((Object)this.m_display)).requestFocus();
                        return;
                    }
                }
                switch (n) {
                    case 38: {
                        this.performKeyPressed(65);
                        break;
                    }
                    case 16: {
                        this.performKeyPressed(88);
                        break;
                    }
                    case 21: {
                        this.performKeyPressed(71);
                        break;
                    }
                    case 10: {
                        this.performKeyPressed(70);
                        break;
                    }
                    case 22: {
                        this.performKeyPressed(68);
                        break;
                    }
                    case 11: {
                        this.performKeyPressed(73);
                        break;
                    }
                    case 13: {
                        this.performKeyPressed(66);
                        break;
                    }
                    case 20: {
                        this.performKeyPressed(76);
                        break;
                    }
                    case 12: {
                        this.performKeyPressed(77);
                        break;
                    }
                    case 9: {
                        this.performKeyPressed(74);
                        break;
                    }
                    case 14: {
                        this.performKeyPressed(84);
                        break;
                    }
                    case 15: {
                        this.performKeyPressed(69);
                        break;
                    }
                    case 7: {
                        this.performKeyPressed(72);
                        break;
                    }
                    case 44: {
                        this.showDialog(30);
                        break;
                    }
                    case 45: {
                        this.showDialog(36);
                        break;
                    }
                    case 5: {
                        this.performKeyPressed(85);
                        break;
                    }
                    case 0: {
                        this.performKeyPressed(78);
                        break;
                    }
                    case 1: {
                        this.performKeyPressed(79);
                        break;
                    }
                    case 6: {
                        this.performKeyPressed(80);
                        break;
                    }
                    case 4: {
                        this.performKeyPressed(82);
                        break;
                    }
                    case 3: {
                        this.performKeyPressed(83);
                        break;
                    }
                    case 61: {
                        this.performKeyPressed(75);
                    }
                }
            }
        }
    }

    public void addProjects() {
        String string;
        int n = 1;
        while ((string = this.getParameter("Project" + n)) != null) {
            ++n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n2 = stringTokenizer.countTokens() - 2;
            String[] stringArray = new String[n2];
            String string2 = stringTokenizer.nextToken();
            string2 = string2.trim();
            String string3 = stringTokenizer.nextToken();
            string3 = string3.trim();
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                stringArray[i] = stringArray[i].trim();
            }
            this.addProject(string2, string3, stringArray);
            PsDebug.notify("found project" + n + " = " + string2 + "; " + string3);
        }
        string = this.getParameter("Select");
        if (string != null) {
            PsDebug.notify("select project" + string);
            this.selectProject(string);
        }
    }

    public boolean addProject(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null || string3 == null) {
            PsDebug.warning("missing name or class");
            return false;
        }
        if (this.m_projectClass.containsKey(string2)) {
            PsDebug.warning("project name already exists, name = " + string2 + "\n\texisting name belong to class = " + (String)this.m_projectClass.get(string2));
            return false;
        }
        if (string == null) {
            string = "Default";
        }
        this.m_projectCategory.put(string2, string);
        this.m_projectClass.put(string2, string3);
        this.setEnabledMenu(100, true);
        if (stringArray != null) {
            this.m_projectParms.put(string2, stringArray);
        }
        return true;
    }

    public boolean addProject(String string, String string2, String[] stringArray) {
        return this.addProject(null, string, string2, stringArray);
    }

    public boolean addProject(PjProject pjProject) {
        if (pjProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        String string = pjProject.getName();
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.hasProject(string) || this.m_projectList.contains(pjProject)) {
            PsDebug.warning("project already available, use selectProject, name = " + string);
            return false;
        }
        this.m_projectList.put(string, pjProject);
        pjProject.setViewer(this);
        return true;
    }

    public boolean hasProject(String string) {
        return this.m_projectList.containsKey(string);
    }

    public PjProject getCurrentProject() {
        return this.m_currentProject;
    }

    public PjProject getProject(String string) {
        PjProject pjProject = (PjProject)this.m_projectList.get(string);
        if (pjProject == null) {
            String string2 = (String)this.m_projectClass.get(string);
            if (string2 != null) {
                pjProject = (PjProject)PsUtil.newInstance(string2);
            }
            if (pjProject == null) {
                PsDebug.warning("could not create instance of " + string + " (" + string2 + ")", this);
                return null;
            }
            pjProject.setViewer(this);
            this.m_projectList.put(string, pjProject);
        }
        return pjProject;
    }

    public Hashtable getProjectClasses() {
        return this.m_projectClass;
    }

    public Hashtable getProjectInstances() {
        return this.m_projectList;
    }

    public boolean removeProject(String string) {
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject == null) {
            PsDebug.notify("empty current project");
            return false;
        }
        PjProject pjProject = this.getProject(string);
        if (pjProject == null) {
            PsDebug.warning("missing project = " + string);
            return false;
        }
        return this.removeProject(pjProject);
    }

    public boolean removeProject(PjProject pjProject) {
        Object object;
        if (pjProject == null) {
            return true;
        }
        if (this.m_currentProject == pjProject) {
            this.m_currentProject.stop();
            object = null;
            if (this.m_control != null) {
                object = this.m_control.releasePanel(10);
            }
            if (this.m_applet != null && object != null) {
                this.m_applet.remove((Component)object);
                this.m_applet.validate();
            }
            if (this.m_control != null) {
                this.m_control.setProject(null);
            }
            this.m_currentProject = null;
            this.setEnabledMenu(21, false);
            this.setEnabledMenu(40, false);
        }
        if (this.m_projectList.contains(pjProject)) {
            object = this.m_projectList.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (this.m_projectList.get(string) != pjProject) continue;
                this.m_projectList.remove(string);
                break;
            }
        }
        return true;
    }

    public boolean selectProject(PjProject pjProject) {
        if (pjProject == null) {
            PsDebug.warning("missing project");
            return false;
        }
        if (!this.m_projectList.contains(pjProject)) {
            PsDebug.warning("project not available in viewer, must be added before selecting.");
            return false;
        }
        if (this.m_currentProject != null) {
            if (this.m_currentProject == pjProject) {
                return true;
            }
            this.m_currentProject.stop();
            PsPanel psPanel = null;
            if (this.m_control != null) {
                psPanel = this.m_control.releasePanel(10);
            }
            if (this.m_applet != null && psPanel != null) {
                this.m_applet.remove(psPanel);
                this.m_applet.validate();
            }
        }
        this.m_currentProject = pjProject;
        this.m_currentProject.setParent(this);
        if (this.m_display != null) {
            if (this.m_currentProject.hasDisplay(this.m_display)) {
                this.m_currentProject.selectDisplay(this.m_display);
            } else {
                this.m_currentProject.setDisplay(this.m_display);
            }
        }
        if (this.m_control != null) {
            this.m_control.setProject(this.m_currentProject);
        }
        if (this.m_bStarted) {
            this.m_currentProject.start();
        }
        this.setEnabledMenu(21, true);
        this.setEnabledMenu(40, this.m_currentProject.hasAnimation());
        return true;
    }

    public boolean selectProject(String string) {
        PjProject pjProject;
        if (string == null) {
            PsDebug.warning("missing project name");
            return false;
        }
        if (this.m_currentProject != null) {
            if (string.equals(this.m_currentProject.getName())) {
                return true;
            }
            this.m_currentProject.stop();
        }
        if ((pjProject = this.getProject(string)) == null) {
            PsDebug.error("could not find project " + string, this);
            return false;
        }
        if (this.m_applet != null && this.m_applet.getParameterInfo() != null) {
            pjProject.setParameterInfo(this.m_applet.getParameterInfo());
        }
        this.m_parm = pjProject.getParameterInfo();
        this.selectProject(pjProject);
        return true;
    }

    public PgGeometryIf getGeometry() {
        return this.m_currentGeometry;
    }

    public void setGeometry(PgGeometryIf pgGeometryIf) {
        if (pgGeometryIf == null) {
            PsDebug.notify("setting null geometry.");
        }
        if (this.m_control != null) {
            this.m_control.setGeometry(pgGeometryIf);
        }
        if (pgGeometryIf == null) {
            this.setEnabledMenu(3, false);
            this.setEnabledMenu(22, false);
            if (this.m_currentProject == null) {
                this.setEnabledMenu(40, false);
            }
            this.m_currentGeometry = null;
            return;
        }
        if (this.m_currentGeometry == pgGeometryIf) {
            return;
        }
        this.m_currentGeometry = pgGeometryIf;
        this.setEnabledMenu(3, true);
        this.setEnabledMenu(22, true);
        this.setEnabledMenu(220, this.m_currentGeometry.isConfigurable(4));
        this.setEnabledMenu(221, this.m_currentGeometry.isConfigurable(5));
        this.setEnabledMenu(222, this.m_currentGeometry.isConfigurable(6));
        this.setEnabledMenu(223, this.m_currentGeometry.isConfigurable(7));
        this.setEnabledMenu(224, this.m_currentGeometry.isConfigurable(8));
        this.setEnabledMenu(225, this.m_currentGeometry.isConfigurable(9));
        this.setEnabledMenu(226, this.m_currentGeometry.isConfigurable(10));
    }

    private PvControl getControl() {
        if (!PsJavaView.m_bControlUsable) {
            return null;
        }
        if (this.m_control != null) {
            this.m_control.setGeometry(this.m_currentGeometry);
            this.m_control.setDisplay(this.m_display);
            this.m_control.setProject(this.m_currentProject);
            return this.m_control;
        }
        this.m_control = new PvControl(this);
        if (this.m_control == null) {
            PsDebug.error("missing control panel", this);
            return null;
        }
        if (!PsConfig.hasArchive(1)) {
            this.setEnabledMenu(15, false);
        }
        this.addFrame(this.m_control);
        if (this.m_currentGeometry == null && this.m_display != null) {
            PsDebug.notify("missing geometry, registered from display.");
            this.setGeometry(this.m_display.getSelectedGeometry());
        }
        this.m_control.setGeometry(this.m_currentGeometry);
        this.m_control.setDisplay(this.m_display);
        this.m_control.setProject(this.m_currentProject);
        if (this.m_showPanel != -1) {
            this.m_control.showPanel(this.m_showPanel);
        }
        return this.m_control;
    }

    private void removeControl() {
        this.m_control.setVisible(false);
        this.m_control.setGeometry(null);
        this.m_control.setProject(null);
        this.m_control.setDisplay(null);
        this.removeFrame(this.m_control);
        this.m_control.dispose();
        this.m_control = null;
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == this.m_currentProject) {
            PsDebug.notify("event = m_currentProjec): called");
            return true;
        }
        return super.update(object);
    }

    public boolean showDialog(int n) {
        Serializable serializable;
        Point point;
        PgFileDialog pgFileDialog = null;
        String string = null;
        String string2 = null;
        int[] nArray = PsJavaView.getWindowSize(2);
        int[] nArray2 = PsJavaView.getWindowSize(1);
        int[] nArray3 = PsJavaView.getWindowSize(4);
        int[] nArray4 = PsJavaView.getWindowSize(6);
        if (this.m_control != null && this.m_control.isShowing()) {
            point = this.m_control.getLocation();
            nArray2[0] = point.x / PsConfig.getMonitorScale();
            nArray2[1] = point.y / PsConfig.getMonitorScale();
            serializable = this.m_control.getSize();
            nArray2[2] = ((Dimension)serializable).width / PsConfig.getMonitorScale();
            nArray2[3] = ((Dimension)serializable).height / PsConfig.getMonitorScale();
        } else {
            point = new Point(nArray2[0], nArray2[1]);
        }
        this.m_bShowingDialog = true;
        block2 : switch (n) {
            case 31: {
                serializable = PvViewer.getAboutDialog();
                ((Component)serializable).setLocation(point.x + nArray[0], point.y + nArray[1]);
                ((Component)serializable).setSize(nArray[2], nArray[3]);
                ((Container)serializable).validate();
                ((Dialog)serializable).setModal(true);
                ((Component)serializable).setVisible(true);
                break;
            }
            case 32: {
                Dialog dialog = PvViewer.getAboutAppletDialog();
                ((Component)dialog).setLocation(point.x + nArray[0] + 20, point.y + nArray[1] + 20);
                ((Component)dialog).setSize(nArray[2], nArray[3]);
                dialog.validate();
                dialog.setModal(true);
                ((Component)dialog).setVisible(true);
                break;
            }
            case 30: {
                PsJavaView_IP psJavaView_IP = (PsJavaView_IP)this.m_jvRsrc.getInfoPanel();
                psJavaView_IP.setParent(this.m_jvRsrc);
                psJavaView_IP.update(this.m_jvRsrc);
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), psJavaView_IP.getDialogTitle(), true);
                psDialog.addActionListener(psJavaView_IP);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psJavaView_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(psJavaView_IP.getDialogButtons()), "South");
                psDialog.setLocation(point.x + nArray2[0] + 20, point.y + nArray2[1] + 20);
                ((Component)psDialog).setSize(psJavaView_IP.getDialogSize());
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                break;
            }
            case 29: {
                if (this.m_jvLic == null) {
                    this.m_jvLic = new PsLicense();
                }
                this.m_jvLic.showInfoPanel();
                break;
            }
            case 33: {
                Object object;
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (psDialog == null && this.m_currentGeometry != null) {
                    PsTimeListenerIf psTimeListenerIf;
                    for (object = (Object)this.m_currentGeometry; object != null && !(object instanceof PsTimeListenerIf); object = object.getFather()) {
                    }
                    if (object != null && (psTimeListenerIf = (PsTimeListenerIf)object).hasAnimation()) {
                        psDialog = psTimeListenerIf.getAnimation().getAnimationPanel();
                    }
                }
                if (psDialog == null) {
                    PsDebug.warning("missing animation");
                    this.m_bShowingDialog = false;
                    return false;
                }
                object = PsJavaView.getWindowSize(5);
                ((Component)psDialog).setLocation(point.x, point.y + nArray2[3] - object[3]);
                ((Component)psDialog).setSize((int)object[2], (int)object[3]);
                ((Component)psDialog).setVisible(true);
                break;
            }
            case 35: {
                if (!PsJavaView.m_bConsoleUsable) {
                    return false;
                }
                boolean bl = PsDebug.hasConsole();
                PsConsole psConsole = PsDebug.getConsole();
                if (psConsole == null) {
                    PsDebug.error("missing console panel", this);
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!bl) {
                    psConsole.setLocation(nArray3[0], nArray3[1]);
                    psConsole.setSize(nArray3[2], nArray3[3]);
                }
                ((Component)psConsole).setVisible(true);
                break;
            }
            case 34: {
                if (!PsJavaView.m_bControlUsable) {
                    return false;
                }
                if (this.m_control == null) {
                    this.m_control = this.getControl();
                    if (this.m_control == null) {
                        PsDebug.warning("missing control panel");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                this.m_control.setOuterBounds(nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                this.m_control.setVisible(true);
                this.m_control.requestFocus();
                break;
            }
            case 36: {
                if (!PsConfig.isApplication() && this.m_applet != null) {
                    try {
                        URL uRL = new URL(PsConfig.getCodeBase() + PsConfig.HELP_HTML);
                        uRL.openConnection();
                        uRL.openStream();
                        this.m_applet.getAppletContext().showDocument(uRL, "Help on Viewer");
                        break;
                    }
                    catch (Exception exception) {
                        PsDebug.warning("file not found = " + PsConfig.HELP_HTML);
                    }
                }
                if (this.m_help == null) {
                    this.m_help = PvViewer.getHelpDialog();
                }
                ((Component)this.m_help).setLocation(point.x + nArray3[2] / 2, point.y + nArray3[3] / 5);
                int[] nArray5 = PsJavaView.getWindowSize(3);
                ((Component)this.m_help).setSize(nArray5[2], nArray5[3]);
                ((Component)this.m_help).setVisible(true);
                break;
            }
            case 37: {
                PsDebug.notify("add project");
                String[] stringArray = PvViewer.getCategories(this.m_projectCategory);
                String[][] stringArray2 = PvViewer.getEntries(this.m_projectCategory, stringArray);
                if (stringArray2 == null) {
                    PsDebug.warning("no registered projects");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.addProjectCheckboxes();
                psCategoryList_IP.setCategories(stringArray, stringArray2);
                psCategoryList_IP.setTitle(PsConfig.getMessage(24312));
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24311), true);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psCategoryList_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(5), "South");
                psDialog.setLocation(point.x + nArray4[0], point.y + nArray4[1]);
                psDialog.setSize(nArray4[2], nArray4[3]);
                ((Component)psDialog).setVisible(true);
                int n2 = psDialog.getUserAction();
                if (n2 != 4) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                String string3 = psCategoryList_IP.getSelectedEntry();
                PsDebug.notify("project selected = " + string3);
                if (PuString.isEmpty(string3)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (psCategoryList_IP.isClosing()) {
                    this.reset();
                }
                if (!this.selectProject(string3)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!PsConfig.isApplication()) break;
                int n3 = this.getNumFrames();
                for (int i = 0; i < n3; ++i) {
                    Frame frame = (Frame)this.m_frameVector.elementAt(i);
                    PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
                    if (pvDisplayIf == null || pvDisplayIf != this.m_mainDisplay) continue;
                    frame.setTitle(PsConfig.getProgramAndVersion() + ": " + this.m_currentProject.getName());
                }
                break;
            }
            case 39: 
            case 40: {
                boolean bl;
                PsDebug.notify("add geometry");
                String[] stringArray = PvViewer.getCategories(this.m_geometryCategory);
                String[][] stringArray3 = PvViewer.getEntries(this.m_geometryCategory, stringArray);
                if (stringArray3 == null) {
                    PsDebug.warning("no registered geometrys");
                    break;
                }
                PsCategoryList_IP psCategoryList_IP = new PsCategoryList_IP();
                psCategoryList_IP.addProjectCheckboxes();
                psCategoryList_IP.setCategories(stringArray, stringArray3);
                psCategoryList_IP.setTitle(PsConfig.getMessage(24316));
                PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24315), true);
                psDialog.setLayout(new BorderLayout());
                psDialog.add((Component)psCategoryList_IP, "Center");
                psDialog.add((Component)psDialog.getBottomButtons(5), "South");
                psDialog.setLocation(point.x + nArray4[0], point.y + nArray4[1]);
                psDialog.setSize(nArray4[2], nArray4[3]);
                psDialog.validate();
                ((Component)psDialog).setVisible(true);
                int n4 = psDialog.getUserAction();
                if (n4 != 4) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                String string4 = psCategoryList_IP.getSelectedEntry();
                PsDebug.notify("geometry selected = " + string4);
                if (PuString.isEmpty(string4)) {
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf pgGeometryIf = this.getGeometry(string4);
                if (pgGeometryIf == null) {
                    PsDebug.warning("failed to create geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (this.m_display == null) {
                    PsDebug.warning("missing display.");
                    this.newDisplay(pgGeometryIf.getName());
                }
                if (bl = psCategoryList_IP.isClosing()) {
                    this.reset();
                }
                if (this.m_currentProject != null) {
                    this.m_currentProject.setParent(pgGeometryIf);
                    this.m_currentProject.addGeometry(pgGeometryIf);
                }
                this.m_display.addGeometry(pgGeometryIf);
                this.m_display.selectGeometry(pgGeometryIf);
                if (bl) {
                    if (pgGeometryIf.getDimOfVertices() == 2) {
                        this.m_display.selectCamera(1);
                    } else {
                        this.m_display.selectCamera(0);
                    }
                }
                pgGeometryIf.update(pgGeometryIf);
                if (psCategoryList_IP.isClosing()) {
                    this.m_display.fit();
                }
                if (!((PgGeometry)pgGeometryIf).hasTag(10)) break;
                this.showPanel(17);
                break;
            }
            case 41: {
                PsDebug.notify("import model into current project's geometry");
                PjImportModel pjImportModel = new PjImportModel();
                pjImportModel.setVisibleReplaceChoice(true);
                PjImportModel_Dialog pjImportModel_Dialog = new PjImportModel_Dialog(PsConfig.getFrame());
                ((PsDialog)pjImportModel_Dialog).setParent(pjImportModel);
                ((PsDialog)pjImportModel_Dialog).update(pjImportModel);
                int[] nArray6 = PsJavaView.getWindowSize(7);
                pjImportModel_Dialog.setLocation(point.x + nArray6[0], point.y + nArray6[1]);
                pjImportModel_Dialog.setSize(nArray6[2], nArray6[3]);
                if (this.m_currentProject != null) {
                    pjImportModel.setParentProject(this.m_currentProject);
                    ((Component)pjImportModel_Dialog).setVisible(true);
                    if (pjImportModel_Dialog.getUserAction() != 0) break;
                    PsJavaView.setFullFileName(7, pjImportModel.getFileName());
                    break;
                }
                if (this.m_display == null || pjImportModel.getGeometry() == null) {
                    PsDebug.warning("no project or display available to add geometry.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                pjImportModel_Dialog.setModal(true);
                pjImportModel.setDisplay(this.m_display);
                ((Component)pjImportModel_Dialog).setVisible(true);
                this.m_display.isShowingVisible();
                if (pjImportModel.getConfirm() == 0) {
                    PsTimeListenerIf psTimeListenerIf;
                    PsUpdateIf psUpdateIf;
                    this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                    for (psUpdateIf = pjImportModel.getGeometry(0); psUpdateIf != null && !(psUpdateIf instanceof PsTimeListenerIf); psUpdateIf = psUpdateIf.getFather()) {
                    }
                    if (psUpdateIf != null && (psTimeListenerIf = (PsTimeListenerIf)((Object)psUpdateIf)).hasAnimation()) {
                        this.setEnabledMenu(40, true);
                    }
                    if (pjImportModel.isEnabledRemoveGeometry() && pgGeometryIfArray != null) {
                        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                            this.m_display.removeGeometry(pgGeometryIfArray[i]);
                        }
                        this.m_display.fit();
                    }
                    PsJavaView.setFullFileName(7, pjImportModel.getFileName());
                } else {
                    pjImportModel.removeGeometries();
                }
                PsConfig.runGC();
                pjImportModel.removeDisplay(this.m_display);
                this.m_display.update(this.m_display);
                break;
            }
            case 42: 
            case 43: {
                string2 = n == 43 ? "jvd" : "*";
                pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24113), 0);
                pgFileDialog.setDirectory(PsJavaView.getDirectory(7));
                pgFileDialog.setExtension(string2);
                pgFileDialog.show();
                if (!pgFileDialog.isFileSelected()) {
                    PsDebug.notify("dialog cancelled");
                    break;
                }
                string = pgFileDialog.getFullFileName();
                this.loadModel(string);
                break;
            }
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 71: 
            case 72: {
                String string5;
                string2 = n == 49 ? "ma" : (n == 44 ? "byu" : (n == 46 ? "fe" : (n == 47 ? "jvx" : (n == 48 ? "jvz" : (n == 50 ? "mgs" : (n == 51 ? "mpl" : (n == 52 ? "obj" : (n == 53 ? "off" : (n == 71 ? "pdf" : (n == 55 ? "ply" : (n == 54 ? "pov" : (n == 56 ? "stl" : (n == 57 ? "u3d" : (n == 58 ? "wrl" : (n == 60 ? "jvd" : (n == 72 ? "html" : "jvx"))))))))))))))));
                if (PsConfig.isApplication()) {
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24141), 1);
                    pgFileDialog.setDirectory(PsJavaView.getDirectory(7));
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.show();
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        PsDebug.notify("dialog cancelled");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                if ((string5 = PsUtil.getFileExtension(string)) == null || !string5.equalsIgnoreCase(string2)) {
                    string = string + "." + string2;
                }
                if (!this.export(n, string) || !PsConfig.isApplication()) break;
                PsJavaView.setFullFileName(7, string);
                if (n != 72) break;
                try {
                    String string6 = pgFileDialog.getDirectory();
                    int n5 = string6.length();
                    if (n5 > 0 && string6.charAt(n5 - 1) != PsConfig.getFileSeparator()) {
                        string6 = string6 + PsConfig.getFileSeparator();
                    }
                    String[] stringArray = new String[]{"jars" + PsConfig.getFileSeparator() + "javaview.jar", "jars" + PsConfig.getFileSeparator() + "jvLite.jar"};
                    String[] stringArray4 = new String[]{string6 + stringArray[0], string6 + stringArray[1]};
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file = new File(stringArray4[i]);
                        if (file.exists()) continue;
                        String string7 = null;
                        if (PsConfig.getOSId() == 0) {
                            string7 = "xcopy /Y \"" + PsConfig.getCodeBase() + stringArray[i] + "\" \"" + string6 + "jars\"";
                        } else if (PsConfig.getOSId() == 3 || PsConfig.getOSId() == 2 || PsConfig.getOSId() == 1) {
                            string7 = "cp -r " + PsConfig.getCodeBase() + "jars " + string6;
                        } else {
                            PsDebug.warning("Must assure existence of JavaView archive: " + stringArray4[i]);
                            continue;
                        }
                        Runtime runtime = Runtime.getRuntime();
                        if (i == 0) {
                            runtime.exec("mkdir \"" + string6 + "jars\"");
                            Thread.sleep(1000L);
                        }
                        runtime.exec(string7);
                        Thread.sleep(1000L);
                        if (file.exists()) {
                            PsDebug.message("JavaView archive copied to HTML destination:\n\t" + stringArray4[i], true);
                        } else {
                            PsDebug.message("Failed to copy JavaView archive using cmd:\n\t" + string7 + "\nto HTML destination:\n\t" + stringArray4[i], true);
                        }
                        if (PsConfig.getOSId() != 0) break block2;
                    }
                    break;
                }
                catch (IOException iOException) {
                    PsDebug.warning("failed to copy JavaView jar archives to HTML destination. Must copy by hand.");
                    break;
                }
                catch (SecurityException securityException) {
                    PsDebug.warning("failed to copy JavaView jar archives to HTML destination. Must copy by hand.");
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                if (!PsConfig.isApplication()) {
                    PsDebug.warning("cannot export image in applet mode.");
                    this.m_bShowingDialog = false;
                    return false;
                }
            }
            case 69: 
            case 70: {
                String string8;
                string2 = n == 61 ? "gif" : (n == 62 ? "001.gif" : (n == 63 ? "jpg" : (n == 64 ? "001.jpg" : (n == 67 ? "png" : (n == 65 ? "ppm" : (n == 66 ? "001.ppm" : (n == 70 ? "ps" : (n == 69 ? "eps" : "ppm"))))))));
                if (PsConfig.isApplication()) {
                    pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24319), 1);
                    pgFileDialog.setDirectory(PsJavaView.getDirectory(8));
                    pgFileDialog.setExtension(string2);
                    pgFileDialog.show();
                    string = pgFileDialog.getFullFileName();
                    if (string == null) {
                        PsDebug.notify("dialog cancelled");
                        this.m_bShowingDialog = false;
                        return false;
                    }
                }
                if (string == null) {
                    string = "javaview." + string2;
                }
                if ((string8 = PsUtil.getFileExtension(string)) == null || !string8.equalsIgnoreCase(string2)) {
                    string = string + "." + string2;
                }
                if (n != 62 && n != 64 && n != 66) {
                    boolean bl = this.export(n, string);
                    if (bl && PsConfig.isApplication()) {
                        PsJavaView.setFullFileName(8, string);
                    }
                    this.m_bShowingDialog = false;
                    return bl;
                }
                PsAnimation psAnimation = null;
                if (this.m_currentProject != null && this.m_currentProject.hasAnimation()) {
                    psAnimation = this.m_currentProject.getAnimation();
                }
                if (psAnimation == null && this.m_currentGeometry != null) {
                    PsUpdateIf psUpdateIf;
                    for (psUpdateIf = this.m_currentGeometry; psUpdateIf != null && !(psUpdateIf instanceof PsTimeListenerIf); psUpdateIf = psUpdateIf.getFather()) {
                    }
                    if (psUpdateIf != null) {
                        PsTimeListenerIf psTimeListenerIf = (PsTimeListenerIf)((Object)psUpdateIf);
                        psAnimation = psTimeListenerIf.getAnimation();
                    }
                }
                if (psAnimation != null && psAnimation.isRunning()) {
                    psAnimation.stop();
                }
                double d = 0.0;
                double d2 = 1.0;
                int n6 = 100;
                if (psAnimation != null) {
                    double d3 = psAnimation.getMinTime();
                    double d4 = psAnimation.getMaxTime();
                    d2 = psAnimation.getTimePageIncr();
                    d = d3;
                    n6 = 1 + (int)((d4 - d3) / d2);
                    if (n6 > 999) {
                        PsDebug.warning("too many images, 999 < num = " + n6);
                        this.m_bShowingDialog = false;
                        return false;
                    }
                } else if (this.m_display == null) {
                    PsDebug.warning("missing display");
                    this.m_bShowingDialog = false;
                    return false;
                }
                string2 = n == 62 ? "gif" : (n == 64 ? "jpg" : "ppm");
                String string9 = PsUtil.getFileBaseName(string);
                if (string9.endsWith("001")) {
                    string9 = PsUtil.getFileBaseName(string9);
                }
                String string10 = PsUtil.getFilePath(string);
                string9 = string10 + string9;
                for (int i = 0; i < n6; ++i) {
                    if (psAnimation != null) {
                        psAnimation.setTime(d);
                        d += d2;
                    } else if (this.m_display != null) {
                        this.m_display.incrementAutoRotation();
                    }
                    string = i < 9 ? string9 + ".00" + (i + 1) + "." + string2 : (i < 99 ? string9 + ".0" + (i + 1) + "." + string2 : string9 + "." + (i + 1) + "." + string2);
                    if (this.export(n, string)) continue;
                    PsDebug.warning("error during animation export.");
                    this.m_bShowingDialog = false;
                    return false;
                }
                if (!PsConfig.isApplication()) break;
                PsJavaView.setFullFileName(8, string);
                break;
            }
            case 73: 
            case 75: 
            case 76: {
                this.export(n, null);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                this.m_bShowingDialog = false;
                return false;
            }
        }
        this.m_bShowingDialog = false;
        return true;
    }

    public boolean export(int n, String string, int n2, int n3) {
        if (this.m_display == null) {
            PsDebug.warning("missing display, no geometry available");
            return false;
        }
        PvDisplay pvDisplay = (PvDisplay)this.m_display;
        boolean bl = this.m_display.hasPaintTag(4L);
        this.m_display.setPaintTag(4L, false);
        boolean bl2 = this.m_display.hasPaintTag(0x20000000L);
        this.m_display.setPaintTag(0x20000000L, false);
        boolean bl3 = this.m_display.isEnabledZBuffer() || this.m_display.isEnabledClip() || this.m_display.isShowingBackgroundImage() && this.m_display.getBackgroundImage() != null || this.m_display.isShowingForegroundImage() && this.m_display.getForegroundImage() != null;
        PgLoader pgLoader = new PgLoader();
        switch (n) {
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                pvDisplay.setEnabledExternalRendering(true);
                pvDisplay.setExternalRenderSize(n2, n3);
                pvDisplay.update(this.m_display.getCanvas().getGraphics());
                Image image = this.m_display.getImage();
                Thread thread = new Thread(){

                    public synchronized void run() {
                        System.out.println("start: waiting for image, thread = " + Thread.currentThread().getName());
                        PvDisplay pvDisplay = (PvDisplay)PvViewer.this.m_display;
                        PvDisplayHandlerIf pvDisplayHandlerIf = (PvDisplayHandlerIf)((Object)pvDisplay.m_renderCanvas);
                        int n = 0;
                        try {
                            while (pvDisplayHandlerIf.getImage(false) == null && n++ < 10) {
                                System.out.println("      wait for image, cnt = " + n + ", thread = " + Thread.currentThread().getName());
                                Thread.yield();
                                Thread.sleep(100L);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        Image image = pvDisplayHandlerIf.getImage(true);
                        pvDisplay.setEnabledExternalRendering(false);
                        PvViewer.this.m_thread_loader.saveImage(image, PvViewer.this.m_thread_fileName);
                        PvViewer.this.m_thread_fileName = null;
                        PvViewer.this.m_thread_loader = null;
                    }
                };
                if (image == null) {
                    this.m_thread_fileName = string;
                    this.m_thread_loader = pgLoader;
                    thread.start();
                    break;
                }
                pgLoader.saveImage(image, string);
                pvDisplay.setEnabledExternalRendering(false);
                break;
            }
            case 69: 
            case 70: {
                String string2 = null;
                string2 = this.m_currentGeometry != null ? this.m_currentGeometry.getName() : PsConfig.getProgram();
                PSGr pSGr = new PSGr(this.m_display.getCanvas().getGraphics(), string2, n2, n3);
                if (!bl3) {
                    this.m_display.setPaintTag(8L, true);
                    pSGr.setZoom(PvDisplay.PS_ZOOM);
                    this.print(pSGr, bl3, n2, n3);
                    this.m_display.setPaintTag(8L, false);
                    pSGr.setZoom(1.0f);
                } else {
                    pvDisplay.setEnabledExternalRendering(true);
                    this.print(pSGr, bl3, n2, n3);
                    pvDisplay.setEnabledExternalRendering(false);
                }
                String string3 = pSGr.toString();
                if (n == 70) {
                    string3 = string3 + "showpage";
                }
                pgLoader.saveString(string3, string);
                break;
            }
            case 76: {
                try {
                    Canvas canvas = this.m_display.getCanvas();
                    PrintJob printJob = canvas.getToolkit().getPrintJob(PsConfig.getFrame(), "JavaView Print Job", null);
                    if (printJob == null) {
                        return true;
                    }
                    Graphics graphics = printJob.getGraphics();
                    Dimension dimension = printJob.getPageDimension();
                    double d = (double)n2 / (double)n3;
                    double d2 = (double)dimension.width / (double)dimension.height;
                    if (d > d2) {
                        n2 = dimension.width;
                        n3 = (int)((double)dimension.width / d);
                    } else {
                        n2 = (int)((double)dimension.height * d);
                        n3 = dimension.height;
                    }
                    this.print(graphics, bl3, n2, n3);
                    graphics.dispose();
                    printJob.end();
                }
                catch (Exception exception) {
                    PsDebug.warning("printing failed in Java.");
                }
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return false;
            }
        }
        this.m_display.setPaintTag(0x20000000L, bl2);
        this.m_display.setPaintTag(4L, bl);
        pvDisplay.render();
        return true;
    }

    private void print(Graphics graphics, boolean bl, int n, int n2) {
        PvDisplay pvDisplay = (PvDisplay)this.m_display;
        if (bl) {
            Color color = pvDisplay.getBackgroundColor();
            pvDisplay.setBackgroundColor(Color.white);
            pvDisplay.setEnabledExternalRendering(true);
            pvDisplay.setExternalRenderSize(n, n2);
            pvDisplay.render();
            Image image = this.m_display.getImage();
            pvDisplay.setEnabledExternalRendering(false);
            graphics.drawImage(image, 0, 0, n, n2, null);
            pvDisplay.setBackgroundColor(color);
            pvDisplay.render();
        } else {
            boolean bl2 = this.m_display.isEnabledAntiAlias();
            if (bl2) {
                this.m_display.setEnabledAntiAlias(false);
            }
            pvDisplay.setEnabledExternalRendering(true);
            pvDisplay.setExternalRenderSize(n, n2);
            pvDisplay.paintGeom(graphics);
            pvDisplay.setEnabledExternalRendering(false);
            if (bl2) {
                this.m_display.setEnabledAntiAlias(true);
            }
        }
    }

    protected void submit() {
        if (!PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar");
            return;
        }
        PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance("jvx.rsrc.PsModelInfo");
        if (pjWorkshopIf == null) {
            PsDebug.warning("missing class PsModelInfo, probably jvx.jar not available.");
            return;
        }
        pjWorkshopIf.setViewer(this);
        PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
        if (psDialog != null) {
            psDialog.setParent(pjWorkshopIf);
            psDialog.setLocation(5, 5);
            psDialog.update(pjWorkshopIf);
            psDialog.setModal(true);
            ((Component)psDialog).setVisible(true);
        }
    }

    protected boolean burnTexture() {
        PvDisplay pvDisplay = (PvDisplay)this.m_display;
        if (pvDisplay == null) {
            PsDebug.warning("missing display");
            return false;
        }
        pvDisplay.burn();
        return true;
    }

    private boolean saveFiles(int n) {
        if (!PsConfig.hasArchive(1)) {
            PsDebug.warning("missing archive jvx.jar");
            return false;
        }
        PjWorkshopIf pjWorkshopIf = (PjWorkshopIf)PsUtil.newInstance("jvx.loader.PsExportInfo");
        if (pjWorkshopIf == null) {
            PsDebug.warning("missing class PsExportInfo, probably jvx.jar not available.");
            return false;
        }
        pjWorkshopIf.setViewer(this);
        pjWorkshopIf.setMode(n);
        PsDialog psDialog = (PsDialog)PsUtil.newInstance("jvx.project.PjWorkshop_Dialog");
        if (psDialog != null) {
            psDialog.setParent(pjWorkshopIf);
            psDialog.update(pjWorkshopIf);
            psDialog.setLocation(50, 50);
            psDialog.setModal(true);
            ((Component)psDialog).setVisible(true);
        }
        return true;
    }

    public String getRecentGeometryFile() {
        return PsJavaView.getFullFileName(7);
    }

    public void setRecentGeometryFile(String string) {
        PsJavaView.setFullFileName(7, string);
    }

    private static String[] getCategories(Hashtable hashtable) {
        int n;
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        int n2 = hashtable.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        String[] stringArray2 = hashtable.elements();
        while (stringArray2.hasMoreElements()) {
            String string = (String)stringArray2.nextElement();
            boolean bl = false;
            for (n = 0; n < n3; ++n) {
                if (!stringArray[n].equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            stringArray[n3++] = string;
        }
        if (n3 == 0) {
            return null;
        }
        stringArray2 = new String[n3];
        for (n = 0; n < n3; ++n) {
            stringArray2[n] = stringArray[n];
        }
        PuString.sort(stringArray2);
        return stringArray2;
    }

    private static String[][] getEntries(Hashtable hashtable, String[] stringArray) {
        if (hashtable == null || stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[][] stringArray2 = new String[n][];
        int n2 = hashtable.size();
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = new String[n2];
            int n3 = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                if (!string2.equals(stringArray[i]) || string.startsWith("jvx") && !PsConfig.hasArchive(1)) continue;
                stringArray3[n3++] = string;
            }
            stringArray2[i] = new String[n3];
            if (n3 == 0) continue;
            for (int j = 0; j < n3; ++j) {
                stringArray2[i][j] = stringArray3[j];
            }
            PuString.sort(stringArray2[i]);
        }
        return stringArray2;
    }

    public PsDialog getDialog(int n) {
        switch (n) {
            case 33: {
                PsDialog psDialog = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    psDialog = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                return psDialog;
            }
            case 35: {
                return PsDebug.getConsole();
            }
        }
        PsDebug.warning("invalid dialog index = " + n);
        return null;
    }

    public boolean hideDialog(int n) {
        switch (n) {
            case 33: {
                Component component = null;
                if (this.m_currentProject != null && this.m_currentProject.getAnimation() != null) {
                    component = this.m_currentProject.getAnimation().getAnimationPanel();
                }
                if (component == null) {
                    return true;
                }
                component.setVisible(false);
                return true;
            }
            case 35: {
                if (PsDebug.hasConsole()) {
                    ((Component)PsDebug.getConsole()).setVisible(false);
                }
                return true;
            }
            case 34: {
                if (this.m_control != null) {
                    this.m_control.setVisible(false);
                }
                return true;
            }
            case 36: {
                if (this.m_help != null) {
                    ((Component)this.m_help).setVisible(false);
                }
                return true;
            }
        }
        PsDebug.notify("invalid dialog index = " + n);
        return false;
    }

    public String newDisplay() {
        PvDisplayIf pvDisplayIf = this.m_display;
        PvDisplayIf pvDisplayIf2 = this.newDisplay(null);
        if (pvDisplayIf2 == null) {
            return null;
        }
        if (this.m_currentProject != null) {
            PvDisplayIf pvDisplayIf3 = this.m_currentProject.getDisplay();
            this.m_currentProject.setDisplay(pvDisplayIf2);
            if (pvDisplayIf3 != null) {
                this.m_currentProject.selectDisplay(pvDisplayIf3);
            }
        }
        if (pvDisplayIf != null) {
            ((PvDisplay)pvDisplayIf).configure(pvDisplayIf2);
        }
        pvDisplayIf2.update(pvDisplayIf2);
        return pvDisplayIf2.getName();
    }

    public PvDisplayIf newDisplay(String string) {
        PvDisplayIf pvDisplayIf = this.newDisplay(string, true);
        Frame frame = pvDisplayIf.getFrame();
        int n = this.getNumDisplays() - 1;
        Insets insets = frame.getInsets();
        int n2 = (320 + insets.left + insets.right) * PsConfig.getMonitorScale();
        int n3 = (256 + insets.bottom + insets.top) * PsConfig.getMonitorScale();
        if (n > 0) {
            ((Component)frame).setBounds(new Rectangle(5 * PsConfig.getMonitorScale() + n2 * ((n - 1) % 3), 5 * PsConfig.getMonitorScale() + n3 * ((n - 1) / 3), n2, n3));
        } else {
            ((Component)frame).setBounds(new Rectangle(50 * PsConfig.getMonitorScale(), 50 * PsConfig.getMonitorScale(), n2, n3));
        }
        ((Component)frame).setVisible(true);
        return pvDisplayIf;
    }

    public PvDisplayIf newDisplay(String string, boolean bl, boolean bl2) {
        PvDisplay pvDisplay = new PvDisplay(this);
        pvDisplay.setFrame(null);
        if (string == null) {
            string = pvDisplay.getName();
        }
        this.addDisplay(string, pvDisplay);
        if (bl2) {
            this.selectDisplay(pvDisplay);
        }
        if (bl) {
            PsMainFrame psMainFrame = new PsMainFrame(pvDisplay.getCanvas(), string, null);
            psMainFrame.setShortTitle(string);
            Image image = PsToolbar.getImage(psMainFrame, 22);
            if (image != null) {
                psMainFrame.setIconImage(image);
            }
            psMainFrame.setMenuBar(this.newMenuBar(psMainFrame));
            psMainFrame.pack();
            psMainFrame.setInnerBounds(new Rectangle(50, 50, 320, 256));
            pvDisplay.setFrame(psMainFrame);
            this.addFrame(psMainFrame);
        }
        return pvDisplay;
    }

    public PvDisplayIf newDisplay(String string, boolean bl) {
        return this.newDisplay(string, bl, true);
    }

    public PvDisplayIf getDisplay() {
        if (this.m_display != null) {
            return this.m_display;
        }
        this.m_display = new PvDisplay(this);
        this.addDisplay(PsConfig.getMessage(true, 24000, "Main") + " " + PsConfig.getMessage(24320), this.m_display);
        if (this.m_currentProject != null && !this.m_currentProject.hasDisplay(this.m_display)) {
            this.m_currentProject.setDisplay(this.m_display);
        }
        this.selectDisplay(this.m_display);
        return this.m_display;
    }

    public PvDisplayIf[] getDisplays() {
        if (this.m_displayVector == null) {
            return null;
        }
        PvDisplayIf[] pvDisplayIfArray = new PvDisplayIf[this.m_displayVector.size()];
        int n = 0;
        Enumeration enumeration = this.m_displayVector.elements();
        while (enumeration.hasMoreElements()) {
            pvDisplayIfArray[n++] = (PvDisplayIf)enumeration.nextElement();
        }
        return pvDisplayIfArray;
    }

    private int getNumDisplays() {
        if (this.m_displayVector == null) {
            return 0;
        }
        return this.m_displayVector.size();
    }

    public boolean hasDisplay(PvDisplayIf pvDisplayIf) {
        if (this.m_displayVector == null) {
            return false;
        }
        return this.m_displayVector.contains(pvDisplayIf);
    }

    public boolean addDisplay(String string, PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (this.m_displayVector == null) {
            PsDebug.error("missing instance variable m_displayVector.", this);
            return false;
        }
        if (this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + string + " already registered.");
        }
        pvDisplayIf.setParent(this);
        pvDisplayIf.setViewer(this);
        pvDisplayIf.addKeyListener(this);
        if (string != null) {
            pvDisplayIf.setName(string);
        }
        this.m_displayVector.addElement(pvDisplayIf);
        PsDropHandlerIf psDropHandlerIf = (PsDropHandlerIf)PsUtil.newInstance("dev.objectGui.PsDropHandler");
        if (psDropHandlerIf != null) {
            psDropHandlerIf.configure(pvDisplayIf.getCanvas(), true, this);
        }
        return true;
    }

    public void filesDropped(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            PsDebug.warning("missing or empty array of files");
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String string = fileArray[i].getCanonicalPath();
                PsDebug.message("File dropped: file = " + string + "\n", false);
                this.loadModel(string);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void loadModel(String string) {
        boolean bl = PsJavaView.m_bAutoLoadDisplay;
        boolean bl2 = PsJavaView.m_bCleanDisplay;
        if (this.m_currentProject != null && bl2) {
            this.reset();
        }
        if (string.endsWith("jvd")) {
            PgLoader pgLoader = new PgLoader();
            PvDisplayOption[] pvDisplayOptionArray = pgLoader.loadDisplay(string);
            if (pvDisplayOptionArray == null) {
                PsDebug.warning("error when reading file = " + string);
                return;
            }
            PsJavaView.setFullFileName(7, string);
            if (this.m_display != null) {
                pvDisplayOptionArray[0].configure(this.m_display);
                this.m_display.update(this.m_display);
            }
        } else {
            Object object;
            PjImportModel pjImportModel = new PjImportModel();
            pjImportModel.removeGeometries();
            if (this.m_currentProject != null) {
                pjImportModel.setParentProject(this.m_currentProject);
            }
            pjImportModel.setEnabledLoadCamera(bl);
            boolean bl3 = pjImportModel.load(string);
            PvDisplayOption[] pvDisplayOptionArray = null;
            if (bl3) {
                PsJavaView.setFullFileName(7, string);
                if (bl) {
                    PgLoader pgLoader;
                    if (pjImportModel.getDisplayOption() != null) {
                        pvDisplayOptionArray = pjImportModel.getDisplayOption();
                    }
                    if (pvDisplayOptionArray == null && (pvDisplayOptionArray = (pgLoader = new PgLoader()).loadDisplay((String)(object = PsUtil.getFilePathAndBaseName(string) + ".jvd"))) == null) {
                        PsDebug.warning("error when reading file = " + (String)object);
                    }
                }
            }
            if (bl3 && this.m_display != null) {
                object = this.m_display.getGeometries();
                int n = pjImportModel.getNumGeometries();
                if (this.m_currentProject == null) {
                    int n2;
                    for (n2 = 0; n2 < n; ++n2) {
                        this.m_display.addGeometry(pjImportModel.getGeometry(n2));
                    }
                    if (n != 0) {
                        this.m_display.selectGeometry(pjImportModel.getGeometry(0));
                    }
                    if (bl2 && n > 0 && object != null) {
                        for (n2 = 0; n2 < ((PgGeometryIf[])object).length; ++n2) {
                            this.m_display.removeGeometry(object[n2]);
                        }
                    }
                }
                if (bl && pvDisplayOptionArray != null) {
                    pvDisplayOptionArray[0].configure(this.m_display);
                } else if (this.m_display.getNumGeometries() == 1) {
                    this.m_display.fit();
                }
                this.m_display.update(this.m_display);
                if (n > 0) {
                    PsTimeListenerIf psTimeListenerIf;
                    PsUpdateIf psUpdateIf;
                    for (psUpdateIf = pjImportModel.getGeometry(0); psUpdateIf != null && !(psUpdateIf instanceof PsTimeListenerIf); psUpdateIf = psUpdateIf.getFather()) {
                    }
                    if (psUpdateIf != null && (psTimeListenerIf = (PsTimeListenerIf)((Object)psUpdateIf)).hasAnimation()) {
                        this.setEnabledMenu(40, true);
                    }
                }
            }
            pjImportModel = null;
            PsConfig.runGC();
        }
    }

    public boolean removeDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf == null) {
            PsDebug.warning("missing argument display");
            return false;
        }
        if (!this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + pvDisplayIf.getName() + " not found.");
            return false;
        }
        this.m_displayVector.removeElement(pvDisplayIf);
        ((PvDisplay)pvDisplayIf).removeGeometriesDoIt();
        pvDisplayIf.setParent(null);
        pvDisplayIf.setViewer(null);
        pvDisplayIf.removeKeyListener(this);
        Frame frame = pvDisplayIf.getFrame();
        if (frame != null && this.hasFrame(frame)) {
            this.removeFrame(frame);
            frame.dispose();
        }
        if (this.m_display == pvDisplayIf) {
            PvDisplayIf pvDisplayIf2 = null;
            if (this.m_displayVector.size() > 0) {
                pvDisplayIf2 = (PvDisplayIf)this.m_displayVector.firstElement();
            }
            this.selectDisplay(pvDisplayIf2);
        } else if (this.getNumDisplays() == 1) {
            PvViewer.setAutoFocus(this.m_display, true, false);
        }
        if (this.m_mainDisplay == pvDisplayIf) {
            this.m_mainDisplay = this.m_display;
        }
        return true;
    }

    public boolean selectDisplay(PvDisplayIf pvDisplayIf) {
        if (pvDisplayIf != null && !this.hasDisplay(pvDisplayIf)) {
            PsDebug.warning("display with name = " + pvDisplayIf.getName() + " not found.");
            return false;
        }
        if (pvDisplayIf != null && !pvDisplayIf.isEnabledInspection()) {
            return true;
        }
        PvDisplayIf pvDisplayIf2 = this.m_display;
        this.m_display = pvDisplayIf;
        if (this.m_control != null) {
            this.m_control.setDisplay(this.m_display);
        }
        if (this.m_display == null) {
            this.m_mainDisplay = null;
            this.setGeometry(null);
        } else {
            PgGeometryIf pgGeometryIf = this.m_display.getSelectedGeometry();
            if (pgGeometryIf != null && pgGeometryIf != this.m_currentGeometry) {
                this.setGeometry(pgGeometryIf);
            }
            if (this.m_mainDisplay == null) {
                this.m_mainDisplay = this.m_display;
            }
        }
        boolean bl = this.m_display != null;
        this.setEnabledMenu(24, bl);
        this.setEnabledMenu(25, bl);
        this.setEnabledMenu(23, bl);
        this.setEnabledMenu(26, bl);
        if (pvDisplayIf2 != null && pvDisplayIf2 != this.m_display) {
            PvViewer.setAutoFocus(pvDisplayIf2, false, false);
        }
        if (this.m_display != null) {
            PvViewer.setAutoFocus(this.m_display, true, this.getNumDisplays() > 1);
            this.m_display.getCanvas().requestFocus();
        }
        return true;
    }

    private static final void setAutoFocus(PvDisplayIf pvDisplayIf, boolean bl, boolean bl2) {
        if (pvDisplayIf == null) {
            return;
        }
        pvDisplayIf.setPaintTag(0x20000000L, bl2);
        pvDisplayIf.getCanvas().repaint();
    }

    public PvDisplayIf getSelectedDisplay() {
        return this.m_display;
    }

    public int getNumFrames() {
        return this.m_frameVector.size();
    }

    private int getNumVisibleFrames() {
        int n = 0;
        if (this.m_frameVector != null) {
            Enumeration enumeration = this.m_frameVector.elements();
            while (enumeration.hasMoreElements()) {
                Frame frame = (Frame)enumeration.nextElement();
                if (!frame.isVisible()) continue;
                ++n;
            }
        }
        return n;
    }

    public void showAllFrames() {
        int n = this.getNumFrames();
        for (int i = 0; i < n; ++i) {
            Frame frame = (Frame)this.m_frameVector.elementAt(i);
            if (!frame.isShowing()) continue;
            frame.toFront();
        }
    }

    protected boolean hasFrame(Frame frame) {
        return this.m_frameVector != null && this.m_frameVector.contains(frame);
    }

    protected boolean addFrame(Frame frame) {
        if (frame == null) {
            PsDebug.warning("missing frame.");
            return false;
        }
        if (this.hasFrame(frame)) {
            PsDebug.warning("frame already used.");
            return false;
        }
        String string = null;
        if (frame instanceof PsMainFrame) {
            string = ((PsMainFrame)frame).getShortTitle();
        }
        if (string == null) {
            string = frame.getTitle();
        }
        if (string == null) {
            string = "No Title";
        }
        if (this.m_menuBars != null && this.m_menuBars.size() > 0) {
            Object object;
            int n = this.getNumFrames();
            if (n > 0) {
                object = (PvControlMenu)frame.getMenuBar();
                for (int i = 0; i < n; ++i) {
                    Frame frame2 = (Frame)this.m_frameVector.elementAt(i);
                    ((PvControlMenu)object).newMenuFrame(((PvControlMenu)object).m_mWindow, (String)this.m_frameTitle.elementAt(i), frame2);
                }
            }
            object = this.m_menuBars.elements();
            while (object.hasMoreElements()) {
                PvControlMenu pvControlMenu = (PvControlMenu)object.nextElement();
                pvControlMenu.newMenuFrame(pvControlMenu.m_mWindow, string, frame);
            }
        }
        this.m_frameVector.addElement(frame);
        this.m_frameTitle.addElement(string);
        frame.addWindowListener(this);
        if (frame instanceof PsMainFrame) {
            frame.removeWindowListener((PsMainFrame)frame);
        }
        return true;
    }

    protected boolean updateFrame(Frame frame, String string) {
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        int n = this.m_frameVector.indexOf(frame);
        if (n != -1) {
            this.m_frameTitle.setElementAt(string, n);
        }
        if (this.m_menuBars != null && this.m_menuBars.size() > 0) {
            Enumeration enumeration = this.m_menuBars.elements();
            while (enumeration.hasMoreElements()) {
                PvControlMenu pvControlMenu = (PvControlMenu)enumeration.nextElement();
                MenuItem menuItem = pvControlMenu.getMenuFrame(frame);
                if (menuItem == null) continue;
                menuItem.setLabel(string);
            }
        }
        return true;
    }

    protected boolean removeFrame(Frame frame) {
        Object object;
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        if (this.m_menuBars != null && this.m_menuBars.size() > 0) {
            object = this.m_menuBars.elements();
            while (object.hasMoreElements()) {
                PvControlMenu pvControlMenu = (PvControlMenu)object.nextElement();
                pvControlMenu.removeMenuFrame(pvControlMenu.m_mWindow, frame);
            }
        }
        if ((object = frame.getMenuBar()) != null && this.m_menuBars != null && this.m_menuBars.contains(object)) {
            this.m_menuBars.removeElement(object);
        }
        frame.removeWindowListener(this);
        if (frame instanceof PsMainFrame) {
            frame.addWindowListener((PsMainFrame)frame);
        }
        int n = this.m_frameVector.indexOf(frame);
        this.m_frameVector.removeElementAt(n);
        this.m_frameTitle.removeElementAt(n);
        PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
        if (pvDisplayIf != null && this.m_displayVector.contains(pvDisplayIf)) {
            pvDisplayIf.setFrame(null);
            this.removeDisplay(pvDisplayIf);
        }
        return true;
    }

    protected boolean selectFrame(Frame frame) {
        if (!this.hasFrame(frame)) {
            PsDebug.warning("frame not found.");
            return false;
        }
        PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
        if (pvDisplayIf != null && this.hasDisplay(pvDisplayIf)) {
            this.selectDisplay(pvDisplayIf);
        }
        return true;
    }

    private PvDisplayIf getDisplayOfFrame(Frame frame) {
        Component[] componentArray = frame.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof PvDisplayIf) {
                return (PvDisplayIf)((Object)componentArray[i]);
            }
            if (!(componentArray[i] instanceof Applet)) continue;
            Component[] componentArray2 = ((Applet)componentArray[i]).getComponents();
            for (int j = 0; j < componentArray2.length; ++j) {
                if (!(componentArray2[j] instanceof PvDisplayIf)) continue;
                return (PvDisplayIf)((Object)componentArray2[j]);
            }
        }
        return null;
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control || this.m_bShowingDialog) {
            return;
        }
        PvDisplayIf pvDisplayIf = this.getDisplayOfFrame(frame);
        if (pvDisplayIf == null) {
            return;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (!(windowEvent.getSource() instanceof Frame)) {
            return;
        }
        Frame frame = (Frame)windowEvent.getSource();
        if (frame == this.m_control) {
            this.removeControl();
        } else if (this.m_frameVector.contains(frame)) {
            this.removeFrame(frame);
            if (!this.isEmbedded()) {
                frame.dispose();
            } else {
                ((Component)frame).setVisible(false);
            }
        }
        if (PsConfig.isApplication() && this.getNumVisibleFrames() == 0 && (this.m_control == null || !this.m_control.isShowing())) {
            this.destroy();
        }
    }

    public boolean showPanel(int n) {
        this.m_showPanel = n;
        if (this.m_control != null) {
            return this.m_control.showPanel(n);
        }
        return true;
    }

    public boolean setEnabledPanel(int n, boolean bl) {
        if (this.m_control == null) {
            return true;
        }
        return this.m_control.setEnabledPanel(n, true);
    }

    public boolean isEnabledPanel(int n) {
        if (this.m_control == null) {
            return true;
        }
        return this.m_control.isEnabledPanel(n);
    }

    public Panel getPanel(int n) {
        if (this.m_control == null) {
            this.m_control = this.getControl();
        }
        return this.m_control.getPanel(n);
    }

    protected static int getPanelId(String string) {
        if ("Project".equalsIgnoreCase(string)) {
            return 10;
        }
        if ("Info".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("Material".equalsIgnoreCase(string)) {
            return 13;
        }
        if ("Texture".equalsIgnoreCase(string)) {
            return 15;
        }
        if ("Vector".equalsIgnoreCase(string)) {
            return 16;
        }
        if ("Label".equalsIgnoreCase(string)) {
            return 18;
        }
        if ("Config".equalsIgnoreCase(string)) {
            return 17;
        }
        if ("Axis".equalsIgnoreCase(string)) {
            return 20;
        }
        if ("Light".equalsIgnoreCase(string)) {
            return 19;
        }
        if ("Camera".equalsIgnoreCase(string)) {
            return 21;
        }
        if ("Display".equalsIgnoreCase(string)) {
            return 22;
        }
        PsDebug.warning("panel not found = " + string);
        return -1;
    }

    public boolean isEmbedded() {
        return this.m_bEmbedded;
    }

    public void setEmbedded(boolean bl) {
        this.m_bEmbedded = bl;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 17 || n == 16 || n == 18) {
            return;
        }
        if (keyEvent.isAltDown()) {
            return;
        }
        switch (n) {
            case 112: {
                this.showDialog(36);
                return;
            }
            case 113: {
                if (this.m_control != null && this.m_control.isShowing()) {
                    this.hideDialog(34);
                } else {
                    this.showDialog(34);
                }
                return;
            }
            case 114: {
                this.showDialog(35);
                return;
            }
            case 115: {
                this.showDialog(33);
                return;
            }
            case 116: {
                if (this.m_display != null) {
                    PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                    if (pgGeometryIfArray != null) {
                        for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                            pgGeometryIfArray[i].update(pgGeometryIfArray[i]);
                        }
                    } else {
                        ((PvDisplay)this.m_display).repaint();
                    }
                }
                return;
            }
        }
        if (!keyEvent.isControlDown()) {
            return;
        }
        boolean bl = keyEvent.isShiftDown();
        if (n == 89 && bl) {
            this.reset();
            return;
        }
        if (n == 88 && bl) {
            block34: {
                if (!PsConfig.isApplication()) {
                    this.destroy();
                } else {
                    try {
                        this.destroy();
                        if (!this.isEmbedded()) {
                            System.exit(0);
                        }
                    }
                    catch (Exception exception) {
                        if (this.isEmbedded()) break block34;
                        System.exit(0);
                    }
                }
            }
            return;
        }
        if (n == 83 && bl) {
            if (PsConfig.isApplication()) {
                this.showDialog(73);
            }
            return;
        }
        if (n == 74 && bl) {
            if (this.m_control != null) {
                this.m_control.releasePanel(10);
                this.showPanel(10);
                this.showDialog(34);
                if (this.m_frame != null) {
                    this.m_frame.validate();
                }
            }
            return;
        }
        if (n == 78 && bl) {
            String string = PsJavaView.getFullFileName(7);
            if (string == null) {
                PsDebug.warning("missing recent geometry file");
                return;
            }
            PvDisplayOption[] pvDisplayOptionArray = null;
            PgLoader pgLoader = new PgLoader();
            String string2 = PsUtil.getFilePathAndBaseName(string) + ".jvd";
            pvDisplayOptionArray = pgLoader.loadDisplay(string2);
            if (pvDisplayOptionArray == null) {
                PsDebug.warning("error when reading file = " + string2);
                return;
            }
            if (this.m_display != null) {
                pvDisplayOptionArray[0].configure(this.m_display);
                this.m_display.update(this.m_display);
            }
            return;
        }
        if (n == 68 && bl) {
            PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
            for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                pgGeometryIfArray[i].setVisible(true);
                pgGeometryIfArray[i].update(pgGeometryIfArray[i]);
            }
            return;
        }
        this.performKeyPressed(n);
    }

    private void performKeyPressed(int n) {
        switch (n) {
            case 65: {
                this.showDialog(33);
                break;
            }
            case 66: {
                if (!this.isEnabledPanel(18)) break;
                this.showPanel(18);
                this.showDialog(34);
                break;
            }
            case 68: {
                if (!this.isEnabledPanel(22)) break;
                this.showPanel(22);
                this.showDialog(34);
                break;
            }
            case 69: {
                if (!this.isEnabledPanel(16)) break;
                this.showPanel(16);
                this.showDialog(34);
                break;
            }
            case 70: {
                if (!this.isEnabledPanel(17)) break;
                this.showPanel(17);
                this.showDialog(34);
                break;
            }
            case 71: {
                this.showPanel(21);
                this.showDialog(34);
                break;
            }
            case 72: {
                this.showDialog(35);
                break;
            }
            case 73: {
                if (!this.isEnabledPanel(12)) break;
                this.showPanel(12);
                this.showDialog(34);
                break;
            }
            case 74: {
                if (!this.isEnabledPanel(10)) break;
                this.showPanel(10);
                this.showDialog(34);
                break;
            }
            case 75: {
                if (this.m_currentGeometry == null) break;
                PsKeyframe psKeyframe = null;
                PgGeometry pgGeometry = (PgGeometry)this.m_currentGeometry;
                PsUpdateIf psUpdateIf = pgGeometry.getFather();
                if (psUpdateIf == null || !(psUpdateIf instanceof PsKeyframe)) {
                    PsObject psObject;
                    psKeyframe = new PsKeyframe();
                    psKeyframe.setName(PsConfig.getMessage(true, 15000, "Keyframes of") + " " + pgGeometry.getName());
                    psKeyframe.setTime(0.0);
                    psKeyframe.addKey((PgGeometry)pgGeometry.clone(), 0.0);
                    psKeyframe.setDynamic(pgGeometry);
                    String string = PsConfig.getMessage(15043) + " " + pgGeometry.getName();
                    if (this.m_currentProject == null) {
                        psObject = new PjProject(string);
                        ((PjProject)psObject).setEnabledAutoFit(false);
                        this.addProject((PjProject)psObject);
                        this.selectProject((PjProject)psObject);
                    }
                    this.m_currentProject.addGeometry(psKeyframe);
                    psObject = null;
                    if (this.m_currentProject.hasAnimation()) {
                        psObject = this.m_currentProject.getAnimation();
                    } else {
                        psObject = new PsAnimation();
                        psObject.setName(string);
                        this.m_currentProject.setAnimation((PsAnimation)psObject);
                        this.setEnabledMenu(40, true);
                    }
                    ((PsAnimation)psObject).addTimeListener(psKeyframe);
                    ((PsAnimation)psObject).enableKeys(true);
                    this.showDialog(33);
                    break;
                }
                psKeyframe = (PsKeyframe)psUpdateIf;
                psKeyframe.addKey((PgGeometry)pgGeometry.clone(), psKeyframe.getAnimation().getTime());
                break;
            }
            case 76: {
                this.showPanel(19);
                this.showDialog(34);
                break;
            }
            case 77: {
                if (!this.isEnabledPanel(13)) break;
                this.showPanel(13);
                this.showDialog(34);
                break;
            }
            case 78: {
                this.showDialog(39);
                break;
            }
            case 79: {
                if (PsConfig.isApplication()) {
                    this.showDialog(42);
                    break;
                }
                this.showDialog(41);
                break;
            }
            case 80: {
                this.showDialog(76);
                break;
            }
            case 81: {
                if (this.m_control == null || !this.m_control.isShowing()) {
                    this.showDialog(34);
                    break;
                }
                if (this.m_control == null || !this.m_control.isShowing()) break;
                this.hideDialog(34);
                break;
            }
            case 82: {
                String string = PsJavaView.getFullFileName(7);
                if (string == null) {
                    PsDebug.warning("missing recent geometry file");
                    return;
                }
                PgLoader pgLoader = new PgLoader();
                PgGeometry[] pgGeometryArray = pgLoader.loadGeometry((PgGeometry[])null, string);
                if (pgGeometryArray == null || pgGeometryArray.length == 0 || pgGeometryArray[0] == null) {
                    PsDebug.warning("loading failed of recent file = " + string);
                    return;
                }
                this.m_display.removeGeometries();
                for (int i = 0; i < pgGeometryArray.length; ++i) {
                    this.m_display.addGeometry(pgGeometryArray[i]);
                }
                if (this.m_frame != null) {
                    this.m_frame.setTitle(PsConfig.getProgramAndVersion() + ": " + string);
                }
                this.m_display.update(this.m_display);
                break;
            }
            case 83: {
                if (this.saveFiles(0)) break;
                this.showDialog(47);
                break;
            }
            case 84: {
                if (!this.isEnabledPanel(15)) break;
                this.showPanel(15);
                this.showDialog(34);
                break;
            }
            case 85: {
                if (this.burnTexture()) break;
                this.showDialog(47);
                break;
            }
            case 88: {
                if (!this.isEnabledPanel(20)) break;
                this.showPanel(20);
                this.showDialog(34);
                break;
            }
            case 49: {
                if (!this.isEnabledPanel(23)) break;
                this.showPanel(23);
                this.showDialog(34);
                break;
            }
            case 50: {
                if (!this.isEnabledPanel(24)) break;
                this.showPanel(24);
                this.showDialog(34);
                break;
            }
            case 51: {
                if (!this.isEnabledPanel(25)) break;
                this.showPanel(25);
                this.showDialog(34);
                break;
            }
            default: {
                return;
            }
        }
    }

    protected synchronized void reset() {
        Enumeration enumeration = this.m_projectList.elements();
        while (enumeration.hasMoreElements()) {
            PjProject pjProject = (PjProject)enumeration.nextElement();
            pjProject.removeGeometries();
            this.removeProject(pjProject);
            pjProject.dispose();
        }
        if (this.m_displayVector != null) {
            int n = 0;
            int n2 = this.m_displayVector.size();
            while (n < n2) {
                PvDisplayIf pvDisplayIf = (PvDisplayIf)this.m_displayVector.elementAt(n);
                if (this.m_mainDisplay != null && this.m_mainDisplay == pvDisplayIf) {
                    this.selectDisplay(this.m_mainDisplay);
                    this.m_mainDisplay.init();
                    ++n;
                    continue;
                }
                this.removeDisplay(pvDisplayIf);
                --n2;
            }
        }
        if (this.m_currentGeometry != null) {
            this.setGeometry(null);
        }
    }

    public synchronized void destroy() {
        block8: {
            try {
                this.stop();
                if (this.m_currentProject != null) {
                    this.m_currentProject.dispose();
                    this.m_currentProject = null;
                }
                if (this.m_frameVector != null) {
                    Enumeration enumeration = this.m_frameVector.elements();
                    while (enumeration.hasMoreElements()) {
                        Frame frame = (Frame)enumeration.nextElement();
                        ((Component)frame).setVisible(false);
                        if (!this.isEmbedded()) {
                            frame.dispose();
                            continue;
                        }
                        ((Component)frame).setVisible(false);
                    }
                    this.m_frameTitle.removeAllElements();
                }
                if (!this.isEmbedded()) {
                    PsDebug.disposeConsole();
                }
                if (PsConfig.isApplication() && !this.isEmbedded()) {
                    System.exit(0);
                }
            }
            catch (Exception exception) {
                if (!PsConfig.isApplication() || this.isEmbedded()) break block8;
                System.exit(0);
            }
        }
    }

    public synchronized void start() {
        int n;
        Object object;
        this.m_bStarted = true;
        if (this.m_display != null) {
            this.m_display.getCanvas().requestFocus();
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.start();
            if (this.m_mainDisplay != null && (object = this.m_mainDisplay.getCamera()).isEnabledSceneRatio() && object.getProjectionMode() == 1) {
                ((PvDisplay)this.m_mainDisplay).selectCamera(1);
            }
        }
        if ((object = this.getParameter("Animation")) != null && ((String)object).equalsIgnoreCase("Show")) {
            this.showDialog(33);
        }
        if ((object = this.getParameter("Panel")) != null) {
            this.showPanel(PvViewer.getPanelId((String)object));
        }
        if ((object = this.getParameter("Control")) != null && ((String)object).equalsIgnoreCase("Show")) {
            this.showDialog(34);
        }
        if ((object = this.getParameter("Embedded")) != null && ((String)object).equalsIgnoreCase("True")) {
            this.setEmbedded(true);
        }
        if ((object = this.getParameter("Monitor.Size")) != null) {
            n = ((String)object).startsWith("1600") || ((String)object).equalsIgnoreCase("UXGA") ? 0 : (((String)object).startsWith("1280") || ((String)object).equalsIgnoreCase("SXGA") ? 1 : (((String)object).startsWith("1024") || ((String)object).equalsIgnoreCase("XGA") ? 2 : (((String)object).startsWith("800") || ((String)object).equalsIgnoreCase("SVGA") ? 3 : (((String)object).startsWith("640") || ((String)object).equalsIgnoreCase("VGA") ? 4 : (((String)object).startsWith("320") || ((String)object).equalsIgnoreCase("QVGA") ? 5 : 6)))));
            PsJavaView.setMonitorType(n);
        }
        if ((object = this.getParameter("FastZBuffer")) != null || (object = this.getParameter("FastDisplay")) != null || (object = this.getParameter("FastClipping")) != null) {
            PvDisplay.setEnabledFastClipping(((String)object).equalsIgnoreCase("Show"));
        }
        if ((object = this.getParameter("Workshop.Backup")) != null) {
            PsJavaView.setEnabledWorkshopBackup(((String)object).equalsIgnoreCase("enable"));
        }
        if (this.m_mainDisplay != null) {
            n = this.parseDisplayParameters(this.m_mainDisplay) ? 1 : 0;
            ((PvDisplay)this.m_mainDisplay).saveCameraDefaults();
            if (n != 0) {
                this.m_mainDisplay.update(this.m_mainDisplay.getCamera());
            }
            if (this.m_mainDisplay != null && this.m_mainDisplay.isShowingAxes()) {
                ((PvDisplay)this.m_mainDisplay).updateCameraListener(101);
            }
            if ((object = this.getParameter("AutoRotate")) != null) {
                String string = this.getParameter("RotDir");
                if (string != null) {
                    PdVector pdVector = PsXmlLoader.parsePdVector(string);
                    if (pdVector != null) {
                        this.m_mainDisplay.setAutoRotation(pdVector, 0.06283185307179587);
                    }
                } else {
                    this.m_mainDisplay.setAutoRotation(new PdVector(0.0, 1.0, 0.0), 0.06283185307179587);
                }
                if (((String)object).equalsIgnoreCase("Show")) {
                    this.m_mainDisplay.setEnabledAnimation(true);
                    this.m_mainDisplay.start();
                }
            }
        }
        if (this.m_mainDisplay != null) {
            this.m_mainDisplay.saveInitials();
        }
    }

    private boolean parseDisplayParameters(PvDisplayIf pvDisplayIf) {
        PdVector pdVector;
        boolean bl = false;
        String string = this.getParameter("Antialias");
        if (string != null) {
            pvDisplayIf.setEnabledAntiAlias(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Axes")) != null) {
            pvDisplayIf.showAxes(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Background")) != null) {
            pvDisplayIf.setBackgroundColor(PdColor.parseColor(string));
            bl = true;
        } else {
            string = this.getParameter("BGCOLOR");
            if (string != null) {
                pvDisplayIf.setBackgroundColor(PdColor.parseColor(string));
                bl = true;
            }
        }
        string = this.getParameter("BackgroundImage");
        if (string != null) {
            pvDisplayIf.setBackgroundImageFile(string);
            string = this.getParameter("BackgroundImageFit");
            if (string != null) {
                if (string.equalsIgnoreCase("center")) {
                    pvDisplayIf.setBackgroundImageFit(0);
                } else if (string.equalsIgnoreCase("fit")) {
                    pvDisplayIf.setBackgroundImageFit(1);
                } else if (string.equalsIgnoreCase("resize")) {
                    pvDisplayIf.setBackgroundImageFit(2);
                } else if (string.equalsIgnoreCase("tesselate")) {
                    pvDisplayIf.setBackgroundImageFit(3);
                } else {
                    PsDebug.warning("unknown applet parameter = " + string);
                }
            }
            pvDisplayIf.showBackgroundImage(true);
            bl = true;
        }
        if ((string = this.getParameter("Border")) != null) {
            pvDisplayIf.setPaintTag(4L, string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("BoundingBox")) != null) {
            pvDisplayIf.showBndBox(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Copyright")) != null) {
            ((PvDisplay)pvDisplayIf).showCopyright(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Depthcue")) != null) {
            pvDisplayIf.showDepthcue(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("EdgeAura")) != null) {
            pvDisplayIf.showEdgeAura(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("ForegroundImage")) != null) {
            pvDisplayIf.setForegroundImageFile(string);
            string = this.getParameter("ForegroundImageFit");
            if (string != null) {
                if (string.equalsIgnoreCase("center")) {
                    pvDisplayIf.setForegroundImageFit(0);
                } else if (string.equalsIgnoreCase("fit")) {
                    pvDisplayIf.setForegroundImageFit(1);
                } else if (string.equalsIgnoreCase("resize")) {
                    pvDisplayIf.setForegroundImageFit(2);
                } else if (string.equalsIgnoreCase("tesselate")) {
                    pvDisplayIf.setForegroundImageFit(3);
                } else {
                    PsDebug.warning("unknown value of applet parameter = " + string);
                }
            }
            pvDisplayIf.showForegroundImage(true);
            bl = true;
        }
        if ((string = this.getParameter("Frame")) != null) {
            pvDisplayIf.showFrame(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Sorting")) != null) {
            pvDisplayIf.setEnabledPainters(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("Interest")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null) {
                pvDisplayIf.getCamera().setInterest(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("ViewDir")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null) {
                pvDisplayIf.getCamera().setViewDir(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("UpDir")) != null) {
            pdVector = PsXmlLoader.parsePdVector(string);
            if (pdVector != null && pdVector.normalize()) {
                pvDisplayIf.getCamera().setUpVector(pdVector);
            }
            bl = true;
        }
        if ((string = this.getParameter("Roll")) != null) {
            double d = PuDouble.parseDouble(string);
            if (d != 0.0) {
                pvDisplayIf.getCamera().setRoll(d);
            }
            bl = true;
        }
        if ((string = this.getParameter("Distance")) != null) {
            double d = PuDouble.parseDouble(string);
            if (d != 0.0) {
                pvDisplayIf.getCamera().setDist(d);
            }
            bl = true;
        }
        if ((string = this.getParameter("Perspective")) != null) {
            double d = PuDouble.parseDouble(string);
            pvDisplayIf.getCamera().setFieldOfView(d);
            bl = true;
        }
        if ((string = this.getParameter("Title")) != null) {
            pvDisplayIf.setName(string);
            pvDisplayIf.showTitle(true);
            bl = true;
        }
        if ((string = this.getParameter("ZBuffer")) != null) {
            pvDisplayIf.setEnabledZBuffer(string.equalsIgnoreCase("Show"));
            bl = true;
        }
        if ((string = this.getParameter("MajorMode")) != null) {
            if (string.equalsIgnoreCase("rotate")) {
                pvDisplayIf.setMajorMode(0);
            } else if (string.equalsIgnoreCase("rotate-xy")) {
                pvDisplayIf.setMajorMode(17);
            } else if (string.equalsIgnoreCase("scale")) {
                pvDisplayIf.setMajorMode(1);
            } else if (string.equalsIgnoreCase("translate")) {
                pvDisplayIf.setMajorMode(3);
            } else if (string.equalsIgnoreCase("translate-z")) {
                pvDisplayIf.setMajorMode(4);
            } else if (string.equalsIgnoreCase("initial")) {
                pvDisplayIf.setMajorMode(6);
            } else if (string.equalsIgnoreCase("pick")) {
                pvDisplayIf.setMajorMode(5);
            } else {
                PsDebug.warning("unknown parameter value: MajorMode = " + string);
            }
        }
        if ((string = this.getParameter("DirectSelect")) != null) {
            if (string.equalsIgnoreCase("show")) {
                pvDisplayIf.setEnabledDirectSelect(true);
            } else {
                PsDebug.warning("unknown parameter value: DirectSelect = " + string);
            }
        }
        if ((string = this.getParameter("LocalTransform")) != null) {
            if (string.equalsIgnoreCase("show")) {
                pvDisplayIf.setEnabledLocalTransform(true);
            } else {
                PsDebug.warning("unknown parameter value: LocalTransform = " + string);
            }
        }
        if ((string = this.getParameter("PopupMenu")) != null) {
            pvDisplayIf.clearPopupMenu();
            String[] stringArray = PuString.splitString(string, '|');
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (stringArray[i].equalsIgnoreCase("Rotate")) {
                    pvDisplayIf.addPopupItem(20500);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("RotateXY")) {
                    pvDisplayIf.addPopupItem(20501);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("Scale")) {
                    pvDisplayIf.addPopupItem(20502);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("Translate")) {
                    pvDisplayIf.addPopupItem(20504);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("TranslateZ")) {
                    pvDisplayIf.addPopupItem(20505);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("InitialPick")) {
                    pvDisplayIf.addPopupItem(20507);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("PickVertex")) {
                    pvDisplayIf.addPopupItem(20506);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("Drawing")) {
                    pvDisplayIf.addPopupItem(20516);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("AddVertex")) {
                    pvDisplayIf.addPopupItem(20513);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("AddElement")) {
                    pvDisplayIf.addPopupItem(20514);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("MarkVertex")) {
                    pvDisplayIf.addPopupItem(20509);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("MarkElement")) {
                    pvDisplayIf.addPopupItem(20511);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("UnmarkVertex")) {
                    pvDisplayIf.addPopupItem(20510);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("UnmarkElement")) {
                    pvDisplayIf.addPopupItem(20512);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("Separator")) {
                    pvDisplayIf.addPopupItem(0);
                    continue;
                }
                if (stringArray[i].equalsIgnoreCase("NewDisplay")) {
                    pvDisplayIf.addPopupItem(102);
                    continue;
                }
                if (!stringArray[i].equalsIgnoreCase("Inspector")) continue;
                pvDisplayIf.addPopupItem(2);
            }
        }
        return bl;
    }

    public synchronized void stop() {
        this.m_bStarted = false;
        if (this.m_help != null) {
            this.m_help.dispose();
            this.m_help = null;
        }
        if (this.m_control != null) {
            this.m_control.dispose();
            this.m_control = null;
        }
        if (this.m_currentProject != null) {
            this.m_currentProject.stop();
        }
        PsDebug.notify("regular stop");
        if (PsDebug.hasConsole()) {
            ((Component)PsDebug.getConsole()).setVisible(false);
        }
    }

    protected void serialize(String string) {
        if (!PsConfig.isApplication()) {
            return;
        }
        Object object = null;
        if (string.equalsIgnoreCase(PsConfig.getMessage(21147))) {
            object = this.getDisplay();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21121))) {
            object = this.getDisplay().getSelectedGeometry();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21146))) {
            object = this.getApplet();
        } else if (string.equalsIgnoreCase(PsConfig.getMessage(21120))) {
            object = this.m_currentProject;
        } else {
            PsDebug.warning("Serialization target not found, name = " + string);
            return;
        }
        if (object == null) {
            PsDebug.warning("missing object to serialize.");
            return;
        }
        PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24321), 1);
        pgFileDialog.setFile(object.getClass().getName() + ".ser");
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        pgFileDialog.setDirectory(this.m_serialDirName);
        pgFileDialog.setExtension("ser");
        pgFileDialog.show();
        String string2 = pgFileDialog.getFullFileName();
        if (string2 == null) {
            PsDebug.notify("dialog cancelled");
            return;
        }
        this.m_serialDirName = pgFileDialog.getDirectory();
        PsObject psObject = null;
        PsUpdateIf psUpdateIf = null;
        if (object instanceof PsObject) {
            psObject = (PsObject)object;
            psUpdateIf = psObject.getFather();
            psObject.setParent(null);
        }
        PvDisplay pvDisplay = null;
        if (object instanceof PvDisplay) {
            pvDisplay = (PvDisplay)object;
            pvDisplay.removeKeyListener(this);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (NotSerializableException notSerializableException) {
            PsDebug.message(notSerializableException.toString());
        }
        catch (IOException iOException) {
            PsDebug.message(iOException.toString());
        }
        if (pvDisplay != null) {
            pvDisplay.addKeyListener(this);
        }
        if (psObject != null && psUpdateIf != null) {
            psObject.setParent(psUpdateIf);
        }
    }

    protected void deserialize() {
        Object object;
        Object object2;
        PgFileDialog pgFileDialog = new PgFileDialog(PsConfig.getFrame(), PsConfig.getMessage(24322), 0);
        if (this.m_serialDirName == null) {
            this.m_serialDirName = PsConfig.getCodeBase() + "dev/models/serialized/";
        }
        pgFileDialog.setDirectory(this.m_serialDirName);
        pgFileDialog.setExtension("ser");
        pgFileDialog.show();
        String string = pgFileDialog.getFullFileName();
        if (string == null) {
            PsDebug.notify("dialog cancelled.");
            return;
        }
        this.m_serialDirName = pgFileDialog.getDirectory();
        Object object3 = null;
        try {
            object2 = new FileInputStream(string);
            object = new ObjectInputStream((InputStream)object2);
            object3 = ((ObjectInputStream)object).readObject();
            ((FileInputStream)object2).close();
        }
        catch (Exception exception) {
            PsDebug.message(exception.toString());
        }
        if (object3 == null) {
            PsDebug.warning("object not loaded.");
            return;
        }
        object2 = pgFileDialog.getFile();
        if (object3 instanceof PvDisplay) {
            object = (PvDisplayIf)object3;
            Dimension dimension = object.getSize();
            object.setName((String)object2);
            this.addDisplay((String)object2, (PvDisplayIf)object);
            this.selectDisplay((PvDisplayIf)object);
            PsMainFrame psMainFrame = new PsMainFrame((String)object2, null);
            psMainFrame.setMenuBar(this.newMenuBar(psMainFrame));
            psMainFrame.add((Component)object.getCanvas(), "Center");
            object.setFrame(psMainFrame);
            psMainFrame.pack();
            if (dimension != null) {
                psMainFrame.setInnerBounds(50, 50, dimension.width, dimension.height);
            } else {
                psMainFrame.setInnerBounds(50, 50, 320, 256);
            }
            ((Component)psMainFrame).setVisible(true);
            this.addFrame(psMainFrame);
        } else if (object3 instanceof PgGeometryIf) {
            object = (PgGeometryIf)object3;
            object.setName((String)object2);
            PvDisplayIf pvDisplayIf = this.getDisplay();
            pvDisplayIf.addGeometry((PgGeometryIf)object);
            pvDisplayIf.selectGeometry((PgGeometryIf)object);
            pvDisplayIf.update(pvDisplayIf);
        } else if (object3 instanceof Applet) {
            object = (Applet)object3;
            ((Component)object).setName((String)object2);
            PsMainFrame psMainFrame = new PsMainFrame((Component)object, (String)object2, null);
            ((Applet)object).init();
            String string2 = System.getProperty("os.name");
            if (string2 != null) {
                if (string2.toLowerCase().startsWith("win")) {
                    psMainFrame.setOuterBounds(420, 5, 640, 550);
                } else {
                    psMainFrame.setOuterSize(640, 550);
                }
            }
            ((Component)psMainFrame).setVisible(true);
        } else if (object3 instanceof PjProject) {
            object = (PjProject)object3;
            ((PsObject)object).setName((String)object2);
            this.addProject((PjProject)object);
            this.selectProject((String)object2);
        }
    }

    protected static Dialog getAboutDialog() {
        int n;
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24318) + " " + PsConfig.getProgram(), true);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new PsStackLayout(1));
        Component component = new Label("\u00a9 " + PsConfig.getProgram() + " - " + PsConfig.getMessage(12016) + " " + PsConfig.getVersion(), 1);
        component.setFont(PsConfig.getFont(3));
        panel.add(component);
        panel.add(new PsMultiLineLabel(PsConfig.getHomepage() + "\n" + PsConfig.getEmail() + "\n\n", 1));
        psDialog.add((Component)panel, "North");
        component = new PsPanel(new BorderLayout());
        ((PsPanel)component).setInsetSizeHorizontal(5);
        Panel panel2 = new Panel(new PsStackLayout(1));
        Component component2 = new Label(PsConfig.getMessage(12017), 1);
        component2.setFont(PsConfig.getFont(3));
        panel2.add(component2);
        String[] stringArray = PsConfig.AUTHOR[0];
        for (n = 1; n < Math.min(3, PsConfig.AUTHOR.length); ++n) {
            stringArray = (String)stringArray + ", " + PsConfig.AUTHOR[n];
        }
        if (PsConfig.AUTHOR.length > 3) {
            stringArray = (String)stringArray + "\n" + PsConfig.AUTHOR[3];
            for (n = 4; n < Math.min(6, PsConfig.AUTHOR.length); ++n) {
                stringArray = (String)stringArray + ", " + PsConfig.AUTHOR[n];
            }
        }
        panel2.add(new PsMultiLineLabel((String)stringArray + "\n\n", 1));
        Label label = new Label(PsConfig.getMessage(12018), 1);
        label.setFont(PsConfig.getFont(3));
        panel2.add(label);
        ((Container)component).add(panel2, "North");
        component2 = new TextArea("", 10, 80);
        ((TextComponent)component2).setEditable(false);
        stringArray = PsConfig.getContributors();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                ((TextArea)component2).append(stringArray[i] + "\n");
            }
        }
        ((Container)component).add(component2, "Center");
        psDialog.add(component, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    protected static Dialog getAboutAppletDialog() {
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getMessage(24317), true);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(4, 1));
        Object object = new Label("\u00a9 " + PsConfig.getProgram() + " " + PsConfig.getMessage(13002), 1);
        ((Component)object).setFont(PsConfig.getFont(3));
        panel.add((Component)object);
        object = new Label(PsConfig.getProject(), 1);
        ((Component)object).setFont(PsConfig.getFont(3));
        panel.add((Component)object);
        Component component = new Label(PsConfig.getMessage(12016) + " " + PsConfig.getVersion(), 1);
        panel.add(component);
        panel.add(new Label("", 1));
        psDialog.add((Component)panel, "North");
        object = null;
        if (PsConfig.getApplet() != null) {
            object = PsConfig.getApplet().getAppletInfo();
        }
        if (object == null) {
            PsDebug.warning("missing applet info");
            object = PsConfig.getMessage(28006);
        }
        if (object != null) {
            object = ((String)object).replace('\r', ' ');
        }
        component = new PsMultiLineLabel((String)object);
        PsPanel psPanel = new PsPanel();
        psPanel.setInsetSizeHorizontal(5);
        psPanel.add(component);
        psDialog.add((Component)psPanel, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    protected static Dialog getHelpDialog() {
        PsDialog psDialog = new PsDialog(PsConfig.getFrame(), PsConfig.getProgram() + ": " + PsConfig.getMessage(24314), false);
        psDialog.setLayout(new BorderLayout());
        Panel panel = new Panel(new GridLayout(2, 1));
        Component component = new Label(PsConfig.getMessage(24313), 0);
        component.setFont(PsConfig.getFont(3));
        panel.add(component);
        component = new Label(PsConfig.getMessage(28007), 0);
        panel.add(component);
        psDialog.add((Component)panel, "North");
        component = new TextArea();
        component.setFont(PsConfig.getFont(1));
        ((TextComponent)component).setText(PsConfig.getMessage(28008));
        ((TextComponent)component).setEditable(false);
        psDialog.add(component, "Center");
        psDialog.add((Component)psDialog.getBottomButtons(2), "South");
        psDialog.pack();
        return psDialog;
    }

    public boolean export(int n, String string) {
        Object object;
        if (this.m_display == null) {
            PsDebug.warning("missing display, no geometry available");
            return false;
        }
        PvDisplayOption pvDisplayOption = null;
        if (this.m_display != null) {
            switch (n) {
                case 53: 
                case 54: 
                case 57: 
                case 60: 
                case 71: 
                case 72: {
                    pvDisplayOption = new PvDisplayOption();
                    pvDisplayOption.setOptions(this.m_display);
                }
            }
            switch (n) {
                case 57: 
                case 71: {
                    if (!(this.m_display instanceof PvDisplay)) break;
                    object = (PvDisplay)this.m_display;
                    ((PvDisplay)object).setEnabledExternalRendering(true);
                    ((PvDisplay)object).setExternalRenderSize(400, 300);
                    ((PvDisplay)object).update(((PvDisplay)object).getCanvas().getGraphics());
                    pvDisplayOption.setPreviewImage(((PvDisplay)object).getImage());
                    ((PvDisplay)object).setEnabledExternalRendering(false);
                }
            }
        }
        object = new PgLoader();
        switch (n) {
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 71: 
            case 72: {
                PgGeometryIf pgGeometryIf;
                ((PgLoader)object).setDisplayOption(pvDisplayOption);
                PgGeometryIf[] pgGeometryIfArray = this.m_display.getGeometries();
                if (pgGeometryIfArray != null && pgGeometryIfArray.length > 1 && pgGeometryIfArray[0] != (pgGeometryIf = this.m_display.getSelectedGeometry())) {
                    for (int i = 0; i < pgGeometryIfArray.length; ++i) {
                        if (pgGeometryIfArray[i] != pgGeometryIf) continue;
                        PgGeometryIf pgGeometryIf2 = pgGeometryIfArray[0];
                        pgGeometryIfArray[0] = pgGeometryIf;
                        pgGeometryIfArray[i] = pgGeometryIf2;
                        break;
                    }
                }
                ((PgLoader)object).saveGeometry(pgGeometryIfArray, string);
                break;
            }
            case 75: {
                this.saveFiles(0);
                break;
            }
            case 73: {
                this.saveFiles(2);
                break;
            }
            case 74: {
                this.saveFiles(1);
                break;
            }
            case 60: {
                ((PgLoader)object).saveDisplay(new PvDisplayOption[]{pvDisplayOption}, string);
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 76: {
                Dimension dimension = this.m_display.getSize();
                this.export(n, string, dimension.width, dimension.height);
                break;
            }
            default: {
                PsDebug.warning("invalid dialog index = " + n);
                return false;
            }
        }
        return true;
    }

    protected boolean isEnabledMenu(int n) {
        if (this.m_menuBars == null || this.m_menuBars.size() == 0) {
            return false;
        }
        PvControlMenu pvControlMenu = (PvControlMenu)this.m_menuBars.elementAt(0);
        if (pvControlMenu == null) {
            return false;
        }
        return pvControlMenu.isMenuEnabled(n);
    }

    protected void setEnabledMenu(int n, boolean bl) {
        if (this.m_menuBars == null || this.m_menuBars.size() == 0) {
            return;
        }
        Enumeration enumeration = this.m_menuBars.elements();
        while (enumeration.hasMoreElements()) {
            PvControlMenu pvControlMenu = (PvControlMenu)enumeration.nextElement();
            pvControlMenu.setEnabledMenu(n, bl);
            if (this.m_currentGeometry == null || n != 3) continue;
            if (bl) {
                this.m_currentGeometry.fillMethodMenu(pvControlMenu.m_mMethod, this);
                continue;
            }
            this.m_currentGeometry.removeMethodMenus();
        }
    }

    public PsToolbar newToolbar(Frame frame) {
        PsToolbar psToolbar = new PsToolbar();
        if (!PsToolbar.loadDefaultImage()) {
            return null;
        }
        frame.add((Component)psToolbar, "North");
        psToolbar.addGuide();
        psToolbar.addItem(0, this);
        psToolbar.addItem(1, this);
        psToolbar.addItem(3, this);
        psToolbar.addItem(6, this);
        psToolbar.addSeparator();
        psToolbar.addItem(9, this);
        psToolbar.addItem(11, this);
        psToolbar.addItem(12, this);
        psToolbar.addItem(14, this);
        psToolbar.addItem(13, this);
        psToolbar.addItem(16, this);
        psToolbar.addItem(20, this);
        psToolbar.addItem(21, this);
        psToolbar.addItem(22, this);
        psToolbar.addSeparator();
        psToolbar.addItem(23, this);
        psToolbar.addItem(24, this);
        psToolbar.addItem(26, this);
        psToolbar.addItem(28, this);
        psToolbar.addItem(29, this);
        psToolbar.addSeparator();
        psToolbar.addItem(32, this);
        psToolbar.addSeparator();
        psToolbar.addItem(7, this);
        psToolbar.addItem(44, this);
        psToolbar.addItem(45, this);
        psToolbar.add(new Label(""));
        return psToolbar;
    }

    public PvControlMenu newMenuBar(Frame frame) {
        String string;
        PvControlMenu pvControlMenu = new PvControlMenu(this, frame);
        if (frame != null && frame == this.m_frame) {
            pvControlMenu.m_mFile.remove(pvControlMenu.m_mFile_Close);
        }
        pvControlMenu.setEnabledMenu(21, this.m_currentProject != null);
        pvControlMenu.setEnabledMenu(22, this.m_currentGeometry != null);
        pvControlMenu.setEnabledMenu(3, this.m_currentGeometry != null);
        if (this.m_currentGeometry != null) {
            this.m_currentGeometry.fillMethodMenu(pvControlMenu.m_mMethod, this);
            pvControlMenu.setEnabledMenu(220, this.m_currentGeometry.isConfigurable(4));
            pvControlMenu.setEnabledMenu(221, this.m_currentGeometry.isConfigurable(5));
            pvControlMenu.setEnabledMenu(222, this.m_currentGeometry.isConfigurable(6));
            pvControlMenu.setEnabledMenu(223, this.m_currentGeometry.isConfigurable(7));
            pvControlMenu.setEnabledMenu(224, this.m_currentGeometry.isConfigurable(8));
            pvControlMenu.setEnabledMenu(225, this.m_currentGeometry.isConfigurable(9));
            pvControlMenu.setEnabledMenu(226, this.m_currentGeometry.isConfigurable(10));
        }
        boolean bl = this.m_currentProject != null && this.m_currentProject.hasAnimation();
        pvControlMenu.setEnabledMenu(40, bl);
        if (this.m_projectClass != null && this.m_projectClass.size() > 0 && ((string = this.getParameter("menu-new-project")) == null || "enable".equalsIgnoreCase(string))) {
            pvControlMenu.setEnabledMenu(100, true);
        }
        if (this.m_menuBars == null) {
            this.m_menuBars = new Vector();
        }
        this.m_menuBars.addElement(pvControlMenu);
        return pvControlMenu;
    }

    protected void setLanguage(String string) {
        PsConfig.setLanguage(string);
        this.recreatePanels();
    }

    public void updateFonts(int n) {
        PsConfig.setFont(-1, 0, null, -1, n);
        PsConfig.setFont(-1, 1, null, -1, n);
        PsConfig.setFont(-1, 2, null, -1, n);
        PsConfig.setFont(-1, 3, null, -1, n + 2);
        PsConfig.setFont(-1, 4, null, -1, n);
        if (this.m_control != null) {
            ((Component)this.m_control).setFont(PsConfig.getFont(0));
        }
        this.recreatePanels();
    }

    private void recreatePanels() {
        if (this.m_control != null) {
            this.m_control.recreatePanels();
        }
        this.m_help = null;
        if (this.m_menuBars != null) {
            int n = this.m_menuBars.size();
            Vector vector = (Vector)this.m_menuBars.clone();
            this.m_menuBars.removeAllElements();
            for (int i = 0; i < n; ++i) {
                PvControlMenu pvControlMenu = (PvControlMenu)vector.elementAt(i);
                Frame frame = pvControlMenu.m_frame;
                PvControlMenu pvControlMenu2 = this.newMenuBar(frame);
                frame.setMenuBar(pvControlMenu2);
            }
        }
    }
}

