/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;

public class PuProj {
    public static void lorentz2Klein(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector2.getSize();
        if (pdVector2.m_data[n - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3, " + pdVector2.toShortString());
            pdVector.setConstant(0.0);
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] / pdVector2.m_data[n - 1];
        }
    }

    public static void klein2Lorentz(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector.getSize();
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] * d;
        }
        pdVector.m_data[n - 1] = d = 1.0 / Math.sqrt(1.0 - d);
    }

    public static void diffKlein2Lorentz(PdMatrix pdMatrix, PdVector pdVector) {
        int n;
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        double[][] dArray = pdMatrix.m_data;
        double d = pdVector.sqrLength();
        if (d > 0.9999999999) {
            int n2;
            for (int i = 0; i < 3; ++i) {
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray[i + 1][n2] = pdVector.m_data[i] * pdVector2.m_data[n2];
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[0][n2] = 1.0;
            }
            dArray[n2 + 1][n2] = 1.0;
            return;
        }
        d = 1.0 / Math.sqrt(1.0 - d);
        for (n = 0; n < 3; ++n) {
            dArray[0][n] = pdVector2.m_data[n] = pdVector.m_data[n] * d * d * d;
        }
        for (int i = 0; i < 3; ++i) {
            for (n = 0; n < 3; ++n) {
                dArray[i + 1][n] = pdVector.m_data[i] * pdVector2.m_data[n];
            }
        }
        n = 0;
        while (n < 3) {
            double[] dArray2 = dArray[n + 1];
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d;
        }
    }

    public static void lorentz2Poincare(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector2.getSize();
        if (pdVector2.m_data[n - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pdVector2.toShortString());
            pdVector.setConstant(0.0);
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] / (pdVector2.m_data[n - 1] + 1.0);
        }
    }

    public static void poincare2Lorentz(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector.getSize();
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 2.0 / (1.0 - d);
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] * d;
        }
        pdVector.m_data[n - 1] = d - 1.0;
    }

    public static void diffPoincare2Lorentz(PdMatrix pdMatrix, PdVector pdVector) {
        int n;
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        PdVector pdVector2 = new PdVector(pdVector.getSize());
        double[][] dArray = pdMatrix.m_data;
        double d = pdVector.sqrLength();
        if (d > 0.9999999999) {
            int n2;
            for (int i = 0; i < 3; ++i) {
                for (n2 = 0; n2 < 3; ++n2) {
                    dArray[i + 1][n2] = pdVector.m_data[i] * pdVector2.m_data[n2];
                }
            }
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[0][n2] = 1.0;
            }
            dArray[n2 + 1][n2] = 2.0;
            return;
        }
        d = 2.0 / (1.0 - d);
        for (n = 0; n < 3; ++n) {
            dArray[0][n] = pdVector2.m_data[n] = pdVector.m_data[n] * d * d;
        }
        for (int i = 0; i < 3; ++i) {
            for (n = 0; n < 3; ++n) {
                dArray[i + 1][n] = pdVector.m_data[i] * pdVector2.m_data[n];
            }
        }
        n = 0;
        while (n < 3) {
            double[] dArray2 = dArray[n + 1];
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d;
        }
    }

    public static void lorentz2Uhm(PdVector pdVector, PdVector pdVector2) {
        int n;
        int n2 = pdVector2.getSize();
        if (pdVector2.m_data[n2 - 1] < 0.9999999999) {
            PsDebug.warning("point pl is not in H3; " + pdVector2.toShortString());
            pdVector.setConstant(0.0);
            pdVector.setEntry(n2 - 1, 1.0);
            return;
        }
        double d = pdVector2.m_data[n2 - 1] - pdVector2.m_data[n2 - 2];
        for (n = 0; n < n2 - 2; ++n) {
            pdVector.m_data[n] = pdVector2.m_data[n];
        }
        pdVector.m_data[n2 - 2] = 1.0;
        n = 0;
        while (n < n2 - 1) {
            int n3 = n++;
            pdVector.m_data[n3] = pdVector.m_data[n3] / d;
        }
    }

    public static void uhm2Lorentz(PdVector pdVector, PdVector pdVector2) {
        int n;
        int n2 = pdVector.getSize();
        if (pdVector2.m_data[n2 - 2] < 1.0E-10) {
            pdVector2.m_data[n2 - 2] = 1.0E-10;
        }
        double d = pdVector2.sqrLength();
        double d2 = 2.0 * pdVector2.m_data[n2 - 2];
        for (n = 0; n < n2 - 2; ++n) {
            pdVector.m_data[n] = pdVector2.m_data[n];
        }
        pdVector.m_data[n2 - 1] = d + 1.0;
        pdVector.m_data[n2 - 2] = d - 1.0;
        n = 0;
        while (n < n2) {
            int n3 = n++;
            pdVector.m_data[n3] = pdVector.m_data[n3] / d2;
        }
    }

    public static void poincare2Klein(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 2.0 / (1.0 + d);
        pdVector.copy(pdVector2);
        pdVector.multScalar(d);
    }

    public static void klein2Poincare(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        d = 1.0 / (1.0 + Math.sqrt(1.0 - d));
        pdVector.copy(pdVector2);
        pdVector.multScalar(d);
    }

    public static void poincare2Uhm(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        int n = pdVector.getSize();
        double d2 = d - 2.0 * pdVector2.m_data[n - 1] + 1.0;
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = 2.0 * pdVector2.m_data[i];
        }
        pdVector.m_data[n - 1] = 1.0 - d;
        pdVector.multScalar(1.0 / d2);
    }

    public static void uhm2Poincare(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector2.getSize();
        if (pdVector2.m_data[n - 1] < 1.0E-10) {
            pdVector2.m_data[n - 1] = 1.0E-10;
        }
        double d = pdVector.sqrLength();
        double d2 = d + 2.0 * pdVector2.m_data[n - 1] + 1.0;
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = 2.0 * pdVector2.m_data[i];
        }
        pdVector.m_data[n - 1] = d - 1.0;
        pdVector.multScalar(1.0 / d2);
    }

    public static void klein2Uhm(PdVector pdVector, PdVector pdVector2) {
        double d = pdVector2.sqrLength();
        if (d > 0.9999999999) {
            d = 0.9999999999;
            pdVector2.setLength(d);
        }
        int n = pdVector2.getSize();
        double d2 = 1.0 - pdVector2.m_data[n - 1];
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i];
        }
        pdVector.m_data[n - 1] = 1.0 - d / (1.0 + Math.sqrt(1.0 - d));
        pdVector.multScalar(1.0 / d2);
    }

    public static void uhm2Klein(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector2.getSize();
        if (pdVector2.m_data[n - 1] < 1.0E-10) {
            pdVector2.m_data[n - 1] = 1.0E-10;
        }
        double d = pdVector.sqrLength();
        double d2 = 1.0 + d;
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = 2.0 * pdVector2.m_data[i];
        }
        pdVector2.m_data[n - 1] = d - 1.0;
        pdVector.multScalar(1.0 / d2);
    }

    public static void stereoS3_to_R3(PdVector pdVector, PdVector pdVector2) {
        PuProj.stereographic(pdVector, pdVector2);
    }

    public static void stereographic(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector2.getSize();
        double d = 1.0 - pdVector2.m_data[n - 1];
        if (Math.abs(d) < 1.0E-10) {
            d = d > 0.0 ? 1.0E-10 : -1.0E-10;
        }
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] / d;
        }
    }

    public static void diffStereoS3_to_R3(PdMatrix pdMatrix, PdVector pdVector) {
        int n;
        double d;
        if (pdMatrix.getISize() != 3 || pdMatrix.getJSize() != 4) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(3, 4);
        }
        if (Math.abs(d = pdVector.m_data[0] + 1.0) < 1.0E-10) {
            PsDebug.warning("argument vertex lies at projection center");
            d = Math.sqrt(1.0E-10);
        }
        d = 1.0 / d;
        double[][] dArray = pdMatrix.m_data;
        for (n = 0; n < 3; ++n) {
            dArray[n][n + 1] = d;
        }
        d *= d;
        for (n = 0; n < 3; ++n) {
            dArray[n][0] = -pdVector.m_data[n + 1] * d;
        }
        dArray[1][1] = 0.0;
        dArray[0][3] = 0.0;
        dArray[0][2] = 0.0;
        dArray[2][2] = 0.0;
        dArray[2][1] = 0.0;
        dArray[1][3] = 0.0;
    }

    public static void stereoInvR3_to_S3(PdVector pdVector, PdVector pdVector2) {
        int n = pdVector.getSize();
        double d = 2.0 / (1.0 + pdVector2.sqrLength());
        for (int i = 0; i < n - 1; ++i) {
            pdVector.m_data[i] = pdVector2.m_data[i] * d;
        }
        pdVector.m_data[n - 1] = 1.0 - d;
    }

    public static void diffStereoInvR3_to_S3(PdMatrix pdMatrix, PdVector pdVector) {
        int n;
        int n2;
        if (pdMatrix.getISize() != 4 || pdMatrix.getJSize() != 3) {
            PsDebug.warning("matrix has invalid size.");
            pdMatrix.setSize(4, 3);
        }
        double d = 2.0 / (1.0 + pdVector.sqrLength());
        double d2 = d * d;
        double[][] dArray = pdMatrix.m_data;
        for (n2 = 0; n2 < 3; ++n2) {
            dArray[0][n2] = -pdVector.m_data[n2] * d2;
        }
        for (n = 0; n < 3; ++n) {
            for (n2 = 0; n2 < 3; ++n2) {
                dArray[n + 1][n2] = pdVector.m_data[n] * dArray[0][n2];
            }
        }
        n = 0;
        while (n < 3) {
            double[] dArray2 = dArray[n + 1];
            int n3 = n++;
            dArray2[n3] = dArray2[n3] + d;
        }
    }
}

