/*
 * Decompiled with CFR 0.152.
 */
package jv.vecmath;

import jv.object.PsDebug;
import jv.vecmath.P_Vector;
import jv.vecmath.PdBaryDir;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PuData;

public class PdBary
extends P_Vector
implements Cloneable {
    public static final PdBary[] TRIANGLE_VERTEX = new PdBary[]{new PdBary(1.0, 0.0, 0.0), new PdBary(0.0, 1.0, 0.0), new PdBary(0.0, 0.0, 1.0)};
    public static final PdBary TRIANGLE_CENTER;
    public static final PdBary TRIANGLE_MID;
    public double[] m_data;
    public int m_elementInd = -1;
    private static PdVector[] m_c;
    private static PdVector[] m_jc;

    public static PdBary[][] alloc(int n, int n2, int n3) {
        PdBary[][] pdBaryArray = new PdBary[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                pdBaryArray[i][j] = new PdBary(n3);
            }
        }
        return pdBaryArray;
    }

    public static PdBary[] realloc(PdBary[] pdBaryArray, int n, int n2) {
        int n3;
        int n4;
        if (pdBaryArray != null && pdBaryArray.length == n) {
            for (int i = 0; i < pdBaryArray.length; ++i) {
                if (pdBaryArray[i] == null) {
                    pdBaryArray[i] = new PdBary(n2);
                    continue;
                }
                if (pdBaryArray[i].m_data != null && pdBaryArray[i].m_data.length == n2) continue;
                pdBaryArray[i].setSize(n2);
            }
            return pdBaryArray;
        }
        PdBary[] pdBaryArray2 = new PdBary[n];
        if (pdBaryArray == null) {
            n4 = 0;
        } else {
            n4 = Math.min(pdBaryArray.length, n);
            System.arraycopy(pdBaryArray, 0, pdBaryArray2, 0, n4);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (pdBaryArray2[n3] == null) {
                pdBaryArray2[n3] = new PdBary(n2);
                continue;
            }
            if (pdBaryArray2[n3].m_data != null && pdBaryArray2[n3].m_data.length == n2) continue;
            pdBaryArray2[n3].setSize(n2);
        }
        for (n3 = n4; n3 < n; ++n3) {
            pdBaryArray2[n3] = new PdBary(n2);
        }
        return pdBaryArray2;
    }

    public static boolean copy(PdBary[] pdBaryArray, int n, PdBary[] pdBaryArray2, int n2, int n3) {
        if (n3 == 0) {
            return true;
        }
        if (pdBaryArray == null || pdBaryArray.length < n + n3) {
            PsDebug.warning("missing space in dataDest", pdBaryArray);
            return false;
        }
        if (pdBaryArray2 == null || pdBaryArray2.length < n2 + n3) {
            PsDebug.warning("missing space in dataSrc", pdBaryArray2);
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            pdBaryArray[n + i].copy(pdBaryArray2[n2 + i]);
        }
        return true;
    }

    public static double sqrDist(PdBary pdBary, PdBary pdBary2) {
        if (pdBary == null || pdBary2 == null) {
            PsDebug.warning("missing argument");
            return 0.0;
        }
        if (pdBary.m_data.length != pdBary2.m_data.length) {
            PsDebug.warning("vectors have incompatible size");
            return 0.0;
        }
        double d = 0.0;
        for (int i = 0; i < pdBary.m_data.length; ++i) {
            double d2 = pdBary.m_data[i] - pdBary2.m_data[i];
            d += d2 * d2;
        }
        return d;
    }

    public static double dist(PdBary pdBary, PdBary pdBary2) {
        return Math.sqrt(PdBary.sqrDist(pdBary, pdBary2));
    }

    public PdBary() {
        this(0);
    }

    public PdBary(int n) {
        this.m_data = new double[n];
        if (n > 0) {
            this.m_data[0] = 1.0;
        }
    }

    public PdBary(double d, double d2) {
        this(2);
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public PdBary(double d, double d2, double d3) {
        this(3);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdBary(int n, double d, double d2, double d3) {
        this(3);
        this.m_elementInd = n;
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public PdBary(double d, double d2, double d3, double d4) {
        this(4);
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_data[3] = d4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PdBary *********\n");
        int n = this.getSize();
        stringBuffer.append("\t size\t = " + String.valueOf(n) + "\n");
        if (n > 0) {
            stringBuffer.append("\t m_data = (" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
            stringBuffer.append(")\n");
        } else if (this.m_data != null) {
            stringBuffer.append("\t m_data = {}\n");
        } else {
            stringBuffer.append("\t m_data = null\n");
        }
        stringBuffer.append("\t m_elementInd = " + String.valueOf(this.m_elementInd) + "\n");
        return stringBuffer.toString();
    }

    public String toShortString() {
        StringBuffer stringBuffer = new StringBuffer("\t ");
        int n = this.getSize();
        if (n > 0) {
            stringBuffer.append("{" + String.valueOf(this.m_data[0]));
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(", " + String.valueOf(this.m_data[i]));
            }
        } else if (this.m_data != null) {
            stringBuffer.append("m_data = {");
        } else {
            stringBuffer.append("m_data = {null");
        }
        stringBuffer.append("}, m_elementInd = " + String.valueOf(this.m_elementInd) + "\n");
        return stringBuffer.toString();
    }

    public double[] getEntries() {
        return (double[])this.m_data.clone();
    }

    public double getEntry(int n) {
        if (n < 0 || this.m_data == null || this.m_data.length <= n) {
            PsDebug.warning("index out of range, index=" + n);
            return 0.0;
        }
        return this.m_data[n];
    }

    public void setEntry(int n, double d) {
        if (this.m_data == null || this.m_data.length <= n) {
            this.setSize(n + 1);
        }
        this.m_data[n] = d;
    }

    public void set(double d, double d2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
    }

    public void set(int n, double d, double d2) {
        if (this.m_data == null || this.m_data.length < 2) {
            this.setSize(2);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_elementInd = n;
    }

    public void set(double d, double d2, double d3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
    }

    public void set(int n, double d, double d2, double d3) {
        if (this.m_data == null || this.m_data.length < 3) {
            this.setSize(3);
        }
        this.m_data[0] = d;
        this.m_data[1] = d2;
        this.m_data[2] = d3;
        this.m_elementInd = n;
    }

    public int getElementInd() {
        return this.m_elementInd;
    }

    public void setElementInd(int n) {
        this.m_elementInd = n;
    }

    public Object clone() {
        PdBary pdBary = null;
        pdBary = (PdBary)super.clone();
        if (pdBary == null) {
            return null;
        }
        if (this.m_data != null) {
            pdBary.m_data = (double[])this.m_data.clone();
        }
        return pdBary;
    }

    public static PdBary copyNew(PdBary pdBary) {
        if (pdBary == null) {
            PsDebug.warning("missing argument vector");
            return null;
        }
        if (pdBary.m_data == null) {
            PsDebug.warning("missing data of argument vector.");
            return null;
        }
        PdBary pdBary2 = new PdBary(pdBary.getSize());
        pdBary2.copy(pdBary);
        return pdBary2;
    }

    public void copy(PdBary pdBary) {
        if (this == pdBary) {
            return;
        }
        if (pdBary == null) {
            PsDebug.warning("missing argument");
            return;
        }
        super.copy(pdBary);
        this.m_elementInd = pdBary.m_elementInd;
        if (pdBary.m_data == null) {
            this.m_data = null;
            return;
        }
        if (this.m_data == null || this.m_data.length != pdBary.getSize()) {
            this.setSize(pdBary.getSize());
        }
        System.arraycopy(pdBary.m_data, 0, this.m_data, 0, this.m_data.length);
    }

    public int getSize() {
        if (this.m_data == null) {
            return 0;
        }
        return this.m_data.length;
    }

    public int setSize(int n) {
        if (this.m_data == null || this.m_data.length != n) {
            this.m_data = PuData.realloc(this.m_data, n);
        }
        return n;
    }

    public void blend(double d, PdBary pdBary, double d2, PdBary pdBary2) {
        if (pdBary == null || pdBary2 == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data.length != pdBary.m_data.length || this.m_data.length != pdBary2.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        if (this.m_data == null) {
            this.setSize(pdBary.m_data.length);
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = d * pdBary.m_data[i] + d2 * pdBary2.m_data[i];
        }
        this.m_elementInd = d > d2 ? pdBary.m_elementInd : pdBary2.m_elementInd;
    }

    public void blendBase(PdBary pdBary, double d, PdBaryDir pdBaryDir) {
        if (pdBary == null || pdBaryDir == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (this.m_data == null || this.m_data.length == 0) {
            this.setSize(pdBary.m_data.length);
        }
        if (this.m_data.length != pdBary.m_data.length || this.m_data.length != pdBaryDir.m_data.length) {
            PsDebug.warning("different size of this and argument");
            return;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_data[i] = pdBary.m_data[i] + d * pdBaryDir.m_data[i];
        }
    }

    public void validate() {
        int n;
        if (this.m_data == null) {
            return;
        }
        double d = 0.0;
        for (n = 0; n < this.m_data.length; ++n) {
            if (Math.abs(this.m_data[n]) < 1.0E-10) {
                this.m_data[n] = 0.0;
                continue;
            }
            d += this.m_data[n];
        }
        if (Math.abs(d - 1.0) < 1.0E-10) {
            return;
        }
        for (n = 0; n < this.m_data.length; ++n) {
            if (this.m_data[n] == 0.0) continue;
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] / d;
        }
    }

    public void projectToInside() {
        int n;
        if (this.m_data == null) {
            return;
        }
        this.validate();
        boolean bl = false;
        double d = 0.0;
        while (!bl) {
            bl = true;
            n = 0;
            double d2 = 0.0;
            for (int i = 0; i < this.m_data.length; ++i) {
                if (this.m_data[i] == 0.0) continue;
                if (this.m_data[i] < d) {
                    this.m_data[i] = 0.0;
                    bl = false;
                    continue;
                }
                ++n;
                d2 += this.m_data[i];
            }
            d = (d2 - 1.0) / (double)n;
        }
        for (n = 0; n < this.m_data.length; ++n) {
            if (!(this.m_data[n] > 0.0)) continue;
            int n2 = n;
            this.m_data[n2] = this.m_data[n2] - d;
        }
    }

    public boolean isInside() {
        return this.isInside(0.0);
    }

    public boolean isInside(double d) {
        if (this.m_data == null) {
            return false;
        }
        this.validate();
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!(this.m_data[i] < -d)) continue;
            return false;
        }
        return true;
    }

    public int isOutside() {
        return this.isOutside(0.0);
    }

    public int isOutside(double d) {
        if (this.m_data == null) {
            return -1;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!(this.m_data[i] < d)) continue;
            return i;
        }
        return -1;
    }

    public int isOnVertex() {
        return this.isOnVertex(0.0);
    }

    public int isOnVertex(double d) {
        if (this.m_data == null) {
            return -1;
        }
        this.validate();
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!(this.m_data[i] >= 1.0 - d) || !(this.m_data[i] <= 1.0 + d)) continue;
            return i;
        }
        return -1;
    }

    public int isOnEdge() {
        return this.isOnEdge(0.0);
    }

    public int isOnEdge(double d) {
        if (this.m_data.length == 3) {
            return this.isOnFace(d);
        }
        if (!this.isInside(d)) {
            return -1;
        }
        if (this.m_data.length == 2) {
            return 1;
        }
        this.validate();
        int n = 0;
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!(this.m_data[i] > d)) continue;
            ++n;
        }
        return n == 2 ? 1 : -1;
    }

    public int isOnFace() {
        return this.isOnFace(0.0);
    }

    public int isOnFace(double d) {
        if (this.m_data.length == 2) {
            return this.isOnVertex(d);
        }
        this.validate();
        if (!this.isInside(d)) {
            return -1;
        }
        for (int i = 0; i < this.m_data.length; ++i) {
            if (!(this.m_data[i] >= -d) || !(this.m_data[i] <= d)) continue;
            return i;
        }
        return -1;
    }

    public static void getVertex(PdVector pdVector, PdBary pdBary, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        pdBary.getVertex(pdVector, pdVector2, pdVector3, pdVector4);
    }

    public PdVector getVertex(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        int n = pdVector2.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = this.m_data[0] * pdVector2.m_data[i] + this.m_data[1] * pdVector3.m_data[i] + this.m_data[2] * pdVector4.m_data[i];
        }
        return pdVector;
    }

    public PdVector getVertex(PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        int n = pdVector2.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = this.m_data[0] * pdVector2.m_data[i] + this.m_data[1] * pdVector3.m_data[i];
        }
        return pdVector;
    }

    public PdVector getVertex(PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4, PdVector pdVector5) {
        int n = pdVector2.getSize();
        if (pdVector == null) {
            pdVector = new PdVector(n);
        }
        for (int i = 0; i < n; ++i) {
            pdVector.m_data[i] = this.m_data[0] * pdVector2.m_data[i] + this.m_data[1] * pdVector3.m_data[i] + this.m_data[2] * pdVector4.m_data[i] + this.m_data[3] * pdVector5.m_data[i];
        }
        return pdVector;
    }

    public void add(PdBaryDir pdBaryDir) {
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            int n = i;
            this.m_data[n] = this.m_data[n] + pdBaryDir.m_data[i];
        }
    }

    public void add(PdBary pdBary, PdBaryDir pdBaryDir) {
        for (int i = this.m_data.length - 1; i >= 0; --i) {
            this.m_data[i] = pdBary.m_data[i] + pdBaryDir.m_data[i];
        }
    }

    public static void add(PdBary pdBary, double d, PdBaryDir pdBaryDir, PdBary pdBary2) {
        int n = pdBary.getSize();
        for (int i = 0; i < n; ++i) {
            pdBary2.m_data[i] = pdBary.m_data[i] + d * pdBaryDir.m_data[i];
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix) {
        int n = this.m_data.length;
        double[] dArray = (double[])this.m_data.clone();
        for (int i = 0; i < n; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < n; ++j) {
                int n2 = i;
                this.m_data[n2] = this.m_data[n2] + pdMatrix.m_data[i][j] * dArray[j];
            }
        }
    }

    public void leftMultMatrix(PdMatrix pdMatrix, PdBary pdBary) {
        if (this == pdBary) {
            PsDebug.warning("this vector must be different from argument vector");
            return;
        }
        if (this.m_data.length != pdMatrix.m_iSize) {
            this.setSize(pdMatrix.m_iSize);
        }
        for (int i = 0; i < pdMatrix.m_iSize; ++i) {
            this.m_data[i] = 0.0;
            for (int j = 0; j < pdBary.m_data.length; ++j) {
                int n = i;
                this.m_data[n] = this.m_data[n] + pdMatrix.m_data[i][j] * pdBary.m_data[j];
            }
        }
    }

    public static void getBary(PdBary pdBary, PdVector pdVector, PdVector pdVector2, PdVector pdVector3, PdVector pdVector4) {
        PdVector[] pdVectorArray = new PdVector[]{pdVector2, pdVector3, pdVector4};
        PdBary.getBary(pdBary, pdVector, pdVectorArray);
    }

    public static void getBary(PdBary pdBary, PdVector pdVector, PdVector[] pdVectorArray) {
        int n;
        int n2 = pdVector.getSize();
        if (n2 != pdVectorArray[0].getSize()) {
            PsDebug.warning("point and vertex have different dimension");
            return;
        }
        if (m_c == null || m_c.length != 3 || m_c[0].getSize() != n2) {
            m_c = PdVector.realloc(null, 3, n2);
        }
        if (m_jc == null || m_jc.length != 3 || m_jc[0].getSize() != n2) {
            m_jc = PdVector.realloc(null, 3, n2);
        }
        for (int i = 0; i < 3; ++i) {
            m_c[i].sub(pdVectorArray[(i + 2) % 3], pdVectorArray[(i + 1) % 3]);
        }
        int n3 = 2;
        for (int i = 0; i < 3; ++i) {
            double d = m_c[i].sqrLength();
            double d2 = PdVector.dot(m_c[i], m_c[n3]);
            m_jc[i].blend(1.0, m_c[n3], -d2 / d, m_c[i]);
            if (++n3 != 3) continue;
            n3 = 0;
        }
        double d = 0.0;
        for (n = 0; n < 3; ++n) {
            pdBary.m_data[n] = PdVector.area(pdVector, pdVectorArray[(n + 1) % 3], pdVectorArray[(n + 2) % 3]);
            m_c[0].sub(pdVector, pdVectorArray[(n + 1) % 3]);
            if (PdVector.dot(m_jc[n], m_c[0]) < 0.0) {
                pdBary.m_data[n] = -pdBary.m_data[n];
            }
            d += pdBary.m_data[n];
        }
        n = 0;
        while (n < 3) {
            int n4 = n++;
            pdBary.m_data[n4] = pdBary.m_data[n4] / d;
        }
    }

    public static void getBaryInside(PdBary pdBary, PdVector pdVector, PdVector[] pdVectorArray) {
        int n;
        double d;
        PdVector pdVector2;
        double d2;
        int n2 = pdVector.getSize();
        if (n2 != pdVectorArray[0].getSize()) {
            PsDebug.warning("point and vertex have different dimension");
            return;
        }
        if (pdVectorArray.length != 3) {
            PsDebug.warning("Vertex array has wrong size.");
            return;
        }
        PdVector pdVector3 = PdVector.subNew(pdVectorArray[1], pdVectorArray[0]);
        PdVector pdVector4 = PdVector.subNew(pdVectorArray[2], pdVectorArray[0]);
        double d3 = pdVector3.sqrLength();
        if (d3 > 1.0E-10) {
            d2 = PdVector.dot(pdVector3, pdVector4) / d3;
            pdVector4.add(-d2, pdVector3);
            pdVector2 = PdVector.subNew(pdVector, pdVectorArray[0]);
            d = PdVector.dot(pdVector2, pdVector3) / d3;
            double d4 = pdVector4.sqrLength();
            if (d4 > 1.0E-10) {
                double d5 = PdVector.dot(pdVector2, pdVector4) / d4;
                pdBary.m_data[0] = 1.0 - (d -= d5 * d2) - d5;
                pdBary.m_data[1] = d;
                pdBary.m_data[2] = d5;
            } else {
                pdBary.m_data[0] = 1.0 - d;
                pdBary.m_data[1] = d;
                pdBary.m_data[2] = 0.0;
            }
        } else {
            d2 = pdVector4.sqrLength();
            if (d2 > 1.0E-10) {
                pdVector2 = PdVector.subNew(pdVector, pdVectorArray[0]);
                d = PdVector.dot(pdVector2, pdVector4) / d2;
                pdBary.m_data[0] = (1.0 - d) / 2.0;
                pdBary.m_data[1] = pdBary.m_data[0];
                pdBary.m_data[2] = d;
            } else {
                pdBary.m_data[0] = 0.3333333333333333;
                pdBary.m_data[1] = 0.3333333333333333;
                pdBary.m_data[2] = 0.3333333333333333;
            }
        }
        int n3 = 0;
        for (n = 0; n < 3; ++n) {
            if (!(pdBary.m_data[n] < 0.0)) continue;
            ++n3;
        }
        if (n3 == 0) {
            return;
        }
        if (n3 == 1) {
            for (n = 0; n < 3; ++n) {
                if (!(pdBary.m_data[n] < 0.0)) continue;
                pdBary.m_data[n] = 0.0;
                pdVector3 = PdVector.subNew(pdVectorArray[(n + 2) % 3], pdVectorArray[(n + 1) % 3]);
                d3 = pdVector3.sqrLength();
                if (d3 < 1.0E-10) {
                    pdBary.m_data[(n + 1) % 3] = 0.5;
                    pdBary.m_data[(n + 2) % 3] = 0.5;
                    return;
                }
                pdVector2 = PdVector.subNew(pdVector, pdVectorArray[(n + 1) % 3]);
                pdBary.m_data[(n + 2) % 3] = PdVector.dot(pdVector2, pdVector3) / d3;
                if (pdBary.m_data[(n + 2) % 3] > 1.0) {
                    pdBary.m_data[(n + 2) % 3] = 1.0;
                }
                if (pdBary.m_data[(n + 2) % 3] < 0.0) {
                    pdBary.m_data[(n + 2) % 3] = 0.0;
                }
                pdBary.m_data[(n + 1) % 3] = 1.0 - pdBary.m_data[(n + 2) % 3];
                return;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (!(pdBary.m_data[n] > 0.0)) continue;
            pdVector2 = PdVector.subNew(pdVector, pdVectorArray[n]);
            pdVector3 = PdVector.subNew(pdVectorArray[(n + 1) % 3], pdVectorArray[n]);
            d3 = pdVector3.sqrLength();
            if (d3 > 1.0E-10) {
                pdBary.m_data[(n + 1) % 3] = PdVector.dot(pdVector2, pdVector3) / d3;
                if (pdBary.m_data[(n + 1) % 3] >= 0.0 && pdBary.m_data[(n + 1) % 3] <= 1.0) {
                    pdBary.m_data[n] = 1.0 - pdBary.m_data[(n + 1) % 3];
                    pdBary.m_data[(n + 2) % 3] = 0.0;
                    return;
                }
            }
            if ((d3 = (pdVector3 = PdVector.subNew(pdVectorArray[(n + 2) % 3], pdVectorArray[n])).sqrLength()) < 1.0E-10) {
                pdBary.m_data[n] = 1.0;
                pdBary.m_data[(n + 1) % 3] = 0.0;
                pdBary.m_data[(n + 2) % 3] = 0.0;
                return;
            }
            pdBary.m_data[(n + 2) % 3] = PdVector.dot(pdVector2, pdVector3) / d3;
            if (pdBary.m_data[(n + 2) % 3] >= 0.0 && pdBary.m_data[(n + 2) % 3] <= 1.0) {
                pdBary.m_data[n] = 1.0 - pdBary.m_data[(n + 2) % 3];
                pdBary.m_data[(n + 1) % 3] = 0.0;
                return;
            }
            pdBary.m_data[n] = 1.0;
            pdBary.m_data[(n + 1) % 3] = 0.0;
            pdBary.m_data[(n + 2) % 3] = 0.0;
            return;
        }
    }

    public static boolean getBary(PdBary pdBary, PdVector pdVector, PdVector pdVector2, PdVector pdVector3) {
        pdBary.m_data[0] = PdVector.dot(pdVector3, pdVector2, pdVector);
        pdBary.m_data[1] = PdVector.dot(pdVector2, pdVector3, pdVector);
        double d = pdBary.m_data[0] + pdBary.m_data[1];
        if (Math.abs(d) < 1.0E-10) {
            return false;
        }
        int n = 0;
        while (n < 2) {
            int n2 = n++;
            pdBary.m_data[n2] = pdBary.m_data[n2] / d;
        }
        return true;
    }

    public int getFirstVertexOfEdge() {
        int n;
        int n2 = this.isOnEdge();
        if (n2 == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return n2;
        }
        if (this.m_data.length == 3) {
            for (n = 0; n < this.m_data.length; ++n) {
                if (this.m_data[n] == 0.0 || this.m_data[(n + 1) % this.m_data.length] == 0.0) continue;
                return n;
            }
        }
        for (n = 0; n < this.m_data.length; ++n) {
            if (this.m_data[n] == 0.0) continue;
            return n;
        }
        return 0;
    }

    public int getSecondVertexOfEdge() {
        int n;
        int n2 = this.isOnEdge();
        if (n2 == -1) {
            return -1;
        }
        if (this.m_data.length < 3) {
            return 1;
        }
        if (this.m_data.length == 3) {
            for (n = 0; n < this.m_data.length; ++n) {
                if (this.m_data[n] == 0.0 || this.m_data[(n + 1) % this.m_data.length] == 0.0) continue;
                return (n + 1) % this.m_data.length;
            }
        }
        for (n = this.m_data.length - 1; n >= 0; --n) {
            if (this.m_data[n] == 0.0) continue;
            return n;
        }
        return 0;
    }

    static {
        TRIANGLE_MID = TRIANGLE_CENTER = new PdBary(0.3333333333333333, 0.3333333333333333, 0.3333333333333333);
    }
}

