/*
 * Decompiled with CFR 0.152.
 */
package jv.thirdParty.acmeEncoders;

import java.util.Dictionary;
import java.util.Enumeration;
import jv.thirdParty.acmeEncoders.IntHashtableEntry;
import jv.thirdParty.acmeEncoders.IntHashtableEnumerator;

public class IntHashtable
extends Dictionary
implements Cloneable {
    private IntHashtableEntry[] m_table;
    private int m_count;
    private int m_threshold;
    private float m_loadFactor;

    public IntHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.m_loadFactor = f;
        this.m_table = new IntHashtableEntry[n];
        this.m_threshold = (int)((float)n * f);
    }

    public IntHashtable(int n) {
        this(n, 0.75f);
    }

    public IntHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.m_count;
    }

    public boolean isEmpty() {
        return this.m_count == 0;
    }

    public synchronized Enumeration keys() {
        return new IntHashtableEnumerator(this.m_table, true);
    }

    public synchronized Enumeration elements() {
        return new IntHashtableEnumerator(this.m_table, false);
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n = intHashtableEntryArray.length;
        while (n-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n];
            while (intHashtableEntry != null) {
                if (intHashtableEntry.m_value.equals(object)) {
                    return true;
                }
                intHashtableEntry = intHashtableEntry.m_next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.m_hash == n2 && intHashtableEntry.m_key == n) {
                return true;
            }
            intHashtableEntry = intHashtableEntry.m_next;
        }
        return false;
    }

    public synchronized Object get(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.m_hash == n2 && intHashtableEntry.m_key == n) {
                return intHashtableEntry.m_value;
            }
            intHashtableEntry = intHashtableEntry.m_next;
        }
        return null;
    }

    public Object get(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.get(n2);
    }

    protected void rehash() {
        int n = this.m_table.length;
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n2 = n * 2 + 1;
        IntHashtableEntry[] intHashtableEntryArray2 = new IntHashtableEntry[n2];
        this.m_threshold = (int)((float)n2 * this.m_loadFactor);
        this.m_table = intHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
            while (intHashtableEntry != null) {
                IntHashtableEntry intHashtableEntry2 = intHashtableEntry;
                intHashtableEntry = intHashtableEntry.m_next;
                int n4 = (intHashtableEntry2.m_hash & Integer.MAX_VALUE) % n2;
                intHashtableEntry2.m_next = intHashtableEntryArray2[n4];
                intHashtableEntryArray2[n4] = intHashtableEntry2;
            }
        }
    }

    public synchronized Object put(int n, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        while (intHashtableEntry != null) {
            if (intHashtableEntry.m_hash == n2 && intHashtableEntry.m_key == n) {
                Object object2 = intHashtableEntry.m_value;
                intHashtableEntry.m_value = object;
                return object2;
            }
            intHashtableEntry = intHashtableEntry.m_next;
        }
        if (this.m_count >= this.m_threshold) {
            this.rehash();
            return this.put(n, object);
        }
        intHashtableEntry = new IntHashtableEntry();
        intHashtableEntry.m_hash = n2;
        intHashtableEntry.m_key = n;
        intHashtableEntry.m_value = object;
        intHashtableEntry.m_next = intHashtableEntryArray[n3];
        intHashtableEntryArray[n3] = intHashtableEntry;
        ++this.m_count;
        return null;
    }

    public Object put(Object object, Object object2) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.put(n2, object2);
    }

    public synchronized Object remove(int n) {
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n2 = n;
        int n3 = (n2 & Integer.MAX_VALUE) % intHashtableEntryArray.length;
        IntHashtableEntry intHashtableEntry = intHashtableEntryArray[n3];
        IntHashtableEntry intHashtableEntry2 = null;
        while (intHashtableEntry != null) {
            if (intHashtableEntry.m_hash == n2 && intHashtableEntry.m_key == n) {
                if (intHashtableEntry2 != null) {
                    intHashtableEntry2.m_next = intHashtableEntry.m_next;
                } else {
                    intHashtableEntryArray[n3] = intHashtableEntry.m_next;
                }
                --this.m_count;
                return intHashtableEntry.m_value;
            }
            intHashtableEntry2 = intHashtableEntry;
            intHashtableEntry = intHashtableEntry.m_next;
        }
        return null;
    }

    public Object remove(Object object) {
        if (!(object instanceof Integer)) {
            throw new InternalError("key is not an Integer");
        }
        Integer n = (Integer)object;
        int n2 = n;
        return this.remove(n2);
    }

    public synchronized void clear() {
        IntHashtableEntry[] intHashtableEntryArray = this.m_table;
        int n = intHashtableEntryArray.length;
        while (--n >= 0) {
            intHashtableEntryArray[n] = null;
        }
        this.m_count = 0;
    }

    public synchronized Object clone() {
        try {
            IntHashtable intHashtable = (IntHashtable)super.clone();
            intHashtable.m_table = new IntHashtableEntry[this.m_table.length];
            int n = this.m_table.length;
            while (n-- > 0) {
                intHashtable.m_table[n] = this.m_table[n] != null ? (IntHashtableEntry)this.m_table[n].clone() : null;
            }
            return intHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

