/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.objectGui.PsTabPanel;

class PsTabsHeader
extends Panel {
    protected Font normalFont;
    protected Font boldFont;
    protected FontMetrics fmBoldFont;
    protected static int selUpper = 2;
    protected static int lineWidth = 1;
    protected static int horRound = 1;
    protected static int verRound = 1;
    protected static int XTitle = 4;
    protected static int YTitle = 2;
    protected int X;
    protected int Y;
    protected int Z;
    protected String[] arrName;
    protected int[] arrEnd;
    protected int[] arrBeg;
    protected boolean[] arrEnabled;
    protected int selected = 0;
    protected int m_oldWidth = 0;
    protected int m_oldHeight = 0;
    protected int m_numTabs;
    protected int m_maxNumTabs = 9;
    protected PsTabPanel m_tabPanel;
    protected boolean m_modified = false;

    PsTabsHeader(PsTabPanel psTabPanel) {
        this.addMouseListener(new PsTabsHeader_MA());
        this.m_tabPanel = psTabPanel;
        this.normalFont = PsConfig.getFont(0);
        this.boldFont = PsConfig.getFont(3);
        this.fmBoldFont = super.getFontMetrics(this.boldFont);
        this.Z = this.fmBoldFont.getHeight() + 9;
        this.arrName = new String[this.m_maxNumTabs];
        this.arrEnd = new int[this.m_maxNumTabs];
        this.arrBeg = new int[this.m_maxNumTabs];
        this.arrEnabled = new boolean[this.m_maxNumTabs];
        super.setLayout(null);
    }

    public void init() {
        this.m_numTabs = 0;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getParent().getInsets();
        int n = 100;
        int n2 = this.Z;
        return new Dimension(insets.left + insets.right + n, insets.top + insets.bottom + n2);
    }

    public Dimension minimumLayoutSize() {
        return this.getPreferredSize();
    }

    public String getCurrentPanel() {
        return this.arrName[this.selected];
    }

    protected void addPanel(String string, Panel panel) {
        if (this.m_numTabs >= this.m_maxNumTabs) {
            PsDebug.warning("too many tabs, numTabs = " + this.m_numTabs);
            return;
        }
        for (int i = 0; i < this.m_numTabs; ++i) {
            if (!this.arrName[i].equals(string)) continue;
            PsDebug.notify("panel already included = " + string);
            return;
        }
        this.arrName[this.m_numTabs] = string;
        this.arrEnabled[this.m_numTabs] = true;
        ++this.m_numTabs;
        this.m_modified = true;
    }

    protected void removePanel(String string) {
        int n;
        int n2 = -1;
        for (n = 0; n < this.m_numTabs; ++n) {
            if (!this.arrName[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            PsDebug.notify("panel does not exist = " + string);
            return;
        }
        for (n = n2; n < this.m_numTabs - 1; ++n) {
            this.arrName[n] = this.arrName[n + 1];
        }
        --this.m_numTabs;
        this.m_modified = true;
    }

    protected void show(String string) {
        int n = -1;
        for (int i = 0; i < this.m_numTabs; ++i) {
            if (!this.arrName[i].equals(string)) continue;
            n = i;
            break;
        }
        if (n < 0 || n > this.m_numTabs) {
            PsDebug.warning("panel not found = " + string);
            return;
        }
        int n2 = this.selected;
        this.arrBeg[n2] = this.arrBeg[n2] + 2;
        int n3 = this.selected;
        this.arrEnd[n3] = this.arrEnd[n3] - 2;
        int n4 = this.selected = n;
        this.arrBeg[n4] = this.arrBeg[n4] - 2;
        int n5 = this.selected;
        this.arrEnd[n5] = this.arrEnd[n5] + 2;
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.getSize();
        if (dimension.width == 0 || dimension.height == 0 || this.m_numTabs == 0) {
            return;
        }
        if (dimension.width != this.m_oldWidth || dimension.height != this.m_oldHeight || this.m_modified) {
            this.m_modified = false;
            this.m_oldWidth = dimension.width;
            this.m_oldHeight = dimension.height;
            this.X = dimension.width;
            this.Y = dimension.height;
            int[] nArray = new int[this.m_numTabs];
            n2 = dimension.width;
            for (n = 0; n < this.m_numTabs; ++n) {
                nArray[n] = this.fmBoldFont.stringWidth(this.arrName[n]);
                n2 -= nArray[n];
            }
            n = 1;
            while (n < this.m_numTabs) {
                int n3 = n++;
                nArray[n3] = nArray[n3] + n2 / this.m_numTabs;
            }
            n = dimension.width / this.m_numTabs;
            this.arrBeg[0] = 0;
            this.arrEnd[0] = n + 2;
            for (int i = 1; i < this.m_numTabs; ++i) {
                this.arrBeg[i] = this.arrEnd[i - 1];
                this.arrEnd[i] = this.arrBeg[i] + nArray[i];
            }
        }
        graphics.setColor(super.getBackground());
        graphics.fillRect(0, 0, this.X, this.Z + 1);
        for (n = 0; n < this.m_numTabs; ++n) {
            if (n == this.selected) {
                graphics.setFont(this.boldFont);
                n2 = 0;
            } else {
                graphics.setFont(this.normalFont);
                n2 = 2;
            }
            graphics.setColor(Color.darkGray);
            graphics.drawLine(this.arrEnd[n] - 2, n2 + 2, this.arrEnd[n] - 2, this.Z - 2);
            graphics.setColor(Color.black);
            graphics.drawLine(this.arrEnd[n] - 1, n2 + 2, this.arrEnd[n] - 1, this.Z - 2);
            graphics.setColor(this.isEnabled(n) ? Color.black : Color.gray);
            graphics.drawString(this.arrName[n], this.arrBeg[n] + 6, n2 + 4 + this.fmBoldFont.getAscent());
            graphics.setColor(Color.white);
            graphics.drawLine(this.arrBeg[n], n2 + 2, this.arrBeg[n], this.Z);
            graphics.drawLine(this.arrBeg[n] + 1, n2 + 1, this.arrEnd[n] - 3, n2 + 1);
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.arrBeg[n] + 1, n2 + 2, this.arrBeg[n] + 1, this.Z);
            graphics.drawLine(this.arrBeg[n] + 2, n2 + 2, this.arrEnd[n] - 3, n2 + 2);
        }
        graphics.setColor(Color.darkGray);
        for (int i = 0; i < 2; ++i) {
            if (this.selected != 0) {
                graphics.drawLine(0, this.Z - 2 + i, this.arrBeg[this.selected], this.Z - 2 + i);
            }
            if (this.selected != this.m_numTabs - 1) {
                graphics.drawLine(this.arrEnd[this.selected], this.Z - 2 + i, this.X, this.Z - 2 + i);
            }
            graphics.setColor(Color.white);
        }
    }

    public boolean isEnabled(int n) {
        return this.arrEnabled[n];
    }

    public void setEnabled(String string, boolean bl) {
        for (int i = 0; i < this.m_numTabs; ++i) {
            if (!this.arrName[i].equals(string)) continue;
            this.setEnabled(i, bl);
        }
    }

    public void setEnabled(int n, boolean bl) {
        if (this.arrEnabled[n] != bl) {
            this.arrEnabled[n] = bl;
            this.repaint();
        }
    }

    class PsTabsHeader_MA
    extends MouseAdapter {
        PsTabsHeader_MA() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getY() >= PsTabsHeader.this.Z) {
                return;
            }
            for (int i = 0; i < PsTabsHeader.this.m_numTabs; ++i) {
                if (PsTabsHeader.this.arrBeg[i] >= mouseEvent.getX() || mouseEvent.getX() >= PsTabsHeader.this.arrEnd[i]) continue;
                if (i == PsTabsHeader.this.selected || !PsTabsHeader.this.isEnabled(i)) {
                    return;
                }
                int n = PsTabsHeader.this.selected;
                PsTabsHeader.this.arrBeg[n] = PsTabsHeader.this.arrBeg[n] + 2;
                int n2 = PsTabsHeader.this.selected;
                PsTabsHeader.this.arrEnd[n2] = PsTabsHeader.this.arrEnd[n2] - 2;
                PsTabsHeader.this.selected = i;
                PsTabsHeader.this.m_tabPanel.showFromHeader(PsTabsHeader.this.arrName[PsTabsHeader.this.selected]);
                int n3 = PsTabsHeader.this.selected;
                PsTabsHeader.this.arrBeg[n3] = PsTabsHeader.this.arrBeg[n3] - 2;
                int n4 = PsTabsHeader.this.selected;
                PsTabsHeader.this.arrEnd[n4] = PsTabsHeader.this.arrEnd[n4] + 2;
                PsTabsHeader.this.paint(PsTabsHeader.this.getGraphics());
                return;
            }
        }
    }
}

