/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import jv.number.PuString;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsUtil;

public class PsImage {
    protected transient Image m_image;
    protected URL m_imageUrl;
    protected String m_imageName;
    protected String m_alternateText;
    protected int m_width;
    protected int m_height;
    protected boolean m_explicitSize = false;
    protected int m_explicitWidth = 0;
    protected int m_explicitHeight = 0;
    protected MediaTracker m_tracker;
    protected Component m_parentComponent;
    protected int m_lastTrackerID = 0;
    protected int m_currentTrackerID;
    protected boolean m_bDoneLoading = false;

    public PsImage(URL uRL) {
        this.m_imageUrl = uRL;
        this.m_imageName = uRL.toString();
        this.m_alternateText = this.m_imageUrl.getFile();
        this.m_image = PsImage.getImage(this.m_imageUrl);
        this.init();
    }

    public PsImage(String string) {
        this.m_imageName = string;
        this.m_alternateText = string;
        this.m_image = PsImage.getImage(string);
        this.init();
    }

    public PsImage(Image image, String string) {
        this.m_image = image;
        this.m_imageName = string;
        this.m_alternateText = string;
        this.init();
    }

    public void init() {
        this.m_tracker = this.m_parentComponent != null ? new MediaTracker(this.m_parentComponent) : new MediaTracker(PsConfig.getFrame());
        this.m_currentTrackerID = this.m_lastTrackerID++;
        this.m_tracker.addImage(this.m_image, this.m_currentTrackerID);
    }

    public void setParentComponent(Component component) {
        this.m_parentComponent = component;
    }

    public boolean loadImage() {
        if (this.m_bDoneLoading) {
            return true;
        }
        PsDebug.notify("waiting for " + this.m_imageName);
        try {
            this.m_tracker.waitForID(this.m_currentTrackerID);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            PsDebug.warning("Error loading image " + this.m_imageName + ": " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        if (this.m_tracker.isErrorID(this.m_currentTrackerID)) {
            PsDebug.warning("Error loading image " + this.m_imageName);
            return false;
        }
        this.m_bDoneLoading = true;
        this.m_width = this.m_image.getWidth(null);
        this.m_height = this.m_image.getHeight(null);
        PsDebug.notify(this.m_imageName + " loaded, size = (" + this.m_width + ", " + this.m_height + ")");
        return true;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public Image getImage() {
        boolean bl;
        if (!this.m_bDoneLoading && !(bl = this.loadImage())) {
            PsDebug.warning("loading of image failed = " + this.m_imageName);
            return null;
        }
        return this.m_image;
    }

    public void setSize(int n, int n2) {
        this.m_explicitSize = true;
        this.getImage();
        double d = (0.5 + (double)this.m_width) / (double)this.m_height;
        this.m_explicitWidth = n;
        this.m_explicitHeight = n2;
        if (n < 0 && n2 > 0) {
            this.m_explicitWidth = (int)(d * (double)n2);
        } else if (n > 0 && n2 < 0) {
            this.m_explicitHeight = (int)((double)n / d);
        }
        this.m_image = this.m_image.getScaledInstance(this.m_explicitWidth, this.m_explicitWidth, 4);
    }

    public static int[] getPixels(Image image, int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        if (image == null) {
            PsDebug.warning("missing image");
            return null;
        }
        if (nArray == null) {
            if (n3 > 0 && n4 > 0) {
                nArray = new int[n3 * n4];
            }
            if (nArray == null) {
                PsDebug.warning("missing image size to create missing pixels");
                return null;
            }
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, n5, n6);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
            PsDebug.warning("could not grab pixels");
            return null;
        }
        return nArray;
    }

    public static int[] getPixels(Image image) {
        int[] nArray = null;
        if (image != null) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n != -1 && n2 != -1) {
                nArray = new int[n * n2];
                PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
                try {
                    pixelGrabber.grabPixels();
                }
                catch (Exception exception) {
                    System.err.println("Exception: " + exception);
                    PsDebug.warning("could not grab pixels");
                    return null;
                }
            }
        }
        return nArray;
    }

    public static Image getImage(String string) {
        Image image = null;
        if (!PsConfig.isApplication()) {
            Applet applet = PsConfig.getApplet();
            if (applet == null) {
                PsDebug.warning("missing applet");
                return null;
            }
            image = applet.getImage(applet.getCodeBase(), string);
        } else {
            image = Toolkit.getDefaultToolkit().getImage(string);
            if (image == null) {
                String string2 = PsConfig.getInstBase();
                if (PuString.isEmpty(string2)) {
                    string2 = PsConfig.getCodeBase();
                }
                image = Toolkit.getDefaultToolkit().getImage(string2 + string);
            }
        }
        if (image == null) {
            PsDebug.warning("failed to load image = " + string);
        }
        return image;
    }

    public static Image getImage(URL uRL) {
        Image image;
        if (!PsConfig.isApplication()) {
            Applet applet = PsConfig.getApplet();
            if (applet == null) {
                PsDebug.warning("missing applet");
                return null;
            }
            image = applet.getImage(uRL);
        } else {
            image = Toolkit.getDefaultToolkit().getImage(uRL);
        }
        if (image == null) {
            PsDebug.warning("failed to load url = " + uRL.toString());
        }
        return image;
    }

    public static boolean loadImage(Component component, Image image) {
        if (image == null) {
            PsDebug.warning("missing argument image.");
            return false;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        int n = 0;
        mediaTracker.addImage(image, n);
        try {
            mediaTracker.waitForID(n);
        }
        catch (Exception exception) {
            PsDebug.warning("error loading image " + image.toString() + ": " + exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        if (mediaTracker.isErrorID(n)) {
            new Throwable("Error loading image " + image.toString()).printStackTrace();
            return false;
        }
        return true;
    }

    public static Image createImageFromPixels(Component component, int[] nArray, int n, int n2, int n3, int n4) {
        if (component == null) {
            PsDebug.warning("missing component.");
            return null;
        }
        if (nArray == null) {
            PsDebug.warning("missing pixels.");
            return null;
        }
        Image image = component.createImage(new MemoryImageSource(n, n2, nArray, n3, n4));
        if (PsImage.loadImage(component, image)) {
            return image;
        }
        return null;
    }

    public static Image getImageResource(String string) {
        Object object;
        InputStream inputStream = null;
        Applet applet = PsConfig.getApplet();
        Object object2 = null;
        if (applet != null) {
            try {
                inputStream = applet.getClass().getResourceAsStream(string);
            }
            catch (Exception exception) {
                PsDebug.message("exception-1 when opening image = " + string, false);
                PsDebug.message("ex = " + exception.toString(), false);
                object = new StringWriter();
                exception.printStackTrace(new PrintWriter((Writer)object));
                PsDebug.message("trace = " + ((StringWriter)object).toString(), false);
            }
        }
        if (inputStream == null) {
            Object object3;
            if (!PsUtil.isAbsolutePath(string) && PsConfig.isApplication()) {
                object3 = PsConfig.getInstBase();
                if (PuString.isEmpty((String)object3)) {
                    object3 = PsConfig.getCodeBase();
                }
                string = (String)object3 + string;
            }
            try {
                object3 = PsImage.getImage(string);
                if (PsImage.loadImage(PsConfig.getFrame(), (Image)object3)) {
                    object2 = object3;
                }
            }
            catch (Exception exception) {
                PsDebug.message("exception-2 when opening image = " + string, false);
                PsDebug.message("ex = " + exception.toString(), false);
                object = new StringWriter();
                exception.printStackTrace(new PrintWriter((Writer)object));
                PsDebug.message("trace = " + ((StringWriter)object).toString(), false);
            }
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            object = new byte[1024];
            boolean bl = false;
            try {
                int n;
                do {
                    if ((n = inputStream.read((byte[])object)) == -1) continue;
                    byteArrayOutputStream.write((byte[])object, 0, n);
                } while (n != -1);
            }
            catch (IOException iOException) {
                bl = true;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                bl = true;
            }
            if (!bl && (object2 = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray())) != null) {
                MediaTracker mediaTracker = new MediaTracker(PsConfig.getFrame());
                mediaTracker.addImage((Image)object2, 0);
                try {
                    if (!mediaTracker.waitForAll(1000L)) {
                        object2 = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    object2 = null;
                }
                if (mediaTracker.isErrorAny()) {
                    object2 = null;
                }
                mediaTracker = null;
            }
        }
        if (object2 == null) {
            PsDebug.message("Resource = " + string + "\n\t... not found yet, we search again.", false);
        }
        return object2;
    }
}

