/*
 * Decompiled with CFR 0.152.
 */
package jv.objectGui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;

public final class GuiStackLayout
implements Serializable,
LayoutManager {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 0;
    private int margin = 2;
    private Hashtable codeTable = new Hashtable();
    static final int CENTER = 0;
    static final int FRONT = 1;
    static final int BACK = 2;
    static final int FILL = 4;
    static final int ABS = 8;
    static final int FLUSH = 16;
    static final int POSMASK = 3;
    static final int SIZEMASK = 12;
    int[] defaultCode = new int[]{0, 0, 0, 0};

    public GuiStackLayout() {
    }

    public GuiStackLayout(int n) {
        this.orientation = n;
    }

    public GuiStackLayout(int n, int n2) {
        this.orientation = n;
        this.margin = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addLayoutComponent(String string, Component component) {
        string = string.toUpperCase().trim();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.length();
        int n6 = 0;
        while (n6 < n5) {
            block33: {
                int n7;
                if (string.startsWith("CENTER", n6)) {
                    n6 += 6;
                } else if (string.startsWith("LEFT", n6)) {
                    n6 += 4;
                    n |= 1;
                } else if (string.startsWith("TOP", n6)) {
                    n6 += 3;
                    n2 |= 1;
                } else if (string.startsWith("RIGHT", n6)) {
                    n6 += 5;
                    n |= 2;
                } else if (string.startsWith("BOTTOM", n6)) {
                    n6 += 6;
                    n2 |= 2;
                } else if (string.startsWith("WIDE", n6)) {
                    n |= 4;
                    if (string.startsWith("*", n6 += 4)) {
                        n7 = this.countDigits(string, ++n6);
                        n3 = this.parseArg(string, n6, n7);
                        n6 += n7;
                    } else {
                        n3 = 1;
                    }
                } else if (string.startsWith("TALL", n6)) {
                    n2 |= 4;
                    if (string.startsWith("*", n6 += 4)) {
                        n7 = this.countDigits(string, ++n6);
                        n4 = this.parseArg(string, n6, n7);
                        n6 += n7;
                    } else {
                        n4 = 1;
                    }
                } else if (string.startsWith("FILL", n6)) {
                    n |= 4;
                    n2 |= 4;
                    if (string.startsWith("*", n6 += 4)) {
                        n7 = this.countDigits(string, ++n6);
                        n3 = n4 = this.parseArg(string, n6, n7);
                        n6 += n7;
                    } else {
                        n4 = 1;
                        n3 = 1;
                    }
                } else {
                    if (string.startsWith("WIDTH", n6)) {
                        n |= 8;
                        if (string.startsWith("=", n6 += 5)) {
                            n7 = this.countDigits(string, ++n6);
                            n3 = this.parseArg(string, n6, n7);
                            n6 += n7;
                            break block33;
                        } else {
                            n3 = -1;
                            break;
                        }
                    }
                    if (string.startsWith("HEIGHT", n6)) {
                        n2 |= 8;
                        if (string.startsWith("=", n6 += 6)) {
                            n7 = this.countDigits(string, ++n6);
                            n4 = this.parseArg(string, n6, n7);
                            n6 += n7;
                            break block33;
                        } else {
                            n4 = -1;
                            break;
                        }
                    }
                    if (string.startsWith("FLUSH", n6)) {
                        n6 += 5;
                        n |= 0x10;
                        n2 |= 0x10;
                    } else {
                        n3 = -1;
                        break;
                    }
                }
            }
            while (n6 < n5 && Character.isWhitespace(string.charAt(n6))) {
                ++n6;
            }
        }
        if (n3 != -1 && n4 != -1) {
            int[] nArray = new int[]{n, n2, n3, n4};
            this.codeTable.put(component, nArray);
            return;
        }
        System.out.println("StackLayout: can't understand \"" + string + "\"");
    }

    int countDigits(String string, int n) {
        int n2;
        int n3 = string.length();
        for (n2 = n; n2 < n3 && Character.isDigit(string.charAt(n2)); ++n2) {
        }
        return n2 - n;
    }

    int parseArg(String string, int n, int n2) {
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string.substring(n, n + n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3;
    }

    public void removeLayoutComponent(Component component) {
        this.codeTable.remove(component);
    }

    int[] getCode(Component component) {
        int[] nArray = (int[])this.codeTable.get(component);
        return nArray == null ? this.defaultCode : nArray;
    }

    boolean stretches(Component component) {
        int[] nArray = this.getCode(component);
        return nArray[this.orientation] == 4;
    }

    Dimension computeLayoutSize(Container container, boolean bl) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = container.getComponentCount();
        if (this.orientation == 0) {
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n3; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                int n6 = this.getCode(component)[this.orientation];
                int n7 = (n6 & 0x10) == 0 ? this.margin : 0;
                Dimension dimension = bl && (n6 & 0xC) == 4 ? component.getPreferredSize() : component.getMinimumSize();
                n4 = Math.max(n4, dimension.height + 2 * n7);
                n5 += dimension.width + 2 * n7;
            }
            return new Dimension(n5 + n, n4 + n2);
        }
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            int n10 = this.getCode(component)[this.orientation];
            int n11 = (n10 & 0x10) == 0 ? this.margin : 0;
            Dimension dimension = bl && (n10 & 0xC) == 4 ? component.getPreferredSize() : component.getMinimumSize();
            n8 = Math.max(n8, dimension.width + 2 * n11);
            n9 += dimension.height + 2 * n11;
        }
        return new Dimension(n8 + n, n9 + n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, false);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, true);
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        int n3;
        int n4 = this.orientation;
        int n5 = (this.orientation + 1) % 2;
        int n6 = container.getComponentCount();
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n7 = dimension.width - insets.left - insets.right;
        int n8 = dimension.height - insets.top - insets.bottom;
        int n9 = this.orientation == 0 ? n7 : n8;
        int n10 = this.orientation == 0 ? n8 : n7;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 1;
        int[][] nArrayArray = new int[n6][];
        int[][] nArray = new int[n6][2];
        for (n3 = 0; n3 < n6; ++n3) {
            Component component = container.getComponent(n3);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            int[] nArray2 = this.getCode(component);
            int[] nArray3 = nArray[n3];
            nArrayArray[n3] = nArray2;
            nArray3[0] = dimension2.width;
            nArray3[1] = dimension2.height;
            n2 = nArray3[n4];
            n = nArray2[n4];
            switch (n & 0xC) {
                case 4: {
                    n11 += nArray2[n4 + 2];
                    break;
                }
                case 8: {
                    n13 += nArray2[n4 + 2];
                    break;
                }
                default: {
                    n13 += n2;
                }
            }
            switch (n & 3) {
                case 0: {
                    ++n12;
                    break;
                }
                case 2: {
                    if (n14 == 2) break;
                    ++n12;
                }
            }
            if ((n & 0x10) == 0) {
                n13 += 2 * this.margin;
            }
            n14 = n & 3;
        }
        if (n14 == 0) {
            ++n12;
        }
        n3 = n11 != 0 || n12 == 0 ? 0 : Math.max(0, (n9 - n13) / n12);
        int n15 = n11 == 0 ? 0 : Math.max(0, (n9 - n13) / n11);
        int n16 = this.orientation == 0 ? insets.left : insets.top;
        int n17 = this.orientation == 0 ? insets.top : insets.left;
        n14 = 1;
        for (int i = 0; i < n6; ++i) {
            int[] nArray4 = nArrayArray[i];
            int[] nArray5 = nArray[i];
            if (nArray4 == null) continue;
            int n18 = nArray4[n4];
            int n19 = nArray4[n5];
            int n20 = (n18 & 0x10) == 0 ? this.margin : 0;
            n16 += n20;
            int n21 = n17 + n20;
            n2 = nArray5[n4];
            n = nArray5[n5];
            switch (n18 & 0xC) {
                case 4: {
                    if (n15 <= 0) break;
                    n2 = n15 * nArray4[n4 + 2];
                    break;
                }
                case 8: {
                    n2 = nArray4[n4 + 2];
                }
            }
            switch (n18 & 3) {
                case 0: {
                    n16 += n3;
                    break;
                }
                case 2: {
                    if (n14 == 2) break;
                    n16 += n3;
                }
            }
            n14 = n18 & 3;
            switch (n19 & 0xC) {
                case 4: {
                    n = n10 - 2 * n20;
                    break;
                }
                case 8: {
                    n = nArray4[n5 + 2];
                }
            }
            switch (n19 & 3) {
                case 2: {
                    n21 += n10 - n;
                    break;
                }
                case 0: {
                    n21 += (n10 - n) / 2;
                }
            }
            Component component = container.getComponent(i);
            if (this.orientation == 0) {
                component.setBounds(n16, n21, n2, n);
            } else {
                component.setBounds(n21, n16, n, n2);
            }
            n16 += n2 + n20;
        }
    }
}

