/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsStackLayout;
import jv.object.PsUpdateIf;

public class PsPanel
extends Panel
implements PsUpdateIf {
    public static final String BOUNDARY_EXT = "_BP";
    public static final String BOUNDARY = "Boundary";
    public static final String CONFIG_EXT = "_CP";
    public static final String CONFIG = "Config";
    public static final String INFO_EXT = "_IP";
    public static final String INFO = "Info";
    public static final String LABEL_EXT = "_LP";
    public static final String LABEL = "Label";
    public static final String MATERIAL_EXT = "_MP";
    public static final String MATERIAL = "Material";
    public static final String TEXTURE_EXT = "_TP";
    public static final String TEXTURE = "Texture";
    public static final String VECTOR_EXT = "_VP";
    public static final String VECTOR = "Vector";
    public static final int BORDER_NONE = 0;
    public static final int BORDER_LINE = 1;
    public static final int BORDER_SUNK = 2;
    public static final int BORDER_GROOVE = 3;
    public static final int BORDER_LINETOP = 4;
    protected int m_borderType = 0;
    public static final int ORIENT_HORIZONTAL = 0;
    public static final int ORIENT_VERTICAL = 1;
    public static final int ORIENT_GUIDE = 2;
    protected int m_insetSizeHor = 0;
    protected int m_insetSizeVer = 0;
    protected int m_insetSizeVerExtra = 0;
    private static int m_numPanels = 0;
    protected Label m_lTitle;
    protected int m_panelVersion;
    protected String m_language;
    protected PsUpdateIf m_parent;
    protected Image m_image;
    protected boolean m_bOutOfDate = false;
    protected Dimension m_preferredSize;
    protected Color m_backColor;
    static /* synthetic */ Class class$jv$object$PsPanel;

    public PsPanel() {
        this(new PsStackLayout(1));
    }

    public PsPanel(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
        ++m_numPanels;
        this.m_panelVersion = PsConfig.getPanelVersion();
        this.m_language = PsConfig.getLanguage();
        if (this.getClass() == (class$jv$object$PsPanel == null ? (class$jv$object$PsPanel = PsPanel.class$("jv.object.PsPanel")) : class$jv$object$PsPanel)) {
            this.init();
        }
    }

    public void init() {
        ((Component)this).setFont(PsConfig.getFont(0));
    }

    public Dimension getPreferredSize() {
        if (this.m_preferredSize == null) {
            return super.getPreferredSize();
        }
        return this.m_preferredSize;
    }

    public void setPreferredSize(int n, int n2) {
        this.m_preferredSize = new Dimension(n * PsConfig.getMonitorScale(), n2 * PsConfig.getMonitorScale());
    }

    public void setBackColor(Color color) {
        this.m_backColor = color;
        this.setBackground(color);
    }

    protected static int getNumPanels() {
        return m_numPanels;
    }

    public int getPanelVersion() {
        return this.m_panelVersion;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.setLayout(null);
        }
        this.m_image = image;
    }

    public void setVisible(boolean bl) {
        if (bl && this.m_parent != null) {
            this.update(this.m_parent);
        }
        super.setVisible(bl);
    }

    public PsUpdateIf getFather() {
        return this.m_parent;
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        this.m_parent = psUpdateIf;
    }

    public boolean update(Object object) {
        if (object == this.m_parent) {
            return true;
        }
        if (object != this && object != null) {
            PsDebug.warning("could not handle event = " + object.toString() + "\n\tmissing implementation of update(Object)");
            return false;
        }
        if (this.m_parent != null) {
            PsDebug.notify("update parent");
            return this.m_parent.update(this);
        }
        return true;
    }

    public final boolean instanceOf(String string) {
        String string2 = this.getClass().getName();
        return string2.endsWith(string);
    }

    public Insets getInsets() {
        return new Insets((this.m_insetSizeVer + this.m_insetSizeVerExtra) * PsConfig.getMonitorScale(), this.m_insetSizeHor * PsConfig.getMonitorScale(), this.m_insetSizeVer * PsConfig.getMonitorScale(), this.m_insetSizeHor * PsConfig.getMonitorScale());
    }

    public void setInsetSize(int n) {
        this.m_insetSizeHor = n;
        this.m_insetSizeVer = n;
    }

    public void setInsetSizeHorizontal(int n) {
        this.m_insetSizeHor = n;
    }

    public void setInsetSizeVertical(int n) {
        this.m_insetSizeVer = n;
    }

    public Label getTitle() {
        return this.m_lTitle;
    }

    public Label getTitle(String string) {
        this.m_lTitle = new Label(string, 0);
        return this.m_lTitle;
    }

    public Label getTitle(String string, Font font) {
        this.m_lTitle = new Label(string, 0);
        this.m_lTitle.setFont(font);
        return this.m_lTitle;
    }

    public boolean hasTitle() {
        return this.m_lTitle != null;
    }

    public void removeTitle() {
        if (!this.hasTitle()) {
            return;
        }
        this.remove(this.m_lTitle);
        this.m_lTitle = null;
    }

    public void setTitle(String string) {
        if (this.m_lTitle == null) {
            this.m_lTitle = new Label(string, 0);
        } else if (PsPanel.setText(this.m_lTitle, string)) {
            this.m_lTitle.validate();
        }
    }

    public Label addTitle(String string) {
        this.m_lTitle = new Label(string, 0);
        this.m_lTitle.setFont(PsConfig.getFont(3));
        this.add(this.m_lTitle);
        return this.m_lTitle;
    }

    public Label addSubTitle(String string) {
        Label label = new Label(string, 0);
        label.setFont(PsConfig.getFont(3));
        this.add(label);
        return label;
    }

    public Canvas addLine(int n) {
        return this.addLine(n, 0);
    }

    public Canvas addLine(int n, int n2) {
        PsLine psLine = new PsLine(n);
        psLine.setOrientation(n2);
        this.add(psLine);
        return psLine;
    }

    public TextField addTextField(String string, int n) {
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(new Label(string));
        TextField textField = new TextField(n);
        panel.add(textField);
        this.add(panel);
        return textField;
    }

    public static boolean setText(TextComponent textComponent, String string) {
        String string2;
        if (textComponent == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if ((string2 = textComponent.getText()) != null && string.equals(string2)) {
            return false;
        }
        textComponent.setText(string);
        return true;
    }

    public static boolean setText(Label label, String string) {
        if (label == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (label.getText().equals(string)) {
            return false;
        }
        label.setText(string);
        return true;
    }

    public static boolean select(Choice choice, int n) {
        if (choice == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (choice.getSelectedIndex() == n) {
            return false;
        }
        choice.select(n);
        return true;
    }

    public static boolean setSelectedCheckbox(CheckboxGroup checkboxGroup, Checkbox checkbox) {
        if (checkboxGroup == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (checkboxGroup.getSelectedCheckbox() == checkbox) {
            return false;
        }
        checkboxGroup.setSelectedCheckbox(checkbox);
        return true;
    }

    public static boolean setState(Checkbox checkbox, boolean bl) {
        if (checkbox == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (checkbox.getState() == bl) {
            return false;
        }
        checkbox.setState(bl);
        return true;
    }

    public static boolean setLabel(Button button, String string) {
        if (button == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (button.getLabel().equals(string)) {
            return false;
        }
        button.setLabel(string);
        return true;
    }

    public static boolean setLabel(Checkbox checkbox, String string) {
        if (checkbox == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (string == null) {
            string = "";
        }
        if (checkbox.getLabel().equals(string)) {
            return false;
        }
        checkbox.setLabel(string);
        return true;
    }

    public static boolean setEnabled(Component component, boolean bl) {
        if (component == null) {
            PsDebug.warning("missing widget");
            return false;
        }
        if (component.isEnabled() == bl) {
            return false;
        }
        component.setEnabled(bl);
        return true;
    }

    public Panel addLabelComponent(String string, Component component) {
        Panel panel = new Panel(new GridLayout(1, 2));
        panel.add(new Label(string));
        panel.add(component);
        this.add(panel);
        return panel;
    }

    private static void drawLineTop(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
    }

    private static void drawLineRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y);
    }

    private static void drawSunkRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color.brighter());
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 2, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.x + 2, rectangle.y + 1, rectangle.x + rectangle.width - 3, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 3);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(rectangle.x + 1, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 1, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    private static void drawGrooveRect(Graphics graphics, Rectangle rectangle, Color color) {
        graphics.setColor(color);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.drawLine(rectangle.x + rectangle.width - 2, rectangle.y + 2, rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + rectangle.width - 1, rectangle.y + 1);
        graphics.drawLine(rectangle.x + 1, rectangle.y + 1, rectangle.x + 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + 2, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + 2, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
    }

    public void drawText(Graphics graphics, Point point, String string) {
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        graphics.drawString(string, point.x, point.y);
    }

    public static void drawBorder(Graphics graphics, int n, Rectangle rectangle) {
        switch (n) {
            case 4: {
                PsPanel.drawLineTop(graphics, rectangle, Color.gray);
                break;
            }
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle, Color.gray);
                break;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle, Color.black);
                break;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle, Color.darkGray);
            }
        }
    }

    public static void drawBorder(Graphics graphics, int n, Rectangle rectangle, Color color) {
        switch (n) {
            case 4: {
                PsPanel.drawLineTop(graphics, rectangle, color);
                break;
            }
            case 1: {
                PsPanel.drawLineRect(graphics, rectangle, color);
                break;
            }
            case 2: {
                PsPanel.drawSunkRect(graphics, rectangle, color);
                break;
            }
            case 3: {
                PsPanel.drawGrooveRect(graphics, rectangle, color);
            }
        }
    }

    public void drawBorder(Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(this.getSize());
        PsPanel.drawBorder(graphics, n, rectangle);
    }

    public static void drawBorder(Component component, Graphics graphics, int n) {
        Rectangle rectangle = new Rectangle(component.getSize());
        PsPanel.drawBorder(graphics, n, rectangle);
    }

    public void setBorderType(int n) {
        this.m_borderType = n;
    }

    public void setOutOfDate(boolean bl) {
        this.m_bOutOfDate = bl;
    }

    public void paint(Graphics graphics) {
        if (this.m_bOutOfDate && this.m_parent != null) {
            this.update(this.m_parent);
            this.m_bOutOfDate = false;
        }
        if (this.m_image == null) {
            if (this.m_backColor != null) {
                // empty if block
            }
            super.paint(graphics);
        } else if (this.m_image != null) {
            Dimension dimension = super.getSize();
            Color color = this.getBackground();
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = this.m_image.getWidth(null);
            int n2 = this.m_image.getHeight(null);
            int n3 = Math.max(0, dimension.width - n >> 1);
            int n4 = Math.max(0, dimension.height - n2 >> 1);
            graphics.drawImage(this.m_image, n3, n4, n, n2, this);
            super.paint(graphics);
        }
        if (this.m_borderType != 0) {
            this.drawBorder(graphics, this.m_borderType);
        }
    }

    public void update(Graphics graphics) {
        if (this.m_image != null) {
            this.paint(graphics);
            return;
        }
        super.update(graphics);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PsLine
    extends Canvas {
        private int m_orient = 0;
        private int m_size = 1 * PsConfig.getMonitorScale();
        private Dimension m_preferredLineSize;

        public PsLine(int n) {
            this.m_size = n * PsConfig.getMonitorScale();
            this.m_preferredLineSize = new Dimension(10, 10);
            this.setSize(this.m_preferredLineSize);
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            Dimension dimension = this.getSize();
            int n = 0;
            int n2 = 0;
            int n3 = n + dimension.width;
            int n4 = n2 + dimension.height;
            if (this.m_orient == 0) {
                int n5 = n2 + n4 - this.m_size >> 1;
                graphics.setColor(new Color(Math.max(color.getRed() - 64, 0), Math.max(color.getGreen() - 64, 0), Math.max(color.getBlue() - 64, 0)));
                graphics.drawLine(n + 1, n5, n3 - 1, n5);
                if (this.m_size > 0) {
                    graphics.setColor(color);
                    for (int i = 1; i < this.m_size; ++i) {
                        graphics.drawLine(n + 1, n5 + i, n3 - 1, n5 + i);
                    }
                    graphics.setColor(new Color(Math.min(color.getRed() + 32, 255), Math.min(color.getGreen() + 32, 255), Math.min(color.getBlue() + 32, 255)));
                    graphics.drawLine(n + 1, n5 + this.m_size, n3 - 1, n5 + this.m_size);
                    graphics.setColor(color2);
                }
            } else if (this.m_orient == 1) {
                int n6 = n + n3 - this.m_size >> 1;
                graphics.setColor(new Color(Math.max(color.getRed() - 64, 0), Math.max(color.getGreen() - 64, 0), Math.max(color.getBlue() - 64, 0)));
                graphics.drawLine(n6, n2 + 1, n6, n4 - 1);
                if (this.m_size > 0) {
                    graphics.setColor(color);
                    for (int i = 1; i < this.m_size; ++i) {
                        graphics.drawLine(n6 + i, n2 + 1, n6 + i, n4 - 1);
                    }
                    graphics.setColor(new Color(Math.min(color.getRed() + 32, 255), Math.min(color.getGreen() + 32, 255), Math.min(color.getBlue() + 32, 255)));
                    graphics.drawLine(n6 + this.m_size, n2 + 1, n6 + this.m_size, n4 - 1);
                    graphics.setColor(color2);
                }
            } else {
                int n7 = n + n3 - this.m_size >> 1;
                Color color3 = new Color(Math.min(color.getRed() + 32, 255), Math.min(color.getGreen() + 32, 255), Math.min(color.getBlue() + 32, 255));
                Color color4 = new Color(Math.max(color.getRed() - 64, 0), Math.max(color.getGreen() - 64, 0), Math.max(color.getBlue() - 64, 0));
                graphics.setColor(color3);
                graphics.drawLine(n7, n2 + 1, n7 + 3, n2 + 1);
                graphics.setColor(color4);
                graphics.drawLine(n7, n4 - 1, n7 + 3, n4 - 1);
                graphics.setColor(color3);
                graphics.drawLine(n7, n2 + 1, n7, n4 - 1);
                graphics.drawLine(n7 + 2, n2 + 1, n7 + 2, n4 - 1);
                graphics.setColor(color4);
                graphics.drawLine(n7 + 1, n2 + 1, n7 + 1, n4 - 1);
                graphics.drawLine(n7 + 3, n2 + 1, n7 + 3, n4 - 1);
            }
        }

        public void setOrientation(int n) {
            this.m_orient = n;
            if (this.m_orient == 1 || this.m_orient == 2) {
                this.m_preferredLineSize = new Dimension(7, 20);
            }
        }

        public Dimension getPreferredSize() {
            return this.m_preferredLineSize;
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }
}

