/*
 * Decompiled with CFR 0.152.
 */
package jv.object;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import jv.object.PsConfig;
import jv.object.PsConsole;
import jv.object.PsPanel;

public final class PsDebug
implements Runnable {
    public static final boolean STATUS = true;
    public static final boolean MESSAGE = true;
    public static final boolean NOTIFY = true;
    public static final boolean WARNING = true;
    public static final boolean ERROR = true;
    public static final boolean DEBUG = true;
    public static final boolean MEMORY = false;
    public static boolean PROFILE = false;
    protected static PsPanel m_pStatus;
    protected static Label m_lStatus;
    protected static String m_status;
    protected static String m_statusSave;
    protected static PsConsole m_console;
    protected static Rectangle m_consoleSize;
    protected static boolean m_bMessage;
    protected static boolean m_bNotify;
    protected static boolean m_bWarning;
    protected static boolean m_bError;
    protected static boolean m_bDebug;
    protected static final boolean m_bTrace = false;
    private static StringBuffer m_messageBuffer;
    private static long m_flushInterval;
    private static transient Thread m_thread;
    private static transient Thread m_threadStatus;
    public static final int MAX_MESSAGE_LENGTH = 50000;
    private static final int MSG_MESSAGE = 1;
    private static final int MSG_NOTIFY = 2;
    private static final int MSG_WARNING = 3;
    private static final int MSG_ERROR = 4;
    private static int m_numBeeps;
    private static int m_maxNumBeeps;
    protected static boolean m_bRunning;
    protected static int m_remainTime;
    protected static long m_initTime;
    protected static long m_currTime;
    private static long m_currMemory;

    public static PsConsole getConsole() {
        if (m_console == null && PsConfig.getFrame() != null) {
            m_console = new PsConsole(PsConfig.getFrame());
            PsDebug.flushMessages();
        }
        return m_console;
    }

    public static Panel getStatusPanel() {
        if (m_pStatus == null) {
            m_pStatus = new PsPanel();
            m_pStatus.setBackground(SystemColor.menu);
            m_pStatus.setBorderType(3);
            m_lStatus = new Label();
            m_pStatus.add(m_lStatus);
            PsDebug.showStatus("");
        }
        return m_pStatus;
    }

    public static synchronized void disposeConsole() {
        if (m_console != null) {
            m_console.stop();
            m_console.dispose();
            m_console = null;
            m_thread = null;
            m_messageBuffer = null;
        }
        m_bMessage = true;
        m_bNotify = true;
        m_bWarning = true;
        m_bError = true;
        m_bDebug = true;
    }

    public static void setConsole(PsConsole psConsole) {
        m_console = psConsole;
    }

    public static boolean hasConsole() {
        return m_console != null;
    }

    public static Rectangle getConsoleSize() {
        return m_consoleSize;
    }

    public static boolean isMessage() {
        return m_bMessage;
    }

    public static void setMessage(boolean bl) {
        m_bMessage = bl;
    }

    public static boolean isNotify() {
        return m_bNotify;
    }

    public static synchronized void setNotify(boolean bl) {
        m_bNotify = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static boolean isWarning() {
        return m_bWarning;
    }

    public static synchronized void setWarning(boolean bl) {
        m_bWarning = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static boolean isError() {
        return m_bError;
    }

    public static synchronized void setError(boolean bl) {
        m_bError = bl;
        if (PsDebug.hasConsole()) {
            PsDebug.getConsole().update();
        }
    }

    public static boolean isDebug() {
        return m_bDebug;
    }

    public static void setDebug(boolean bl) {
        m_bDebug = bl;
    }

    public static long getFlushInterval() {
        return m_flushInterval;
    }

    public static boolean hasMessages() {
        return m_messageBuffer != null;
    }

    protected static final synchronized void append(String string) {
        if (m_messageBuffer == null) {
            m_messageBuffer = new StringBuffer();
        }
        m_messageBuffer.append(string);
        if (PsDebug.hasConsole() && m_thread == null) {
            m_thread = new Thread((Runnable)m_console, PsConfig.getProgram() + ": " + PsConfig.getMessage(12010));
            m_thread.start();
        }
    }

    public static final synchronized void flushMessages() {
        m_thread = null;
        if (m_messageBuffer == null) {
            return;
        }
        if (PsDebug.hasConsole()) {
            m_console.append(m_messageBuffer);
            m_messageBuffer = null;
        }
    }

    public static final synchronized void popStatus() {
        if (m_bRunning) {
            return;
        }
        if (m_statusSave == null) {
            return;
        }
        PsDebug.showStatus(m_statusSave);
    }

    public static final synchronized void pushStatus(String string) {
        if (string == null) {
            return;
        }
        String string2 = m_status;
        PsDebug.showStatus(string);
        m_statusSave = string2;
    }

    public static final synchronized void pushStatus(String string, int n) {
        if (string == null) {
            return;
        }
        if (m_bRunning) {
            String string2 = m_statusSave;
            PsDebug.showStatus(string);
            m_statusSave = string2;
            return;
        }
        PsDebug.pushStatus(string);
        m_remainTime = n;
        m_threadStatus = new Thread((Runnable)new PsDebug(), PsConfig.getProgram() + ": " + PsConfig.getMessage(true, 12000, "status message"));
        m_threadStatus.start();
        m_bRunning = true;
    }

    public void run() {
        while (m_bRunning) {
            try {
                int n = m_remainTime;
                m_remainTime = 0;
                Thread.sleep(1000 * n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (m_remainTime > 0) continue;
            m_bRunning = false;
            PsDebug.popStatus();
            break;
        }
    }

    protected void stop() {
        m_bRunning = false;
    }

    public static final synchronized void showStatus(String string) {
        Applet applet;
        if (string == null) {
            return;
        }
        m_statusSave = null;
        m_status = string;
        if (m_lStatus != null) {
            m_lStatus.setText(m_status);
        }
        if (!PsConfig.isApplication() && (applet = PsConfig.getApplet()) != null && applet.getAppletContext() != null) {
            applet.showStatus(m_status);
        }
    }

    public static final synchronized void message(String string) {
        PsDebug.message(string, true);
    }

    public static final synchronized void messageWithoutNewline(String string) {
        PsDebug.messageWithoutNewline(string, true);
    }

    public static final synchronized void message(String string, boolean bl) {
        PsDebug.messageWithoutNewline(string + "\n", bl);
    }

    public static final synchronized void messageWithoutNewline(String string, boolean bl) {
        if (!m_bMessage) {
            return;
        }
        if (string == null) {
            return;
        }
        PsDebug.append(string);
        if (bl) {
            if (!PsDebug.hasConsole()) {
                if (PsDebug.getConsole() == null) {
                    System.out.println("PsDebug.error: " + PsConfig.getMessage(38000));
                    System.out.println("\t" + PsConfig.getMessage(38001) + ": " + string);
                    new Throwable().printStackTrace();
                    return;
                }
                m_console.setLocation(PsDebug.m_consoleSize.x, PsDebug.m_consoleSize.y);
                m_console.setSize(PsDebug.m_consoleSize.width, PsDebug.m_consoleSize.height);
            }
            if (PsDebug.hasConsole() && !m_console.isShowing()) {
                ((Component)m_console).setVisible(true);
            }
        }
    }

    public static final synchronized void notify(String string) {
        if (!m_bNotify) {
            return;
        }
        if (string == null) {
            return;
        }
        PsDebug.append(PsConfig.getMessage(12011) + ": " + string + "\n\t" + PsDebug.getMethodName(null, 2) + "\n");
    }

    public static final synchronized void warning(String string) {
        if (!m_bWarning) {
            return;
        }
        PsDebug.showStatus(PsConfig.getMessage(12012) + ", " + string);
        PsDebug.warning(PsConfig.getMessage(12012) + ": " + string + "\n\t" + PsDebug.getMethodName(null, 3), null);
    }

    public static final synchronized void warning(Exception exception, String string) {
        if (!m_bWarning) {
            return;
        }
        PsDebug.showStatus(PsConfig.getMessage(12012) + ", " + string);
        PsDebug.warning(PsConfig.getMessage(12012) + ": " + string + "\n\t" + PsDebug.getMethodName(exception, 3), null);
    }

    public static final synchronized void warning(String string, Object object) {
        if (!m_bWarning) {
            return;
        }
        if (string == null) {
            return;
        }
        if (object != null) {
            PsDebug.showStatus(PsConfig.getMessage(12012) + ", " + string);
            string = PsConfig.getMessage(12012) + ": " + string + "\n\t" + PsDebug.getMethodName(null, 3);
        }
        PsDebug.beep(string);
        PsDebug.append(string + "\n");
        if (object != null) {
            PsDebug.append("\n\tObject = " + object.toString() + "\n");
        }
    }

    private static final String getMethodName(Exception exception, int n) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (exception != null) {
            exception.printStackTrace(printWriter);
        } else {
            new Throwable().printStackTrace(printWriter);
        }
        String string = stringWriter.toString();
        if (string == null) {
            return "";
        }
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = string.indexOf("PsDebug.message");
                break;
            }
            case 2: {
                n2 = string.indexOf("PsDebug.notify");
                break;
            }
            case 3: {
                n2 = string.indexOf("PsDebug.warning");
                break;
            }
            case 4: {
                n2 = string.indexOf("PsDebug.error");
                break;
            }
        }
        if (n2 == -1) {
            return string;
        }
        int n3 = string.indexOf("at ", n2);
        if (n3 == -1) {
            return "";
        }
        int n4 = string.indexOf(")", n3);
        if (n4 == -1) {
            return "";
        }
        return string.substring(n3, n4 + 1);
    }

    public static final synchronized void error(String string) {
        if (!m_bError) {
            return;
        }
        PsDebug.showStatus(PsConfig.getMessage(12013) + ", " + string);
        PsDebug.error(PsConfig.getMessage(12013) + ": " + string + "\n\t" + PsDebug.getMethodName(null, 4), null);
    }

    public static final synchronized void error(String string, Object object) {
        if (!m_bError) {
            return;
        }
        if (string == null) {
            return;
        }
        if (object != null) {
            PsDebug.showStatus(PsConfig.getMessage(12013) + ", " + string);
            string = PsConfig.getMessage(12013) + ": " + string + "\n\t" + PsDebug.getMethodName(null, 4);
        }
        PsDebug.beep(string);
        PsDebug.append(string + "\n");
        if (!PsDebug.hasConsole()) {
            if (PsDebug.getConsole() != null) {
                ((Component)m_console).setBounds(m_consoleSize);
            } else {
                System.out.println("PsDebug.error: " + PsConfig.getMessage(38000));
                System.out.println("\t" + PsConfig.getMessage(38001) + ": " + string);
                new Throwable().printStackTrace();
                return;
            }
        }
        if (!m_console.isShowing()) {
            ((Component)m_console).setVisible(true);
        }
        if (object != null) {
            PsDebug.append("\n\tObject = " + object.toString() + "\n");
        }
    }

    public static int getMaxNumBeeps() {
        return m_maxNumBeeps;
    }

    public static void setMaxNumBeeps(int n) {
        m_maxNumBeeps = n;
    }

    public static void beep(String string) {
        if (m_numBeeps++ >= m_maxNumBeeps) {
            return;
        }
        System.out.println(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit != null) {
            toolkit.beep();
        }
    }

    public static void initTime() {
        m_currTime = m_initTime = new Date().getTime();
    }

    public static long getTimeUsed() {
        long l = new Date().getTime();
        return l - m_initTime;
    }

    public static long getTimeIncr() {
        long l = new Date().getTime();
        long l2 = l - m_currTime;
        m_currTime = l;
        return l2;
    }

    public static void initMemory() {
        PsConfig.runGC();
        m_currMemory = PsDebug.getMemoryTotal();
    }

    public static long getMemoryTotal() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static long getMemoryIncr() {
        long l = PsDebug.getMemoryTotal();
        long l2 = l - m_currMemory;
        m_currMemory = l;
        return l2;
    }

    public static void outOfMemory(OutOfMemoryError outOfMemoryError) {
        long l = PsDebug.getMemoryTotal();
        System.gc();
        PsConfig.runGC(4, 10);
        String string = "Out of memory occurred! Try using command line parameter\n  java -Xmx256m or -Xmx512m or higher\nto increase the maximal memory available to the virtual machine.";
        PsDebug.error(string);
        if (PsDebug.getConsole() != null) {
            ((Component)m_console).setBounds(m_consoleSize);
            if (!m_console.isShowing()) {
                ((Component)m_console).setVisible(true);
            }
        }
        new Throwable().printStackTrace();
        System.out.println("Current maximal memory of VM = " + String.valueOf(l) + " byte");
    }

    static {
        m_consoleSize = new Rectangle(10, 10, 500, 350);
        m_bMessage = true;
        m_bNotify = false;
        m_bWarning = true;
        m_bError = true;
        m_bDebug = true;
        m_messageBuffer = null;
        m_flushInterval = 500L;
        m_thread = null;
        m_threadStatus = null;
        m_numBeeps = 0;
        m_maxNumBeeps = 10;
        m_bRunning = false;
        m_currMemory = 0L;
    }
}

