/*
 * Decompiled with CFR 0.152.
 */
package jv.number;

import java.awt.FontMetrics;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Vector;
import jv.object.PsDebug;

public abstract class PuString {
    public static boolean m_bConvertDoubleToFloat = false;

    public static String[][] clone(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[][] stringArray2 = (String[][])stringArray.clone();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringArray2[i] = (String[])stringArray[i].clone();
        }
        return stringArray2;
    }

    public static int fromCharSet(String string, String string2, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && string2.indexOf(string.charAt(n2)) != -1; ++n2) {
        }
        return n2 - n;
    }

    public static int notFromCharSet(String string, String string2, int n) {
        int n2;
        for (n2 = n; n2 < string.length() && string2.indexOf(string.charAt(n2)) == -1; ++n2) {
        }
        return n2 - n;
    }

    public static boolean matchPattern(String string, String string2) {
        int n = 0;
        while (true) {
            int n2 = 0;
            while (true) {
                boolean bl;
                boolean bl2 = n2 >= string.length();
                boolean bl3 = bl = n >= string2.length() || string2.charAt(n) == '|';
                if (bl2 && bl) {
                    return true;
                }
                if (bl2 || bl) break;
                if (string2.charAt(n) != '?') {
                    if (string2.charAt(n) == '*') {
                        ++n;
                        for (int i = string.length(); i >= n2; --i) {
                            if (!PuString.matchPattern(string2.substring(n), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (string2.charAt(n) != string.charAt(n2)) break;
                }
                ++n;
                ++n2;
            }
            if ((n = string2.indexOf(124, n)) == -1) {
                return false;
            }
            ++n;
        }
    }

    public static int commonInitials(String string, String string2) {
        int n;
        for (n = 0; n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n); ++n) {
        }
        return n;
    }

    public static int containsChars(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String bracketedString(String string, char c, char c2) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(c);
        int n2 = string.lastIndexOf(c2);
        if (n == -1 && n2 == -1) {
            return null;
        }
        if (n == -1 && n2 != -1 || n != -1 && n2 == -1) {
            PsDebug.warning("missing delimiter in string.");
            return null;
        }
        if (n == n2 - 1) {
            return "";
        }
        return string.substring(n + 1, n2);
    }

    public static String[] splitString(String string, char c) {
        if (string == null) {
            return null;
        }
        int n = PuString.numSplitStrings(string, c);
        if (n == 0) {
            return new String[]{string};
        }
        boolean bl = c == ' ';
        String[] stringArray = new String[n];
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string.indexOf(c, n2 + 1);
            if (n4 == -1) {
                stringArray[n - 1] = string.substring(n2 + 1);
                break;
            }
            if (bl && n4 == n2 + 1) {
                n2 = n4;
                continue;
            }
            stringArray[n3++] = string.substring(n2 + 1, n4);
            n2 = n4;
        }
        return stringArray;
    }

    public static int numSplitStrings(String string, char c) {
        int n;
        if (string == null) {
            return 0;
        }
        boolean bl = c == ' ';
        int n2 = string.length();
        while (string.lastIndexOf(c) == n2) {
            string = string.substring(0, --n2);
        }
        int n3 = 1;
        int n4 = -1;
        while ((n = string.indexOf(c, n4 + 1)) != -1) {
            if (bl && n == n4 + 1) {
                n4 = n;
                continue;
            }
            n4 = n;
            ++n3;
        }
        return n3;
    }

    public static String[] splitString(String string, int n) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxCharsPerString=" + n + "<=0");
        }
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        string = PuString.replaceTab(string, 4);
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        do {
            String string2;
            if (string.length() <= n && string.indexOf(10) == -1) {
                vector.addElement(string);
                bl = true;
                continue;
            }
            n3 = -1;
            int n4 = -1;
            for (int i = 0; i < n; ++i) {
                n2 = string.charAt(i);
                if (n2 == 10) {
                    n4 = i;
                    break;
                }
                if (n2 != 32) continue;
                n3 = i;
            }
            if (n4 == -1) {
                if (n3 == -1) {
                    n3 = n - 1;
                }
                string2 = string.substring(0, n3 + 1);
                if ((string = string.substring(n3 + '\u0001', string.length())).length() > 0 && string.charAt(0) == '\n') {
                    string = string.substring(1, string.length());
                }
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1, string.length());
                }
            } else {
                string2 = string.substring(0, n4);
                string = string.length() > n4 + 1 ? string.substring(n4 + '\u0001', string.length()) : "";
            }
            while (string2.endsWith(" ")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            vector.addElement(string2);
        } while (!bl);
        n3 = vector.size();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = vector.elementAt(n2).toString();
        }
        return stringArray;
    }

    public static String[] splitString(String string, int n, FontMetrics fontMetrics) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            throw new IllegalArgumentException("argument maxWidth=" + n + "<=0");
        }
        if (fontMetrics == null) {
            throw new IllegalArgumentException("argument fm=null");
        }
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
            string = string.substring(0, string.length() - 1);
        }
        while (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        string = PuString.replaceTab(string, 4);
        Vector<String> vector = new Vector<String>();
        while (true) {
            String string2;
            if (fontMetrics.stringWidth(string) <= n && string.indexOf(10) == -1) break;
            n3 = -1;
            int n4 = -1;
            int n5 = 0;
            while (fontMetrics.stringWidth(string.substring(0, n5)) < n) {
                n2 = string.charAt(n5);
                if (n2 == 10) {
                    n4 = n5;
                    break;
                }
                if (n2 == 32) {
                    n3 = n5;
                }
                ++n5;
            }
            if (n4 == -1) {
                if (n3 == -1) {
                    n3 = n5 - 1;
                }
                string2 = string.substring(0, n3 + 1);
                if ((string = string.substring(n3 + 1, string.length())).length() > 0 && string.charAt(0) == '\n') {
                    string = string.substring(1, string.length());
                }
                while (string.length() > 0 && string.charAt(0) == ' ') {
                    string = string.substring(1, string.length());
                }
            } else {
                string2 = string.substring(0, n4);
                string = string.length() > n4 + 1 ? string.substring(n4 + 1, string.length()) : "";
            }
            while (string2.endsWith(" ")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            vector.addElement(string2);
        }
        vector.addElement(string);
        n3 = vector.size();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = vector.elementAt(n2).toString();
        }
        return stringArray;
    }

    public static String replaceTab(String string, int n) {
        if (string == null) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        int n2 = string.indexOf(9);
        if (n2 == -1) {
            return string;
        }
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + " ";
        }
        while (n2 != -1) {
            string = string.substring(0, n2) + string2 + string.substring(n2 + 1, string.length());
            n2 = string.indexOf(9);
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null || string2.equals("")) {
            return null;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string2.length();
        int n3 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n3, n) + string3);
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }

    public static String mergeStrings(String[] stringArray, char c) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return "";
        }
        String string = new String(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            string = stringArray[i] != null ? string + c + stringArray[i] : string + c;
        }
        return string;
    }

    public static String mergeStrings(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return "";
        }
        String string2 = new String(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = stringArray[i] != null ? string2 + string + stringArray[i] : string2 + string;
        }
        return string2;
    }

    public static void sort(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (stringArray[i].compareTo(stringArray[j]) <= 0) continue;
                String string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
    }

    public static String[] sort(String[] stringArray, int[] nArray) {
        int n;
        if (stringArray == null || nArray == null) {
            PsDebug.warning("missing argument.");
            return null;
        }
        if (stringArray.length != nArray.length) {
            PsDebug.warning("argument arrays have different size.");
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < stringArray2.length - 1; ++n) {
            stringArray2[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length - 1; ++n) {
            for (int i = n + 1; i < stringArray2.length; ++i) {
                if (stringArray2[n].compareTo(stringArray2[i]) <= 0) continue;
                String string = stringArray2[n];
                stringArray2[n] = stringArray2[i];
                stringArray2[i] = string;
            }
        }
        return stringArray2;
    }

    public static int indexOfString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfStringIgnoreCase(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static String intToString(int n, int n2) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n *= -1;
        }
        if ((double)n >= Math.pow(10.0, n2)) {
            PsDebug.warning("string width too small.");
            n = (int)Math.pow(10.0, n2) - 1;
        }
        String string = Long.toString(n);
        if (bl) {
            string = "-" + string;
        }
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    public static String toString(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            d = Double.MAX_VALUE;
        } else if (d == Double.NEGATIVE_INFINITY) {
            d = -1.7976931348623157E308;
        }
        String string = Double.toString(d);
        if (0.001 <= d && d <= 1.0E7) {
            return string;
        }
        int n = (string = string.toLowerCase()).indexOf("e");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = Integer.valueOf(string3);
        double d2 = Double.valueOf(string2) * Math.pow(10.0, n2);
        int n3 = string2.length();
        int n4 = n3 - string2.indexOf(".");
        int n5 = Math.min(15, Math.max(1, n4 - n2));
        string = PuString.doubleToString(d2, n5, Math.max(n5 + 3, n3 + Math.abs(n2)));
        string = string.substring(string.lastIndexOf(" ") + 1, string.length());
        return string;
    }

    public static String toString(double d, int n) {
        String string;
        if (n < 0) {
            PsDebug.warning("Digits must be >0.");
            return "";
        }
        switch (n) {
            case 0: {
                string = "0.";
                break;
            }
            case 1: {
                string = "0.#";
                break;
            }
            case 2: {
                string = "0.##";
                break;
            }
            case 3: {
                string = "0.###";
                break;
            }
            case 4: {
                string = "0.####";
                break;
            }
            case 5: {
                string = "0.#####";
                break;
            }
            default: {
                string = "0.";
                for (int i = 0; i < n; ++i) {
                    string = string + '#';
                }
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat(string, new DecimalFormatSymbols(Locale.ENGLISH));
        return decimalFormat.format(d);
    }

    public static String toString(double[] dArray, boolean bl) {
        return PuString.toString(dArray, m_bConvertDoubleToFloat, bl);
    }

    public static String toString(double[] dArray, boolean bl, boolean bl2) {
        int n;
        if (dArray == null || dArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = null;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == Double.POSITIVE_INFINITY) {
                dArray[n] = Double.MAX_VALUE;
                continue;
            }
            if (dArray[n] != Double.NEGATIVE_INFINITY) continue;
            dArray[n] = -1.7976931348623157E308;
        }
        if (!bl2) {
            stringBuffer = bl ? new StringBuffer(PuString.toString((float)dArray[0])) : new StringBuffer(PuString.toString(dArray[0]));
            for (n = 1; n < dArray.length; ++n) {
                if (bl) {
                    stringBuffer.append(" " + PuString.toString((float)dArray[n]));
                    continue;
                }
                stringBuffer.append(" " + PuString.toString(dArray[n]));
            }
        } else {
            stringBuffer = bl ? new StringBuffer(String.valueOf((float)dArray[0])) : new StringBuffer(String.valueOf(dArray[0]));
            for (n = 1; n < dArray.length; ++n) {
                if (bl) {
                    stringBuffer.append(" " + String.valueOf((float)dArray[n]));
                    continue;
                }
                stringBuffer.append(" " + String.valueOf(dArray[n]));
            }
        }
        return stringBuffer.toString();
    }

    public static String toString(double[] dArray) {
        return PuString.toString(dArray, m_bConvertDoubleToFloat, true);
    }

    public static String toString(float f) {
        if (f == Float.POSITIVE_INFINITY) {
            f = Float.MAX_VALUE;
        } else if (f == Float.NEGATIVE_INFINITY) {
            f = -3.4028235E38f;
        }
        String string = Float.toString(f);
        if (0.001 <= (double)f && (double)f <= 1.0E7) {
            return string;
        }
        int n = (string = string.toLowerCase()).indexOf("e");
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n2 = Integer.valueOf(string3);
        float f2 = (float)((double)Float.valueOf(string2).floatValue() * Math.pow(10.0, n2));
        int n3 = string2.length();
        int n4 = n3 - string2.indexOf(".");
        int n5 = Math.min(8, Math.max(1, n4 - n2));
        string = PuString.doubleToString(f2, n5, Math.max(n5 + 3, n3 + Math.abs(n2)));
        string = string.substring(string.lastIndexOf(" ") + 1, string.length());
        return string;
    }

    public static String toString(float[] fArray, boolean bl) {
        if (fArray == null || fArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = null;
        if (!bl) {
            stringBuffer = new StringBuffer(PuString.toString(fArray[0]));
            for (int i = 1; i < fArray.length; ++i) {
                stringBuffer.append(" " + PuString.toString(fArray[i]));
            }
        } else {
            stringBuffer = new StringBuffer(String.valueOf(fArray[0]));
            for (int i = 1; i < fArray.length; ++i) {
                stringBuffer.append(" " + String.valueOf(fArray[i]));
            }
        }
        return stringBuffer.toString();
    }

    public static String toString(float[] fArray) {
        return PuString.toString(fArray, false);
    }

    public static String doubleToString(double d, int n, int n2) {
        if (n < 1 || n2 - n < 3) {
            return "";
        }
        long l = Math.round(d * Math.pow(10.0, n));
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l *= -1L;
        }
        if ((double)l >= Math.pow(10.0, n2 - 2)) {
            l = (long)Math.pow(10.0, n2 - 2) - 1L;
        }
        String string = Long.toString(l);
        while (string.length() < n + 1) {
            string = "0" + string;
        }
        if (bl) {
            string = "-" + string;
        }
        while (string.length() < n2 - 1) {
            string = " " + string;
        }
        string = string.substring(0, n2 - n - 1) + "." + string.substring(n2 - n - 1);
        return string;
    }

    public static String doubleToString(double d, int n) {
        int n2;
        if (n < 1) {
            return "";
        }
        String string = Double.toString(d);
        int n3 = string.indexOf("E");
        if (n3 == -1) {
            n2 = 0;
        } else {
            n2 = Integer.valueOf(string.substring(n3 + 1));
            string = string.substring(0, n3);
        }
        if (string.charAt(0) != '-') {
            string = " " + string;
        }
        n3 = string.indexOf(".");
        string = string.substring(0, n3) + string.substring(n3 + 1);
        n2 += n3 - 2;
        while (string.length() > 2 && string.charAt(1) == '0') {
            string = string.substring(0, 1) + string.substring(2);
            --n2;
        }
        if (string.charAt(1) == '0') {
            n2 = 0;
        }
        while (string.length() < n + 2) {
            string = string + "0";
        }
        while (string.length() > n + 2 && string.charAt(string.length() - 1) == '0') {
            string = string.substring(0, string.length() - 1);
        }
        if (string.length() > n + 2 && (string = Long.toString(Math.round(Double.valueOf(string.substring(0, n + 2) + "." + string.substring(n + 2))))).charAt(0) != '-') {
            string = " " + string;
        }
        if (string.length() > n + 2) {
            string = string.substring(0, n + 2);
            ++n2;
        }
        if (n2 >= 100) {
            n2 = 99;
            string = string.substring(0, 1);
            while (string.length() < n + 2) {
                string = string + "9";
            }
        }
        if (n2 <= -100) {
            n2 = 0;
            string = " ";
            while (string.length() < n + 2) {
                string = string + "0";
            }
        }
        string = string.substring(0, 2) + "." + string.substring(2) + "E" + Integer.toString(n2);
        if (n2 < 0) {
            n2 *= -1;
        } else {
            string = string.substring(0, n + 4) + "+" + string.substring(n + 4);
        }
        if (n2 < 10) {
            string = string.substring(0, n + 5) + "0" + string.substring(n + 5);
        }
        return string;
    }

    public static String toString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(nArray[0]));
        for (int i = 1; i < nArray.length; ++i) {
            stringBuffer.append(" " + nArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String timeToString(long l) {
        if (l < 0L) {
            return "- " + PuString.timeToString(-l);
        }
        if (l < 1000L) {
            return "" + l + " ms";
        }
        int n = (int)(l % 1000L);
        if ((l = (l - (long)n) / 1000L) < 60L) {
            return "" + l + "." + Math.round((double)n * 0.01) + " s";
        }
        int n2 = (int)(l % 60L);
        if ((l = (l - (long)n2) / 60L) < 60L) {
            String string = n2 < 10 ? "0" + n2 : "" + n2;
            return "" + l + ":" + string + " min";
        }
        int n3 = (int)(l % 60L);
        if ((l = (l - (long)n3) / 60L) < 24L) {
            String string = n3 < 10 ? "0" + n3 : "" + n3;
            return "" + l + ":" + string + " h";
        }
        int n4 = (int)(l % 24L);
        l = (l - (long)n4) / 24L;
        return "" + l + " days, " + n4 + " h";
    }

    public static String millisToString(long l) {
        int n = (int)(l % 1000L);
        int n2 = (int)(l / 1000L) % 60;
        int n3 = (int)(l / 60000L) % 60;
        int n4 = (int)(l / 3600000L);
        String string = n2 + "." + (n < 100 ? "0" : "") + (n < 10 ? "0" : "") + n;
        if (n4 > 0) {
            return "" + n4 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n2 < 10 ? "0" : "") + string + " hours";
        }
        if (n3 > 0) {
            return "" + n3 + ":" + (n2 < 10 ? "0" : "") + string + " minutes";
        }
        return string + " seconds";
    }

    public static String shortCutString(String string, int n) {
        if (n < 6) {
            PsDebug.warning("NumChars must be >= 6.");
            return null;
        }
        int n2 = string.length();
        if (n2 < n) {
            return string;
        }
        return string.substring(0, n - 6) + "..." + string.substring(n2 - 3);
    }
}

