/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.object.PsConfig;
import jv.vecmath.PiVector;

public final class PgFaceStar
extends PiVector {
    protected int m_valence = 0;
    protected PiVector m_elementInd;
    protected PiVector m_neighbourLocInd;

    public PgFaceStar() {
    }

    public PgFaceStar(int n, int n2, int n3) {
        this();
        this.setSize(3);
        this.set(n, n2, n3);
        this.setMaxValence(2);
    }

    public PgFaceStar(int n, int n2, int n3, int n4) {
        this();
        this.setSize(4);
        this.set(n, n2, n3, n4);
        this.setMaxValence(2);
    }

    public void copy(PiVector piVector) {
        if (piVector == null) {
            return;
        }
        this.setSize(piVector.getSize());
        super.copy(piVector);
        if (!(piVector instanceof PgFaceStar)) {
            return;
        }
        PgFaceStar pgFaceStar = (PgFaceStar)piVector;
        this.setValence(pgFaceStar.getValence());
        this.m_elementInd.copy(pgFaceStar.m_elementInd);
        this.m_neighbourLocInd.copy(pgFaceStar.m_neighbourLocInd);
    }

    public Object clone() {
        PgFaceStar pgFaceStar = (PgFaceStar)super.clone();
        if (pgFaceStar == null) {
            return null;
        }
        if (this.m_elementInd != null) {
            pgFaceStar.m_elementInd = (PiVector)this.m_elementInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgFaceStar.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        return pgFaceStar;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\t ******* PgEdgeStar ***********\n");
        stringBuffer.append("\t " + PsConfig.getMessage(33001) + " = " + this.m_valence + "\n");
        if (this.m_valence > 0) {
            int n;
            stringBuffer.append("\t " + PsConfig.getMessage(33002) + " = [" + this.m_elementInd.m_data[0]);
            for (n = 1; n < this.m_valence; ++n) {
                stringBuffer.append(", " + this.m_elementInd.m_data[n]);
            }
            stringBuffer.append("]\n");
            stringBuffer.append("\t " + PsConfig.getMessage(33003) + " = [" + this.m_neighbourLocInd.m_data[0]);
            for (n = 1; n < this.m_valence; ++n) {
                stringBuffer.append(", " + this.m_neighbourLocInd.m_data[n]);
            }
            stringBuffer.append("]\n");
        }
        return stringBuffer.toString();
    }

    public int getValence() {
        return this.m_valence;
    }

    public void setValence(int n) {
        if (this.m_valence == n) {
            return;
        }
        if (n > this.m_valence) {
            this.setMaxValence(n);
        }
        this.m_valence = n;
    }

    protected void setMaxValence(int n) {
        if (n < this.m_valence) {
            this.m_valence = n;
        }
        if (this.m_elementInd == null) {
            this.m_elementInd = new PiVector(n);
        } else {
            this.m_elementInd.setSize(n);
        }
        if (this.m_neighbourLocInd == null) {
            this.m_neighbourLocInd = new PiVector(n);
        } else {
            this.m_neighbourLocInd.setSize(n);
        }
    }

    public void addElement(int n, int n2) {
        this.setValence(this.m_valence + 1);
        this.m_elementInd.m_data[this.m_valence - 1] = n;
        this.m_neighbourLocInd.m_data[this.m_valence - 1] = n2;
    }

    public int getVertexInd(int n) {
        return this.getEntry(n);
    }

    public PiVector getElementInd() {
        return this.m_elementInd;
    }

    public int getElementInd(int n) {
        return this.m_elementInd.m_data[n];
    }

    public void setElementInd(int n, int n2) {
        this.m_elementInd.m_data[n] = n2;
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public int getNeighbourLocInd(int n) {
        return this.m_neighbourLocInd.m_data[n];
    }

    public void setNeighbourLocInd(int n, int n2) {
        this.m_neighbourLocInd.m_data[n] = n2;
    }
}

