/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import jv.geom.PgBndPolygon;
import jv.geom.PgElementSet;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsPanel;
import jv.object.PsUpdateIf;
import jv.objectGui.PsList;

public class PgElementSet_BP
extends PsPanel
implements ActionListener,
ItemListener {
    protected PgElementSet m_elementSet;
    protected PgBndPolygon m_selectedBnd;
    protected TextField m_tNumBnds;
    protected PsPanel m_pVertexIP;
    protected List m_listVisible;
    protected List m_listSelect;
    protected Button m_bSelect;
    protected Button m_bSelectAll;
    protected Button m_bDeleteAll;
    static /* synthetic */ Class class$jv$geom$PgElementSet_BP;

    public PgElementSet_BP() {
        if (this.getClass() == (class$jv$geom$PgElementSet_BP == null ? (class$jv$geom$PgElementSet_BP = PgElementSet_BP.class$("jv.geom.PgElementSet_BP")) : class$jv$geom$PgElementSet_BP)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.setInsetSize(4);
        this.setBorderType(1);
        this.addTitle("");
        Panel panel = new Panel(new GridLayout(1, 2));
        this.add(panel);
        Component component = new Label(PsConfig.getMessage(true, 24000, "Number of Boundaries"));
        panel.add(component);
        this.m_tNumBnds = new TextField("0", 7);
        this.m_tNumBnds.addActionListener(this);
        panel.add(this.m_tNumBnds);
        this.m_pVertexIP = new PsPanel();
        this.add(this.m_pVertexIP);
        this.addLine(1);
        component = new PsPanel();
        ((PsPanel)component).setInsetSize(3);
        this.add(component);
        Panel panel2 = new PsPanel(new GridLayout(1, 2));
        ((PsPanel)panel2).addSubTitle(PsConfig.getMessage(true, 24000, "Visible Boundaries"));
        ((Container)component).add(panel2);
        Panel panel3 = new Panel(new GridLayout(1, 2));
        Panel panel4 = new Panel(new BorderLayout());
        Label label = new Label(PsConfig.getMessage(true, 24000, "Selected Boundary"));
        panel4.add((Component)label, "North");
        this.m_listSelect = new List(5, false);
        this.m_listSelect.addItemListener(this);
        panel4.add((Component)this.m_listSelect, "Center");
        panel3.add(panel4);
        Panel panel5 = new Panel(new BorderLayout());
        Label label2 = new Label(PsConfig.getMessage(true, 24000, "Visible Boundary"));
        panel5.add((Component)label2, "North");
        this.m_listVisible = new PsList(5, true);
        this.m_listVisible.addItemListener(this);
        panel5.add((Component)this.m_listVisible, "Center");
        panel3.add(panel5);
        ((Container)component).add(panel3);
        panel2 = new Panel(new FlowLayout());
        this.add(panel2);
        this.m_bSelect = new Button(PsConfig.getMessage(true, 24000, "Select"));
        this.m_bSelect.addActionListener(this);
        panel2.add(this.m_bSelect);
        this.m_bSelectAll = new Button(PsConfig.getMessage(true, 24000, "Select All"));
        this.m_bSelectAll.addActionListener(this);
        panel2.add(this.m_bSelectAll);
        this.m_bDeleteAll = new Button(PsConfig.getMessage(true, 24000, "Delete All"));
        this.m_bDeleteAll.addActionListener(this);
        panel2.add(this.m_bDeleteAll);
    }

    public void setParent(PsUpdateIf psUpdateIf) {
        super.setParent(psUpdateIf);
        this.m_elementSet = (PgElementSet)psUpdateIf;
        this.m_selectedBnd = null;
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (this.m_elementSet == null) {
            PsDebug.warning("missing elementSet");
            return true;
        }
        if (object == this.m_elementSet) {
            String string;
            int n;
            this.setTitle(PsConfig.getMessage(true, 24000, "Boundaries") + ": " + this.m_elementSet.getName());
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            PsPanel.setText(this.m_tNumBnds, String.valueOf(this.m_elementSet.getNumBoundaries()));
            PgBndPolygon pgBndPolygon = this.m_elementSet.getSelectedBndPolygon();
            if (pgBndPolygon != this.m_selectedBnd) {
                this.m_pVertexIP.removeAll();
                this.m_selectedBnd = pgBndPolygon;
                if (this.m_selectedBnd != null) {
                    this.m_pVertexIP.addLine(1);
                    this.m_pVertexIP.add(this.m_selectedBnd.getInfoPanel());
                }
                this.validate();
            }
            boolean bl = true;
            int n2 = this.m_elementSet.getNumBoundaries();
            int n3 = this.m_listVisible.getItemCount();
            if (n3 != n2) {
                bl = false;
            } else {
                for (n = 0; n < n2; ++n) {
                    string = this.m_listVisible.getItem(n);
                    if (string != null && string.equals(pgBndPolygonArray[n].getName())) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                if (n3 > 0) {
                    this.m_listVisible.removeAll();
                    this.m_listSelect.removeAll();
                }
                for (n = 0; n < n2; ++n) {
                    string = pgBndPolygonArray[n].getName();
                    this.m_listVisible.add(string);
                    this.m_listSelect.add(string);
                }
            }
            for (n = 0; n < n2; ++n) {
                if (pgBndPolygonArray[n].isVisible() != this.m_listVisible.isIndexSelected(n)) {
                    if (pgBndPolygonArray[n].isVisible()) {
                        this.m_listVisible.select(n);
                    } else {
                        this.m_listVisible.deselect(n);
                    }
                }
                if (pgBndPolygonArray[n] != this.m_selectedBnd) continue;
                this.m_listSelect.select(n);
            }
            return true;
        }
        return super.update(object);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        PsDebug.notify("entered");
        if (object == this.m_listVisible) {
            int n = (Integer)itemEvent.getItem();
            PsDebug.notify("selected index = " + n + " in listVisible");
            if (n < 0 || this.m_listVisible.getItemCount() <= n) {
                return;
            }
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            switch (itemEvent.getStateChange()) {
                case 1: {
                    if (pgBndPolygonArray[n].isVisible()) break;
                    pgBndPolygonArray[n].setVisible(true);
                    break;
                }
                case 2: {
                    if (!pgBndPolygonArray[n].isVisible()) break;
                    pgBndPolygonArray[n].setVisible(false);
                }
            }
            pgBndPolygonArray[n].update(pgBndPolygonArray[n]);
        } else if (object == this.m_listSelect) {
            int n = (Integer)itemEvent.getItem();
            if (n < 0 || this.m_listSelect.getItemCount() <= n) {
                return;
            }
            PgBndPolygon[] pgBndPolygonArray = this.m_elementSet.getBoundaries();
            this.m_elementSet.selectBndPolygon(pgBndPolygonArray[n]);
            this.m_elementSet.update(pgBndPolygonArray[n]);
        } else {
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        PsDebug.notify("entered");
        if (this.m_elementSet == null) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.m_bSelect) {
            this.m_elementSet.update(this);
        } else if (object == this.m_bSelectAll) {
            this.m_elementSet.update(this);
        } else if (object == this.m_bDeleteAll) {
            this.m_elementSet.removeBoundaries();
            this.m_elementSet.update(this.m_elementSet);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

