/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jv.geom.PgBndConstraint;
import jv.geom.PgBndPolygon;
import jv.geom.PgEdgeStar;
import jv.geom.PgPointSet;
import jv.geom.PgPolygon;
import jv.geom.PgTexture;
import jv.geom.PgUtil;
import jv.geom.PgVectorField;
import jv.number.PdColor;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.project.PgJvxSrc;
import jv.project.PvGeometryIf;
import jv.project.PvPickEvent;
import jv.rsrc.PsJavaView;
import jv.vecmath.P_Vector;
import jv.vecmath.PbVector;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuData;
import jv.vecmath.PuVectorGeom;

public class PgElementSet
extends PgPointSet {
    protected boolean m_bShowEdgeLabels;
    protected boolean m_bShowElementLabels;
    protected int m_dimOfElements;
    protected int m_maxDimOfElements = 300;
    protected int m_numElements;
    protected int m_maxNumElements;
    protected PiVector[] m_element;
    protected Color[] m_elementColor;
    protected Color[] m_elementBackColor;
    protected PdVector[] m_elementNormal;
    protected PiVector[] m_neighbour;
    protected PgBndPolygon[] m_bndList;
    protected PgBndPolygon m_selectedBndPolygon;
    protected boolean m_bShowBoundaries;
    protected boolean m_bShowTaggedBoundaries;
    protected PdColor m_globalBndColor;
    protected PdColor m_globalBndTagColor;
    protected PuDouble m_globalBndSize;
    protected boolean m_bConforming;
    protected PiVector[] m_elementSaved;
    protected int m_savedNumVertices;
    protected boolean m_bShowElementTexture;
    protected PdVector[][] m_elementTexture;
    protected boolean m_bShowSilhouette;
    protected boolean m_bEnableEdges;
    protected int m_numEdgeStars;
    protected PgEdgeStar[] m_edgeStar;
    protected Color[] m_edgeColor;
    protected PdVector m_edgeSize;
    protected PiVector[] m_elementEdge;
    protected boolean m_bShowEdges;
    protected boolean m_bShowTaggedEdges;
    protected boolean m_bShowEdgeColors;
    protected boolean m_bShowEdgeColorFromElements;
    protected boolean m_bShowEdgeColorFromVertices;
    protected PdColor m_globalEdgeColor;
    protected PdColor m_globalEdgeTagColor;
    protected PuDouble m_globalEdgeSize;
    protected boolean m_bShowEdgeSizes;
    protected PuDouble m_creaseAngle;
    protected boolean m_bShowElements;
    protected boolean m_bShowTaggedElements;
    protected boolean m_bShowBackface;
    protected boolean m_bShowElementNormals;
    protected boolean m_bShowElementNormalArrow;
    protected PuDouble m_globalElementNormalLength;
    protected PuDouble m_globalElementNormalSize;
    protected PdColor m_globalElementNormalColor;
    protected boolean m_bShowElementColors;
    protected PdColor m_globalElementColor;
    protected PdColor m_globalElementTagColor;
    protected PdColor m_globalElementBackColor;
    protected boolean m_bShowElementBackColor;
    protected boolean m_bShowElementBackColors;
    protected boolean m_bShowSmoothLighting;
    protected boolean m_bShowSmoothEdgeColors;
    protected boolean m_bShowSmoothElementColors;
    protected boolean m_bShowElementColorFromVertices;
    static /* synthetic */ Class class$jv$geom$PgElementSet;
    static /* synthetic */ Class class$jv$geom$PgEdgeStar;

    public PgElementSet() {
        this(3);
        this.m_bShowVertices = true;
    }

    public PgElementSet(int n) {
        super(n);
        this.setType(33);
        this.setTag(6);
        this.setTag(7);
        this.addGeometryItem("Element");
        this.setDimOfSimplex(2);
        this.m_element = new PiVector[0];
        this.m_neighbour = null;
        this.m_elementSaved = null;
        this.m_elementTexture = null;
        this.m_globalElementColor = new PdColor(PsConfig.getMessage(24017), this);
        this.m_globalElementBackColor = new PdColor(PsConfig.getMessage(24018), this);
        this.m_globalElementTagColor = new PdColor(PsConfig.getMessage(24019), this);
        this.m_globalElementNormalLength = new PuDouble(PsConfig.getMessage(24020), this);
        this.m_globalElementNormalSize = new PuDouble(PsConfig.getMessage(24021), this);
        this.m_globalElementNormalColor = new PdColor(PsConfig.getMessage(24022), this);
        this.m_creaseAngle = new PuDouble(PsConfig.getMessage(24367), this);
        this.m_globalEdgeColor = new PdColor(PsConfig.getMessage(24023), this);
        this.m_globalEdgeTagColor = new PdColor(PsConfig.getMessage(24024), this);
        this.m_globalEdgeSize = new PuDouble(PsConfig.getMessage(24025), this);
        this.m_globalBndColor = new PdColor(PsConfig.getMessage(24026), this);
        this.m_globalBndTagColor = new PdColor(PsConfig.getMessage(24027), this);
        this.m_globalBndSize = new PuDouble(PsConfig.getMessage(24028), this);
        this.m_bConforming = true;
        if (this.getClass() == (class$jv$geom$PgElementSet == null ? (class$jv$geom$PgElementSet = PgElementSet.class$("jv.geom.PgElementSet")) : class$jv$geom$PgElementSet)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_bShowEdgeLabels = false;
        this.m_bShowElementLabels = false;
        this.m_bShowVertices = false;
        this.m_dimOfElements = -1;
        this.setMaxNumElements(0);
        this.m_bShowElements = true;
        this.m_bShowTaggedElements = true;
        this.m_bShowBackface = true;
        this.m_elementColor = null;
        this.m_bShowElementColors = false;
        this.m_globalElementColor.setColor(new Color(150, 220, 255));
        this.m_globalElementTagColor.setColor(Color.magenta);
        this.m_bShowSmoothLighting = false;
        this.m_bShowSmoothElementColors = false;
        this.m_bShowElementColorFromVertices = false;
        this.m_elementBackColor = null;
        this.m_bShowElementBackColor = false;
        this.m_bShowElementBackColors = false;
        this.m_globalElementBackColor.setColor(new Color(255, 200, 0));
        this.m_globalElementBackColor.setEnabled(this.m_bShowElementBackColor);
        this.m_elementNormal = null;
        this.m_bShowElementNormals = false;
        this.m_bShowElementNormalArrow = false;
        this.m_globalElementNormalSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalElementNormalSize.setDefValue(1.0);
        this.m_globalElementNormalSize.init();
        this.m_globalElementNormalLength.setDefBounds(0.0, 5.0, 0.1, 1.0);
        this.m_globalElementNormalLength.setDefValue(0.5);
        this.m_globalElementNormalLength.init();
        this.m_globalElementNormalColor.setColor(Color.yellow);
        this.m_creaseAngle.setDefBounds(0.0, 3.2, 0.02, 0.2);
        this.m_creaseAngle.setDefValue(3.2);
        this.m_creaseAngle.init();
        this.m_bShowSilhouette = false;
        this.m_numEdgeStars = 0;
        this.m_edgeStar = null;
        this.m_bEnableEdges = false;
        this.m_bShowEdges = true;
        this.m_bShowTaggedEdges = false;
        this.m_edgeColor = null;
        this.m_bShowEdgeColors = false;
        this.m_bShowSmoothEdgeColors = false;
        this.m_bShowEdgeColorFromElements = false;
        this.m_bShowEdgeColorFromVertices = false;
        this.m_globalEdgeColor.setColor(Color.black);
        this.m_globalEdgeTagColor.setColor(Color.magenta);
        this.m_edgeSize = null;
        this.m_bShowEdgeSizes = false;
        this.m_globalEdgeSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalEdgeSize.setDefValue(1.0);
        this.m_globalEdgeSize.init();
        this.m_elementEdge = null;
        this.m_bndList = null;
        this.m_bShowBoundaries = false;
        this.m_bShowTaggedBoundaries = false;
        this.m_globalBndColor.setColor(Color.blue);
        this.m_globalBndTagColor.setColor(Color.magenta);
        this.m_globalBndSize.setDefBounds(0.0, 10.0, 1.0, 2.0);
        this.m_globalBndSize.setDefValue(3.0);
        this.m_globalBndSize.init();
        this.m_elementTexture = null;
        this.m_bShowElementTexture = false;
    }

    public PgJvxSrc getJvx() {
        PgJvxSrc pgJvxSrc = super.getJvx();
        pgJvxSrc.setType(33);
        pgJvxSrc.showEdgeLabels(this.isShowingEdgeLabels());
        pgJvxSrc.showElementLabels(this.isShowingElementLabels());
        pgJvxSrc.showBackface(this.isShowingBackface());
        pgJvxSrc.showSilhouette(this.isShowingSilhouette());
        pgJvxSrc.showTaggedElements(this.isShowingTaggedElements());
        pgJvxSrc.showElements(this.isShowingElements());
        pgJvxSrc.setDimOfElements(this.getDimOfElements());
        pgJvxSrc.setNumElements(this.getNumElements());
        pgJvxSrc.setElements(this.getElements());
        pgJvxSrc.setNeighbours(this.getNeighbours());
        pgJvxSrc.showSmoothLighting(this.isShowingSmoothLighting());
        pgJvxSrc.showSmoothElementColors(this.isShowingSmoothElementColors());
        pgJvxSrc.showElementColorFromVertices(this.isShowingElementFromVertexColors());
        pgJvxSrc.showElementColors(this.isShowingElementColors());
        pgJvxSrc.setElementColors(this.getElementColors());
        pgJvxSrc.showElementBackColors(this.isShowingElementBackColors());
        pgJvxSrc.setElementBackColors(this.getElementBackColors());
        pgJvxSrc.setGlobalElementColor(this.getGlobalElementColor());
        pgJvxSrc.setGlobalElementTagColor(this.getGlobalElementTagColor());
        pgJvxSrc.setGlobalElementBackColor(this.getGlobalElementBackColor());
        pgJvxSrc.showElementBackColor(this.isShowingElementBackColor());
        if (this.hasElementNormals()) {
            pgJvxSrc.showElementNormals(this.isShowingElementNormals());
            pgJvxSrc.setElementNormals(this.getElementNormals());
        } else {
            pgJvxSrc.showElementNormals(false);
        }
        pgJvxSrc.showElementNormalArrow(this.isShowingElementNormalArrow());
        pgJvxSrc.setGlobalElementNormalColor(this.getGlobalElementNormalColor());
        pgJvxSrc.setGlobalElementNormalLength(this.getGlobalElementNormalLength());
        pgJvxSrc.setGlobalElementNormalSize(this.getGlobalElementNormalSize());
        pgJvxSrc.setCreaseAngle(this.getCreaseAngle());
        if (this.hasElementTextures()) {
            pgJvxSrc.showElementTexture(this.isShowingElementTexture());
            pgJvxSrc.setElementTextures(this.getElementTextures());
        } else {
            pgJvxSrc.showElementTexture(false);
        }
        pgJvxSrc.showEdges(this.isShowingEdges());
        pgJvxSrc.setNumEdges(this.getNumEdgeStars());
        pgJvxSrc.setEdges(this.getEdgeStars());
        pgJvxSrc.showEdgeColors(this.isShowingEdgeColors());
        pgJvxSrc.showEdgeColorFromElements(this.isShowingEdgeColorFromElements());
        pgJvxSrc.showEdgeColorFromVertices(this.isShowingEdgeColorFromVertices());
        pgJvxSrc.showSmoothEdgeColors(this.isShowingSmoothEdgeColors());
        pgJvxSrc.setGlobalEdgeColor(this.getGlobalEdgeColor());
        pgJvxSrc.setGlobalEdgeTagColor(this.getGlobalEdgeTagColor());
        pgJvxSrc.setGlobalEdgeSize(this.getGlobalEdgeSize());
        pgJvxSrc.showBoundaries(this.isShowingBoundaries());
        pgJvxSrc.setGlobalBndColor(this.getGlobalBndColor());
        pgJvxSrc.setGlobalBndTagColor(this.getGlobalBndTagColor());
        pgJvxSrc.setGlobalBndSize(this.getGlobalBndSize());
        PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
        if (pgBndPolygonArray != null) {
            int n = pgBndPolygonArray.length;
            pgJvxSrc.setNumBndPolygons(n);
            for (int i = 0; i < n; ++i) {
                pgJvxSrc.showBnd(i, pgBndPolygonArray[i].isVisible());
                pgJvxSrc.setBndName(i, pgBndPolygonArray[i].getName());
                pgJvxSrc.setBndNumVertices(i, pgBndPolygonArray[i].getNumVertices());
                pgJvxSrc.setBndVertices(i, pgBndPolygonArray[i].getVertices());
                pgJvxSrc.setBndVertexInd(i, pgBndPolygonArray[i].getVertexInd());
                pgJvxSrc.setBndElementInd(i, pgBndPolygonArray[i].getElementInd());
                pgJvxSrc.setBndNeighbourLocInd(i, pgBndPolygonArray[i].getNeighbourLocInd());
                boolean bl = pgBndPolygonArray[i].isShowingIndividualMaterial();
                pgJvxSrc.showBndMaterials(i, bl);
                if (bl) {
                    pgJvxSrc.setBndColor(i, pgBndPolygonArray[i].getGlobalEdgeColor());
                    pgJvxSrc.setBndSize(i, pgBndPolygonArray[i].getGlobalEdgeSize());
                    continue;
                }
                pgJvxSrc.setBndColor(i, this.getGlobalBndColor());
                pgJvxSrc.setBndSize(i, this.getGlobalBndSize());
            }
        }
        return pgJvxSrc;
    }

    public void setJvx(PgJvxSrc pgJvxSrc) {
        PgBndPolygon[] pgBndPolygonArray;
        int n;
        if (pgJvxSrc == null) {
            PsDebug.warning("Argument is null.");
            return;
        }
        super.setJvx(pgJvxSrc);
        this.showEdgeLabels(pgJvxSrc.isShowingEdgeLabels());
        this.showElementLabels(pgJvxSrc.isShowingElementLabels());
        this.showSilhouette(pgJvxSrc.isShowingSilhouette());
        this.showBackface(pgJvxSrc.isShowingBackface());
        this.showTaggedElements(pgJvxSrc.isShowingTaggedElements());
        this.showElements(pgJvxSrc.isShowingElements());
        int n2 = PiVector.getSameSize(pgJvxSrc.getElements(), pgJvxSrc.getNumElements());
        this.setDimOfElements(n2);
        this.setNumElements(pgJvxSrc.getNumElements());
        this.setElements(pgJvxSrc.getElements());
        if (pgJvxSrc.getNeighbours() != null) {
            this.setNeighbours(pgJvxSrc.getNeighbours());
        } else if (PsJavaView.m_bAutoNeighbour) {
            this.makeNeighbour();
        } else {
            this.setNeighbours(null);
        }
        this.showSmoothLighting(pgJvxSrc.isShowingSmoothLighting());
        this.showSmoothElementColors(pgJvxSrc.isShowingSmoothElementColors());
        this.showElementColorFromVertices(pgJvxSrc.isShowingElementColorFromVertices());
        if (pgJvxSrc.getGlobalElementColor() != null) {
            this.setGlobalElementColor(pgJvxSrc.getGlobalElementColor());
        }
        if (pgJvxSrc.getGlobalElementTagColor() != null) {
            this.setGlobalElementTagColor(pgJvxSrc.getGlobalElementTagColor());
        }
        this.setElementColors(pgJvxSrc.getElementColors());
        this.showElementColors(pgJvxSrc.isShowingElementColors());
        this.setElementBackColors(pgJvxSrc.getElementBackColors());
        this.showElementBackColors(pgJvxSrc.isShowingElementBackColors());
        if (pgJvxSrc.getGlobalElementBackColor() != null) {
            this.setGlobalElementBackColor(pgJvxSrc.getGlobalElementBackColor());
        }
        this.showElementBackColor(pgJvxSrc.isShowingElementBackColor());
        this.showElementNormals(pgJvxSrc.isShowingElementNormals());
        this.showElementNormalArrow(pgJvxSrc.isShowingElementNormalArrow());
        if (pgJvxSrc.getElementNormals() != null) {
            this.setElementNormals(pgJvxSrc.getElementNormals());
        } else if (PsJavaView.m_bAutoElementNormals) {
            this.makeElementNormals();
        } else {
            this.setElementNormals(null);
        }
        if (pgJvxSrc.getVertexNormals() == null && PsJavaView.m_bAutoNormals) {
            this.makeVertexNormals();
        }
        if (pgJvxSrc.getGlobalElementNormalColor() != null) {
            this.setGlobalElementNormalColor(pgJvxSrc.getGlobalElementNormalColor());
        }
        this.setGlobalElementNormalLength(pgJvxSrc.getGlobalElementNormalLength());
        this.setGlobalElementNormalSize(pgJvxSrc.getGlobalElementNormalSize());
        this.setCreaseAngle(pgJvxSrc.getCreaseAngle());
        this.setElementTextures(pgJvxSrc.getElementTextures());
        this.showElementTexture(pgJvxSrc.isShowingElementTexture());
        this.showEdges(pgJvxSrc.isShowingEdges());
        this.setNumEdgeStars(pgJvxSrc.getNumEdges());
        this.setEdges(pgJvxSrc.getEdges());
        if (this.m_numEdgeStars != 0) {
            this.setEnabledEdges(true);
        }
        this.showEdgeColors(pgJvxSrc.isShowingEdgeColors());
        this.showEdgeColorFromElements(pgJvxSrc.isShowingEdgeColorFromElements());
        this.showEdgeColorFromVertices(pgJvxSrc.isShowingEdgeColorFromVertices());
        this.showSmoothEdgeColors(pgJvxSrc.isShowingSmoothEdgeColors());
        if (pgJvxSrc.getGlobalEdgeColor() != null) {
            this.setGlobalEdgeColor(pgJvxSrc.getGlobalEdgeColor());
        }
        this.setEdgeColors(pgJvxSrc.getEdgeColors());
        if (pgJvxSrc.getGlobalEdgeTagColor() != null) {
            this.setGlobalEdgeTagColor(pgJvxSrc.getGlobalEdgeTagColor());
        }
        this.showEdgeSizes(pgJvxSrc.isShowingEdgeSizes());
        this.setEdgeSizes(pgJvxSrc.getEdgeSizes());
        this.setGlobalEdgeSize(pgJvxSrc.getGlobalEdgeSize());
        int n3 = pgJvxSrc.getNumVectorFields();
        for (n = 0; n < n3; ++n) {
            if (!pgJvxSrc.isVectorElementBased(n)) continue;
            pgBndPolygonArray = this.getVectorField(n);
            PdVector[] pdVectorArray = pgJvxSrc.getVectors(n);
            if (pdVectorArray == null) {
                PsDebug.warning("missing vectors in vector field[" + n + "].");
                return;
            }
            int n4 = pdVectorArray.length;
            pgBndPolygonArray.setGeometry(this);
            pgBndPolygonArray.setBasedOn(1);
            pgBndPolygonArray.setNumVectors(n4);
            pgBndPolygonArray.setVectorColors(pgJvxSrc.getVectorFieldColors(n));
            pgBndPolygonArray.setVectors(pdVectorArray);
        }
        this.showBoundaries(pgJvxSrc.isShowingBoundaries());
        if (pgJvxSrc.getGlobalBndColor() != null) {
            this.setGlobalBndColor(pgJvxSrc.getGlobalBndColor());
        }
        if (pgJvxSrc.getGlobalBndTagColor() != null) {
            this.setGlobalBndTagColor(pgJvxSrc.getGlobalBndTagColor());
        }
        this.setGlobalBndSize(pgJvxSrc.getGlobalBndSize());
        n = pgJvxSrc.getNumBndPolygons();
        this.assureBoundary(n);
        pgBndPolygonArray = this.getBoundaries();
        for (int i = 0; i < n; ++i) {
            PgBndPolygon pgBndPolygon = pgBndPolygonArray[i];
            pgBndPolygon.setVisible(pgJvxSrc.isShowingBnd(i));
            pgBndPolygon.setName(pgJvxSrc.getBndName(i));
            pgBndPolygon.setNumVertices(pgJvxSrc.getBndNumVertices(i));
            pgBndPolygon.setVertices(pgJvxSrc.getBndVertices(i));
            pgBndPolygon.setVertexInd(pgJvxSrc.getBndVertexInd(i));
            pgBndPolygon.setElementInd(pgJvxSrc.getBndElementInd(i));
            pgBndPolygon.setNeighbourLocInd(pgJvxSrc.getBndNeighbourLocInd(i));
            boolean bl = pgJvxSrc.isShowingBndMaterials(i);
            pgBndPolygon.showIndividualMaterial(bl);
            if (bl) {
                pgBndPolygon.setGlobalEdgeColor(pgJvxSrc.getBndColor(i));
                pgBndPolygon.setGlobalEdgeSize(pgJvxSrc.getBndSize(i));
                continue;
            }
            pgBndPolygon.setGlobalEdgeColor(pgJvxSrc.getGlobalBndColor());
            pgBndPolygon.setGlobalEdgeSize(pgJvxSrc.getGlobalBndSize());
        }
    }

    public boolean applyModelingMatrix() {
        if (!super.applyModelingMatrix()) {
            return false;
        }
        if (this.m_numElements > 0) {
            if (this.hasElementNormals()) {
                PdVector pdVector = new PdVector(3);
                PdVector pdVector2 = new PdVector(3);
                for (int i = 0; i < this.m_numElements; ++i) {
                    pdVector.copyArray(this.m_elementNormal[i]);
                    pdVector2.leftMultAffin(this.m_modelMatrix, pdVector, false);
                    this.m_elementNormal[i].copyArray(pdVector2);
                }
            }
            if (this.hasBoundary()) {
                int n = this.getNumBoundaries();
                for (int i = 0; i < n; ++i) {
                    this.m_bndList[i].setModelMatrix(this.m_modelMatrix);
                    this.m_bndList[i].applyModelingMatrix();
                }
            }
        }
        return super.applyModelingMatrix();
    }

    public boolean projectFromAmbientSpace() {
        super.projectFromAmbientSpace();
        if (this.m_numElements > 0 && this.hasElementNormals()) {
            this.makeElementNormals();
        }
        return true;
    }

    public Object clone() {
        PgElementSet pgElementSet = (PgElementSet)super.clone();
        if (pgElementSet == null) {
            return null;
        }
        pgElementSet.m_globalElementColor = (PdColor)this.m_globalElementColor.clone();
        pgElementSet.m_globalElementBackColor = (PdColor)this.m_globalElementBackColor.clone();
        pgElementSet.m_globalElementTagColor = (PdColor)this.m_globalElementTagColor.clone();
        pgElementSet.m_globalElementColor.setParent(pgElementSet);
        pgElementSet.m_globalElementBackColor.setParent(pgElementSet);
        pgElementSet.m_globalElementTagColor.setParent(pgElementSet);
        pgElementSet.m_globalBndSize = (PuDouble)this.m_globalBndSize.clone();
        pgElementSet.m_globalBndColor = (PdColor)this.m_globalBndColor.clone();
        pgElementSet.m_globalBndTagColor = (PdColor)this.m_globalBndTagColor.clone();
        pgElementSet.m_globalBndSize.setParent(pgElementSet);
        pgElementSet.m_globalBndColor.setParent(pgElementSet);
        pgElementSet.m_globalBndTagColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeSize = (PuDouble)this.m_globalEdgeSize.clone();
        pgElementSet.m_globalEdgeColor = (PdColor)this.m_globalEdgeColor.clone();
        pgElementSet.m_globalEdgeTagColor = (PdColor)this.m_globalEdgeTagColor.clone();
        pgElementSet.m_globalEdgeSize.setParent(pgElementSet);
        pgElementSet.m_globalEdgeColor.setParent(pgElementSet);
        pgElementSet.m_globalEdgeTagColor.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalLength = (PuDouble)this.m_globalElementNormalLength.clone();
        pgElementSet.m_globalElementNormalSize = (PuDouble)this.m_globalElementNormalSize.clone();
        pgElementSet.m_globalElementNormalColor = (PdColor)this.m_globalElementNormalColor.clone();
        pgElementSet.m_globalElementNormalLength.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalSize.setParent(pgElementSet);
        pgElementSet.m_globalElementNormalColor.setParent(pgElementSet);
        pgElementSet.m_creaseAngle = (PuDouble)this.m_creaseAngle.clone();
        pgElementSet.m_creaseAngle.setParent(pgElementSet);
        if (this.m_element != null) {
            pgElementSet.m_element = (PiVector[])P_Vector.clone(this.m_element);
        }
        if (this.m_elementColor != null) {
            pgElementSet.m_elementColor = (Color[])this.m_elementColor.clone();
        }
        if (this.m_elementBackColor != null) {
            pgElementSet.m_elementBackColor = (Color[])this.m_elementBackColor.clone();
        }
        if (this.m_elementNormal != null) {
            pgElementSet.m_elementNormal = (PdVector[])P_Vector.clone(this.m_elementNormal);
        }
        if (this.m_elementTexture != null) {
            pgElementSet.m_elementTexture = (PdVector[][])P_Vector.clone(this.m_elementTexture);
        }
        if (this.m_neighbour != null) {
            pgElementSet.m_neighbour = (PiVector[])P_Vector.clone(this.m_neighbour);
        }
        if (this.m_bndList != null) {
            pgElementSet.m_bndList = null;
            int n = this.getNumBoundaries();
            if (n > 0) {
                int n2;
                PgBndPolygon[] pgBndPolygonArray = (PgBndPolygon[])this.m_bndList.clone();
                for (n2 = 0; n2 < n; ++n2) {
                    pgBndPolygonArray[n2] = (PgBndPolygon)this.m_bndList[n2].clone();
                    pgBndPolygonArray[n2].setGeometry(null);
                }
                pgElementSet.setBoundary(pgBndPolygonArray);
                for (n2 = 0; n2 < n; ++n2) {
                    if (this.m_selectedBndPolygon != this.m_bndList[n2]) continue;
                    pgElementSet.m_selectedBndPolygon = pgBndPolygonArray[n2];
                }
            }
        }
        if (this.m_elementSaved != null) {
            pgElementSet.m_elementSaved = (PiVector[])P_Vector.clone(this.m_elementSaved);
        }
        if (this.m_edgeStar != null) {
            pgElementSet.m_edgeStar = (PgEdgeStar[])P_Vector.clone(this.m_edgeStar);
        }
        if (this.m_edgeColor != null) {
            pgElementSet.m_edgeColor = (Color[])this.m_edgeColor.clone();
        }
        if (this.m_edgeSize != null) {
            pgElementSet.m_edgeSize = (PdVector)this.m_edgeSize.clone();
        }
        if (this.m_elementEdge != null) {
            pgElementSet.m_elementEdge = (PiVector[])this.m_elementEdge.clone();
        }
        return pgElementSet;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgElementSet)) {
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)psObject;
        this.m_bShowEdgeLabels = pgElementSet.m_bShowEdgeLabels;
        this.m_bShowElementLabels = pgElementSet.m_bShowElementLabels;
        this.m_bShowBoundaries = pgElementSet.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgElementSet.m_bShowTaggedBoundaries;
        this.m_bShowElementTexture = pgElementSet.m_bShowElementTexture;
        this.m_bShowSilhouette = pgElementSet.m_bShowSilhouette;
        this.m_bShowEdges = pgElementSet.m_bShowEdges;
        this.m_bShowTaggedEdges = pgElementSet.m_bShowTaggedEdges;
        this.m_bShowEdgeColors = pgElementSet.m_bShowEdgeColors;
        this.m_bShowEdgeColorFromElements = pgElementSet.m_bShowEdgeColorFromElements;
        this.m_bShowEdgeColorFromVertices = pgElementSet.m_bShowEdgeColorFromVertices;
        this.m_bShowSmoothEdgeColors = pgElementSet.m_bShowSmoothEdgeColors;
        this.m_bShowEdgeSizes = pgElementSet.m_bShowEdgeSizes;
        this.m_bShowElements = pgElementSet.m_bShowElements;
        this.m_bShowTaggedElements = pgElementSet.m_bShowTaggedElements;
        this.m_bShowBackface = pgElementSet.m_bShowBackface;
        this.m_bShowElementNormals = pgElementSet.m_bShowElementNormals;
        this.m_bShowElementNormalArrow = pgElementSet.m_bShowElementNormalArrow;
        this.m_bShowElementColors = pgElementSet.m_bShowElementColors;
        this.m_bShowElementColorFromVertices = pgElementSet.m_bShowElementColorFromVertices;
        this.m_bShowSmoothElementColors = pgElementSet.m_bShowSmoothElementColors;
        this.m_bShowElementBackColor = pgElementSet.m_bShowElementBackColor;
        this.m_bShowElementBackColors = pgElementSet.m_bShowElementBackColors;
        this.m_bShowSmoothLighting = pgElementSet.m_bShowSmoothLighting;
        this.m_bConforming = pgElementSet.m_bConforming;
        this.m_bEnableEdges = pgElementSet.m_bEnableEdges;
        this.m_globalBndColor.copy(pgElementSet.m_globalBndColor);
        this.m_globalBndTagColor.copy(pgElementSet.m_globalBndTagColor);
        this.m_globalBndSize.copy(pgElementSet.m_globalBndSize);
        this.m_globalEdgeColor.copy(pgElementSet.m_globalEdgeColor);
        this.m_globalEdgeTagColor.copy(pgElementSet.m_globalEdgeTagColor);
        this.m_globalEdgeSize.copy(pgElementSet.m_globalEdgeSize);
        this.m_globalElementNormalLength.copy(pgElementSet.m_globalElementNormalLength);
        this.m_globalElementNormalSize.copy(pgElementSet.m_globalElementNormalSize);
        this.m_globalElementNormalColor.copy(pgElementSet.m_globalElementNormalColor);
        this.m_globalElementColor.copy(pgElementSet.m_globalElementColor);
        this.m_globalElementTagColor.copy(pgElementSet.m_globalElementTagColor);
        this.m_globalElementBackColor.copy(pgElementSet.m_globalElementBackColor);
        this.copyElementSet(pgElementSet);
    }

    public void copyElementSet(PgElementSet pgElementSet) {
        int n;
        this.copyConnectivity(pgElementSet);
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, 0, pgElementSet.getElementNormals(), 0, this.m_numElements);
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null) {
            this.assureElementColors();
            PdColor.copy(this.m_elementColor, 0, pgElementSet.getElementColors(), 0, this.m_numElements);
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null) {
            this.assureElementBackColors();
            PdColor.copy(this.m_elementBackColor, 0, pgElementSet.getElementBackColors(), 0, this.m_numElements);
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            for (int i = 0; i < this.m_numElements; ++i) {
                PdVector.copy(this.m_elementTexture[i], 0, pgElementSet.m_elementTexture[i], 0, pgElementSet.m_elementTexture[i].length);
            }
        } else {
            this.m_elementTexture = null;
        }
        this.setNumEdgeStars(pgElementSet.getNumEdgeStars());
        if (pgElementSet.m_edgeStar != null) {
            PiVector.copy(this.m_edgeStar, 0, pgElementSet.getEdgeStars(), 0, this.m_numEdgeStars);
        } else {
            this.m_edgeStar = null;
        }
        if (pgElementSet.m_edgeColor != null) {
            this.assureEdgeColors();
            PdColor.copy(this.m_edgeColor, 0, pgElementSet.getEdgeColors(), 0, this.m_numEdgeStars);
        } else {
            this.m_edgeColor = null;
        }
        if (pgElementSet.m_edgeSize != null) {
            this.assureEdgeSizes();
            this.m_edgeSize.copy(0, pgElementSet.getEdgeSizes(), 0, this.m_numEdgeStars);
        } else {
            this.m_edgeSize = null;
        }
        if (pgElementSet.m_elementEdge != null) {
            this.assureElementEdges();
            PiVector.copy(this.m_elementEdge, 0, pgElementSet.getElementEdges(), 0, this.m_numElements);
        } else {
            this.m_elementEdge = null;
        }
        if (pgElementSet.hasBoundary()) {
            PgBndPolygon[] pgBndPolygonArray = pgElementSet.getBoundaries();
            this.assureBoundary(pgBndPolygonArray.length);
            for (n = 0; n < this.m_bndList.length; ++n) {
                this.m_bndList[n].copy(pgBndPolygonArray[n]);
            }
        } else {
            this.removeBoundaries();
        }
        int n2 = this.getNumVectorFields();
        for (n = 0; n < n2; ++n) {
            PgVectorField pgVectorField = this.getVectorField(n);
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setGeometry(this);
        }
    }

    public void copyConnectivity(PgElementSet pgElementSet) {
        this.setDimOfElements(pgElementSet.getDimOfElements());
        this.setNumElements(pgElementSet.getNumElements());
        this.m_bConforming = pgElementSet.m_bConforming;
        if (this.m_dimOfElements == -1) {
            PiVector.adjustSizes(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        }
        PiVector.copy(this.m_element, 0, pgElementSet.getElements(), 0, this.m_numElements);
        if (pgElementSet.m_neighbour != null) {
            if (this.m_dimOfElements == -1) {
                PiVector.adjustSizes(this.m_neighbour, 0, pgElementSet.getNeighbours(), 0, this.m_numElements);
            }
            PiVector.copy(this.m_neighbour, 0, pgElementSet.getNeighbours(), 0, this.m_numElements);
        } else {
            this.m_neighbour = null;
        }
        this.m_savedNumVertices = pgElementSet.m_savedNumVertices;
        if (pgElementSet.m_elementSaved != null) {
            this.m_elementSaved = PiVector.copyNew(pgElementSet.m_elementSaved, pgElementSet.m_elementSaved.length);
        }
    }

    public void copySelect(PsObject psObject, PiVector piVector) {
        int n;
        PiVector piVector2;
        int n2;
        if (psObject == null || piVector == null) {
            return;
        }
        if (!(psObject instanceof PgElementSet)) {
            return;
        }
        PgElementSet pgElementSet = (PgElementSet)psObject;
        int n3 = pgElementSet.getNumVertices();
        PbVector pbVector = new PbVector(n3);
        pbVector.setConstant(false);
        int n4 = piVector.getSize();
        for (n2 = 0; n2 < n4; ++n2) {
            piVector2 = pgElementSet.getElement(piVector.getEntry(n2));
            for (n = piVector2.getSize() - 1; n >= 0; --n) {
                pbVector.setEntry(piVector2.getEntry(n), true);
            }
        }
        n2 = pbVector.countTrueEntries();
        piVector2 = new PiVector(n2);
        n = 0;
        for (int i = 0; i < n3; ++i) {
            if (!pbVector.getEntry(i)) continue;
            piVector2.setEntry(n, i);
            ++n;
        }
        super.copySelect(psObject, piVector2);
        this.m_bShowEdgeLabels = pgElementSet.m_bShowEdgeLabels;
        this.m_bShowElementLabels = pgElementSet.m_bShowElementLabels;
        this.m_bShowBoundaries = pgElementSet.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgElementSet.m_bShowTaggedBoundaries;
        this.m_bShowElementTexture = pgElementSet.m_bShowElementTexture;
        this.m_bShowSilhouette = pgElementSet.m_bShowSilhouette;
        this.m_bShowEdges = pgElementSet.m_bShowEdges;
        this.m_bShowTaggedEdges = pgElementSet.m_bShowTaggedEdges;
        this.m_bShowEdgeColors = pgElementSet.m_bShowEdgeColors;
        this.m_bShowEdgeColorFromElements = pgElementSet.m_bShowEdgeColorFromElements;
        this.m_bShowEdgeColorFromVertices = pgElementSet.m_bShowEdgeColorFromVertices;
        this.m_bShowSmoothEdgeColors = pgElementSet.m_bShowSmoothEdgeColors;
        this.m_bShowEdgeSizes = pgElementSet.m_bShowEdgeSizes;
        this.m_bShowElements = pgElementSet.m_bShowElements;
        this.m_bShowTaggedElements = pgElementSet.m_bShowTaggedElements;
        this.m_bShowBackface = pgElementSet.m_bShowBackface;
        this.m_bShowElementNormals = pgElementSet.m_bShowElementNormals;
        this.m_bShowElementNormalArrow = pgElementSet.m_bShowElementNormalArrow;
        this.m_bShowElementColors = pgElementSet.m_bShowElementColors;
        this.m_bShowElementColorFromVertices = pgElementSet.m_bShowElementColorFromVertices;
        this.m_bShowSmoothElementColors = pgElementSet.m_bShowSmoothElementColors;
        this.m_bShowElementBackColor = pgElementSet.m_bShowElementBackColor;
        this.m_bShowElementBackColors = pgElementSet.m_bShowElementBackColors;
        this.m_bShowSmoothLighting = pgElementSet.m_bShowSmoothLighting;
        this.m_bConforming = pgElementSet.m_bConforming;
        this.m_bEnableEdges = pgElementSet.m_bEnableEdges;
        this.m_globalBndColor.copy(pgElementSet.m_globalBndColor);
        this.m_globalBndTagColor.copy(pgElementSet.m_globalBndTagColor);
        this.m_globalBndSize.copy(pgElementSet.m_globalBndSize);
        this.m_globalEdgeColor.copy(pgElementSet.m_globalEdgeColor);
        this.m_globalEdgeTagColor.copy(pgElementSet.m_globalEdgeTagColor);
        this.m_globalEdgeSize.copy(pgElementSet.m_globalEdgeSize);
        this.m_globalElementNormalLength.copy(pgElementSet.m_globalElementNormalLength);
        this.m_globalElementNormalSize.copy(pgElementSet.m_globalElementNormalSize);
        this.m_globalElementNormalColor.copy(pgElementSet.m_globalElementNormalColor);
        this.m_globalElementColor.copy(pgElementSet.m_globalElementColor);
        this.m_globalElementTagColor.copy(pgElementSet.m_globalElementTagColor);
        this.m_globalElementBackColor.copy(pgElementSet.m_globalElementBackColor);
        this.copyElementSetSelect(pgElementSet, piVector2, piVector);
    }

    public void copyConnectivitySelect(PgElementSet pgElementSet, PiVector piVector, PiVector piVector2) {
        int n;
        if (piVector2 == null) {
            PsDebug.warning("missing element index of elements to be copied.");
            return;
        }
        int n2 = piVector2.getSize();
        if (n2 == 0) {
            this.setNumElements(n2);
            return;
        }
        int n3 = piVector.getSize();
        PiVector piVector3 = new PiVector(pgElementSet.getNumVertices());
        piVector3.setConstant(-1);
        for (int i = 0; i < n3; ++i) {
            piVector3.setEntry(piVector.getEntry(i), i);
        }
        PiVector piVector4 = new PiVector(pgElementSet.getNumElements());
        piVector4.setConstant(-1);
        for (int i = 0; i < n2; ++i) {
            piVector4.setEntry(piVector2.getEntry(i), i);
        }
        PiVector[] piVectorArray = pgElementSet.getElements();
        int n4 = -2;
        for (n = 0; n < n2; ++n) {
            if (n4 == -1) continue;
            if (n4 == -2) {
                n4 = piVectorArray[n].getSize();
                continue;
            }
            if (n4 == piVectorArray[n].getSize()) continue;
            n4 = -1;
        }
        this.m_bConforming = pgElementSet.m_bConforming;
        this.setDimOfElements(n4);
        this.setNumElements(n2);
        for (n = 0; n < n2; ++n) {
            this.setElement(n, piVectorArray[piVector2.m_data[n]]);
            for (int i = this.m_element[n].getSize() - 1; i >= 0; --i) {
                this.m_element[n].m_data[i] = piVector3.getEntry(this.m_element[n].m_data[i]);
            }
        }
        if (pgElementSet.m_neighbour != null) {
            this.assureNeighbours();
            for (n = 0; n < n2; ++n) {
                PiVector piVector5 = pgElementSet.m_neighbour[piVector2.m_data[n]];
                for (int i = piVector5.getSize() - 1; i >= 0; --i) {
                    int n5 = piVector5.m_data[i];
                    this.m_neighbour[n].m_data[i] = n5 == -1 ? -1 : piVector4.getEntry(n5);
                }
            }
        } else {
            this.m_neighbour = null;
        }
    }

    public void copyElementSetSelect(PgElementSet pgElementSet, PiVector piVector, PiVector piVector2) {
        int n;
        this.copyConnectivitySelect(pgElementSet, piVector, piVector2);
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            for (n = 0; n < this.m_numElements; ++n) {
                this.setElementNormal(n, pgElementSet.getElementNormal(piVector2.m_data[n]));
            }
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null) {
            this.assureElementColors();
            for (n = 0; n < this.m_numElements; ++n) {
                this.setElementColor(n, pgElementSet.getElementColor(piVector2.m_data[n]));
            }
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null) {
            this.assureElementBackColors();
            for (n = 0; n < this.m_numElements; ++n) {
                this.setElementBackColor(n, pgElementSet.getElementBackColor(piVector2.m_data[n]));
            }
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            for (n = 0; n < this.m_numElements; ++n) {
                PdVector.copy(this.m_elementTexture[n], 0, pgElementSet.m_elementTexture[piVector2.m_data[n]], 0, pgElementSet.m_elementTexture[piVector2.m_data[n]].length);
            }
        } else {
            this.m_elementTexture = null;
        }
        this.setEnabledEdges(false);
        this.removeBoundaries();
        n = this.getNumVectorFields();
        for (int i = 0; i < n; ++i) {
            PgVectorField pgVectorField = this.getVectorField(i);
            if (pgVectorField.getBasedOn() != 1) continue;
            pgVectorField.setGeometry(this);
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgElementSet *********\n");
        stringBuffer.append("\t m_numElements    = " + this.m_numElements + " (max = " + this.m_maxNumElements + ")\n");
        stringBuffer.append("\t m_numBndSegments = " + this.getNumBoundaries() + "\n");
        stringBuffer.append("\t m_bConforming    = " + this.isConforming() + "\n");
        stringBuffer.append("\t ******* m_element *******\n");
        if (this.m_element != null) {
            for (n = 0; n < this.m_numElements; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_element[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_element = null\n");
        }
        stringBuffer.append("\t ******* m_neighbour *******\n");
        if (this.m_neighbour != null) {
            for (n = 0; n < this.m_numElements; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_neighbour[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_neighbour = null\n");
        }
        stringBuffer.append("\t ******* m_elementNormal *******\n");
        if (this.m_elementNormal != null && this.m_numElements > 0) {
            for (n = 0; n < this.m_numElements; ++n) {
                stringBuffer.append("\t [" + n + "] = " + this.m_elementNormal[n].toShortString());
            }
        } else {
            stringBuffer.append("\t m_elementNormal = null\n");
        }
        stringBuffer.append("\t ******* m_elementTexture *******\n");
        if (this.m_elementTexture != null && this.m_numElements > 0) {
            for (n = 0; n < this.m_numElements; ++n) {
                if (this.m_elementTexture[n] == null) {
                    stringBuffer.append("\t [" + n + "] = null");
                    continue;
                }
                for (int i = 0; i < this.m_elementTexture[n].length; ++i) {
                    stringBuffer.append("\t [" + n + "][" + i + "] = " + this.m_elementTexture[n][i].toShortString());
                }
            }
        } else {
            stringBuffer.append("\t m_elementTexture = null\n");
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == null) {
            return super.update(null);
        }
        if (object == this.m_globalBndColor) {
            if (this.getNumBoundaries() > 0) {
                PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
                for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                    if (pgBndPolygonArray[i].isShowingIndividualMaterial()) continue;
                    pgBndPolygonArray[i].setGlobalEdgeColor(this.m_globalBndColor.getColor());
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalBndTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalBndSize) {
            if (this.getNumBoundaries() > 0) {
                PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
                for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                    if (pgBndPolygonArray[i].isShowingIndividualMaterial()) continue;
                    pgBndPolygonArray[i].setGlobalEdgeSize(this.m_globalBndSize.getValue());
                }
            }
            return super.update(null);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(null);
        }
        if (object == this.m_globalElementColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementBackColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementTagColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalColor) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalLength) {
            return super.update(null);
        }
        if (object == this.m_globalElementNormalSize) {
            return super.update(null);
        }
        if (object == this.m_creaseAngle) {
            return super.update(null);
        }
        if (object == this.m_globalVertexNormalColor) {
            this.m_globalElementNormalColor.copy(this.m_globalVertexNormalColor);
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalLength) {
            this.m_globalElementNormalLength.copy(this.m_globalVertexNormalLength);
            return super.update(object);
        }
        if (object == this.m_globalVertexNormalSize) {
            this.m_globalElementNormalSize.copy(this.m_globalVertexNormalSize);
            return super.update(object);
        }
        if (object == this) {
            PsDebug.notify("called with event=this");
            if (this.getNumBoundaries() > 0) {
                PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
                for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                    this.m_bUpdateSender = true;
                    pgBndPolygonArray[i].update(this);
                    this.m_bUpdateSender = false;
                }
            }
            return super.update(this);
        }
        if (this.getNumBoundaries() > 0) {
            PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                if (object != pgBndPolygonArray[i]) continue;
                super.update(this);
                return true;
            }
        }
        return super.update(object);
    }

    public int addElement(PiVector piVector) {
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return -1;
        }
        int n = this.getNumElements();
        if (this.m_numElements == this.m_maxNumElements) {
            this.setMaxNumElements((int)((double)(this.m_numElements + 1) * 1.2));
        }
        this.setNumElements(n + 1);
        this.setElement(n, piVector);
        if (this.m_neighbour != null) {
            int n2 = piVector.getSize();
            block0: for (int i = 0; i < n2; ++i) {
                int n3 = piVector.m_data[(i + 1) % n2];
                int n4 = piVector.m_data[(i + 2) % n2];
                for (int j = 0; j < n; ++j) {
                    int n5 = this.m_element[j].getSize();
                    int n6 = this.m_element[j].m_data[1];
                    for (int k = 0; k < n5; ++k) {
                        int n7 = n6;
                        n6 = this.m_element[j].m_data[(k + 2) % n5];
                        if ((n3 != n6 || n4 != n7 || this.m_neighbour[j].m_data[k] != -1) && (n3 != n7 || n4 != n6 || this.m_neighbour[j].m_data[k] != -1)) continue;
                        this.m_neighbour[n].setEntry(i, j);
                        this.m_neighbour[j].setEntry(k, n);
                        continue block0;
                    }
                }
            }
        }
        if (this.m_elementColor != null) {
            this.m_elementColor[n] = this.m_globalElementColor.getColor();
        }
        if (this.m_elementNormal != null) {
            this.makeElementNormal(n);
        }
        return n;
    }

    public boolean addElement(PiVector piVector, int n) {
        if (n < 0 || n > this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range.");
            return false;
        }
        if (piVector == null || piVector.getSize() < 3) {
            PsDebug.warning("argument element too small.");
            return false;
        }
        int n2 = piVector.getSize();
        if (this.m_numElements == 0) {
            this.m_dimOfElements = n2;
        } else if (this.m_dimOfElements != n2) {
            this.m_dimOfElements = -1;
        }
        this.setNumElements(this.m_numElements + 1);
        if (n == this.m_numElements - 1) {
            this.m_element[this.m_numElements - 1].setSize(n2);
            this.m_element[this.m_numElements - 1].copy(piVector);
            return true;
        }
        for (int i = this.m_numElements - 2; i >= n; --i) {
            this.m_element[i + 1].setSize(this.m_element[i].getSize());
            this.m_element[i + 1].copy(this.m_element[i]);
        }
        this.m_element[n].setSize(n2);
        this.m_element[n].copy(piVector);
        return true;
    }

    public Color getGlobalElementColor() {
        return this.m_globalElementColor.getColor();
    }

    public Color getGlobalElementBackColor() {
        return this.m_globalElementBackColor.getColor();
    }

    public Color getGlobalElementTagColor() {
        return this.m_globalElementTagColor.getColor();
    }

    public void setGlobalElementColor(Color color) {
        this.m_globalElementColor.setColor(color);
    }

    public void setGlobalElementBackColor(Color color) {
        this.m_globalElementBackColor.setColor(color);
    }

    public void setGlobalElementTagColor(Color color) {
        this.m_globalElementTagColor.setColor(color);
    }

    public Color getGlobalElementNormalColor() {
        return this.m_globalElementNormalColor.getColor();
    }

    public double getGlobalElementNormalLength() {
        return this.m_globalElementNormalLength.getValue();
    }

    public double getGlobalElementNormalSize() {
        return this.m_globalElementNormalSize.getValue();
    }

    public void setGlobalElementNormalColor(Color color) {
        this.setGlobalVertexNormalColor(color);
    }

    public void setGlobalElementNormalLength(double d) {
        this.setGlobalVertexNormalLength(d);
    }

    public void setGlobalElementNormalSize(double d) {
        this.setGlobalVertexNormalSize(d);
    }

    public void setGlobalVertexNormalColor(Color color) {
        this.m_globalElementNormalColor.setColor(color);
        super.setGlobalVertexNormalColor(color);
    }

    public void setGlobalVertexNormalLength(double d) {
        this.m_globalElementNormalLength.setValue(d);
        super.setGlobalVertexNormalLength(d);
    }

    public void setGlobalVertexNormalSize(double d) {
        this.m_globalElementNormalSize.setValue(d);
        super.setGlobalVertexNormalSize(d);
    }

    public double getCreaseAngle() {
        return this.m_creaseAngle.getValue();
    }

    public void setCreaseAngle(double d) {
        this.m_creaseAngle.setValue(d);
    }

    public Color getGlobalEdgeColor() {
        return this.m_globalEdgeColor.getColor();
    }

    public Color getGlobalEdgeTagColor() {
        return this.m_globalEdgeTagColor.getColor();
    }

    public double getGlobalEdgeSize() {
        return this.m_globalEdgeSize.getValue();
    }

    public void setGlobalEdgeColor(Color color) {
        this.m_globalEdgeColor.setColor(color);
    }

    public void setGlobalEdgeTagColor(Color color) {
        this.m_globalEdgeTagColor.setColor(color);
    }

    public void setGlobalEdgeSize(double d) {
        this.m_globalEdgeSize.setValue(d);
    }

    public boolean isShowingEdgeColors() {
        return this.m_bShowEdgeColors;
    }

    public void showEdgeColors(boolean bl) {
        this.m_bShowEdgeColors = bl;
    }

    public boolean isShowingEdgeSizes() {
        return this.m_bShowEdgeSizes;
    }

    public void showEdgeSizes(boolean bl) {
        this.m_bShowEdgeSizes = bl;
    }

    public Color getGlobalBndColor() {
        return this.m_globalBndColor.getColor();
    }

    public Color getGlobalBndTagColor() {
        return this.m_globalBndTagColor.getColor();
    }

    public double getGlobalBndSize() {
        return this.m_globalBndSize.getValue();
    }

    public void setGlobalBndColor(Color color) {
        this.m_globalBndColor.setColor(color);
    }

    public void setGlobalBndTagColor(Color color) {
        this.m_globalBndTagColor.setColor(color);
    }

    public void setGlobalBndSize(double d) {
        this.m_globalBndSize.setValue(d);
    }

    public boolean isEnabledEdges() {
        return this.m_bEnableEdges;
    }

    public void setEnabledEdges(boolean bl) {
        if (this.m_bEnableEdges == bl) {
            return;
        }
        if (!bl) {
            this.m_edgeStar = null;
            this.removeElementEdges();
            this.removeEdgeColors();
            this.removeEdgeSizes();
        }
        this.m_bEnableEdges = bl;
    }

    public int getNumEdgeStars() {
        return this.m_numEdgeStars;
    }

    protected void setNumEdgeStars(int n) {
        if (this.m_numEdgeStars == n) {
            return;
        }
        if (n == 0) {
            this.m_edgeStar = null;
        } else {
            this.m_edgeStar = (PgEdgeStar[])PuData.realloc(class$jv$geom$PgEdgeStar == null ? (class$jv$geom$PgEdgeStar = PgElementSet.class$("jv.geom.PgEdgeStar")) : class$jv$geom$PgEdgeStar, this.m_edgeStar, n);
            for (int i = this.m_numEdgeStars; i < n; ++i) {
                this.m_edgeStar[i] = new PgEdgeStar();
            }
        }
        this.m_numEdgeStars = n;
        if (this.m_edgeColor != null) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, n);
        }
        if (this.m_edgeSize != null) {
            this.m_edgeSize.setSize(n);
        }
    }

    public PgEdgeStar[] getEdgeStars() {
        return this.m_edgeStar;
    }

    public PgEdgeStar getEdgeStar(int n) {
        if (n < 0 || n >= this.m_numEdgeStars) {
            PsDebug.warning("edge index out of range.");
            return null;
        }
        return this.m_edgeStar[n];
    }

    public PiVector getEdge(int n) {
        return this.m_edgeStar[n];
    }

    protected void setEdgeStars(PgEdgeStar[] pgEdgeStarArray) {
        if (pgEdgeStarArray == null) {
            this.m_edgeStar = null;
            return;
        }
        if (pgEdgeStarArray.length < this.m_numEdgeStars) {
            PsDebug.warning("edgeStar array too small");
            return;
        }
        if (this.m_edgeStar == null) {
            PsDebug.warning("missing m_edgeStar, call setNumEdgeStars(int) first.");
            return;
        }
        PiVector.copy(this.m_edgeStar, 0, pgEdgeStarArray, 0, this.m_numEdgeStars);
    }

    protected void setEdges(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_edgeStar = null;
            return;
        }
        if (piVectorArray.length < this.m_numEdgeStars) {
            PsDebug.warning("edge array too small");
            return;
        }
        PiVector.copy(this.m_edgeStar, 0, piVectorArray, 0, this.m_numEdgeStars);
    }

    public boolean setEdgeStar(int n, PgEdgeStar pgEdgeStar) {
        if (n < 0 || pgEdgeStar == null) {
            PsDebug.warning("index out of range");
            return false;
        }
        if (n >= this.m_numEdgeStars) {
            PsDebug.warning("index=" + n + " > " + this.m_numEdgeStars + "=m_numEdgeStars, bad programming style");
            this.setNumEdgeStars(n + 1);
        }
        this.m_edgeStar[n].copy(pgEdgeStar);
        return true;
    }

    public PiVector[] getElementEdges() {
        return this.m_elementEdge;
    }

    public int getElementEdge(int n, int n2) {
        if (this.m_elementEdge == null) {
            PsDebug.warning("Edges not initialized.");
            return -1;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("element index out of range.");
            return -1;
        }
        return this.m_elementEdge[n].getEntry(n2);
    }

    public void setElementEdges(PiVector[] piVectorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_elementEdge = piVectorArray;
            return;
        }
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_maxNumElements == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length < this.m_maxNumElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        this.assureElementEdges();
        PiVector.copy(this.m_elementEdge, 0, piVectorArray, 0, this.m_maxNumElements);
    }

    protected void assureElementEdges() {
        if (this.m_dimOfElements != -1) {
            this.m_elementEdge = PiVector.realloc(this.m_elementEdge, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_elementEdge = PiVector.realloc(this.m_elementEdge, this.m_maxNumElements);
            for (int i = 0; i < this.m_maxNumElements; ++i) {
                this.m_elementEdge[i].setSize(this.m_element[i].getSize());
            }
        }
    }

    public void removeElementEdges() {
        this.m_elementEdge = null;
    }

    protected void makeElementEdges() {
        if (this.m_numEdgeStars == 0 && this.m_numElements > 0) {
            PsDebug.warning("edge stars not yet computed, call makeEdgeStars() first.");
            return;
        }
        this.assureElementEdges();
        for (int i = 0; i < this.m_numEdgeStars; ++i) {
            int[] nArray = this.m_edgeStar[i].getElementInd();
            int n = this.m_edgeStar[i].getValence();
            for (int j = 0; j < n; ++j) {
                int n2 = this.m_edgeStar[i].getNeighbourLocInd(j);
                this.m_elementEdge[nArray[j]].m_data[n2] = i;
            }
        }
    }

    public Color[] getEdgeColors() {
        return this.m_edgeColor;
    }

    public boolean hasEdgeColors() {
        return this.m_edgeColor != null && this.m_edgeColor.length == this.m_numEdgeStars;
    }

    public void assureEdgeColors() {
        if (this.m_edgeColor == null || this.m_edgeColor.length != this.m_numEdgeStars) {
            this.m_edgeColor = PdColor.realloc(this.m_edgeColor, this.m_numEdgeStars);
        }
    }

    public void removeEdgeColors() {
        this.setEdgeColors(null);
    }

    public void setEdgeColors(Color[] colorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_edgeColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_edgeColor = null;
            return;
        }
        if (colorArray.length < this.m_numEdgeStars) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureEdgeColors();
        PdColor.copy(this.m_edgeColor, 0, colorArray, 0, this.m_numEdgeStars);
    }

    public PdVector getEdgeSizes() {
        return this.m_edgeSize;
    }

    public boolean hasEdgeSizes() {
        return this.m_edgeSize != null && this.m_edgeSize.getSize() == this.m_numEdgeStars;
    }

    public void assureEdgeSizes() {
        if (this.m_edgeSize == null) {
            this.m_edgeSize = new PdVector(this.m_numEdgeStars);
            this.m_edgeSize.setConstant(this.m_globalEdgeSize.getValue());
        } else if (this.m_edgeSize.getSize() != this.m_numEdgeStars) {
            this.m_edgeSize.setSize(this.m_numEdgeStars);
        }
    }

    public void removeEdgeSizes() {
        this.setEdgeSizes(null);
    }

    public void setEdgeSizes(PdVector pdVector) {
        if (this.isEnabledInstanceSharing()) {
            this.m_edgeSize = pdVector;
            return;
        }
        if (pdVector == null) {
            this.m_edgeSize = null;
            return;
        }
        if (pdVector.getSize() < this.m_numEdgeStars) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureEdgeSizes();
        this.m_edgeSize.copy(0, pdVector, 0, this.m_numEdgeStars);
    }

    public PiVector[] getElements() {
        return this.m_element;
    }

    public Color[] getElementColors() {
        return this.m_elementColor;
    }

    public Color[] getElementBackColors() {
        return this.m_elementBackColor;
    }

    public PdVector[] getElementNormals() {
        return this.m_elementNormal;
    }

    public PdVector[] getElementTexture(int n) {
        if (!this.hasElementTextures()) {
            PsDebug.warning("missing element textures");
            return null;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return null;
        }
        return this.m_elementTexture[n];
    }

    public PdVector[][] getElementTextures() {
        return this.m_elementTexture;
    }

    public PdVector[] getVertexTextures() {
        if (this.hasVertexTextures()) {
            return super.getVertexTextures();
        }
        if (!this.hasElementTextures()) {
            return null;
        }
        int n = this.getNumElementIndices();
        PdVector[] pdVectorArray = new PdVector[n];
        n = 0;
        for (int i = 0; i < this.m_numElements; ++i) {
            int n2 = this.m_element[i].getSize();
            for (int j = 0; j < n2; ++j) {
                pdVectorArray[n++] = this.m_elementTexture[i][j];
            }
        }
        return pdVectorArray;
    }

    public PiVector[] getNeighbours() {
        return this.m_neighbour;
    }

    public int getNumBoundaries() {
        this.removeDeletedBoundaries();
        if (this.m_bndList == null) {
            return 0;
        }
        return this.m_bndList.length;
    }

    public boolean hasBoundary() {
        return this.getNumBoundaries() > 0;
    }

    public PgBndPolygon[] getBoundaries() {
        if (this.m_bndList == null) {
            this.assureBoundary(0);
            return this.m_bndList;
        }
        this.removeDeletedBoundaries();
        return this.m_bndList;
    }

    public PgBndPolygon getSelectedBndPolygon() {
        return this.m_selectedBndPolygon;
    }

    public int selectBndPolygon(PgBndPolygon pgBndPolygon) {
        if (pgBndPolygon == null) {
            PsDebug.warning("Missing argument");
            return -1;
        }
        int n = this.getIndexOfBndPolygon(pgBndPolygon);
        if (n < 0) {
            PsDebug.warning("Missing boundary polygon = " + pgBndPolygon.getName());
            return n;
        }
        if (pgBndPolygon == this.m_selectedBndPolygon) {
            return n;
        }
        this.m_selectedBndPolygon = pgBndPolygon;
        return n;
    }

    public int getIndexOfBndPolygon(PgBndPolygon pgBndPolygon) {
        if (this.m_bndList == null) {
            return -1;
        }
        for (int i = 0; i < this.m_bndList.length; ++i) {
            if (this.m_bndList[i] != pgBndPolygon) continue;
            return i;
        }
        return -1;
    }

    public void removeBoundaries() {
        if (this.m_bndList == null) {
            return;
        }
        for (int i = 0; i < this.m_bndList.length; ++i) {
            this.m_bndList[i].setGeometry(null);
        }
        this.m_selectedBndPolygon = null;
        this.m_bndList = null;
    }

    public int removeDeletedBoundaries() {
        if (this.m_bndList == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_bndList.length; ++i) {
            if (this.m_bndList[i].hasTag(2)) continue;
            ++n;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_bndList;
        if (n != this.m_bndList.length) {
            this.m_bndList = new PgBndPolygon[n];
            int n2 = 0;
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                if (pgBndPolygonArray[i].hasTag(2)) {
                    pgBndPolygonArray[i].setGeometry(null);
                    if (this.m_selectedBndPolygon != pgBndPolygonArray[i]) continue;
                    this.m_selectedBndPolygon = null;
                    continue;
                }
                this.m_bndList[n2++] = pgBndPolygonArray[i];
            }
        }
        if (this.m_selectedBndPolygon == null && n > 0) {
            this.m_selectedBndPolygon = this.m_bndList[0];
        }
        return pgBndPolygonArray.length - n;
    }

    public void setBoundary(PgBndPolygon[] pgBndPolygonArray) {
        if (pgBndPolygonArray == null) {
            this.removeBoundaries();
            return;
        }
        this.m_selectedBndPolygon = null;
        this.m_bndList = new PgBndPolygon[pgBndPolygonArray.length];
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            this.m_bndList[i] = pgBndPolygonArray[i];
            this.m_bndList[i].setGeometry(this);
        }
        this.removeDeletedBoundaries();
    }

    public void assureBoundary(int n) {
        int n2;
        if (this.m_bndList != null && this.m_bndList.length == n) {
            return;
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_bndList;
        this.m_bndList = new PgBndPolygon[n];
        int n3 = 0;
        if (pgBndPolygonArray != null) {
            n3 = pgBndPolygonArray.length;
            for (n2 = 0; n2 < Math.min(n3, n); ++n2) {
                this.m_bndList[n2] = pgBndPolygonArray[n2];
                this.m_bndList[n2].clearTag(2);
            }
        }
        for (n2 = n3; n2 < n; ++n2) {
            this.m_bndList[n2] = new PgBndPolygon(this.m_dim);
            this.m_bndList[n2].setName("Boundary_" + String.valueOf(n2));
            this.m_bndList[n2].setGeometry(this);
            this.m_bndList[n2].setDimOfVectors(this.getDimOfVectors());
        }
        if (this.m_selectedBndPolygon == null && n > 0) {
            this.m_selectedBndPolygon = this.m_bndList[0];
        }
    }

    public boolean isShowingEdges() {
        return this.m_bShowEdges;
    }

    public void showEdges(boolean bl) {
        this.m_bShowEdges = bl;
    }

    public boolean isShowingEdgeColorFromElements() {
        return this.m_bShowEdgeColorFromElements;
    }

    public void showEdgeColorFromElements(boolean bl) {
        this.m_bShowEdgeColorFromElements = bl;
        if (bl && this.m_bShowEdgeColorFromVertices) {
            this.m_bShowEdgeColorFromVertices = false;
        }
    }

    public boolean isShowingSmoothEdgeColors() {
        return this.m_bShowSmoothEdgeColors;
    }

    public void showSmoothEdgeColors(boolean bl) {
        this.m_bShowSmoothEdgeColors = bl;
    }

    public boolean isShowingEdgeColorFromVertices() {
        return this.m_bShowEdgeColorFromVertices;
    }

    public void showEdgeColorFromVertices(boolean bl) {
        this.m_bShowEdgeColorFromVertices = bl;
        if (bl && this.m_bShowEdgeColorFromElements) {
            this.m_bShowEdgeColorFromElements = false;
        }
    }

    public boolean isShowingEdgeLabels() {
        return this.m_bShowEdgeLabels;
    }

    public void showEdgeLabels(boolean bl) {
        this.m_bShowEdgeLabels = bl;
    }

    public boolean isShowingTaggedEdges() {
        return this.m_bShowTaggedEdges;
    }

    public void showTaggedEdges(boolean bl) {
        this.m_bShowTaggedEdges = bl;
    }

    public boolean isShowingElementLabels() {
        return this.m_bShowElementLabels;
    }

    public boolean isShowingElements() {
        return this.m_bShowElements;
    }

    public boolean isShowingTaggedElements() {
        return this.m_bShowTaggedElements;
    }

    public boolean isShowingBackface() {
        return this.m_bShowBackface;
    }

    public boolean isShowingElementNormals() {
        return this.m_bShowElementNormals;
    }

    public boolean isShowingElementNormalArrow() {
        return this.m_bShowElementNormalArrow;
    }

    public boolean isShowingElementTextures() {
        return this.m_bShowElementTexture;
    }

    public boolean isShowingElementTexture() {
        return this.m_bShowElementTexture;
    }

    public boolean isShowingSilhouette() {
        return this.m_bShowSilhouette;
    }

    public void showSilhouette(boolean bl) {
        this.m_bShowSilhouette = bl;
    }

    public boolean isShowingBoundaries() {
        return this.m_bShowBoundaries;
    }

    public boolean isShowingTaggedBoundaries() {
        return this.m_bShowTaggedBoundaries;
    }

    public boolean isShowingElementColors() {
        return this.m_bShowElementColors;
    }

    public boolean isShowingElementBackColors() {
        return this.m_bShowElementBackColors;
    }

    public boolean isShowingElementBackColor() {
        return this.m_bShowElementBackColor;
    }

    public boolean isShowingSmoothLighting() {
        return this.m_bShowSmoothLighting;
    }

    public void showSmoothLighting(boolean bl) {
        this.m_bShowSmoothLighting = bl;
    }

    public boolean isShowingSmoothElementColors() {
        return this.m_bShowSmoothElementColors;
    }

    public void showSmoothElementColors(boolean bl) {
        this.m_bShowSmoothElementColors = bl;
    }

    public boolean isShowingElementColorFromVertices() {
        return this.m_bShowElementColorFromVertices;
    }

    public void showElementColorFromVertices(boolean bl) {
        this.m_bShowElementColorFromVertices = bl;
    }

    public boolean isShowingElementFromVertexColors() {
        return this.m_bShowElementColorFromVertices;
    }

    public void showElementFromVertexColors(boolean bl) {
        this.m_bShowElementColorFromVertices = bl;
    }

    public void showElementLabels(boolean bl) {
        this.m_bShowElementLabels = bl;
    }

    public void showElements(boolean bl) {
        this.m_bShowElements = bl;
    }

    public void showTaggedElements(boolean bl) {
        this.m_bShowTaggedElements = bl;
    }

    public void showElementBackColor(boolean bl) {
        this.m_globalElementBackColor.setEnabled(bl);
        this.m_bShowElementBackColor = bl;
    }

    public void showElementBackColors(boolean bl) {
        this.m_bShowElementBackColors = bl;
    }

    public void showBackface(boolean bl) {
        this.m_bShowBackface = bl;
    }

    public void showElementNormals(boolean bl) {
        this.m_bShowElementNormals = bl;
    }

    public void showElementNormalArrow(boolean bl) {
        this.m_bShowElementNormalArrow = bl;
    }

    public void showElementTexture(boolean bl) {
        this.m_bShowElementTexture = bl;
        if (bl && this.isShowingVertexTexture()) {
            this.showVertexTexture(false);
        }
    }

    public void showVertexTexture(boolean bl) {
        if (bl && this.isShowingElementTexture()) {
            this.showElementTexture(false);
        }
        super.showVertexTexture(bl);
    }

    public void showBoundaries(boolean bl) {
        this.m_bShowBoundaries = bl;
    }

    public void showTaggedBoundaries(boolean bl) {
        this.m_bShowTaggedBoundaries = bl;
    }

    public void showElementColors(boolean bl) {
        this.m_bShowElementColors = bl;
    }

    public int getMaxNumElements() {
        return this.m_maxNumElements;
    }

    public void setMaxNumElements(int n) {
        if (this.m_maxNumElements == n) {
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_maxNumElements = n;
            return;
        }
        if (this.m_dimOfElements > -1) {
            this.m_element = PiVector.realloc(this.m_element, n, this.m_dimOfElements);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n, this.m_dimOfElements);
                for (int i = this.m_maxNumElements; i < n; ++i) {
                    this.m_neighbour[i].setConstant(-1);
                }
            }
        } else {
            this.m_element = PiVector.realloc(this.m_element, n);
            if (this.m_maxNumElements < n) {
                this.m_neighbour = PiVector.realloc(this.m_neighbour, n);
            }
        }
        this.m_maxNumElements = n;
        this.assureNeighbours();
        if (this.m_elementBackColor != null) {
            this.assureElementBackColors();
        }
        if (this.m_elementColor != null) {
            this.assureElementColors();
        }
        if (this.m_elementEdge != null) {
            this.assureElementEdges();
        }
        if (this.m_elementNormal != null) {
            this.assureElementNormals();
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
        if (this.m_maxNumElements < this.m_numElements) {
            this.m_numElements = this.m_maxNumElements;
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setMaxNumVectors(this.m_maxNumElements);
            }
        }
    }

    public int getNumElements() {
        return this.m_numElements;
    }

    public int getNumElementIndices() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements * this.m_numElements;
        }
        int n = 0;
        for (int i = 0; i < this.m_numElements; ++i) {
            n += this.m_element[i].getSize();
        }
        return n;
    }

    public void setNumElements(int n) {
        int n2;
        if (this.m_numElements == n) {
            return;
        }
        if (n > this.m_maxNumElements || n < this.m_maxNumElements / 2 && n < this.m_maxNumElements - 100) {
            this.setMaxNumElements(n);
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_numElements = n;
            return;
        }
        if (n < this.m_numElements && this.m_dimOfElements == -1) {
            for (n2 = n; n2 < this.m_numElements; ++n2) {
                this.m_element[n2].setSize(0);
                if (this.m_neighbour == null) continue;
                this.m_neighbour[n2].setSize(0);
            }
        }
        if (this.m_neighbour != null) {
            if (n < this.m_numElements) {
                for (n2 = 0; n2 < n; ++n2) {
                    for (int i = this.m_neighbour[n2].getSize() - 1; i >= 0; --i) {
                        if (this.m_neighbour[n2].m_data[i] < n) continue;
                        this.m_neighbour[n2].m_data[i] = -1;
                    }
                }
            } else {
                for (n2 = this.m_numElements; n2 < n; ++n2) {
                    this.m_neighbour[n2].setConstant(-1);
                }
            }
        }
        if (this.getNumVectorFields() > 0) {
            Enumeration enumeration = this.m_vectorField.elements();
            while (enumeration.hasMoreElements()) {
                PgVectorField pgVectorField = (PgVectorField)enumeration.nextElement();
                if (pgVectorField.getBasedOn() != 1) continue;
                pgVectorField.setNumVectors(n);
            }
        }
        this.m_numElements = n;
    }

    public int getMaxDimOfElements() {
        if (this.m_dimOfElements != -1) {
            return this.m_dimOfElements;
        }
        int n = 0;
        for (int i = 0; i < this.m_numElements; ++i) {
            int n2 = this.m_element[i].getSize();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getDimOfElements() {
        return this.m_dimOfElements;
    }

    public void setDimOfElements(int n) {
        if (n == this.m_dimOfElements) {
            return;
        }
        if (n != -1 && n < 3) {
            PsDebug.warning("argument aSize=" + n + " out of range.");
            return;
        }
        this.m_dimOfElements = n;
        if (n == -1) {
            for (int i = this.m_numElements; i < this.m_maxNumElements; ++i) {
                this.m_element[i].setSize(0);
                this.m_neighbour[i].setSize(0);
            }
        } else {
            for (int i = 0; i < this.m_maxNumElements; ++i) {
                this.m_element[i].setSize(n);
                if (this.m_neighbour[i].getSize() == n && i < this.m_numElements) continue;
                this.m_neighbour[i].setSize(n);
                this.m_neighbour[i].setConstant(-1);
            }
        }
        if (this.m_elementTexture != null) {
            this.assureElementTextures();
        }
    }

    public int getDimOfElement(int n) {
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return -1;
        }
        return this.m_element[n].getSize();
    }

    public void setDimOfElement(int n, int n2) {
        if (this.m_dimOfElements == n2) {
            return;
        }
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("index out of range, ind = " + n);
            return;
        }
        if (n2 < 3) {
            PsDebug.warning("argument aSize=" + n2 + " out of range.");
            return;
        }
        if (this.m_numElements == 1) {
            this.setDimOfElements(n2);
        } else if (this.m_dimOfElements != -1) {
            PsDebug.notify("m_dimOfElements != aSize = " + n2);
            this.setDimOfElements(-1);
        }
        this.m_element[n].setSize(n2);
        this.m_neighbour[n].setSize(n2);
        this.m_neighbour[n].setConstant(-1);
        if (this.m_elementTexture != null) {
            this.m_elementTexture[n] = PdVector.realloc(this.m_elementTexture[n], n2, this.m_dimOfTextures);
        }
    }

    public void setDimOfColors(int n) {
        if (n < 0 || this.m_dimOfColors == n) {
            return;
        }
        super.setDimOfColors(n);
    }

    public void setDimOfVertices(int n) {
        if (this.m_elementNormal != null) {
            for (int i = 0; i < this.m_maxNumElements; ++i) {
                this.m_elementNormal[i].setSize(n);
            }
        }
        super.setDimOfVertices(n);
    }

    public void setDimOfVectors(int n) {
        if (n < 0 || n == this.m_dim) {
            return;
        }
        super.setDimOfVectors(n);
        if (this.hasBoundary()) {
            for (int i = 0; i < this.m_bndList.length; ++i) {
                if (this.m_bndList[i] == null) continue;
                this.m_bndList[i].setDimOfVectors(n);
            }
        }
    }

    public boolean assureDimOfElements() {
        int n = PiVector.getSameSize(this.m_element, this.m_numElements);
        if (n != this.m_dimOfElements) {
            this.setDimOfElements(n);
            return false;
        }
        return true;
    }

    protected void assureNeighbours() {
        int n;
        boolean bl = false;
        if (this.m_neighbour != null && this.m_neighbour.length == this.m_maxNumElements) {
            for (n = 0; n < this.m_maxNumElements; ++n) {
                if (this.m_neighbour[n].m_data != null && this.m_element[n].m_data != null && this.m_neighbour[n].m_data.length == this.m_element[n].m_data.length) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        if (this.m_dimOfElements != -1) {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements, this.m_dimOfElements);
        } else {
            this.m_neighbour = PiVector.realloc(this.m_neighbour, this.m_maxNumElements);
            for (n = 0; n < this.m_maxNumElements; ++n) {
                this.m_neighbour[n].setSize(this.m_element[n].getSize());
            }
        }
        if (bl) {
            for (n = 0; n < this.m_maxNumElements; ++n) {
                this.m_neighbour[n].setConstant(-1);
            }
        }
    }

    public boolean hasElementColors() {
        return this.m_elementColor != null && this.m_elementColor.length == this.m_maxNumElements;
    }

    public boolean hasElementBackColors() {
        return this.m_elementBackColor != null && this.m_elementBackColor.length == this.m_maxNumElements;
    }

    public boolean hasElementNormals() {
        return this.m_elementNormal != null && this.m_elementNormal.length == this.m_maxNumElements;
    }

    public boolean hasElementTextures() {
        return this.m_elementTexture != null && this.m_elementTexture.length == this.m_maxNumElements;
    }

    public void assureElementColors() {
        if (this.m_elementColor == null || this.m_elementColor.length != this.m_maxNumElements) {
            this.m_elementColor = PdColor.realloc(this.m_elementColor, this.m_maxNumElements);
        }
    }

    public void assureElementBackColors() {
        if (this.m_elementBackColor == null || this.m_elementBackColor.length != this.m_maxNumElements) {
            this.m_elementBackColor = PdColor.realloc(this.m_elementBackColor, this.m_maxNumElements);
        }
    }

    public void assureElementNormals() {
        if (this.m_elementNormal == null || this.m_elementNormal.length != this.m_maxNumElements) {
            this.m_elementNormal = PdVector.realloc(this.m_elementNormal, this.m_maxNumElements, this.m_dim);
        }
    }

    public void assureElementTextures() {
        if (this.m_elementTexture == null) {
            this.m_elementTexture = new PdVector[this.m_maxNumElements][];
        }
        if (this.m_elementTexture.length != this.m_maxNumElements) {
            PdVector[][] pdVectorArrayArray = new PdVector[this.m_maxNumElements][];
            int n = this.m_elementTexture.length;
            if (n > this.m_maxNumElements) {
                n = this.m_maxNumElements;
            }
            for (int i = 0; i < n; ++i) {
                pdVectorArrayArray[i] = this.m_elementTexture[i];
            }
            this.m_elementTexture = pdVectorArrayArray;
        }
        for (int i = 0; i < this.m_maxNumElements; ++i) {
            this.m_elementTexture[i] = PdVector.realloc(this.m_elementTexture[i], this.m_element[i].getSize(), this.m_dimOfTextures);
        }
        if (this.m_texture == null) {
            this.setTexture(new PgTexture());
        }
    }

    public void paint(PvGeometryIf pvGeometryIf) {
        PgBndPolygon[] pgBndPolygonArray;
        super.paint(pvGeometryIf);
        pvGeometryIf.setState(83, this.isShowingEdgeLabels());
        pvGeometryIf.setState(84, this.isShowingElementLabels());
        pvGeometryIf.setState(68, this.m_bShowBackface);
        pvGeometryIf.setState(88, this.m_bShowSilhouette);
        pvGeometryIf.setState(52, this.m_bShowEdges);
        pvGeometryIf.setState(53, this.m_bShowTaggedEdges);
        pvGeometryIf.setState(104, this.isShowingSmoothEdgeColors());
        pvGeometryIf.setState(94, this.m_bShowEdgeColors);
        pvGeometryIf.setState(95, this.m_bShowEdgeColorFromElements);
        pvGeometryIf.setState(96, this.m_bShowEdgeColorFromVertices);
        if (this.m_globalEdgeColor != null) {
            pvGeometryIf.setGlobalEdgeColor(this.m_globalEdgeColor.getColor());
        }
        if (this.m_globalEdgeTagColor != null) {
            pvGeometryIf.setGlobalEdgeTagColor(this.m_globalEdgeTagColor.getColor());
        }
        pvGeometryIf.setState(97, this.m_bShowEdgeSizes);
        if (this.m_globalEdgeSize != null) {
            pvGeometryIf.setGlobalEdgeSize(this.m_globalEdgeSize.getValue());
        }
        pvGeometryIf.setNumEdges(this.m_numEdgeStars);
        pvGeometryIf.setEdges(this.m_edgeStar);
        pvGeometryIf.setEdgeColors(this.m_edgeColor);
        pvGeometryIf.setEdgeSizes(this.m_edgeSize);
        pvGeometryIf.setState(56, this.m_bShowElements);
        pvGeometryIf.setState(57, this.m_bShowTaggedElements);
        pvGeometryIf.setState(103, this.isShowingSmoothLighting());
        pvGeometryIf.setState(105, this.isShowingSmoothElementColors());
        pvGeometryIf.setState(106, this.isShowingElementFromVertexColors());
        pvGeometryIf.setState(98, this.m_bShowElementColors);
        pvGeometryIf.setState(101, this.m_bShowElementBackColor);
        pvGeometryIf.setState(102, this.m_bShowElementBackColors);
        pvGeometryIf.setDimOfElements(this.m_dimOfElements);
        pvGeometryIf.setNumElements(this.m_numElements);
        pvGeometryIf.setElements(this.m_element);
        pvGeometryIf.setState(107, this.isConforming());
        pvGeometryIf.setNeighbours(this.m_neighbour);
        pvGeometryIf.setElementColors(this.m_elementColor);
        pvGeometryIf.setElementBackColors(this.m_elementBackColor);
        pvGeometryIf.setState(62, this.m_bShowElementNormals);
        pvGeometryIf.setState(63, this.m_bShowElementNormalArrow);
        pvGeometryIf.setElementNormals(this.m_elementNormal);
        if (this.m_globalElementNormalSize != null) {
            pvGeometryIf.setGlobalElementNormalSize(this.m_globalElementNormalSize.getValue());
        }
        if (this.m_globalElementNormalLength != null) {
            pvGeometryIf.setGlobalElementNormalLength(this.m_globalElementNormalLength.getValue());
        }
        if (this.m_globalElementNormalColor != null) {
            pvGeometryIf.setGlobalElementNormalColor(this.m_globalElementNormalColor.getColor());
        }
        pvGeometryIf.setElementEdges(this.m_elementEdge);
        if (this.m_creaseAngle != null) {
            pvGeometryIf.setCreaseAngle(this.m_creaseAngle.getValue());
        }
        pvGeometryIf.setState(72, this.m_bShowElementTexture);
        pvGeometryIf.setElementTextures(this.m_elementTexture);
        if (this.m_globalElementColor != null) {
            pvGeometryIf.setGlobalElementColor(this.m_globalElementColor.getColor());
        }
        if (this.m_globalElementBackColor != null) {
            pvGeometryIf.setGlobalElementBackColor(this.m_globalElementBackColor.getColor());
        }
        if (this.m_globalElementTagColor != null) {
            pvGeometryIf.setGlobalElementTagColor(this.m_globalElementTagColor.getColor());
        }
        pvGeometryIf.setState(58, this.m_bShowBoundaries);
        pvGeometryIf.setState(59, this.m_bShowTaggedBoundaries);
        if (this.m_globalBndColor != null) {
            pvGeometryIf.setGlobalBndColor(this.m_globalBndColor.getColor());
        }
        if (this.m_globalBndTagColor != null) {
            pvGeometryIf.setGlobalBndTagColor(this.m_globalBndTagColor.getColor());
        }
        if (this.m_globalBndSize != null) {
            pvGeometryIf.setGlobalBndSize(this.m_globalBndSize.getValue());
        }
        if ((pgBndPolygonArray = this.getBoundaries()) != null) {
            pvGeometryIf.setNumBndPolygons(pgBndPolygonArray.length);
            for (int i = 0; i < pgBndPolygonArray.length; ++i) {
                pvGeometryIf.setBndName(i, pgBndPolygonArray[i].getName());
                pvGeometryIf.setBndElementInd(i, pgBndPolygonArray[i].getElementInd());
                pvGeometryIf.setBndNeighbourLocInd(i, pgBndPolygonArray[i].getNeighbourLocInd());
                pvGeometryIf.showBnd(i, pgBndPolygonArray[i].isVisible());
                pvGeometryIf.showBndMaterials(i, pgBndPolygonArray[i].isShowingIndividualMaterial());
                pvGeometryIf.setBndColor(i, pgBndPolygonArray[i].getGlobalEdgeColor());
                pvGeometryIf.setBndSize(i, pgBndPolygonArray[i].getGlobalEdgeSize());
            }
        }
    }

    public void makeQuadrElementTexture(int n, int n2) {
        this.assureElementTextures();
        if (n < 2 || n2 < 2) {
            return;
        }
        double d = 1.0 / (-1.0 + (double)n);
        double d2 = 1.0 / (-1.0 + (double)n2);
        if (this.m_dimOfElements == 3) {
            int n3 = 0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    this.m_elementTexture[n3][0].m_data[0] = (double)i * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)j * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(i + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)j * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)i * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(j + 1) * d2;
                    this.m_elementTexture[++n3][0].m_data[0] = (double)i * d;
                    this.m_elementTexture[n3][0].m_data[1] = (double)(j + 1) * d2;
                    this.m_elementTexture[n3][1].m_data[0] = (double)(i + 1) * d;
                    this.m_elementTexture[n3][1].m_data[1] = (double)j * d2;
                    this.m_elementTexture[n3][2].m_data[0] = (double)(i + 1) * d;
                    this.m_elementTexture[n3][2].m_data[1] = (double)(j + 1) * d2;
                    ++n3;
                }
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements((n - 1) * (n2 - 1));
            int n4 = 0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    this.m_elementTexture[n4][0].m_data[0] = (double)i * d;
                    this.m_elementTexture[n4][0].m_data[1] = (double)j * d2;
                    this.m_elementTexture[n4][1].m_data[0] = (double)(i + 1) * d;
                    this.m_elementTexture[n4][1].m_data[1] = (double)j * d2;
                    this.m_elementTexture[n4][2].m_data[0] = (double)(i + 1) * d;
                    this.m_elementTexture[n4][2].m_data[1] = (double)(j + 1) * d2;
                    this.m_elementTexture[n4][3].m_data[0] = (double)i * d;
                    this.m_elementTexture[n4][3].m_data[1] = (double)(j + 1) * d2;
                    ++n4;
                }
            }
        }
    }

    public void makeQuadrConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            this.setNumElements(0);
            return;
        }
        if (this.m_dimOfElements == 3) {
            int n3;
            this.setNumElements(2 * (n - 1) * (n2 - 1));
            int n4 = 0;
            int n5 = 0;
            for (n3 = 0; n3 < n - 1; ++n3) {
                for (int i = 0; i < n2 - 1; ++i) {
                    this.m_element[n4++].set(n3 * n2 + i, (n3 + 1) * n2 + i, n3 * n2 + i + 1);
                    this.m_element[n4++].set(n3 * n2 + i + 1, (n3 + 1) * n2 + i, (n3 + 1) * n2 + i + 1);
                    this.m_neighbour[n5].set(n5 + 1, n5 - 2 * (n2 - 1) + 1, n5 - 1);
                    this.m_neighbour[++n5].set(n5 + 2 * (n2 - 1) - 1, n5 + 1, n5 - 1);
                    ++n5;
                }
            }
            n5 = 0;
            for (n3 = 0; n3 < n - 1; ++n3) {
                this.m_neighbour[n5].m_data[2] = -1;
                this.m_neighbour[n5 += 2 * (n2 - 1) - 1].m_data[1] = -1;
                ++n5;
            }
            n5 = 0;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.m_neighbour[n5].m_data[1] = -1;
                n5 += 2;
            }
            n5 = 2 * (n2 - 1) * (n - 2) + 1;
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                this.m_neighbour[n5].m_data[0] = -1;
                n5 += 2;
            }
        } else {
            int n6;
            this.setDimOfElements(4);
            this.setNumElements((n - 1) * (n2 - 1));
            int n7 = 0;
            int n8 = 0;
            for (n6 = 0; n6 < n - 1; ++n6) {
                for (int i = 0; i < n2 - 1; ++i) {
                    this.m_element[n7++].set(n6 * n2 + i, (n6 + 1) * n2 + i, (n6 + 1) * n2 + i + 1, n6 * n2 + i + 1);
                    this.m_neighbour[n8].set(n8 + (n2 - 1), n8 + 1, n8 - (n2 - 1), n8 - 1);
                    ++n8;
                }
            }
            n8 = 0;
            for (n6 = 0; n6 < n - 1; ++n6) {
                this.m_neighbour[n8].m_data[3] = -1;
                this.m_neighbour[n8 += n2 - 1 - 1].m_data[1] = -1;
                ++n8;
            }
            n8 = 0;
            for (n6 = 0; n6 < n2 - 1; ++n6) {
                this.m_neighbour[n8].m_data[2] = -1;
                ++n8;
            }
            n8 = (n2 - 1) * (n - 2);
            for (n6 = 0; n6 < n2 - 1; ++n6) {
                this.m_neighbour[n8].m_data[0] = -1;
                ++n8;
            }
        }
    }

    public void makeAlternatingQuadrConn(int n, int n2, boolean bl) {
        if (n < 2 || n2 < 2) {
            this.setNumElements(0);
            return;
        }
        this.setDimOfElements(3);
        this.setNumElements(2 * (n - 1) * (n2 - 1));
        int n3 = 0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n2 - 1; ++j) {
                if (!bl) {
                    if (j % 2 == 0) {
                        this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                        this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                        continue;
                    }
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                    continue;
                }
                if (i % 2 == 0) {
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                    continue;
                }
                this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
            }
        }
        this.makeNeighbour();
    }

    public void makeCylinderConn(int n, int n2) {
        if (n < 2 || n2 < 2) {
            this.setNumElements(0);
            return;
        }
        if (this.m_dimOfElements == 3) {
            this.setNumElements(2 * (n - 1) * n2);
            int n3 = 0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    this.m_element[n3++].set(i * n2 + j, (i + 1) * n2 + j, i * n2 + j + 1);
                    this.m_element[n3++].set(i * n2 + j + 1, (i + 1) * n2 + j, (i + 1) * n2 + j + 1);
                }
                this.m_element[n3++].set(i * n2 + n2 - 1, (i + 1) * n2 + n2 - 1, i * n2);
                this.m_element[n3++].set(i * n2, (i + 1) * n2 + n2 - 1, (i + 1) * n2);
            }
        } else {
            this.setDimOfElements(4);
            this.setNumElements((n - 1) * n2);
            int n4 = 0;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = 0; j < n2 - 1; ++j) {
                    this.m_element[n4++].set(i * n2 + j, (i + 1) * n2 + j, (i + 1) * n2 + j + 1, i * n2 + j + 1);
                }
                this.m_element[n4++].set(i * n2 + n2 - 1, (i + 1) * n2 + n2 - 1, (i + 1) * n2, i * n2);
            }
        }
        this.makeNeighbour();
    }

    public void makeQuadrBnd(int n, int n2) {
        int n3;
        int n4;
        int n5 = 4;
        this.assureBoundary(n5);
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_bndList[n4].setClosed(false);
        }
        this.m_bndList[0].setNumVertices(n);
        this.m_bndList[1].setNumVertices(n2);
        this.m_bndList[2].setNumVertices(n);
        this.m_bndList[3].setNumVertices(n2);
        for (n4 = 0; n4 < n; ++n4) {
            this.m_bndList[0].m_vertexInd.m_data[n4] = n4 * n2;
            this.m_bndList[2].m_vertexInd.m_data[n4] = (n - n4) * n2 - 1;
        }
        for (int i = 0; i < n2; ++i) {
            this.m_bndList[3].m_vertexInd.m_data[i] = n2 - 1 - i;
            this.m_bndList[1].m_vertexInd.m_data[i] = (n - 1) * n2 + i;
        }
        if (this.m_dimOfElements == 3) {
            n3 = 0;
            for (n4 = 0; n4 < n - 1; ++n4) {
                this.m_bndList[0].m_elementInd.m_data[n4] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n4] = 2;
                n3 += 2 * (n2 - 1);
            }
            n3 = 2 * (n - 2) * (n2 - 1) + 1;
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                this.m_bndList[1].m_elementInd.m_data[n4] = n3;
                this.m_bndList[1].m_neighbourLocInd.m_data[n4] = 0;
                n3 += 2;
            }
            n3 = 2 * (n - 1) * (n2 - 1) - 1;
            for (n4 = 0; n4 < n - 1; ++n4) {
                this.m_bndList[2].m_elementInd.m_data[n4] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n4] = 1;
                n3 -= 2 * (n2 - 1);
            }
            n3 = 2 * (n2 - 1) - 2;
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                this.m_bndList[3].m_elementInd.m_data[n4] = n3;
                this.m_bndList[3].m_neighbourLocInd.m_data[n4] = 1;
                n3 -= 2;
            }
        } else {
            n3 = 0;
            for (n4 = 0; n4 < n - 1; ++n4) {
                this.m_bndList[0].m_elementInd.m_data[n4] = n3;
                this.m_bndList[0].m_neighbourLocInd.m_data[n4] = 3;
                n3 += n2 - 1;
            }
            n3 = (n - 2) * (n2 - 1);
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                this.m_bndList[1].m_elementInd.m_data[n4] = n3++;
                this.m_bndList[1].m_neighbourLocInd.m_data[n4] = 0;
            }
            n3 = (n - 1) * (n2 - 1) - 1;
            for (n4 = 0; n4 < n - 1; ++n4) {
                this.m_bndList[2].m_elementInd.m_data[n4] = n3;
                this.m_bndList[2].m_neighbourLocInd.m_data[n4] = 1;
                n3 -= n2 - 1;
            }
            n3 = n2 - 1 - 1;
            for (n4 = 0; n4 < n2 - 1; ++n4) {
                this.m_bndList[3].m_elementInd.m_data[n4] = n3--;
                this.m_bndList[3].m_neighbourLocInd.m_data[n4] = 2;
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_bndList[n4].assignVertices();
        }
    }

    public void makeTriangleConn(int n) {
        if (n < 2) {
            this.setNumElements(0);
            return;
        }
        int n2 = 0;
        int n3 = 0;
        this.setDimOfElements(3);
        this.setNumElements((n - 1) * (n - 1));
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j < n - 1 - i; ++j) {
                this.m_element[n2++].set(n3 + j, n3 + (n - i) + j, n3 + j + 1);
                if (j == n - 2 - i) continue;
                this.m_element[n2++].set(n3 + j + 1, n3 + (n - i) + j, n3 + (n - i) + j + 1);
            }
            n3 += n - i;
        }
        this.makeNeighbour();
    }

    public void makeTriangleBnd(int n) {
        int n2;
        int n3;
        int n4 = 3;
        this.assureBoundary(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_bndList[n3].setNumVertices(n);
        }
        int n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            this.m_bndList[0].m_vertexInd.m_data[n2] = n5;
            n5 += n - n2;
        }
        n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            this.m_bndList[1].m_vertexInd.m_data[n2] = (n5 += n - n2) - 1;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.m_bndList[2].m_vertexInd.m_data[n2] = n - 1 - n2;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            this.m_bndList[n3].makeElementInd();
        }
    }

    public void flipOrientation() {
        int n;
        super.flipOrientation();
        for (n = 0; n < this.m_numElements; ++n) {
            this.m_element[n].invert();
            int n2 = this.m_element[n].m_data.length;
            int n3 = n2 - 4;
            int n4 = n2 - 4 >> 1;
            int n5 = n3 + n2 >> 1;
            for (int i = n4 + 1; i < n5; ++i) {
                int n6 = (n3 - i + n2) % n2;
                if (n6 == i) continue;
                int n7 = this.m_neighbour[n].m_data[i];
                this.m_neighbour[n].m_data[i] = this.m_neighbour[n].m_data[n6];
                this.m_neighbour[n].m_data[n6] = n7;
            }
        }
        if (this.m_elementNormal != null) {
            for (n = 0; n < this.m_numElements; ++n) {
                this.m_elementNormal[n].multScalar(-1.0);
            }
        }
        if (this.m_elementTexture != null) {
            for (n = 0; n < this.m_numElements; ++n) {
                PuData.invert(this.m_elementTexture[n]);
            }
        }
    }

    public static PiVector getVertexValence(PgElementSet pgElementSet) {
        int n = pgElementSet.getNumVertices();
        int n2 = pgElementSet.getNumElements();
        PiVector[] piVectorArray = pgElementSet.getElements();
        PiVector[] piVectorArray2 = pgElementSet.getNeighbours();
        PiVector piVector = new PiVector(n);
        for (int i = 0; i < n2; ++i) {
            int n3 = piVectorArray[i].getSize();
            for (int j = 0; j < n3; ++j) {
                if (piVectorArray2[i].m_data[j] > i) continue;
                int n4 = piVectorArray[i].m_data[(j + 1) % n3];
                piVector.m_data[n4] = piVector.m_data[n4] + 1;
                int n5 = piVectorArray[i].m_data[(j + 2) % n3];
                piVector.m_data[n5] = piVector.m_data[n5] + 1;
            }
        }
        return piVector;
    }

    public void flipEdges() {
        int n;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("valid for triangulations only");
            return;
        }
        if (this.hasElementTextures()) {
            PsDebug.warning("flip edges not valid when surface has element textures");
            return;
        }
        PiVector piVector = PgElementSet.getVertexValence(this);
        PdVector[] pdVectorArray = new PdVector[4];
        boolean bl = true;
        double[] dArray = new double[4];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PiVector piVector2 = new PiVector(4);
        while (bl) {
            if (++n3 > 10) {
                PsDebug.warning("too many passes, num = " + n3);
                return;
            }
            bl = false;
            for (int i = 0; i < this.m_numElements; ++i) {
                boolean bl2 = false;
                piVector2.setConstant(-1);
                piVector2.setEntry(0, i);
                for (n = 1; n < 4; ++n) {
                    if (this.m_neighbour[i].m_data[n - 1] != -1 && piVector2.contains(this.m_neighbour[i].m_data[n - 1])) {
                        bl2 = true;
                        break;
                    }
                    piVector2.setEntry(n, this.m_neighbour[i].m_data[n - 1]);
                }
                if (bl2) continue;
                for (n = 0; n < 3; ++n) {
                    int n5 = this.m_neighbour[i].m_data[n];
                    if (n5 == -1 || n5 > i) continue;
                    int n6 = n;
                    int n7 = (n + 1) % 3;
                    int n8 = (n + 2) % 3;
                    int n9 = this.getOppVertexLocInd(i, n);
                    int n10 = (n9 + 1) % 3;
                    int n11 = (n9 + 2) % 3;
                    if (this.m_element[i].m_data[n7] == this.m_element[n5].m_data[n10]) {
                        n10 = (n9 + 2) % 3;
                        n11 = (n9 + 1) % 3;
                    }
                    if (this.m_element[i].m_data[n6] == this.m_element[n5].m_data[n9]) {
                        ++n4;
                        continue;
                    }
                    if (this.m_vertex[this.m_element[i].m_data[n7]].hasTag(1) && this.m_vertex[this.m_element[i].m_data[n8]].hasTag(1)) continue;
                    int n12 = this.m_neighbour[n5].m_data[n10];
                    int n13 = this.m_neighbour[n5].m_data[n11];
                    if (n12 > -1 && n12 == n13 || n12 > -1 && piVector2.contains(n12) || n13 > -1 && piVector2.contains(n13)) {
                        ++n4;
                        continue;
                    }
                    if (piVector.getEntry(this.m_element[i].m_data[n7]) <= 4 || piVector.getEntry(this.m_element[i].m_data[n8]) <= 4) continue;
                    pdVectorArray[0] = this.m_vertex[this.m_element[i].m_data[n6]];
                    pdVectorArray[1] = this.m_vertex[this.m_element[i].m_data[n7]];
                    pdVectorArray[2] = this.m_vertex[this.m_element[n5].m_data[n9]];
                    pdVectorArray[3] = this.m_vertex[this.m_element[i].m_data[n8]];
                    PdVector.angle(dArray, pdVectorArray);
                    if (!(dArray[0] + dArray[2] > dArray[1] + dArray[3])) continue;
                    ++n2;
                    bl = true;
                    int n14 = this.m_element[i].m_data[n6];
                    piVector.m_data[n14] = piVector.m_data[n14] + 1;
                    int n15 = this.m_element[i].m_data[n7];
                    piVector.m_data[n15] = piVector.m_data[n15] - 1;
                    int n16 = this.m_element[i].m_data[n8];
                    piVector.m_data[n16] = piVector.m_data[n16] - 1;
                    int n17 = this.m_element[n5].m_data[n9];
                    piVector.m_data[n17] = piVector.m_data[n17] + 1;
                    int n18 = this.m_neighbour[i].m_data[n7];
                    if (n18 > -1) {
                        this.m_neighbour[n18].m_data[this.getOppVertexLocInd((int)i, (int)n7)] = n5;
                    }
                    if ((n18 = this.m_neighbour[n5].m_data[n10]) > -1) {
                        this.m_neighbour[n18].m_data[this.getOppVertexLocInd((int)n5, (int)n10)] = i;
                    }
                    this.m_element[i].m_data[n8] = this.m_element[n5].m_data[n9];
                    this.m_element[n5].m_data[n11] = this.m_element[i].m_data[n6];
                    this.m_neighbour[i].m_data[n6] = this.m_neighbour[n5].m_data[n10];
                    this.m_neighbour[n5].m_data[n9] = this.m_neighbour[i].m_data[n7];
                    this.m_neighbour[i].m_data[n7] = n5;
                    this.m_neighbour[n5].m_data[n10] = i;
                }
            }
        }
        for (n = 0; this.m_bndList != null && n < this.m_bndList.length; ++n) {
            if (this.m_bndList[n].hasTag(2)) continue;
            this.m_bndList[n].makeElementInd();
        }
        if (this.hasElementNormals()) {
            this.makeElementNormals();
        }
        if (this.hasVertexNormals()) {
            this.makeVertexNormals();
        }
        PsDebug.notify("Statistics\n\tnumber of flipped edges = " + n2 + "\n\tnumber of passes\t\t\t = " + n3 + "\n\tnumber of void edges\t = " + n4);
    }

    public void allocateEdgeStars() {
        if (this.getEdgeStars() != null && this.getElementEdges() != null) {
            return;
        }
        this.setEnabledEdges(true);
        this.makeEdgeStars();
    }

    public PgEdgeStar[] makeEdgeStars() {
        int n;
        int n2;
        int n3;
        int n4;
        Object[] objectArray;
        int n5;
        if (this.m_numElements < 1) {
            return null;
        }
        int n6 = -1;
        for (n5 = 0; n5 < this.m_numElements; ++n5) {
            objectArray = this.m_element[n5].m_data;
            int n7 = objectArray.length;
            for (n4 = 0; n4 < n7; ++n4) {
                if (objectArray[n4] <= n6) continue;
                n6 = objectArray[n4];
            }
        }
        n5 = n6 + 1;
        objectArray = new Vector[n5];
        PgEdgeStar pgEdgeStar = null;
        n4 = 0;
        int[] nArray = new int[2];
        for (int i = 0; i < this.m_numElements; ++i) {
            int[] nArray2 = this.m_element[i].m_data;
            n3 = nArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                nArray[0] = this.m_element[i].m_data[n2];
                nArray[1] = this.m_element[i].m_data[(n2 + 1) % n3];
                if (nArray[0] > nArray[1]) {
                    n = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n;
                }
                n = 0;
                if (objectArray[nArray[0]] == null) {
                    objectArray[nArray[0]] = (int)new Vector();
                } else {
                    int n8 = objectArray[nArray[0]].size();
                    for (int j = 0; j < n8; ++j) {
                        pgEdgeStar = (PgEdgeStar)objectArray[nArray[0]].elementAt(j);
                        if (pgEdgeStar.getVertexInd(1) != nArray[1]) continue;
                        n = 1;
                        break;
                    }
                }
                if (n != 0) {
                    pgEdgeStar.addElement(i, (n2 - 1 + n3) % n3);
                    continue;
                }
                ++n4;
                pgEdgeStar = new PgEdgeStar(nArray[0], nArray[1]);
                pgEdgeStar.addElement(i, (n2 - 1 + n3) % n3);
                objectArray[nArray[0]].addElement(pgEdgeStar);
            }
        }
        PgEdgeStar[] pgEdgeStarArray = null;
        if (this.m_bEnableEdges) {
            this.setNumEdgeStars(n4);
            pgEdgeStarArray = this.getEdgeStars();
        } else {
            this.setNumEdgeStars(0);
            pgEdgeStarArray = new PgEdgeStar[n4];
        }
        int n9 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (objectArray[n3] == null) continue;
            n2 = objectArray[n3].size();
            for (n = 0; n < n2; ++n) {
                if (pgEdgeStarArray[n9] != null) {
                    pgEdgeStarArray[n9].copy((PgEdgeStar)objectArray[n3].elementAt(n));
                } else {
                    pgEdgeStarArray[n9] = (PgEdgeStar)objectArray[n3].elementAt(n);
                }
                ++n9;
            }
        }
        if (this.m_bEnableEdges) {
            this.makeElementEdges();
        }
        if (n9 != n4) {
            PsDebug.warning("numEdgeStars is wrong, edge list is void");
            PsDebug.warning("\t numEdgeStars = " + n4 + ", countEdges = " + n9);
        }
        return pgEdgeStarArray;
    }

    public PgEdgeStar[] makeEdgeStarsFromNeighbour() {
        int n;
        int n2;
        int n3;
        if (this.m_numElements < 1) {
            return null;
        }
        if (this.m_neighbour == null || this.m_neighbour.length < this.m_numElements) {
            return null;
        }
        if (!this.checkNeighbour(false)) {
            return null;
        }
        PgEdgeStar pgEdgeStar = null;
        int[] nArray = new int[2];
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < this.m_numElements; ++n3) {
            int n6 = this.m_element[n3].getSize();
            for (n2 = 0; n2 < n6; ++n2) {
                if (this.m_element[n3].m_data[n2] < n5) continue;
                n5 = this.m_element[n3].m_data[n2] + 1;
            }
        }
        Vector[] vectorArray = new Vector[n5];
        for (n3 = 0; n3 < this.m_numElements; ++n3) {
            int n7 = this.m_element[n3].getSize();
            if (this.m_neighbour[n3].getSize() != n7) {
                return null;
            }
            for (n2 = 0; n2 < n7; ++n2) {
                int n8 = this.m_neighbour[n3].m_data[(n2 + n7 - 1) % n7];
                if (n8 != -1 && n8 < n3) continue;
                nArray[0] = this.m_element[n3].m_data[n2];
                nArray[1] = this.m_element[n3].m_data[(n2 + 1) % n7];
                if (nArray[0] > nArray[1]) {
                    n = nArray[0];
                    nArray[0] = nArray[1];
                    nArray[1] = n;
                }
                ++n4;
                pgEdgeStar = new PgEdgeStar(nArray[0], nArray[1]);
                pgEdgeStar.addElement(n3, (n2 - 1 + n7) % n7);
                if (n8 != -1) {
                    pgEdgeStar.addElement(n8, this.getOppVertexLocInd(n3, (n2 - 1 + n7) % n7));
                }
                if (vectorArray[nArray[0]] == null) {
                    vectorArray[nArray[0]] = new Vector();
                }
                vectorArray[nArray[0]].addElement(pgEdgeStar);
            }
        }
        PgEdgeStar[] pgEdgeStarArray = null;
        if (this.m_bEnableEdges) {
            this.setNumEdgeStars(n4);
            pgEdgeStarArray = this.getEdgeStars();
        } else {
            this.setNumEdgeStars(0);
            pgEdgeStarArray = new PgEdgeStar[n4];
        }
        n = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (vectorArray[n3] == null) continue;
            int n9 = vectorArray[n3].size();
            for (int i = 0; i < n9; ++i) {
                if (pgEdgeStarArray[n] != null) {
                    pgEdgeStarArray[n].copy((PgEdgeStar)vectorArray[n3].elementAt(i));
                } else {
                    pgEdgeStarArray[n] = (PgEdgeStar)vectorArray[n3].elementAt(i);
                }
                ++n;
            }
        }
        if (this.m_bEnableEdges) {
            this.makeElementEdges();
        }
        if (n != n4) {
            PsDebug.warning("numEdgeStars is wrong, edge list is void");
            PsDebug.warning("\t numEdgeStars = " + n4 + ", countEdges = " + n);
        }
        return pgEdgeStarArray;
    }

    public String printEdgeList() {
        PgEdgeStar[] pgEdgeStarArray = this.getEdgeStars();
        if (pgEdgeStarArray == null) {
            PsDebug.notify("missing edge list");
            return "missing edge list";
        }
        int n = this.getNumEdgeStars();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\t" + PsConfig.getMessage(33004) + " = " + n + "\n");
        stringBuffer.append("\t" + PsConfig.getMessage(33005) + " = " + this.getNumVertices() + "\n");
        stringBuffer.append("\t" + PsConfig.getMessage(33006) + " = " + this.getNumElements() + "\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t" + PsConfig.getMessage(33007) + "[" + i + "] = (" + pgEdgeStarArray[i].getVertexInd(0) + ", " + pgEdgeStarArray[i].getVertexInd(1) + ")");
            stringBuffer.append("   " + PsConfig.getMessage(33008) + " = {");
            int n2 = pgEdgeStarArray[i].getValence();
            stringBuffer.append(String.valueOf(pgEdgeStarArray[i].getElementInd(0)));
            for (int j = 1; j < n2; ++j) {
                stringBuffer.append(", " + pgEdgeStarArray[i].getElementInd(j));
            }
            stringBuffer.append("}\n");
        }
        return stringBuffer.toString();
    }

    public boolean makeNeighbour() {
        if (this.m_numElements < 1 || !this.m_bConforming) {
            return true;
        }
        this.assureNeighbours();
        PgEdgeStar[] pgEdgeStarArray = this.makeEdgeStars();
        if (pgEdgeStarArray == null) {
            PsDebug.notify("missing edge list");
            return false;
        }
        int n = 0;
        for (int i = 0; i < pgEdgeStarArray.length; ++i) {
            int n2;
            int n3;
            PgEdgeStar pgEdgeStar = pgEdgeStarArray[i];
            int[] nArray = pgEdgeStar.getElementInd();
            if (nArray == null) continue;
            int n4 = pgEdgeStar.getValence();
            if (n4 > n) {
                n = n4;
            }
            if (n4 == 1) {
                this.m_neighbour[nArray[0]].m_data[pgEdgeStar.m_neighbourLocInd[0]] = -1;
                continue;
            }
            if (n4 == 2) {
                this.m_neighbour[nArray[0]].m_data[pgEdgeStar.m_neighbourLocInd[0]] = nArray[1];
                this.m_neighbour[nArray[1]].m_data[pgEdgeStar.m_neighbourLocInd[1]] = nArray[0];
                continue;
            }
            if (n4 <= 2) continue;
            boolean bl = true;
            if (bl || !this.hasElementNormals()) {
                for (int j = 0; j < n4; ++j) {
                    this.m_neighbour[nArray[j]].m_data[pgEdgeStar.m_neighbourLocInd[j]] = -1;
                }
                continue;
            }
            double d = -2.0;
            int n5 = 0;
            int n6 = 1;
            for (n3 = 0; n3 < n4; ++n3) {
                PdVector pdVector = this.m_elementNormal[nArray[n3]];
                for (n2 = n3 + 1; n2 < n4; ++n2) {
                    PdVector pdVector2 = this.m_elementNormal[nArray[n2]];
                    double d2 = PdVector.dot(pdVector, pdVector2);
                    if (d2 <= d) continue;
                    d = d2;
                    n5 = n3;
                    n6 = n2;
                }
            }
            for (n3 = 0; n3 < n4; ++n3) {
                this.m_neighbour[nArray[n3]].m_data[pgEdgeStar.m_neighbourLocInd[n3]] = -1;
            }
            this.m_neighbour[nArray[n5]].m_data[pgEdgeStar.m_neighbourLocInd[n5]] = nArray[n6];
            this.m_neighbour[nArray[n6]].m_data[pgEdgeStar.m_neighbourLocInd[n6]] = nArray[n5];
            if (n4 != 4) continue;
            n3 = -1;
            int n7 = -1;
            for (n2 = 0; n2 < n4; ++n2) {
                if (n3 != -1 || n2 == n5 || n2 == n6) continue;
                n3 = n2;
                break;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                if (n7 != -1 || n2 == n3 || n2 == n5 || n2 == n6) continue;
                n7 = n2;
                break;
            }
            this.m_neighbour[nArray[n3]].m_data[pgEdgeStar.m_neighbourLocInd[n3]] = nArray[n7];
            this.m_neighbour[nArray[n7]].m_data[pgEdgeStar.m_neighbourLocInd[n7]] = nArray[n3];
        }
        if (n > 2) {
            PsDebug.message("Geometry " + this.getName() + " has edge with multiple elements, num = " + n, false);
        }
        return true;
    }

    public boolean makeElementNormals() {
        if (this.m_dim != 3) {
            return false;
        }
        if (this.m_numElements < 1) {
            return true;
        }
        this.assureElementNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
        PdVector.setConstant(this.m_elementNormal, 0.0);
        for (int i = 0; i < this.m_numElements; ++i) {
            PdVector pdVector4;
            PdVector pdVector5;
            int n = this.m_element[i].getSize();
            if (n < 2) continue;
            if (n == 3 && PsJavaView.m_bLargeModel) {
                pdVector5 = this.m_vertex[this.m_element[i].m_data[0]];
                pdVector4 = this.m_vertex[this.m_element[i].m_data[1]];
                pdVector.sub(pdVector4, pdVector5);
                pdVector4 = this.m_vertex[this.m_element[i].m_data[2]];
                pdVector2.sub(pdVector4, pdVector5);
                this.m_elementNormal[i].cross(pdVector, pdVector2);
            } else {
                pdVector5 = this.m_vertex[this.m_element[i].m_data[(-2 + n) % n]];
                pdVector4 = this.m_vertex[this.m_element[i].m_data[(-1 + n) % n]];
                pdVector.sub(pdVector4, pdVector5);
                for (int j = 0; j < n; ++j) {
                    pdVector5 = pdVector4;
                    pdVector4 = this.m_vertex[this.m_element[i].m_data[j]];
                    pdVector2.sub(pdVector4, pdVector5);
                    boolean bl = pdVector3.cross(pdVector, pdVector2);
                    if (bl && pdVector3.normalize()) {
                        this.m_elementNormal[i].add(pdVector3);
                    }
                    pdVector.copyArray(pdVector2);
                }
            }
            this.m_elementNormal[i].normalize();
        }
        return true;
    }

    protected boolean makeElementNormal(int n) {
        if (this.m_dim != 3) {
            return false;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n2 = this.m_element[n].getSize();
        if (n2 < 2) {
            this.m_elementNormal[n].setConstant(0.0);
            return false;
        }
        if (n2 == 3 && PsJavaView.m_bLargeModel) {
            PdVector pdVector3 = this.m_vertex[this.m_element[n].m_data[0]];
            PdVector pdVector4 = this.m_vertex[this.m_element[n].m_data[1]];
            pdVector.sub(pdVector4, pdVector3);
            pdVector4 = this.m_vertex[this.m_element[n].m_data[2]];
            pdVector2.sub(pdVector4, pdVector3);
            this.m_elementNormal[n].cross(pdVector, pdVector2);
        } else {
            this.m_elementNormal[n].setConstant(0.0);
            PdVector pdVector5 = new PdVector(this.m_dim);
            PdVector pdVector6 = this.m_vertex[this.m_element[n].m_data[(-2 + n2) % n2]];
            PdVector pdVector7 = this.m_vertex[this.m_element[n].m_data[(-1 + n2) % n2]];
            pdVector.sub(pdVector7, pdVector6);
            for (int i = 0; i < n2; ++i) {
                pdVector6 = pdVector7;
                pdVector7 = this.m_vertex[this.m_element[n].m_data[i]];
                pdVector2.sub(pdVector7, pdVector6);
                boolean bl = pdVector5.cross(pdVector, pdVector2);
                pdVector.copyArray(pdVector2);
                if (!bl || !pdVector5.normalize()) continue;
                this.m_elementNormal[n].add(pdVector5);
            }
        }
        this.m_elementNormal[n].normalize();
        return true;
    }

    public boolean makeVertexNormals() {
        int n;
        if (this.m_dim != 3) {
            return false;
        }
        super.makeVertexNormals();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        PdVector pdVector3 = new PdVector(this.m_dimOfVectors);
        PdVector pdVector4 = new PdVector(this.m_dimOfVectors);
        boolean[] blArray = new boolean[this.m_maxDimOfElements];
        PdVector.setConstant(this.m_vertexNormal, 0.0);
        for (n = 0; n < this.m_numElements; ++n) {
            int n2;
            int n3;
            boolean bl;
            PdVector pdVector5;
            PdVector pdVector6;
            double d;
            int n4 = this.m_element[n].getSize();
            if (n4 < 3 || (d = this.getAreaOfElement(n)) < 1.0E-10) continue;
            int[] nArray = this.m_element[n].m_data;
            if (n4 == 3 && PsJavaView.m_bLargeModel) {
                pdVector6 = this.m_vertex[nArray[0]];
                pdVector5 = this.m_vertex[nArray[1]];
                pdVector.sub(pdVector5, pdVector6);
                pdVector5 = this.m_vertex[nArray[2]];
                pdVector2.sub(pdVector5, pdVector6);
                bl = pdVector3.cross(pdVector, pdVector2);
                if (bl) {
                    pdVector3.setLength(d);
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    this.m_vertexNormal[nArray[n3]].add(pdVector3);
                }
                continue;
            }
            pdVector6 = this.m_vertex[nArray[(-2 + n4) % n4]];
            pdVector5 = this.m_vertex[nArray[(-1 + n4) % n4]];
            pdVector.sub(pdVector5, pdVector6);
            bl = false;
            pdVector4.setConstant(0.0);
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[(n3 - 1 + n4) % n4];
                pdVector6 = pdVector5;
                pdVector5 = this.m_vertex[nArray[n3]];
                pdVector2.sub(pdVector5, pdVector6);
                boolean bl2 = pdVector3.cross(pdVector, pdVector2);
                pdVector.copyArray(pdVector2);
                boolean bl3 = blArray[n3] = bl2 && pdVector3.setLength(d);
                if (blArray[n3]) {
                    double d2 = this.m_vertexNormal[n2].length();
                    if (d2 > 1.0E-10 && this.m_vertexNormal[n2].dot(pdVector3) / (d2 * d) < -0.707) {
                        this.m_vertexNormal[n2].sub(pdVector3);
                        pdVector4.sub(pdVector3);
                        continue;
                    }
                    this.m_vertexNormal[n2].add(pdVector3);
                    pdVector4.add(pdVector3);
                    continue;
                }
                bl = true;
            }
            if (!bl) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray[(n3 - 1 + n4) % n4];
                if (blArray[n3]) continue;
                this.m_vertexNormal[n2].add(pdVector4);
            }
        }
        for (n = 0; n < this.m_numVertices; ++n) {
            this.m_vertexNormal[n].normalize();
        }
        return true;
    }

    public void buildQuadr(PdVector[] pdVectorArray, int n, int n2) {
        if (pdVectorArray == null || pdVectorArray.length < 4) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = (1 + (n - 1) * (n3 + 1)) * (1 + (n2 - 1) * (n4 + 1));
        int n6 = 4 + 2 * n3 + 2 * n4 - 2;
        int n7 = (n - 1) * (n2 - 1) * n6;
        this.setNumVertices(n5);
        this.setNumElements(n7);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n8 = 0;
        for (int i = 0; i < n; ++i) {
            double d = (double)i / ((double)n - 1.0);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[3], d, pdVectorArray[2]);
            for (int j = 0; j < n2; ++j) {
                double d2 = (double)j / ((double)n2 - 1.0);
                this.m_vertex[n8++].blend(1.0 - d2, pdVector, d2, pdVector2);
            }
        }
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void buildTriangle(PdVector[] pdVectorArray, int n) {
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            PsDebug.warning("no initial vertices or wrong number");
            return;
        }
        int n2 = n * (n + 1) / 2;
        int n3 = (n - 1) * (n - 1);
        this.setNumVertices(n2);
        this.setNumElements(n3);
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            double d = (double)i / (double)(n - 1);
            pdVector.blend(1.0 - d, pdVectorArray[0], d, pdVectorArray[1]);
            pdVector2.blend(1.0 - d, pdVectorArray[2], d, pdVectorArray[1]);
            this.m_vertex[n4++].copy(pdVector);
            for (int j = 1; j < n - i; ++j) {
                double d2 = (double)j / (double)(n - 1 - i);
                this.m_vertex[n4++].blend(1.0 - d2, pdVector, d2, pdVector2);
            }
        }
        this.makeTriangleConn(n);
        this.makeTriangleBnd(n);
    }

    public void buildPolygon(PdVector[] pdVectorArray, int n) {
        PsDebug.error("method not implemented yet");
    }

    public void buildTriangleFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        int n;
        double d;
        int n2;
        int n3;
        PdVector pdVector;
        PdVector pdVector2;
        int n4;
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pgPolygonArray.length != 3 || pgBndConstraintArray.length != 3) {
            PsDebug.warning("wrong argument array list");
            return;
        }
        int n5 = pgPolygonArray[0].getNumVertices();
        int n6 = n5 * (n5 + 1) / 2;
        int n7 = (n5 - 1) * (n5 - 1);
        this.setNumVertices(n6);
        this.setNumElements(n7);
        int n8 = n5;
        for (n4 = 1; n4 < n5 - 1; ++n4) {
            pdVector2 = pgPolygonArray[0].m_vertex[n4];
            pdVector = pgPolygonArray[1].m_vertex[n5 - 1 - n4];
            n3 = 1;
            for (n2 = 1; n2 < n5 - 1 - n4; ++n2) {
                d = (double)n2 / (double)(n5 - 1 - n4);
                for (n = 0; n < this.m_dim; ++n) {
                    this.m_vertex[n8 + n3].m_data[n] = pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]);
                }
                ++n3;
            }
            n8 += n5 - n4;
        }
        --n8;
        for (n4 = 1; n4 < n5 - 1; ++n4) {
            pdVector2 = pgPolygonArray[1].m_vertex[n4];
            pdVector = pgPolygonArray[2].m_vertex[n5 - 1 - n4];
            n3 = -n4 - 2;
            for (n2 = 1; n2 < n5 - 1 - n4; ++n2) {
                d = (double)n2 / (double)(n5 - 1 - n4);
                for (n = 0; n < this.m_dim; ++n) {
                    int n9 = n;
                    this.m_vertex[n8 + n3].m_data[n9] = this.m_vertex[n8 + n3].m_data[n9] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                }
                n3 -= n4 + n2 + 2;
            }
            n8 -= n4 + 1;
        }
        --n8;
        for (n4 = 1; n4 < n5 - 1; ++n4) {
            pdVector2 = pgPolygonArray[2].m_vertex[n4];
            pdVector = pgPolygonArray[0].m_vertex[n5 - 1 - n4];
            n3 = n5 - 1;
            for (n2 = 1; n2 < n5 - 1 - n4; ++n2) {
                d = (double)n2 / (double)(n5 - 1 - n4);
                for (n = 0; n < this.m_dim; ++n) {
                    int n10 = n;
                    this.m_vertex[n8 + n3].m_data[n10] = this.m_vertex[n8 + n3].m_data[n10] + (pdVector2.m_data[n] + d * (pdVector.m_data[n] - pdVector2.m_data[n]));
                }
                n3 += n5 - 1 - n2;
            }
            --n8;
        }
        n8 = n5;
        for (n4 = 1; n4 < n5 - 1; ++n4) {
            n3 = 1;
            for (n2 = 1; n2 < n5 - n4 - 1; ++n2) {
                n = 0;
                while (n < this.m_dim) {
                    int n11 = n++;
                    this.m_vertex[n8 + n3].m_data[n11] = this.m_vertex[n8 + n3].m_data[n11] / 3.0;
                }
                ++n3;
            }
            n8 += n5 - n4;
        }
        n8 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_vertex[n8].copy(pgPolygonArray[0].m_vertex[n4]);
            n8 += n5 - n4;
        }
        --n8;
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_vertex[n8].copy(pgPolygonArray[1].m_vertex[n4]);
            n8 -= n4 + 1;
        }
        n8 += n5;
        for (n4 = 0; n4 < n5; ++n4) {
            this.m_vertex[n8].copy(pgPolygonArray[2].m_vertex[n4]);
            --n8;
        }
        this.makeTriangleConn(n5);
        this.makeTriangleBnd(n5);
        for (n4 = 0; n4 < pgBndConstraintArray.length; ++n4) {
            this.m_bndList[n4].m_bndConstraint = pgBndConstraintArray[n4];
        }
    }

    public void buildQuadrFromCurve(PgPolygon[] pgPolygonArray, PgBndConstraint[] pgBndConstraintArray) {
        int n;
        if (pgPolygonArray == null || pgBndConstraintArray == null) {
            PsDebug.warning("missing argument");
            return;
        }
        if (pgPolygonArray.length != 4 || pgBndConstraintArray.length != 4) {
            PsDebug.warning("wrong argument array list");
            return;
        }
        int n2 = pgPolygonArray[0].getNumVertices();
        int n3 = pgPolygonArray[1].getNumVertices();
        int n4 = 0;
        int n5 = 0;
        int n6 = (1 + (n2 - 1) * (n4 + 1)) * (1 + (n3 - 1) * (n5 + 1));
        int n7 = 4 + 2 * n4 + 2 * n5 - 2;
        int n8 = (n2 - 1) * (n3 - 1) * n7;
        this.setNumVertices(n6);
        this.setNumElements(n8);
        int n9 = 0;
        for (n = 0; n < n2; ++n) {
            double d = (double)n / ((double)n2 - 1.0);
            PdVector pdVector = pgPolygonArray[0].m_vertex[n];
            PdVector pdVector2 = pgPolygonArray[2].m_vertex[n2 - 1 - n];
            for (int i = 0; i < n3; ++i) {
                double d2 = (double)i / ((double)n3 - 1.0);
                PdVector pdVector3 = pgPolygonArray[1].m_vertex[i];
                PdVector pdVector4 = pgPolygonArray[3].m_vertex[n3 - 1 - i];
                for (int j = 0; j < this.m_dim; ++j) {
                    double d3 = pdVector.m_data[j] + d2 * (pdVector2.m_data[j] - pdVector.m_data[j]);
                    double d4 = pdVector4.m_data[j] + d * (pdVector3.m_data[j] - pdVector4.m_data[j]);
                    this.m_vertex[n9].m_data[j] = n == 0 || n == n2 - 1 ? d4 : (i == 0 || i == n3 - 1 ? d3 : (d3 + d4) / 2.0);
                }
                ++n9;
            }
        }
        this.makeQuadrConn(n2, n3);
        this.makeQuadrBnd(n2, n3);
        for (n = 0; n < pgBndConstraintArray.length; ++n) {
            this.m_bndList[n].m_bndConstraint = pgBndConstraintArray[n];
        }
    }

    public boolean close() {
        int n;
        int n2;
        if (this.m_bndList == null || this.m_bndList.length == 0) {
            PsDebug.notify("missing bndList in " + this.getName());
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.warning("less than 2 vertices in " + this.getName());
            return false;
        }
        double d = 0.01;
        boolean bl = true;
        int n3 = this.m_bndList.length;
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_bndList[n2].hasTag(2)) continue;
            dArray[n2] = this.m_bndList[n2].getLength();
            if (!(dArray[n2] > 1.0)) continue;
            dArray[n2] = 1.0;
        }
        PsDebug.notify("removing interior boundaries");
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_bndList[n2].hasTag(2)) continue;
            for (n = n2 + 1; n < n3; ++n) {
                int n4;
                if (this.m_bndList[n].hasTag(2) || (n4 = this.m_bndList[n2].bndcmp(this.m_bndList[n], Math.min(dArray[n2], dArray[n]) * d)) == 0) continue;
                PsDebug.notify("identifying boundary " + n2 + " and " + n);
                this.m_bndList[n2].bnd_id(this.m_bndList[n], n4);
                this.m_bndList[n2].setTag(2);
                this.m_bndList[n].setTag(2);
            }
        }
        if (bl) {
            PsDebug.notify("removing small boundaries");
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.m_bndList[n2].hasTag(2) || this.m_bndList[n2].bndtst(d) != 1) continue;
                PsDebug.notify("removed " + n2);
                this.m_bndList[n2].bnd_shrink();
                this.m_bndList[n2].setTag(2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_bndList[n2] == null || this.m_bndList[n2].hasTag(2)) continue;
            this.m_bndList[n2].assignVertices();
        }
        PsDebug.notify("pasting boundaries");
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_bndList[n2].hasTag(2)) continue;
            for (n = 0; n < n2; ++n) {
                int n5;
                if (this.m_bndList[n].hasTag(2) || (n5 = this.m_bndList[n2].bnd_cmp_paste(this.m_bndList[n], Math.min(dArray[n2], dArray[n]) * d)) == 0) continue;
                PsDebug.notify("pasting " + n2 + " and " + n);
                if (!this.m_bndList[n2].bnd_paste(this.m_bndList[n], n5)) continue;
                this.m_bndList[n].setTag(2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.m_bndList[n2] == null || this.m_bndList[n2].hasTag(2)) continue;
            this.m_bndList[n2].assignVertices();
        }
        int n6 = this.removeDeletedBoundaries();
        if (n6 > 0) {
            PsDebug.notify("Removed " + String.valueOf(n6) + " boundaries.");
        }
        this.removeUnusedVertices();
        return true;
    }

    public int getNumUnusedVertices() {
        int n;
        int n2;
        boolean[] blArray = new boolean[this.m_numVertices];
        for (n2 = 0; n2 < this.m_numElements; ++n2) {
            for (n = this.m_element[n2].m_data.length - 1; n >= 0; --n) {
                blArray[this.m_element[n2].m_data[n]] = true;
            }
        }
        n2 = 0;
        for (n = 0; n < this.m_numVertices; ++n) {
            if (blArray[n]) continue;
            ++n2;
        }
        return n2;
    }

    public boolean removeUnusedVertices() {
        int n;
        int n2;
        int n3 = 1;
        int n4 = -1;
        PiVector piVector = new PiVector(this.m_numVertices);
        piVector.setConstant(n4);
        int[] nArray = piVector.m_data;
        for (n2 = 0; n2 < this.m_numElements; ++n2) {
            for (n = 0; n < this.m_element[n2].m_data.length; ++n) {
                nArray[this.m_element[n2].m_data[n]] = n3;
            }
        }
        int n5 = 0;
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] != n3) continue;
            nArray[n2] = n5++;
        }
        if (n5 == this.m_numVertices) {
            return true;
        }
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
            this.m_vertex[nArray[n2]] = this.m_vertex[n2];
        }
        for (n2 = 0; n2 < this.m_numElements; ++n2) {
            for (n = 0; n < this.m_element[n2].m_data.length; ++n) {
                this.m_element[n2].m_data[n] = nArray[this.m_element[n2].m_data[n]];
            }
        }
        if (this.m_vertexNormal != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexNormal[nArray[n2]] = this.m_vertexNormal[n2];
            }
        }
        if (this.m_vertexColor != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexColor[nArray[n2]] = this.m_vertexColor[n2];
            }
        }
        if (this.m_vertexSize != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexSize.m_data[nArray[n2]] = this.m_vertexSize.m_data[n2];
            }
        }
        if (this.m_vertexTexture != null) {
            for (n2 = 0; n2 < this.m_numVertices; ++n2) {
                if (nArray[n2] == n4 || nArray[n2] >= n2) continue;
                this.m_vertexTexture[nArray[n2]] = this.m_vertexTexture[n2];
            }
        }
        int n6 = this.getNumVectorFields();
        for (n2 = 0; n2 < n6; ++n2) {
            PgVectorField pgVectorField = this.getVectorField(n2);
            if (pgVectorField.getBasedOn() == 1) continue;
            for (n = 0; n < this.m_numVertices; ++n) {
                if (nArray[n] == n4 || nArray[n] >= n) continue;
                pgVectorField.setVector(nArray[n], pgVectorField.getVector(n));
            }
            pgVectorField.setNumVectors(n5);
        }
        if (this.m_bndList != null) {
            for (n2 = 0; n2 < this.m_bndList.length; ++n2) {
                if (this.m_bndList[n2].hasTag(2)) continue;
                int n7 = this.m_bndList[n2].getNumVertices();
                boolean bl = true;
                for (n = 0; n < n7; ++n) {
                    if (this.m_bndList[n2].m_vertexInd.m_data[n] != -1 && this.m_bndList[n2].m_vertexInd.m_data[n] < this.m_numVertices) continue;
                    this.m_bndList[n2].setTag(2);
                    bl = false;
                    break;
                }
                if (!bl) continue;
                for (n = 0; n < n7; ++n) {
                    this.m_bndList[n2].m_vertexInd.m_data[n] = nArray[this.m_bndList[n2].m_vertexInd.m_data[n]];
                }
                this.m_bndList[n2].assignVertices();
            }
        }
        PsDebug.notify("number of deleted vertices = " + (this.m_numVertices - n5));
        this.setNumVertices(n5);
        this.setMaxNumVertices(n5);
        return true;
    }

    public int[] removeMarkedVertices() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = -1;
        int[] nArray = super.removeMarkedVertices();
        if (!this.isConforming()) {
            block0: for (n4 = 0; n4 < this.m_numElements; ++n4) {
                for (n3 = this.m_element[n4].getSize() - 1; n3 >= 0; --n3) {
                    if (nArray[this.m_element[n4].m_data[n3]] != n5) continue;
                    n2 = this.m_neighbour[n4].m_data[(n3 + 1) % 3];
                    n = this.m_neighbour[n4].m_data[(n3 + 2) % 3];
                    int n6 = this.getOppVertexLocInd(n4, (n3 + 1) % 3);
                    int n7 = this.getOppVertexLocInd(n4, (n3 + 2) % 3);
                    if (n6 == -1 || n7 == -1) continue block0;
                    this.m_element[n].m_data[n7] = this.m_element[n2].m_data[n6];
                    this.m_neighbour[n2].m_data[n6] = n;
                    this.m_neighbour[n].m_data[n7] = n2;
                    continue block0;
                }
            }
        }
        block2: for (n4 = 0; n4 < this.m_numElements; ++n4) {
            for (n3 = this.m_element[n4].getSize() - 1; n3 >= 0; --n3) {
                if (nArray[this.m_element[n4].m_data[n3]] == n5) {
                    this.m_element[n4].setTag(2);
                    continue block2;
                }
                this.m_element[n4].m_data[n3] = nArray[this.m_element[n4].m_data[n3]];
            }
        }
        if (this.m_bndList != null) {
            for (n4 = 0; n4 < this.m_bndList.length; ++n4) {
                if (this.m_bndList[n4].hasTag(2)) continue;
                n3 = this.m_bndList[n4].getNumVertices();
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    if (nArray[this.m_bndList[n4].m_vertexInd.m_data[n]] == n5) continue;
                    this.m_bndList[n4].m_vertexInd.m_data[n2++] = nArray[this.m_bndList[n4].m_vertexInd.m_data[n]];
                }
                if (n2 >= n3) continue;
                this.m_bndList[n4].setNumVertices(n2);
            }
        }
        this.removeMarkedElements();
        return nArray;
    }

    public int[] removeElement(int n) {
        this.m_element[n].setTag(2);
        return this.removeMarkedElements();
    }

    public int[] removeMarkedElements() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 1;
        int n7 = -1;
        PiVector piVector = new PiVector(this.m_numElements);
        int[] nArray = piVector.m_data;
        for (n5 = 0; n5 < this.m_numElements; ++n5) {
            nArray[n5] = this.m_element[n5].hasTag(2) ? n7 : n6;
        }
        int n8 = 0;
        for (n5 = 0; n5 < this.m_numElements; ++n5) {
            if (nArray[n5] != n6) continue;
            nArray[n5] = n8++;
        }
        for (n5 = 0; n5 < this.m_numElements; ++n5) {
            if (nArray[n5] == n7) continue;
            for (n4 = 0; n4 < this.m_element[n5].m_data.length; ++n4) {
                if (this.m_neighbour[n5].m_data[n4] <= -1) continue;
                this.m_neighbour[n5].m_data[n4] = nArray[this.m_neighbour[n5].m_data[n4]];
            }
        }
        for (n5 = 0; n5 < this.m_numElements; ++n5) {
            if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
            this.m_element[nArray[n5]].setSize(this.m_element[n5].getSize());
            this.m_element[nArray[n5]].copy(this.m_element[n5]);
            this.m_neighbour[nArray[n5]].setSize(this.m_neighbour[n5].getSize());
            this.m_neighbour[nArray[n5]].copy(this.m_neighbour[n5]);
        }
        if (this.m_elementNormal != null) {
            for (n5 = 0; n5 < this.m_numElements; ++n5) {
                if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
                this.m_elementNormal[nArray[n5]].setSize(this.m_elementNormal[n5].getSize());
                this.m_elementNormal[nArray[n5]].copy(this.m_elementNormal[n5]);
            }
        }
        if (this.m_elementColor != null) {
            for (n5 = 0; n5 < this.m_numElements; ++n5) {
                if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
                this.m_elementColor[nArray[n5]] = this.m_elementColor[n5];
            }
        }
        if (this.m_elementBackColor != null) {
            for (n5 = 0; n5 < this.m_numElements; ++n5) {
                if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
                this.m_elementBackColor[nArray[n5]] = this.m_elementBackColor[n5];
            }
        }
        if (this.m_elementTexture != null) {
            for (n5 = 0; n5 < this.m_numElements; ++n5) {
                if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
                this.m_elementTexture[nArray[n5]] = PdVector.copyNew(this.m_elementTexture[n5]);
            }
        }
        if (this.m_edgeStar != null) {
            for (n5 = 0; n5 < this.m_numEdgeStars; ++n5) {
                n3 = this.m_edgeStar[n5].getValence();
                n2 = 0;
                for (n4 = 0; n4 < n3; ++n4) {
                    n = this.m_edgeStar[n5].getElementInd(n4);
                    if (nArray[n] == n7) continue;
                    this.m_edgeStar[n5].setElementInd(n2, nArray[n]);
                    this.m_edgeStar[n5].setNeighbourLocInd(n2, this.m_edgeStar[n5].getNeighbourLocInd(n4));
                    ++n2;
                }
                if (n2 >= n3) continue;
                this.m_edgeStar[n5].setValence(n2);
            }
        }
        if (this.m_elementEdge != null) {
            for (n5 = 0; n5 < this.m_numElements; ++n5) {
                if (nArray[n5] == n7 || nArray[n5] >= n5) continue;
                this.m_elementEdge[nArray[n5]].setSize(this.m_elementEdge[n5].getSize());
                this.m_elementEdge[nArray[n5]].copy(this.m_elementEdge[n5]);
            }
        }
        if (this.m_bndList != null) {
            n3 = 0;
            block12: for (n5 = 0; n5 < this.m_bndList.length; ++n5) {
                if (this.m_bndList[n5].hasTag(2)) continue;
                n2 = this.m_bndList[n5].getNumElements();
                n = 0;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (nArray[this.m_bndList[n5].m_elementInd.m_data[n4]] == n7) {
                        if (!this.isConforming()) continue;
                        this.m_bndList[n5].setTag(2);
                        n3 = 1;
                        continue block12;
                    }
                    this.m_bndList[n5].m_elementInd.m_data[n++] = nArray[this.m_bndList[n5].m_elementInd.m_data[n4]];
                }
            }
            if (n3 != 0) {
                this.removeDeletedBoundaries();
            }
        }
        n3 = this.getNumVectorFields();
        for (n5 = 0; n5 < n3; ++n5) {
            PgVectorField pgVectorField = this.getVectorField(n5);
            if (pgVectorField.getBasedOn() == 0) continue;
            for (n4 = 0; n4 < this.m_numElements; ++n4) {
                if (nArray[n4] == n7 || nArray[n4] >= n4) continue;
                pgVectorField.setVector(nArray[n4], pgVectorField.getVector(n4));
            }
            pgVectorField.setNumVectors(n8);
        }
        PsDebug.notify("number of deleted elements = " + (this.m_numElements - n8));
        this.setNumElements(n8);
        this.setMaxNumElements(n8);
        return nArray;
    }

    public boolean merge(PgGeometryIf pgGeometryIf) {
        int n;
        boolean bl;
        boolean bl2;
        int n2;
        int n3;
        int n4;
        int n5 = this.m_numVertices;
        if (!super.merge(pgGeometryIf)) {
            return false;
        }
        if (!(pgGeometryIf instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometryIf;
        if (this.m_numElements == 0) {
            this.setDimOfElements(pgElementSet.m_dimOfElements);
        } else if (pgElementSet.m_dimOfElements != this.m_dimOfElements) {
            this.setDimOfElements(-1);
        }
        int n6 = this.m_numElements;
        int n7 = this.m_numElements + pgElementSet.m_numElements;
        this.setNumElements(n7);
        PiVector.copy(this.m_element, n6, pgElementSet.m_element, 0, pgElementSet.m_numElements);
        for (n4 = 0; n4 < pgElementSet.m_numElements; ++n4) {
            n3 = pgElementSet.m_element[n4].getSize();
            if (this.m_dimOfElements == -1) {
                this.m_element[n6 + n4].setSize(n3);
            }
            n2 = 0;
            while (n2 < n3) {
                int n8 = n2++;
                this.m_element[n6 + n4].m_data[n8] = this.m_element[n6 + n4].m_data[n8] + n5;
            }
        }
        if (pgElementSet.m_neighbour != null) {
            PiVector.copy(this.m_neighbour, n6, pgElementSet.m_neighbour, 0, pgElementSet.m_numElements);
            for (n4 = 0; n4 < pgElementSet.m_numElements; ++n4) {
                n3 = pgElementSet.m_element[n4].getSize();
                if (this.m_dimOfElements == -1) {
                    this.m_neighbour[n6 + n4].setSize(n3);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    if (pgElementSet.m_neighbour[n4].m_data[n2] <= -1) continue;
                    int n9 = n2;
                    this.m_neighbour[n6 + n4].m_data[n9] = this.m_neighbour[n6 + n4].m_data[n9] + n6;
                }
            }
        }
        if (pgElementSet.m_elementNormal != null) {
            this.assureElementNormals();
            PdVector.copy(this.m_elementNormal, n6, pgElementSet.m_elementNormal, 0, pgElementSet.m_numElements);
        }
        Color color = this.getGlobalElementColor();
        Color color2 = pgElementSet.getGlobalElementColor();
        boolean bl3 = color.getRGB() != color2.getRGB() || this.hasElementColors() || pgElementSet.hasElementColors();
        boolean bl4 = color.getRGB() == color2.getRGB() && !this.isShowingElementColors() && !pgElementSet.isShowingElementColors();
        boolean bl5 = bl3 && !this.isShowingElementColors();
        boolean bl6 = bl2 = bl3 && !pgElementSet.isShowingElementColors();
        if (!bl4) {
            this.showElementColors(true);
        }
        if (bl3) {
            this.assureElementColors();
            if (bl5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    this.setElementColor(n4, color);
                }
            }
            if (bl2) {
                for (n4 = n6; n4 < n7; ++n4) {
                    this.setElementColor(n4, color2);
                }
            } else {
                PdColor.copy(this.m_elementColor, n6, pgElementSet.m_elementColor, 0, pgElementSet.m_numElements);
            }
        }
        Color color3 = this.getGlobalElementBackColor();
        Color color4 = pgElementSet.getGlobalElementBackColor();
        boolean bl7 = color3.getRGB() != color4.getRGB() || this.hasElementBackColors() || pgElementSet.hasElementBackColors();
        boolean bl8 = color3.getRGB() == color4.getRGB() && !this.isShowingElementBackColors() && !pgElementSet.isShowingElementBackColors();
        boolean bl9 = bl3 && !this.isShowingElementBackColors();
        boolean bl10 = bl = bl3 && !pgElementSet.isShowingElementBackColors();
        if (!bl8) {
            this.showElementBackColors(true);
        }
        if (bl7) {
            this.assureElementBackColors();
            if (bl9) {
                for (n4 = 0; n4 < n6; ++n4) {
                    this.setElementBackColor(n4, color3);
                }
            }
            if (bl) {
                for (n4 = n6; n4 < n7; ++n4) {
                    this.setElementBackColor(n4, color4);
                }
            } else {
                PdColor.copy(this.m_elementBackColor, n6, pgElementSet.m_elementBackColor, 0, pgElementSet.m_numElements);
            }
        }
        if (pgElementSet.m_elementTexture != null) {
            this.assureElementTextures();
            for (n4 = 0; n4 < pgElementSet.m_numElements; ++n4) {
                n3 = pgElementSet.m_element[n4].getSize();
                PdVector.copy(this.m_elementTexture[n6 + n4], 0, pgElementSet.m_elementTexture[n4], 0, n3);
            }
        }
        int n10 = this.m_numEdgeStars;
        int n11 = this.m_numEdgeStars + pgElementSet.m_numEdgeStars;
        this.setNumEdgeStars(n11);
        PiVector.copy(this.m_edgeStar, n10, pgElementSet.m_edgeStar, 0, pgElementSet.m_numEdgeStars);
        for (n4 = 0; n4 < pgElementSet.m_numEdgeStars; ++n4) {
            int n12 = pgElementSet.m_edgeStar[n4].getSize();
            n = pgElementSet.m_edgeStar[n4].getValence();
            n2 = 0;
            while (n2 < n12) {
                int n13 = n2++;
                this.m_edgeStar[n10 + n4].m_data[n13] = this.m_edgeStar[n10 + n4].m_data[n13] + n5;
            }
            n2 = 0;
            while (n2 < n) {
                int n14 = n2++;
                this.m_edgeStar[n10 + n4].m_elementInd[n14] = this.m_edgeStar[n10 + n4].m_elementInd[n14] + n6;
            }
        }
        color = this.getGlobalEdgeColor();
        color2 = pgElementSet.getGlobalEdgeColor();
        bl3 = color.getRGB() != color2.getRGB() || this.hasEdgeColors() || pgElementSet.hasEdgeColors();
        bl4 = color.getRGB() == color2.getRGB() && !this.isShowingEdgeColors() && !pgElementSet.isShowingEdgeColors();
        bl5 = bl3 && !this.hasEdgeColors();
        boolean bl11 = bl2 = bl3 && !pgElementSet.hasEdgeColors();
        if (!bl4) {
            this.showEdgeColors(true);
        }
        if (bl3) {
            this.assureEdgeColors();
            if (bl5) {
                for (n4 = 0; n4 < n10; ++n4) {
                    this.m_edgeColor[n4] = color;
                }
            }
            if (bl2) {
                for (n4 = n10; n4 < n11; ++n4) {
                    this.m_edgeColor[n4] = color2;
                }
            } else {
                PdColor.copy(this.m_edgeColor, n10, pgElementSet.m_edgeColor, 0, pgElementSet.m_numEdgeStars);
            }
        }
        if (pgElementSet.m_edgeSize != null) {
            this.assureEdgeSizes();
            this.m_edgeSize.copy(n10, pgElementSet.m_edgeSize, 0, pgElementSet.m_numEdgeStars);
        }
        if (pgElementSet.m_elementEdge != null) {
            this.assureElementEdges();
            PiVector.copy(this.m_elementEdge, n6, pgElementSet.m_elementEdge, 0, pgElementSet.m_numElements);
            for (n4 = 0; n4 < pgElementSet.m_numElements; ++n4) {
                n3 = pgElementSet.m_element[n4].getSize();
                this.m_elementEdge[n6 + n4].setSize(n3);
                n2 = 0;
                while (n2 < n3) {
                    int n15 = n2++;
                    this.m_elementEdge[n6 + n4].m_data[n15] = this.m_elementEdge[n6 + n4].m_data[n15] + n10;
                }
            }
        }
        if (pgElementSet.m_bndList != null) {
            PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
            this.m_bndList = new PgBndPolygon[pgBndPolygonArray.length + pgElementSet.m_bndList.length];
            for (n4 = 0; n4 < pgBndPolygonArray.length; ++n4) {
                this.m_bndList[n4] = pgBndPolygonArray[n4];
            }
            for (n4 = 0; n4 < pgElementSet.m_bndList.length; ++n4) {
                this.m_bndList[pgBndPolygonArray.length + n4] = pgElementSet.m_bndList[n4];
            }
            for (n4 = pgBndPolygonArray.length; n4 < this.m_bndList.length; ++n4) {
                n = this.m_bndList[n4].getNumVertices();
                if (this.m_bndList[n4].m_vertexInd != null) {
                    n2 = 0;
                    while (n2 < n) {
                        int n16 = n2++;
                        this.m_bndList[n4].m_vertexInd.m_data[n16] = this.m_bndList[n4].m_vertexInd.m_data[n16] + n5;
                    }
                }
                if (this.m_bndList[n4].m_elementInd != null) {
                    n2 = 0;
                    while (n2 < n - 1) {
                        int n17 = n2++;
                        this.m_bndList[n4].m_elementInd.m_data[n17] = this.m_bndList[n4].m_elementInd.m_data[n17] + n6;
                    }
                }
                this.m_bndList[n4].setGeometry(this);
                this.m_bndList[n4].assignVertices();
            }
        }
        return true;
    }

    public boolean refineGlobalIntoFour() {
        return this.refineGlobalIntoFour(true);
    }

    public boolean refineGlobalIntoFour(boolean bl) {
        int n;
        int n2;
        Serializable serializable;
        int n3;
        Cloneable cloneable;
        int n4;
        int n5;
        int n6;
        int[][] nArrayArray = new int[][]{{3, 4, 5}, {0, 5, 4}, {1, 3, 5}, {2, 4, 3}};
        int[] nArray = new int[6];
        if (this.m_dimOfElements != 3 && (n6 = PgElementSet.triangulate(this)) == 0) {
            PsDebug.error("initial triangulation failed");
            return false;
        }
        int n7 = this.m_numVertices;
        int n8 = this.m_numElements;
        n6 = this.m_numVertices + this.getNumEdges();
        this.setNumVertices(n6);
        PdVector[][] pdVectorArray = this.hasElementTextures() ? this.getElementTextures() : new PdVector[1][1];
        this.setNumElements(4 * n8);
        if (this.m_bndList != null) {
            for (n5 = 0; n5 < this.m_bndList.length; ++n5) {
                if (this.m_bndList[n5].hasTag(2)) continue;
                n4 = this.m_bndList[n5].getNumVertices();
                cloneable = this.m_bndList[n5];
                ((PgPolygon)cloneable).setNumVertices(2 * n4 - 1);
                for (n3 = n4 - 1; n3 >= 0; --n3) {
                    ((PgBndPolygon)cloneable).m_vertexInd.m_data[2 * n3] = ((PgBndPolygon)cloneable).m_vertexInd.m_data[n3];
                }
            }
        }
        cloneable = new PiVector(n6 - n7);
        PiVector piVector = new PiVector(n6 - n7);
        int n9 = n7 - 1;
        for (n5 = n8 - 1; n5 >= 0; --n5) {
            for (n3 = 0; n3 < 3; ++n3) {
                if (this.m_neighbour[n5].m_data[n3] >= n5) continue;
                if (++n9 == this.m_numVertices) {
                    PsDebug.error("internal error");
                    return false;
                }
                int n10 = this.m_element[n5].m_data[(n3 + 3 - 1) % 3];
                int n11 = this.m_element[n5].m_data[(n3 + 1) % 3];
                ((PiVector)cloneable).setEntry(n9 - n7, n10);
                piVector.setEntry(n9 - n7, n11);
                if (!bl) continue;
                this.m_vertex[n9].blend(0.5, this.m_vertex[n10], 0.5, this.m_vertex[n11]);
            }
        }
        if (this.hasVertexColors()) {
            n9 = n7 - 1;
            for (n5 = n8 - 1; n5 >= 0; --n5) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (this.m_neighbour[n5].m_data[n3] >= n5) continue;
                    Color color = this.getVertexColor(this.m_element[n5].m_data[(n3 + 3 - 1) % 3]);
                    Color color2 = this.getVertexColor(this.m_element[n5].m_data[(n3 + 1) % 3]);
                    serializable = PdColor.blend(0.5, color, 0.5, color2);
                    this.setVertexColor(++n9, (Color)serializable);
                }
            }
        }
        if (this.hasVertexNormals()) {
            n9 = n7 - 1;
            for (n5 = n8 - 1; n5 >= 0; --n5) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (this.m_neighbour[n5].m_data[n3] >= n5) continue;
                    ++n9;
                    PdVector pdVector = this.getVertexNormal(this.m_element[n5].m_data[(n3 + 3 - 1) % 3]);
                    PdVector pdVector2 = this.getVertexNormal(this.m_element[n5].m_data[(n3 + 1) % 3]);
                    serializable = PdVector.blendNew(0.5, pdVector, 0.5, pdVector2);
                    ((PdVector)serializable).normalize();
                    this.setVertexNormal(n9, (PdVector)serializable);
                }
            }
        }
        if (this.hasVertexTextures()) {
            PdVector[] pdVectorArray2 = this.getVertexTextures();
            n9 = n7 - 1;
            for (n5 = n8 - 1; n5 >= 0; --n5) {
                for (n3 = 0; n3 < 3; ++n3) {
                    if (this.m_neighbour[n5].m_data[n3] >= n5) continue;
                    PdVector pdVector = pdVectorArray2[this.m_element[n5].m_data[(n3 + 3 - 1) % 3]];
                    serializable = pdVectorArray2[this.m_element[n5].m_data[(n3 + 1) % 3]];
                    pdVectorArray2[++n9] = PdVector.blendNew(0.5, pdVector, 0.5, (PdVector)serializable);
                }
            }
        }
        boolean bl2 = this.hasBoundary();
        n9 = n7 - 1;
        for (n5 = n8 - 1; n5 >= 0; --n5) {
            block11: for (n3 = 0; n3 < 3; ++n3) {
                int n12;
                int n13;
                nArray[n3] = this.m_element[n5].m_data[n3];
                if (this.m_neighbour[n5].m_data[n3] < n5) {
                    n13 = this.m_element[n5].m_data[(n3 + 3 - 1) % 3];
                    int n14 = this.m_element[n5].m_data[(n3 + 1) % 3];
                    nArray[n3 + 3] = ++n9;
                    if (this.m_neighbour[n5].m_data[n3] != -1 || !bl2) continue;
                    n2 = 0;
                    block12: for (n = 0; n < this.m_bndList.length && n2 == 0; ++n) {
                        if (this.m_bndList[n].hasTag(2)) continue;
                        n4 = this.m_bndList[n].getNumVertices();
                        for (n12 = 0; n12 < n4 - 2; n12 += 2) {
                            if ((this.m_bndList[n].m_vertexInd.m_data[n12] != n13 || this.m_bndList[n].m_vertexInd.m_data[n12 + 2] != n14) && (this.m_bndList[n].m_vertexInd.m_data[n12] != n14 || this.m_bndList[n].m_vertexInd.m_data[n12 + 2] != n13)) continue;
                            this.m_bndList[n].m_vertexInd.m_data[n12 + 1] = n9;
                            n2 = 1;
                            continue block12;
                        }
                    }
                    if (n2 != 0) continue;
                    PsDebug.warning("boundary edge not found\n\tEdge = (" + n13 + ", " + n14 + ")");
                    continue;
                }
                n13 = this.m_neighbour[n5].m_data[n3];
                for (n12 = 0; n12 < 3; ++n12) {
                    if (this.m_neighbour[n13].m_data[n12] != n5) continue;
                    nArray[n3 + 3] = this.m_element[n13].m_data[n12];
                    continue block11;
                }
            }
            for (n3 = 0; n3 < 4; ++n3) {
                for (n = 0; n < 3; ++n) {
                    this.m_element[n5 + n3 * n8].m_data[n] = nArray[nArrayArray[n3][n]];
                }
            }
        }
        for (n5 = 0; n5 < n8; ++n5) {
            for (n3 = 0; n3 < 3; ++n3) {
                int n15 = n5 + (n3 + 1) * n8;
                int n16 = n5 + ((n3 + 1) % 3 + 1) * n8;
                n2 = this.m_neighbour[n5].m_data[(n3 + 2) % 3];
                if (n2 == -1) {
                    this.m_neighbour[n15].m_data[2] = -1;
                    this.m_neighbour[n16].m_data[1] = -1;
                    continue;
                }
                for (n = 1; n < 4 && this.m_element[n2 + n * n8].m_data[0] != this.m_element[n15].m_data[0]; ++n) {
                }
                this.m_neighbour[n15].m_data[2] = n2 + n * n8;
                for (n = 1; n < 4 && this.m_element[n2 + n * n8].m_data[0] != this.m_element[n16].m_data[0]; ++n) {
                }
                this.m_neighbour[n16].m_data[1] = n2 + n * n8;
            }
        }
        for (n5 = 0; n5 < n8; ++n5) {
            for (n3 = 0; n3 < 3; ++n3) {
                this.m_neighbour[n5].m_data[n3] = n5 + (n3 + 1) * n8;
                this.m_neighbour[n5 + (n3 + 1) * n8].m_data[0] = n5;
            }
        }
        if (this.hasElementColors()) {
            Color[] colorArray = this.getElementColors();
            for (n5 = 0; n5 < n8; ++n5) {
                this.setElementColor(n5 + n8, colorArray[n5]);
                this.setElementColor(n5 + 2 * n8, colorArray[n5]);
                this.setElementColor(n5 + 3 * n8, colorArray[n5]);
            }
        }
        if (this.m_elementBackColor != null) {
            Color[] colorArray = this.getElementBackColors();
            for (n5 = 0; n5 < n8; ++n5) {
                this.setElementBackColor(n5 + n8, colorArray[n5]);
                this.setElementBackColor(n5 + 2 * n8, colorArray[n5]);
                this.setElementBackColor(n5 + 3 * n8, colorArray[n5]);
            }
        }
        if (this.hasElementNormals()) {
            PdVector[] pdVectorArray3 = this.getElementNormals();
            for (n5 = 0; n5 < n8; ++n5) {
                this.setElementNormal(n5 + n8, pdVectorArray3[n5]);
                this.setElementNormal(n5 + 2 * n8, pdVectorArray3[n5]);
                this.setElementNormal(n5 + 3 * n8, pdVectorArray3[n5]);
            }
        }
        int n17 = this.getNumVectorFields();
        for (n5 = 0; n5 < n17; ++n5) {
            Object object;
            PgVectorField pgVectorField = this.getVectorField(n5);
            if (pgVectorField.getBasedOn() == 0) {
                pgVectorField.setNumVectors(n6);
                object = pgVectorField.getVectors();
                for (n3 = n7; n3 < n6; ++n3) {
                    object[n3].blend(0.5, object[((PiVector)cloneable).getEntry(n3 - n7)], 0.5, object[piVector.getEntry(n3 - n7)]);
                }
                continue;
            }
            pgVectorField.setNumVectors(n8 * 4);
            for (n3 = 0; n3 < n8; ++n3) {
                object = pgVectorField.getVector(n3);
                pgVectorField.setVector(n3 + n8, (PdVector)object);
                pgVectorField.setVector(n3 + 2 * n8, (PdVector)object);
                pgVectorField.setVector(n3 + 3 * n8, (PdVector)object);
            }
        }
        if (this.hasElementTextures()) {
            PdVector[][] pdVectorArray4 = this.getElementTextures();
            PdVector[] pdVectorArray5 = new PdVector[6];
            for (n5 = 0; n5 < n8; ++n5) {
                pdVectorArray5[0] = PdVector.copyNew(pdVectorArray[n5][0]);
                pdVectorArray5[1] = PdVector.copyNew(pdVectorArray[n5][1]);
                pdVectorArray5[2] = PdVector.copyNew(pdVectorArray[n5][2]);
                pdVectorArray5[3] = PdVector.blendNew(0.5, pdVectorArray[n5][1], 0.5, pdVectorArray[n5][2]);
                pdVectorArray5[4] = PdVector.blendNew(0.5, pdVectorArray[n5][2], 0.5, pdVectorArray[n5][0]);
                pdVectorArray5[5] = PdVector.blendNew(0.5, pdVectorArray[n5][0], 0.5, pdVectorArray[n5][1]);
                for (n3 = 0; n3 < 4; ++n3) {
                    if (n3 != 0) {
                        pdVectorArray4[n3 * n8 + n5] = new PdVector[3];
                    }
                    for (n = 0; n < 3; ++n) {
                        pdVectorArray4[n3 * n8 + n5][n] = PdVector.copyNew(pdVectorArray5[nArrayArray[n3][n]]);
                    }
                }
            }
        }
        if (this.m_bndList != null) {
            for (n = 0; n < this.m_bndList.length; ++n) {
                if (this.m_bndList[n].hasTag(2) || this.m_bndList[n].makeElementInd()) continue;
                this.removeBoundaries();
                break;
            }
        }
        return true;
    }

    public int getElementWithVertex(int n) {
        for (int i = 0; i < this.m_numElements; ++i) {
            if (!this.m_element[i].contains(n)) continue;
            return i;
        }
        return -1;
    }

    public PgEdgeStar getEdge(int n, int n2) {
        PgEdgeStar pgEdgeStar = null;
        for (int i = 0; i < this.m_numElements; ++i) {
            int[] nArray = this.m_element[i].m_data;
            if (nArray == null) continue;
            int n3 = nArray.length;
            for (int j = 0; j < n3; ++j) {
                int n4;
                if (nArray[j] != n) continue;
                int n5 = (j + 1) % n3;
                int n6 = (j - 1 + n3) % n3;
                if (nArray[n5] == n2) {
                    n4 = n6;
                } else {
                    if (nArray[n6] != n2) continue;
                    n4 = (j - 2 + n3) % n3;
                }
                if (pgEdgeStar == null) {
                    pgEdgeStar = new PgEdgeStar(n, n2);
                }
                pgEdgeStar.addElement(i, n4);
            }
        }
        return pgEdgeStar;
    }

    public void clearTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].clearTag(n2);
    }

    public boolean hasTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        return this.m_element[n].hasTag(n2);
    }

    public void setTagElement(int n, int n2) {
        if (n < 0 || n > this.m_numElements - 1) {
            PsDebug.warning("index=" + n + " out of range");
            return;
        }
        this.m_element[n].setTag(n2);
    }

    public PdVector[] getElementVertices(int n) {
        if (n < 0 || this.m_numElements <= n) {
            PsDebug.warning("elemInd out of bounds, elemInd = " + n);
            return null;
        }
        if (this.m_element[n].getSize() == 0) {
            PsDebug.notify("empty element, elemInd = " + n);
            return null;
        }
        int n2 = this.m_element[n].getSize();
        PdVector[] pdVectorArray = new PdVector[n2];
        --n2;
        while (n2 >= 0) {
            pdVectorArray[n2] = this.m_vertex[this.m_element[n].m_data[n2]];
            --n2;
        }
        return pdVectorArray;
    }

    public PiVector getElement(int n) {
        if (n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_element[n];
    }

    public PiVector getNeighbour(int n) {
        if (this.m_neighbour == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_neighbour[n];
    }

    public Color getElementColor(int n) {
        if (this.m_elementColor == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementColor[n];
    }

    public Color getElementBackColor(int n) {
        if (this.m_elementBackColor == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementBackColor[n];
    }

    public PdVector getElementNormal(int n) {
        if (this.m_elementNormal == null || n < 0 || n >= this.m_numElements) {
            return null;
        }
        return this.m_elementNormal[n];
    }

    public boolean setElementVertices(int n, PdVector[] pdVectorArray) {
        PiVector piVector = this.m_element[n];
        int n2 = piVector.getSize();
        if (n2 != pdVectorArray.length) {
            PsDebug.warning("element and array have different length");
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            this.setVertex(piVector.m_data[i], pdVectorArray[i]);
        }
        return true;
    }

    public void setElement(int n, int n2, int n3, int n4) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 3);
        this.m_element[n].set(n2, n3, n4);
    }

    public void setElement(int n, int n2, int n3, int n4, int n5) {
        if (n < 0) {
            PsDebug.warning("index out of range, corrupt argument");
            return;
        }
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, 4);
        this.m_element[n].set(n2, n3, n4, n5);
    }

    public boolean setElement(int n, int[] nArray) {
        if (n >= this.m_numElements) {
            this.setNumElements(n + 1);
        }
        int n2 = nArray.length;
        this.setDimOfElement(n, n2);
        this.m_element[n].copy(nArray, n2);
        return true;
    }

    public boolean setElement(int n, PiVector piVector) {
        if (n < 0 || piVector == null) {
            PsDebug.warning("index out of range, corrupt argument");
            return false;
        }
        if (n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " > " + this.m_numElements + "=m_numElements, bad programming style");
            this.setNumElements(n + 1);
        }
        this.setDimOfElement(n, piVector.getSize());
        this.m_element[n].copy(piVector);
        return true;
    }

    public boolean setNeighbour(int n, PiVector piVector) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("element index out of range, ind = " + n);
            return false;
        }
        if (piVector == null || piVector.getSize() != this.m_element[n].getSize()) {
            PsDebug.warning("size of given neighbour array does not match size of existing element, elemInd = " + n);
            return false;
        }
        this.m_neighbour[n].copyArray(piVector);
        return true;
    }

    public boolean setElementColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementColor == null || n >= this.m_elementColor.length) {
            this.assureElementColors();
        }
        this.m_elementColor[n] = color;
        return true;
    }

    public boolean setElementBackColor(int n, Color color) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (color == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementBackColor == null || n >= this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        this.m_elementBackColor[n] = color;
        return true;
    }

    public boolean setElementNormal(int n, PdVector pdVector) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVector == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementNormal == null || n >= this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        this.m_elementNormal[n].copy(pdVector);
        return true;
    }

    public boolean setElementTexture(int n, PdVector[] pdVectorArray) {
        if (n < 0 || n >= this.m_numElements) {
            PsDebug.warning("index=" + n + " out of range");
            return false;
        }
        if (pdVectorArray == null) {
            PsDebug.warning("missing argument");
            return false;
        }
        if (this.m_elementTexture == null || n >= this.m_elementTexture.length) {
            this.assureElementTextures();
        }
        this.m_elementTexture[n] = PdVector.copyNew(pdVectorArray, pdVectorArray.length);
        return true;
    }

    public void setElements(PiVector[] piVectorArray) {
        if ((piVectorArray == null || piVectorArray.length == 0) && this.m_numElements == 0) {
            return;
        }
        if (piVectorArray == null || piVectorArray.length == 0 || piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of element array");
            return;
        }
        if (this.isEnabledInstanceSharing()) {
            this.m_element = piVectorArray;
            if (this.m_maxNumElements != piVectorArray.length) {
                this.setMaxNumElements(piVectorArray.length);
            }
            return;
        }
        int n = 0;
        int n2 = piVectorArray[0].getSize();
        if (n2 < 3) {
            n2 = -1;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            int n3 = piVectorArray[i].getSize();
            if (n3 > this.m_maxDimOfElements) {
                n = n3;
                n3 = this.m_maxDimOfElements;
            }
            if (n3 != this.m_element[i].getSize()) {
                this.m_element[i].setSize(n3);
                if (this.m_neighbour != null) {
                    this.m_neighbour[i].setSize(n3);
                }
            }
            if (n2 == -1 || n3 == n2) continue;
            n2 = -1;
        }
        if (this.m_dimOfElements != n2) {
            this.setDimOfElements(n2);
        }
        PiVector.copy(this.m_element, 0, piVectorArray, 0, this.m_numElements);
        if (n > 0) {
            PsDebug.error("maximal dimension of an element = " + n + " truncated to size = " + this.m_maxDimOfElements);
        }
    }

    public void removeElementColors() {
        this.setElementColors(null);
    }

    public void setElementColors(Color[] colorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_elementColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_elementColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementColor == null || this.m_numElements > this.m_elementColor.length) {
            this.assureElementColors();
        }
        PdColor.copy(this.m_elementColor, 0, colorArray, 0, this.m_numElements);
    }

    public void removeElementBackColors() {
        this.setElementBackColors(null);
    }

    public void setElementBackColors(Color[] colorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_elementBackColor = colorArray;
            return;
        }
        if (colorArray == null) {
            this.m_elementBackColor = null;
            return;
        }
        if (colorArray.length < this.m_numElements) {
            PsDebug.warning("void length of color array");
            return;
        }
        if (this.m_elementBackColor == null || this.m_numElements > this.m_elementBackColor.length) {
            this.assureElementBackColors();
        }
        PdColor.copy(this.m_elementBackColor, 0, colorArray, 0, this.m_numElements);
    }

    public void removeElementNormals() {
        this.setElementNormals(null);
    }

    public void setElementNormals(PdVector[] pdVectorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_elementNormal = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_elementNormal = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of normal array");
            return;
        }
        if (this.m_elementNormal == null || this.m_numElements > this.m_elementNormal.length) {
            this.assureElementNormals();
        }
        PdVector.copy(this.m_elementNormal, 0, pdVectorArray, 0, this.m_numElements);
    }

    public void setElementTextures(PdVector[][] pdVectorArray) {
        int n;
        if (this.isEnabledInstanceSharing()) {
            this.m_elementTexture = pdVectorArray;
            return;
        }
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of tex array");
            return;
        }
        for (n = 0; n < this.m_numElements; ++n) {
            if (pdVectorArray[n] != null && pdVectorArray[n].length == this.m_element[n].getSize()) continue;
            PsDebug.warning("void length of texCoords[" + n + "]");
            return;
        }
        this.assureElementTextures();
        for (n = 0; n < this.m_numElements; ++n) {
            PdVector.copy(this.m_elementTexture[n], 0, pdVectorArray[n], 0, this.m_element[n].getSize());
        }
    }

    public void setElementTexturesFromList(PdVector[] pdVectorArray) {
        if (pdVectorArray == null) {
            this.m_elementTexture = null;
            return;
        }
        if (pdVectorArray.length < this.getNumElementIndices()) {
            PsDebug.warning("void length of argument array");
            return;
        }
        this.assureElementTextures();
        int n = 0;
        for (int i = 0; i < this.m_numElements; ++i) {
            int n2 = this.m_element[i].getSize();
            for (int j = 0; j < n2; ++j) {
                this.m_elementTexture[i][j].copy(pdVectorArray[n++]);
            }
        }
    }

    public void removeTexture() {
        this.setElementTextures(null);
        this.showElementTexture(false);
        super.removeTexture();
    }

    public void setNeighbours(PiVector[] piVectorArray) {
        if (this.isEnabledInstanceSharing()) {
            this.m_neighbour = piVectorArray;
            return;
        }
        if (piVectorArray == null) {
            this.m_neighbour = null;
            return;
        }
        if (piVectorArray.length < this.m_numElements) {
            PsDebug.warning("void length of neighbour array");
            return;
        }
        this.assureNeighbours();
        for (int i = 0; i < this.m_numElements; ++i) {
            this.m_neighbour[i].setSize(piVectorArray[i].getSize());
        }
        PiVector.copy(this.m_neighbour, 0, piVectorArray, 0, this.m_numElements);
    }

    public int getNeighbourLocInd(int n, int n2, int n3) {
        int n4 = this.m_element[n].getSize();
        for (int i = 0; i < n4; ++i) {
            if (this.m_element[n].m_data[i] == n2 && this.m_element[n].m_data[(i + 1) % n4] == n3) {
                return (i + n4 - 1) % n4;
            }
            if (this.m_element[n].m_data[i] != n3 || this.m_element[n].m_data[(i + 1) % n4] != n2) continue;
            return (i + n4 - 1) % n4;
        }
        PsDebug.error("cannot find edge (" + n2 + "," + n3 + ") in element[" + n + "]");
        return -1;
    }

    public int getOppVertexInd(int n, int n2) {
        int n3 = this.getOppVertexLocInd(n, n2);
        if (n3 == -2) {
            return -1;
        }
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n].m_data[n2];
        if (n4 < 0) {
            return -1;
        }
        return this.m_element[n4].m_data[n3];
    }

    public int getOppVertexLocInd(int n, int n2) {
        if (this.m_neighbour == null) {
            return -2;
        }
        if (n == -1 || n2 == -1) {
            return -1;
        }
        int n3 = this.m_neighbour[n].m_data[n2];
        if (n3 == -1) {
            return -1;
        }
        int n4 = this.m_neighbour[n3].getSize();
        if (this.m_bConforming) {
            int n5 = this.m_element[n].getSize();
            int n6 = this.m_element[n].m_data[(n2 + 1) % n5];
            int n7 = this.m_element[n].m_data[(n2 + 2) % n5];
            for (int i = 0; i < n4; ++i) {
                int[] nArray = this.m_element[n3].m_data;
                if (this.m_neighbour[n3].m_data[i] != n || (n6 != nArray[(i + 2) % n4] || n7 != nArray[(i + 1) % n4]) && (n6 != nArray[(i + 1) % n4] || n7 != nArray[(i + 2) % n4])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                if (this.m_neighbour[n3].m_data[i] != n) continue;
                return i;
            }
        }
        PsDebug.error("error in neighbour connectivity at element " + n);
        return -2;
    }

    public double getAreaOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        double d = PdVector.area(pdVectorArray);
        return d;
    }

    public double getArea() {
        double d = 0.0;
        for (int i = 0; i < this.m_numElements; ++i) {
            d += this.getAreaOfElement(i);
        }
        return d;
    }

    public double getVolumeOfElement(int n) {
        PdVector[] pdVectorArray = this.getElementVertices(n);
        if (pdVectorArray == null || pdVectorArray.length < 3) {
            return 0.0;
        }
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        pdVector.setConstant(0.0);
        pdVector2.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2]);
        double d = -PuVectorGeom.distOfPointToPlane(pdVector, pdVectorArray[0], pdVector2);
        double d2 = PdVector.area(pdVectorArray);
        return d2 * d / 3.0;
    }

    public double getVolume() {
        double d = 0.0;
        for (int i = 0; i < this.m_numElements; ++i) {
            d += this.getVolumeOfElement(i);
        }
        return d;
    }

    public double getL2Norm() {
        double d = 0.0;
        for (int i = 0; i < this.m_numElements; ++i) {
            PdVector[] pdVectorArray = this.getElementVertices(i);
            double d2 = 0.0;
            int n = this.m_element[i].getSize();
            for (int j = 1; j < n - 1; ++j) {
                d2 += pdVectorArray[0].sqrLength() + PdVector.dot(pdVectorArray[0], pdVectorArray[j]);
                d2 += pdVectorArray[j].sqrLength() + PdVector.dot(pdVectorArray[j], pdVectorArray[j + 1]);
                double d3 = PdVector.area(pdVectorArray[0], pdVectorArray[j], pdVectorArray[j + 1]);
                d += 2.0 * d3 * (d2 += pdVectorArray[j + 1].sqrLength() + PdVector.dot(pdVectorArray[j + 1], pdVectorArray[0])) / 12.0;
            }
        }
        return d;
    }

    public PdMatrix getL2Matrix(PdMatrix pdMatrix) {
        int n;
        Object[] objectArray;
        double d;
        int n2;
        if (this.m_dimOfElements != 3) {
            PsDebug.warning("elements must be triangular.");
            return null;
        }
        if (pdMatrix == null) {
            pdMatrix = new PdMatrix(this.m_numVertices);
        } else if (pdMatrix.getSize() != this.m_numVertices) {
            pdMatrix.setSize(this.m_numVertices);
        }
        for (n2 = 0; n2 < this.m_numElements; ++n2) {
            d = this.getAreaOfElement(n2) / 12.0;
            objectArray = this.m_element[n2].m_data;
            for (n = 0; n < 3; ++n) {
                double[] dArray = pdMatrix.m_data[objectArray[n]];
                double d2 = objectArray[n];
                dArray[d2] = dArray[d2] + (d + d);
                double[] dArray2 = pdMatrix.m_data[objectArray[n]];
                double d3 = objectArray[(n + 1) % 3];
                dArray2[d3] = dArray2[d3] + d;
                double[] dArray3 = pdMatrix.m_data[objectArray[(n + 1) % 3]];
                double d4 = objectArray[n];
                dArray3[d4] = dArray3[d4] + d;
            }
        }
        d = 0.0;
        objectArray = new double[this.m_dim];
        for (n2 = 0; n2 < this.m_numVertices; ++n2) {
            int n3;
            for (n3 = 0; n3 < this.m_dim; ++n3) {
                objectArray[n3] = 0.0;
            }
            for (n = 0; n < this.m_numVertices; ++n) {
                for (n3 = 0; n3 < this.m_dim; ++n3) {
                    int n4 = n3;
                    objectArray[n4] = objectArray[n4] + pdMatrix.m_data[n2][n] * this.m_vertex[n].m_data[n3];
                }
            }
            for (n3 = 0; n3 < this.m_dim; ++n3) {
                d += this.m_vertex[n2].m_data[n3] * objectArray[n3];
            }
        }
        if (Math.abs(d - this.getL2Norm()) > 1.0E-10) {
            PsDebug.warning("different L2-norms:\n\t getL2Norm()   = " + this.getL2Norm() + "\n\t getL2Matrix() = " + d);
        }
        return pdMatrix;
    }

    public double getEdgeLength(int n, int n2) {
        int[] nArray = this.m_element[n].m_data;
        double d = PdVector.dist(this.m_vertex[nArray[(n2 + 1) % nArray.length]], this.m_vertex[nArray[(n2 + 2) % nArray.length]]);
        return d;
    }

    public double getVertexAngle(int n, int n2) {
        int n3 = this.m_element[n].getSize();
        PdVector pdVector = this.m_vertex[this.m_element[n].m_data[n2]];
        PdVector pdVector2 = this.m_vertex[this.m_element[n].m_data[(n2 + 1) % n3]];
        PdVector pdVector3 = this.m_vertex[this.m_element[n].m_data[(n2 - 1 + n3) % n3]];
        return PdVector.angle(pdVector, pdVector2, pdVector3);
    }

    public void computeRotation(PgPolygon pgPolygon, int n) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeRotation(pgPolygon, n);
        int n2 = pgPolygon.getNumVertices();
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeCone(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCone(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeCylinder(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeCylinder(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeDisk(int n, int n2, double d) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeDisk(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computePlane(int n, int n2, double d, double d2, double d3, double d4) {
        if (this.m_dim < 2) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computePlane(n, n2, d, d2, d3, d4);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeSphere(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSphere(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeTorus(int n, int n2, double d, double d2) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeTorus(n, n2, d, d2);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public void computeSnail(int n, int n2, double d) {
        if (this.m_dim < 3) {
            PsDebug.warning("vertex dimension = " + this.m_dim + " too small.");
            return;
        }
        super.computeSnail(n, n2, d);
        this.makeQuadrConn(n, n2);
        this.makeQuadrBnd(n, n2);
    }

    public int getNumBoundaryEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            for (int i = 0; i < this.m_numElements; ++i) {
                n += this.m_element[i].getSize();
            }
        } else {
            for (int i = 0; i < this.m_numElements; ++i) {
                int n2 = this.m_element[i].getSize();
                for (int j = 0; j < n2; ++j) {
                    if (this.m_neighbour[i].m_data[j] != -1) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNumEdges() {
        int n = 0;
        if (this.m_neighbour == null) {
            for (int i = 0; i < this.m_numElements; ++i) {
                n += this.m_element[i].getSize();
            }
            return n;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            int n2 = this.m_element[i].getSize();
            for (int j = 0; j < n2; ++j) {
                if (this.m_neighbour[i].m_data[j] >= i) continue;
                ++n;
            }
        }
        return n;
    }

    public void fixBoundaries() {
        PgBndPolygon[] pgBndPolygonArray = this.getBoundaries();
        if (pgBndPolygonArray == null) {
            return;
        }
        for (int i = 0; i < pgBndPolygonArray.length; ++i) {
            if (pgBndPolygonArray[i] == null) continue;
            PgBndConstraint pgBndConstraint = new PgBndConstraint(this.getDimOfVertices());
            pgBndConstraint.setShape(3);
            pgBndPolygonArray[i].setBndConstraint(pgBndConstraint);
        }
    }

    public void markBoundary() {
        if (this.m_numVertices == 0) {
            return;
        }
        if (this.m_neighbour != null && this.m_neighbour.length != this.m_element.length) {
            PsDebug.warning("void neighbour structure");
            return;
        }
        if (this.m_neighbour == null) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                this.m_vertex[i].setTag(14);
            }
        } else {
            int n;
            for (n = 0; n < this.m_numVertices; ++n) {
                this.m_vertex[n].clearTag(14);
            }
            for (n = 0; n < this.m_numElements; ++n) {
                int n2 = this.m_neighbour[n].getSize();
                for (int i = 0; i < n2; ++i) {
                    if (this.m_neighbour[n].m_data[i] >= 0) continue;
                    if (this.isConforming()) {
                        this.m_vertex[this.m_element[n].m_data[(i + 1) % n2]].setTag(14);
                        this.m_vertex[this.m_element[n].m_data[(i + 2) % n2]].setTag(14);
                        continue;
                    }
                    this.m_vertex[this.m_element[n].m_data[i]].setTag(14);
                }
            }
        }
    }

    public int getNumBoundaryVertices() {
        int n = 0;
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (!this.m_vertex[i].hasTag(14)) continue;
            ++n;
        }
        return n;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        int n;
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgElementSet) || !(pgGeometry2 instanceof PgElementSet)) {
            return false;
        }
        PgElementSet pgElementSet = (PgElementSet)pgGeometry;
        PgElementSet pgElementSet2 = (PgElementSet)pgGeometry2;
        if (pgElementSet.m_numElements != pgElementSet2.m_numElements) {
            PsDebug.warning("unequal number of elements");
            return false;
        }
        double d4 = Math.abs(d);
        PgElementSet pgElementSet3 = d4 > (d3 = Math.abs(d2)) ? pgElementSet : pgElementSet2;
        this.m_bShowEdgeLabels = pgElementSet3.m_bShowEdgeLabels;
        this.m_bShowElementLabels = pgElementSet3.m_bShowElementLabels;
        this.m_bShowBoundaries = pgElementSet3.m_bShowBoundaries;
        this.m_bShowTaggedBoundaries = pgElementSet3.m_bShowTaggedBoundaries;
        this.m_bShowElementTexture = pgElementSet3.m_bShowElementTexture;
        this.m_bShowSilhouette = pgElementSet3.m_bShowSilhouette;
        this.m_bShowEdges = pgElementSet3.m_bShowEdges;
        this.m_bShowTaggedEdges = pgElementSet3.m_bShowTaggedEdges;
        this.m_bShowEdgeColors = pgElementSet3.m_bShowEdgeColors;
        this.m_bShowEdgeSizes = pgElementSet3.m_bShowEdgeSizes;
        this.m_bShowElements = pgElementSet3.m_bShowElements;
        this.m_bShowTaggedElements = pgElementSet3.m_bShowTaggedElements;
        this.m_bShowBackface = pgElementSet3.m_bShowBackface;
        this.m_bShowElementNormals = pgElementSet3.m_bShowElementNormals;
        this.m_bShowElementNormalArrow = pgElementSet3.m_bShowElementNormalArrow;
        this.m_bShowElementColors = pgElementSet3.m_bShowElementColors;
        this.m_bShowElementBackColor = pgElementSet3.m_bShowElementBackColor;
        this.m_bShowElementBackColors = pgElementSet3.m_bShowElementBackColors;
        this.m_bConforming = pgElementSet3.m_bConforming;
        this.m_globalBndColor.blend(d4, pgElementSet.m_globalBndColor, d3, pgElementSet2.m_globalBndColor);
        this.m_globalBndTagColor.blend(d4, pgElementSet.m_globalBndTagColor, d3, pgElementSet2.m_globalBndTagColor);
        this.m_globalBndSize.blend(d4, pgElementSet.m_globalBndSize, d3, pgElementSet2.m_globalBndSize);
        this.m_globalEdgeColor.blend(d4, pgElementSet.m_globalEdgeColor, d3, pgElementSet2.m_globalEdgeColor);
        this.m_globalEdgeTagColor.blend(d4, pgElementSet.m_globalEdgeTagColor, d3, pgElementSet2.m_globalEdgeTagColor);
        this.m_globalEdgeSize.blend(d4, pgElementSet.m_globalEdgeSize, d3, pgElementSet2.m_globalEdgeSize);
        this.m_globalElementNormalLength.blend(d4, pgElementSet.m_globalElementNormalLength, d3, pgElementSet2.m_globalElementNormalLength);
        this.m_globalElementNormalSize.blend(d4, pgElementSet.m_globalElementNormalSize, d3, pgElementSet2.m_globalElementNormalSize);
        this.m_globalElementNormalColor.blend(d4, pgElementSet.m_globalElementNormalColor, d3, pgElementSet2.m_globalElementNormalColor);
        this.m_globalElementColor.blend(d4, pgElementSet.m_globalElementColor, d3, pgElementSet2.m_globalElementColor);
        this.m_globalElementTagColor.blend(d4, pgElementSet.m_globalElementTagColor, d3, pgElementSet2.m_globalElementTagColor);
        this.m_globalElementBackColor.blend(d4, pgElementSet.m_globalElementBackColor, d3, pgElementSet2.m_globalElementBackColor);
        this.setNumElements(pgElementSet3.getNumElements());
        for (n = 0; n < this.m_numElements; ++n) {
            this.m_element[n].copy(pgElementSet3.m_element[n]);
        }
        if (pgElementSet3.m_neighbour != null) {
            for (n = 0; n < this.m_numElements; ++n) {
                this.m_neighbour[n].copy(pgElementSet3.m_neighbour[n]);
            }
        }
        if (pgElementSet.m_elementNormal != null && pgElementSet2.m_elementNormal != null) {
            this.assureElementNormals();
            this.makeElementNormals();
        } else {
            this.m_elementNormal = null;
        }
        if (pgElementSet.m_elementColor != null && pgElementSet2.m_elementColor != null) {
            this.assureElementColors();
            for (n = 0; n < this.m_numElements; ++n) {
                this.m_elementColor[n] = PdColor.blend(d4, pgElementSet.m_elementColor[n], d3, pgElementSet2.m_elementColor[n]);
            }
        } else {
            this.m_elementColor = null;
        }
        if (pgElementSet.m_elementBackColor != null && pgElementSet2.m_elementBackColor != null) {
            this.assureElementBackColors();
            for (n = 0; n < this.m_numElements; ++n) {
                this.m_elementBackColor[n] = PdColor.blend(d4, pgElementSet.m_elementBackColor[n], d3, pgElementSet2.m_elementBackColor[n]);
            }
        } else {
            this.m_elementBackColor = null;
        }
        if (pgElementSet.m_elementTexture != null && pgElementSet2.m_elementTexture != null) {
            this.assureElementTextures();
            for (n = 0; n < this.m_numElements; ++n) {
                int n2 = pgElementSet3.m_element[n].getSize();
                for (int i = 0; i < n2; ++i) {
                    this.m_elementTexture[n][i].blend(d4, pgElementSet.m_elementTexture[n][i], d3, pgElementSet2.m_elementTexture[n][i]);
                }
            }
        } else {
            this.m_elementTexture = null;
        }
        this.setNumEdgeStars(pgElementSet3.getNumEdgeStars());
        if (this.m_numEdgeStars > 0) {
            PiVector.copy(this.m_edgeStar, 0, pgElementSet3.m_edgeStar, 0, this.m_numEdgeStars);
        }
        if (pgElementSet.m_edgeColor != null && pgElementSet2.m_edgeColor != null) {
            this.assureEdgeColors();
            for (n = 0; n < this.m_numEdgeStars; ++n) {
                this.m_edgeColor[n] = PdColor.blend(d4, pgElementSet.m_edgeColor[n], d3, pgElementSet2.m_edgeColor[n]);
            }
        } else {
            this.m_edgeColor = null;
        }
        if (pgElementSet.m_edgeSize != null && pgElementSet2.m_edgeSize != null) {
            this.assureEdgeSizes();
            this.m_edgeSize.blend(d4, pgElementSet.m_edgeSize, d3, pgElementSet2.m_edgeSize);
        } else {
            this.m_edgeSize = null;
        }
        if (pgElementSet3.m_elementEdge != null) {
            this.assureElementEdges();
            for (n = 0; n < this.m_numElements; ++n) {
                this.m_elementEdge[n].copy(pgElementSet3.m_elementEdge[n]);
            }
        } else {
            this.m_elementEdge = null;
        }
        if (pgElementSet.hasBoundary() && pgElementSet2.hasBoundary()) {
            this.assureBoundary(pgElementSet3.m_bndList.length);
            for (n = 0; n < this.m_bndList.length; ++n) {
                this.m_bndList[n].blend(d, pgElementSet.m_bndList[n], d2, pgElementSet2.m_bndList[n]);
            }
        } else {
            this.m_bndList = null;
        }
        return true;
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public void setConforming(boolean bl) {
        this.m_bConforming = bl;
        if (this.m_bndList != null) {
            for (int i = 0; i < this.m_bndList.length; ++i) {
                if (this.m_bndList[i] == null) continue;
                this.m_bndList[i].m_bConforming = bl;
            }
        }
    }

    public static boolean triangulate(PgElementSet pgElementSet) {
        int n;
        Object object;
        int n2;
        if (pgElementSet == null) {
            PsDebug.warning("Missing geometry");
            return false;
        }
        if (pgElementSet.getDimOfElements() == 3) {
            return true;
        }
        int n3 = 0;
        for (n2 = 0; n2 < pgElementSet.m_numElements; ++n2) {
            n3 += pgElementSet.m_element[n2].getSize();
        }
        PiVector piVector = new PiVector(n3 -= 2 * pgElementSet.getNumElements());
        PiVector[] piVectorArray = new PiVector[n3];
        boolean bl = pgElementSet.hasElementTextures();
        PdVector[][] pdVectorArray = null;
        if (bl) {
            pdVectorArray = new PdVector[n3][3];
        }
        int n4 = 0;
        for (n2 = 0; n2 < pgElementSet.m_numElements; ++n2) {
            PiVector piVector2 = pgElementSet.m_element[n2];
            int n5 = piVector2.getSize();
            if (n4 + n5 - 2 > n3) {
                PsDebug.warning("too many triangles, programming error");
            }
            object = pgElementSet.getElementVertices(n2);
            PiVector[] piVectorArray2 = PgUtil.triangulate((PdVector[])object, n5);
            for (n = 0; n < n5 - 2; ++n) {
                int n6;
                piVectorArray2[n].copy((P_Vector)piVector2);
                if (bl) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        pdVectorArray[n4 + n][n6] = PdVector.copyNew(pgElementSet.m_elementTexture[n2][piVectorArray2[n].m_data[n6]]);
                    }
                }
                for (n6 = 0; n6 < 3; ++n6) {
                    piVectorArray2[n].m_data[n6] = piVector2.m_data[piVectorArray2[n].m_data[n6]];
                }
                piVectorArray[n4 + n] = piVectorArray2[n];
                piVector.m_data[n4 + n] = n2;
            }
            n4 += n5 - 2;
        }
        pgElementSet.setDimOfElements(3);
        pgElementSet.setNumElements(n3);
        pgElementSet.setElements(piVectorArray);
        pgElementSet.makeNeighbour();
        if (pgElementSet.hasElementColors()) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                pgElementSet.setElementColor(n2, pgElementSet.getElementColor(piVector.m_data[n2]));
            }
        }
        if (pgElementSet.getElementBackColors() != null) {
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                pgElementSet.setElementBackColor(n2, pgElementSet.getElementBackColor(piVector.m_data[n2]));
            }
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        if (pgElementSet.hasElementNormals()) {
            pgElementSet.makeElementNormals();
        }
        if (bl) {
            pgElementSet.setElementTextures(pdVectorArray);
        }
        int n7 = pgElementSet.getNumVectorFields();
        for (n2 = 0; n2 < n7; ++n2) {
            object = pgElementSet.getVectorField(n2);
            if (((PgVectorField)object).getBasedOn() == 0) continue;
            ((PgVectorField)object).setNumVectors(n3);
            for (n = n3 - 1; n >= 0; --n) {
                ((PgVectorField)object).setVector(n, ((PgVectorField)object).getVector(piVector.m_data[n]));
            }
        }
        int n8 = pgElementSet.getNumBoundaries();
        for (n2 = 0; n2 < n8; ++n2) {
            if (pgElementSet.m_bndList[n2].makeElementInd()) continue;
            pgElementSet.removeBoundaries();
            break;
        }
        if (pgElementSet.hasVertexNormals()) {
            pgElementSet.makeVertexNormals();
        }
        return true;
    }

    public boolean checkNeighbour() {
        return this.checkNeighbour(true);
    }

    public boolean checkNeighbour(boolean bl) {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_neighbour == null) {
            if (bl) {
                PsDebug.warning("missing neighbour information");
            }
            return false;
        }
        int n = -1;
        boolean bl2 = true;
        StringBuffer stringBuffer = null;
        if (bl) {
            stringBuffer = new StringBuffer("");
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            if (bl && !bl2 && stringBuffer.length() > 50000) {
                stringBuffer.append("---- message exceeded max message size, message truncated -----\n");
                break;
            }
            int n2 = this.m_element[i].getSize();
            if (n2 != this.m_neighbour[i].getSize()) {
                bl2 = false;
                if (bl) {
                    stringBuffer.append(PsConfig.getMessage(33009) + "\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33011) + " = " + n2 + "\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33012) + " = " + this.m_neighbour[i].getSize() + "\n");
                }
            }
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = this.m_neighbour[i].m_data[j];
                if (n4 == -1) continue;
                if (n4 == i) {
                    bl2 = false;
                    if (!bl) continue;
                    stringBuffer.append("element has itself as neighbour\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_element[i].m_data[j] + "\n");
                    for (n3 = 0; n3 < n2; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n3 + "] = " + this.m_element[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                if (n4 >= this.m_numElements) {
                    bl2 = false;
                    if (!bl) continue;
                    stringBuffer.append(PsConfig.getMessage(33014) + "\n");
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_element[i].m_data[j] + " >= m_numElements.\n");
                    for (n3 = 0; n3 < n2; ++n3) {
                        stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n3 + "] = " + this.m_element[i].m_data[n3] + ", neighbour[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                    }
                    continue;
                }
                int n5 = this.m_neighbour[n4].getSize();
                boolean bl3 = false;
                for (int k = 0; k < n5; ++k) {
                    if (this.m_neighbour[n4].m_data[k] != i || (this.m_element[i].m_data[(j + 1) % n2] != this.m_element[n4].m_data[(k + 2) % n5] || this.m_element[i].m_data[(j + 2) % n2] != this.m_element[n4].m_data[(k + 1) % n5]) && (this.m_element[i].m_data[(j + 1) % n2] != this.m_element[n4].m_data[(k + 1) % n5] || this.m_element[i].m_data[(j + 2) % n2] != this.m_element[n4].m_data[(k + 2) % n5])) continue;
                    bl3 = true;
                    n = k;
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                if (!bl) continue;
                stringBuffer.append(PsConfig.getMessage(33015) + "\n");
                stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + i + " " + PsConfig.getMessage(33013) + " = " + this.m_element[i].m_data[j] + "\n");
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + i + "][" + n3 + "] = " + this.m_element[i].m_data[n3] + ", " + PsConfig.getMessage(33016) + "[" + i + "][" + n3 + "] = " + this.m_neighbour[i].m_data[n3] + "\n");
                }
                if (bl3) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n4 + " " + PsConfig.getMessage(33013) + " = " + this.m_element[n4].m_data[n] + "\n");
                } else {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + " = " + n4 + " " + PsConfig.getMessage(33017) + "\n");
                }
                for (n3 = 0; n3 < n5; ++n3) {
                    stringBuffer.append("\t" + PsConfig.getMessage(33010) + "[" + n4 + "][" + n3 + "] = " + this.m_element[n4].m_data[n3] + ", " + PsConfig.getMessage(33016) + "[" + n4 + "][" + n3 + "] = " + this.m_neighbour[n4].m_data[n3] + "\n");
                }
            }
            if (!bl && !bl2) break;
        }
        if (bl) {
            if (bl2) {
                PsDebug.message(PsConfig.getMessage(33018), false);
            } else {
                PsDebug.message(stringBuffer.toString());
            }
        }
        return bl2;
    }

    public PvPickEvent intersectionWithLine(PdVector pdVector, PdVector pdVector2) {
        if (this.m_dim != 2 && this.m_dim != 3) {
            return null;
        }
        if (pdVector == null || pdVector.getSize() != 3 || pdVector2 == null || pdVector2.getSize() != 3) {
            PsDebug.warning("missing or wrong dimension of ray");
            return null;
        }
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(3);
        PgGeometry.convertWorldToModel(this, pdVector, pdVector2, pdVector3, pdVector4);
        pdVector4.normalize();
        PdVector pdVector5 = new PdVector(3);
        PdVector pdVector6 = new PdVector(3);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        PdVector pdVector7 = new PdVector(3);
        PdVector pdVector8 = this.m_dim == 2 ? new PdVector(2) : pdVector7;
        PdVector pdVector9 = new PdVector(3);
        PdBary pdBary = new PdBary(3);
        PdBary pdBary2 = new PdBary(3);
        PdVector pdVector10 = null;
        if (this.m_dim == 2) {
            pdVector10 = new PdVector(3);
        }
        PdVector[] pdVectorArray = new PdVector[this.getMaxDimOfElements()];
        boolean bl = this.hasElementNormals();
        for (int i = 0; i < this.m_numElements; ++i) {
            int n4 = this.m_element[i].getSize();
            if (n4 < 3) continue;
            pdVectorArray[0] = this.m_vertex[this.m_element[i].m_data[0]];
            if (this.m_dim == 2) {
                pdVector10.copyArray(pdVectorArray[0]);
                pdVector5.set(0.0, 0.0, 1.0);
            } else {
                pdVector10 = pdVectorArray[0];
            }
            for (int j = 1; j < n4 - 1; ++j) {
                pdVectorArray[1] = this.m_vertex[this.m_element[i].m_data[j]];
                pdVectorArray[2] = this.m_vertex[this.m_element[i].m_data[j + 1]];
                if (this.m_dim != 2) {
                    if (bl) {
                        pdVector5 = this.m_elementNormal[i];
                    } else if (!pdVector5.normalOfPlane(pdVectorArray[0], pdVectorArray[1], pdVectorArray[2])) continue;
                }
                if ((d = PuVectorGeom.intersectionOfLineAndPlane(pdVector7, pdVector3, pdVector4, pdVector10, pdVector5)) >= d2) continue;
                if (this.m_dim == 2) {
                    pdVector8.m_data[0] = pdVector7.m_data[0];
                    pdVector8.m_data[1] = pdVector7.m_data[1];
                }
                PdBary.getBary(pdBary, pdVector8, pdVectorArray);
                if (!pdBary.isInside()) continue;
                d2 = d;
                n2 = i;
                n3 = j;
                pdBary2.copy(pdBary);
                pdBary2.setElementInd(n2);
                pdVector6.copy(pdVector5);
                pdVector9.copy(pdVector7);
                if (Math.abs(1.0 - pdBary.getEntry(0)) < 0.1) {
                    n = this.m_element[i].getEntry(0);
                    continue;
                }
                if (Math.abs(1.0 - pdBary.getEntry(1)) < 0.1) {
                    n = this.m_element[i].getEntry(j);
                    continue;
                }
                if (!(Math.abs(1.0 - pdBary.getEntry(2)) < 0.1)) continue;
                n = this.m_element[i].getEntry(j + 1);
            }
        }
        if (n2 == -1) {
            return null;
        }
        PvPickEvent pvPickEvent = new PvPickEvent(this.m_dim);
        pvPickEvent.setGeometry(this);
        pvPickEvent.setVertex(pdVector9);
        pvPickEvent.setDistance(d2);
        pvPickEvent.setHorDistance(0.0);
        pvPickEvent.setElementInd(n2);
        pvPickEvent.setElementSubInd(n3);
        pvPickEvent.setBary(pdBary2);
        pvPickEvent.setVertexInd(n);
        pvPickEvent.setViewBase(pdVector);
        pvPickEvent.setViewDir(pdVector2);
        pvPickEvent.setNormal(pdVector6);
        return pvPickEvent;
    }

    public int getSavedNumVertices() {
        return this.m_savedNumVertices;
    }

    public void setSavedNumVertices(int n) {
        this.m_savedNumVertices = n;
    }

    public PiVector[] getSavedElements() {
        return this.m_elementSaved;
    }

    public void setSavedElements(PiVector[] piVectorArray) {
        if (piVectorArray == null) {
            this.m_elementSaved = null;
            return;
        }
        if (this.m_elementSaved == null) {
            this.m_elementSaved = PiVector.copyNew(piVectorArray, this.m_numElements);
        } else {
            this.m_elementSaved = PiVector.realloc(this.m_elementSaved, piVectorArray.length);
            PiVector.copy(this.m_elementSaved, 0, piVectorArray, 0, piVectorArray.length);
        }
    }

    public boolean makeElementColorsFromXYZ() {
        int n;
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        double[] dArray = PdVector.subNew((PdVector)pdVectorArray[1], (PdVector)pdVectorArray[0]).m_data;
        for (n = 0; n < this.m_dim; ++n) {
            if (!(dArray[n] < 1.0E-10)) continue;
            dArray[n] = 1.0;
        }
        n = Math.min(3, this.m_dim);
        float[] fArray = new float[n];
        for (int i = 0; i < this.m_numElements; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[i].m_data), pdVectorArray[0]);
            for (int j = 0; j < n; ++j) {
                fArray[j] = (float)(pdVector.m_data[j] / dArray[j]);
            }
            if (n == 1) {
                colorArray[i] = new Color(fArray[0], 0.0f, 1.0f - fArray[0]);
                continue;
            }
            if (n == 2) {
                colorArray[i] = new Color(fArray[0], fArray[1], 0.0f);
                continue;
            }
            if (n != 3) continue;
            colorArray[i] = new Color(fArray[0], fArray[1], fArray[2]);
        }
        return true;
    }

    public boolean makeElementColorsFromZ() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(f2, 0.0f, 1.0f - f2);
        }
        return true;
    }

    public boolean makeElementColorsFromZHue() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim == 0) {
            return false;
        }
        PdVector[] pdVectorArray = this.getAmbientBounds();
        if (pdVectorArray == null) {
            return true;
        }
        int n = Math.min(2, this.m_dim - 1);
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(this.m_dim);
        PdVector pdVector2 = new PdVector(this.m_dim);
        float f = (float)(pdVectorArray[1].m_data[n] - pdVectorArray[0].m_data[n]);
        if ((double)f < 1.0E-10) {
            f = 1.0f;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            pdVector.sub(PgGeometry.getCenterOfElement(pdVector2, this.m_vertex, this.m_element[i].m_data), pdVectorArray[0]);
            float f2 = (float)pdVector.m_data[n] / f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            } else if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            colorArray[i] = new Color(Color.HSBtoRGB(0.83333f * (1.0f - f2), 1.0f, 1.0f));
        }
        return true;
    }

    public boolean makeElementColorsFromNormal() {
        if (this.m_numElements == 0) {
            return true;
        }
        if (this.m_dim != 3) {
            PsDebug.warning("dimension of vertices must be equal to three, dim =" + this.m_dim);
            return false;
        }
        boolean bl = this.hasElementNormals();
        if (!bl) {
            this.assureElementNormals();
            this.makeElementNormals();
        }
        this.assureElementColors();
        Color[] colorArray = this.getElementColors();
        PdVector pdVector = new PdVector(3);
        double[] dArray = pdVector.m_data;
        PdVector pdVector2 = new PdVector(1.0, 0.0, 0.0);
        PdVector pdVector3 = new PdVector(3);
        PdVector pdVector4 = new PdVector(0.0, 0.0, 1.0);
        for (int i = 0; i < this.m_numElements; ++i) {
            double[] dArray2 = this.m_elementNormal[i].m_data;
            dArray[0] = 0.7071068 * dArray2[0] - 0.7071068 * dArray2[1];
            dArray[1] = 0.7071068 * dArray2[0] + 0.7071068 * dArray2[1];
            double d = dArray[1];
            dArray[1] = 0.57735 * d + 0.81649 * dArray2[2];
            dArray[2] = -0.81649 * d + 0.57735 * dArray2[2];
            d = dArray[1];
            dArray[0] = 0.7071068 * dArray2[0] + 0.7071068 * d;
            dArray[1] = -0.7071068 * dArray2[0] + 0.7071068 * d;
            int n = pdVector.indexOfAbsMax();
            float f = (float)Math.abs(pdVector.m_data[n]);
            colorArray[i] = new Color((1.0f + (float)dArray[0] / f) / 2.0f, (1.0f + (float)dArray[1] / f) / 2.0f, (1.0f + (float)dArray[2] / f) / 2.0f);
        }
        if (!bl) {
            this.removeElementNormals();
        }
        return true;
    }

    public boolean makeElementFromVertexColors() {
        if (!this.hasVertexColors()) {
            PsDebug.warning("missing vertex colors");
            return false;
        }
        if (this.m_numElements == 0) {
            return true;
        }
        this.assureElementColors();
        for (int i = 0; i < this.m_numElements; ++i) {
            int n = this.m_element[i].getSize();
            if (n == 0) continue;
            if (n == 1) {
                this.setElementColor(i, this.m_vertexColor[this.m_element[i].m_data[0]]);
                continue;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                int n5 = this.m_vertexColor[this.m_element[i].m_data[j]].getRGB();
                n2 += n5 >> 16 & 0xFF;
                n3 += n5 >> 8 & 0xFF;
                n4 += n5 & 0xFF;
            }
            this.setElementColor(i, new Color(n2 /= n, n3 /= n, n4 /= n));
        }
        return true;
    }

    public boolean makeVertexFromElementColors() {
        int n;
        if (!this.hasElementColors()) {
            PsDebug.warning("missing element colors");
            return false;
        }
        if (this.m_numVertices == 0 || this.m_numElements == 0) {
            return true;
        }
        int[][] nArray = new int[this.m_numVertices][3];
        int[] nArray2 = new int[this.m_numVertices];
        for (n = 0; n < this.m_numElements; ++n) {
            int n2 = this.m_element[n].getSize();
            for (int i = 0; i < n2; ++i) {
                int n3 = this.m_element[n].m_data[i];
                int n4 = this.m_elementColor[n].getRGB();
                int[] nArray3 = nArray[n3];
                nArray3[0] = nArray3[0] + (n4 >> 16 & 0xFF);
                int[] nArray4 = nArray[n3];
                nArray4[1] = nArray4[1] + (n4 >> 8 & 0xFF);
                int[] nArray5 = nArray[n3];
                nArray5[2] = nArray5[2] + (n4 & 0xFF);
                int n5 = n3;
                nArray2[n5] = nArray2[n5] + 1;
            }
        }
        this.assureVertexColors();
        for (n = 0; n < this.m_numVertices; ++n) {
            if (nArray2[n] > 0) {
                this.setVertexColor(n, new Color((int)((float)nArray[n][0] / (float)nArray2[n]), (int)((float)nArray[n][1] / (float)nArray2[n]), (int)((float)nArray[n][2] / (float)nArray2[n])));
                continue;
            }
            this.setVertexColor(n, Color.black);
        }
        return true;
    }

    public boolean makeElementFromVertexTexture() {
        if (!this.hasVertexTextures()) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        PdVector[] pdVectorArray = this.getVertexTextures();
        if (pdVectorArray == null || pdVectorArray.length < this.m_numVertices) {
            PsDebug.warning("missing vertexTextures.");
            return false;
        }
        this.assureElementTextures();
        for (int i = 0; i < this.m_numElements; ++i) {
            int n = this.m_element[i].getSize();
            for (int j = 0; j < n; ++j) {
                this.m_elementTexture[i][j] = PdVector.copyNew(this.m_vertexTexture[this.m_element[i].m_data[j]]);
            }
        }
        this.showElementTexture(true);
        this.showVertexTexture(false);
        this.setVertexTextures(null);
        return true;
    }

    public PgGeometry reflect(PdMatrix pdMatrix, boolean bl, boolean bl2) {
        int n;
        P_Vector[] p_VectorArray;
        P_Vector[] p_VectorArray2;
        if (pdMatrix == null || pdMatrix.getSize() != this.getDimOfVertices() + 1) {
            PsDebug.warning("missing or wrong transformation matrix mat = " + pdMatrix);
            return null;
        }
        PgElementSet pgElementSet = (PgElementSet)super.reflect(pdMatrix, bl, bl2);
        if (!bl) {
            p_VectorArray2 = pgElementSet.getElements();
            for (int i = 0; i < this.m_numElements; ++i) {
                ((PiVector)p_VectorArray2[i]).invert();
            }
            p_VectorArray = pgElementSet.getNeighbours();
            if (p_VectorArray != null) {
                for (n = 0; n < this.m_numElements; ++n) {
                    ((PiVector)p_VectorArray[n]).invert();
                    int n2 = ((PiVector)p_VectorArray[n]).getSize();
                    ((PiVector)p_VectorArray[n]).shift(n2 - 3);
                }
            }
        }
        if (this.hasElementNormals()) {
            p_VectorArray2 = this.getElementNormals();
            p_VectorArray = pgElementSet.getElementNormals();
            for (n = 0; n < this.m_numElements; ++n) {
                ((PdVector)p_VectorArray[n]).leftMultAffin(pdMatrix, (PdVector)p_VectorArray2[n], false);
                if (!bl2) {
                    ((PdVector)p_VectorArray[n]).multScalar(-1.0);
                }
                ((PdVector)p_VectorArray[n]).normalize();
            }
        }
        if (!bl && this.hasElementTextures()) {
            p_VectorArray2 = pgElementSet.getElementTextures();
            for (int i = 0; i < this.m_numElements; ++i) {
                PuData.invert((Object[])p_VectorArray2[i]);
            }
        }
        return pgElementSet;
    }

    public boolean resetBoundaryNormals() {
        if (!this.hasVertexNormals()) {
            PsDebug.warning("missing vertex normals");
            return false;
        }
        for (int i = 0; i < this.m_numElements; ++i) {
            int n = this.m_element[i].getSize();
            for (int j = 0; j < n; ++j) {
                if (this.m_neighbour[i].m_data[j] != -1) continue;
                this.m_vertexNormal[this.m_element[i].m_data[(j + 1) % n]].setConstant(0.0);
                this.m_vertexNormal[this.m_element[i].m_data[(j + 2) % n]].setConstant(0.0);
            }
        }
        return true;
    }

    public int[] getFVector() {
        int[] nArray = super.getFVector();
        int[] nArray2 = PuData.realloc(nArray, nArray.length + 2);
        nArray2[nArray.length] = this.getNumEdges();
        nArray2[nArray.length + 1] = this.getNumElements();
        return nArray2;
    }

    public PdVector getCenterOfElement(PdVector pdVector, int n) {
        return PgGeometry.getCenterOfElement(pdVector, this.m_vertex, this.m_element[n].m_data);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

