/*
 * Decompiled with CFR 0.152.
 */
package jv.geom;

import jv.geom.PgBndConstraint;
import jv.geom.PgElementSet;
import jv.geom.PgPolygon;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;

public class PgBndPolygon
extends PgPolygon {
    protected static double MAX_PASTE_ANGLE = 50.0;
    protected static double MAX_LOGIC_ANGLE = 20.0;
    protected PgElementSet m_geom;
    protected PiVector m_vertexInd = new PiVector();
    protected PiVector m_elementInd = new PiVector();
    protected PiVector m_neighbourLocInd = new PiVector();
    protected boolean m_bConforming = true;
    protected boolean m_bShowIndividualMaterial;
    protected PgBndConstraint m_bndConstraint;
    static /* synthetic */ Class class$jv$geom$PgBndPolygon;

    public PgBndPolygon(int n) {
        super(n);
        if (this.getClass() == (class$jv$geom$PgBndPolygon == null ? (class$jv$geom$PgBndPolygon = PgBndPolygon.class$("jv.geom.PgBndPolygon")) : class$jv$geom$PgBndPolygon)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.clearTag(2);
        this.m_bndConstraint = null;
        this.m_bShowIndividualMaterial = true;
        this.showIndividualMaterial(false);
    }

    public Object clone() {
        PgBndPolygon pgBndPolygon = (PgBndPolygon)super.clone();
        if (pgBndPolygon == null) {
            return null;
        }
        pgBndPolygon.m_geom = null;
        if (this.m_vertexInd != null) {
            pgBndPolygon.m_vertexInd = (PiVector)this.m_vertexInd.clone();
        }
        if (this.m_elementInd != null) {
            pgBndPolygon.m_elementInd = (PiVector)this.m_elementInd.clone();
        }
        if (this.m_neighbourLocInd != null) {
            pgBndPolygon.m_neighbourLocInd = (PiVector)this.m_neighbourLocInd.clone();
        }
        if (this.m_bndConstraint != null) {
            pgBndPolygon.m_bndConstraint = (PgBndConstraint)this.m_bndConstraint.clone();
        }
        return pgBndPolygon;
    }

    public void copy(PsObject psObject) {
        super.copy(psObject);
        if (psObject == null) {
            return;
        }
        if (!(psObject instanceof PgBndPolygon)) {
            return;
        }
        PgBndPolygon pgBndPolygon = (PgBndPolygon)psObject;
        this.m_vertexInd.copy(0, pgBndPolygon.getVertexInd(), 0, this.m_numVertices);
        this.m_elementInd.copy(0, pgBndPolygon.getElementInd(), 0, this.m_numVertices - 1);
        this.m_neighbourLocInd.copy(0, pgBndPolygon.getNeighbourLocInd(), 0, this.m_numVertices - 1);
        this.m_bConforming = pgBndPolygon.isConforming();
        PgBndConstraint pgBndConstraint = pgBndPolygon.getBndConstraint();
        if (pgBndConstraint != null) {
            if (this.m_bndConstraint == null) {
                this.m_bndConstraint = new PgBndConstraint(pgBndConstraint.m_dim);
            }
            this.m_bndConstraint.copy(pgBndConstraint);
        } else {
            this.m_bndConstraint = null;
        }
        this.assignVertices();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t ******* PgBndPolygon *********\n");
        stringBuffer.append("\t MAX_PASTE_ANGLE = " + MAX_PASTE_ANGLE + "\n");
        stringBuffer.append("\t MAX_LOGIC_ANGLE = " + MAX_LOGIC_ANGLE + "\n");
        stringBuffer.append("\t is conforming = " + this.isConforming() + "\n");
        stringBuffer.append("\t ******* m_vertexInd *******\n");
        if (this.m_vertexInd == null) {
            stringBuffer.append("\t m_vertexInd = null\n");
        } else {
            stringBuffer.append("\t m_vertexInd" + this.m_vertexInd.toShortString());
        }
        stringBuffer.append("\t ******* m_elementInd *******\n");
        if (this.m_elementInd == null) {
            stringBuffer.append("\t m_elementInd = null\n");
        } else {
            stringBuffer.append("\t m_elementInd = " + this.m_elementInd.toShortString());
        }
        stringBuffer.append("\t ******* m_neighbourLocInd *******\n");
        if (this.m_neighbourLocInd == null) {
            stringBuffer.append("\t m_neighbourLocInd = null\n");
        } else {
            stringBuffer.append("\t m_neighbourLocInd = " + this.m_neighbourLocInd.toShortString());
        }
        stringBuffer.append("\t ******* m_bndConstraint *******\n");
        if (this.m_bndConstraint == null) {
            stringBuffer.append("\t m_bndConstraint = null\n");
        } else {
            stringBuffer.append("\t " + this.m_bndConstraint.toString());
        }
        return stringBuffer.toString();
    }

    public boolean update(Object object) {
        PsDebug.notify("called");
        if (object == null) {
            return super.update(object);
        }
        if (object == this.m_geom) {
            this.setGeometry(this.m_geom);
            return super.update(this);
        }
        if (object == this.m_globalEdgeColor) {
            return super.update(this);
        }
        if (object == this.m_globalEdgeSize) {
            return super.update(this);
        }
        return super.update(object);
    }

    public boolean applyModelingMatrix() {
        if (this.m_bndConstraint == null) {
            return true;
        }
        if (!this.hasModelMatrix()) {
            return false;
        }
        return this.m_bndConstraint.applyModelingMatrix(this.m_modelMatrix);
    }

    public int getNumElements() {
        int n = this.getNumVertices() - 1;
        if (!this.isConforming()) {
            ++n;
        }
        return n;
    }

    public PiVector getVertexInd() {
        return this.m_vertexInd;
    }

    public void setVertexInd(PiVector piVector) {
        this.m_vertexInd.copy(piVector);
    }

    public PiVector getElementInd() {
        return this.m_elementInd;
    }

    public void setElementInd(PiVector piVector) {
        this.m_elementInd.copy(piVector);
    }

    public PiVector getNeighbourLocInd() {
        return this.m_neighbourLocInd;
    }

    public void setNeighbourLocInd(PiVector piVector) {
        this.m_neighbourLocInd.copy(piVector);
    }

    public PgBndConstraint getBndConstraint() {
        return this.m_bndConstraint;
    }

    public void setBndConstraint(PgBndConstraint pgBndConstraint) {
        this.m_bndConstraint = pgBndConstraint;
    }

    public PgElementSet getGeometry() {
        return this.m_geom;
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setParent(pgElementSet);
        this.m_geom = pgElementSet;
        if (!this.isShowingIndividualMaterial() && this.m_geom != null) {
            this.setGlobalEdgeColor(this.m_geom.getGlobalBndColor());
            this.setGlobalEdgeSize(this.m_geom.getGlobalBndSize());
        }
    }

    public PgElementSet getElementSet() {
        return this.m_geom;
    }

    public void setElementSet(PgElementSet pgElementSet) {
        this.setGeometry(pgElementSet);
    }

    public void setMaxNumVertices(int n) {
        if (this.m_maxNumVertices == n) {
            return;
        }
        super.setMaxNumVertices(n);
        this.m_vertexInd.setSize(n);
        if (n > 0) {
            this.m_elementInd.setSize(n - 1);
            this.m_neighbourLocInd.setSize(n - 1);
        }
    }

    public boolean isConforming() {
        return this.m_bConforming;
    }

    public void makeNonConforming() {
        if (!this.isConforming()) {
            return;
        }
        if (this.m_geom == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices - 1);
        for (int i = 0; i < this.m_numVertices; ++i) {
            int n = this.m_elementInd.m_data[i];
            PiVector piVector = this.m_geom.m_element[n];
            int n2 = this.m_neighbourLocInd.m_data[i];
            this.m_vertexInd.m_data[i] = piVector.m_data[n2];
            if (this.m_geom.m_neighbour[n].m_data[n2] <= -1) continue;
            PsDebug.warning("neighbourLocInd wrong");
        }
        this.m_bConforming = false;
        this.assignVertices();
    }

    public void makeConforming() {
        if (this.isConforming()) {
            return;
        }
        if (this.m_geom == null) {
            PsDebug.warning("missing element set");
            return;
        }
        this.setNumVertices(this.m_numVertices + 1);
        PiVector piVector = null;
        int n = 0;
        for (int i = 0; i < this.m_numVertices - 1; ++i) {
            int n2 = this.m_elementInd.m_data[i];
            piVector = this.m_geom.m_element[n2];
            n = this.m_neighbourLocInd.m_data[i];
            this.m_vertexInd.m_data[i] = piVector.m_data[(n + 1) % piVector.getSize()];
            if (this.m_geom.m_neighbour[n2].m_data[n] <= -1) continue;
            PsDebug.warning("neighbourLocInd wrong");
        }
        this.m_vertexInd.m_data[this.m_numVertices - 1] = piVector.m_data[(n + 2) % piVector.getSize()];
        this.m_bConforming = true;
        this.assignVertices();
    }

    public boolean assignVertices() {
        if (this.m_geom == null) {
            PsDebug.warning("missing element set");
            return false;
        }
        int n = this.m_geom.getNumVertices();
        for (int i = 0; i < this.m_numVertices; ++i) {
            if (this.m_vertexInd.m_data[i] == -1 || this.m_vertexInd.m_data[i] >= n) {
                this.setTag(2);
                return false;
            }
            this.m_vertex[i].copy(this.m_geom.m_vertex[this.m_vertexInd.m_data[i]]);
        }
        return true;
    }

    public boolean makeElementInd() {
        if (this.m_geom == null) {
            PsDebug.warning("missing element set.");
            return false;
        }
        if (!this.isConforming()) {
            PsDebug.warning("element set must be conforming, just returned.");
            return false;
        }
        if (this.m_numVertices < 2) {
            this.assignVertices();
            return true;
        }
        PiVector[] piVectorArray = this.m_geom.getElements();
        PiVector[] piVectorArray2 = this.m_geom.getNeighbours();
        int n = this.m_numVertices - 1;
        int n2 = this.m_vertexInd.m_data[1];
        int n3 = -1;
        PiVector piVector = null;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        boolean bl = true;
        int n7 = 0;
        while (true) {
            int n8;
            int n9;
            Object object;
            if (bl || piVector.m_data[n5] != n2) {
                object = this.m_geom.getEdge(this.m_vertexInd.m_data[n7], this.m_vertexInd.m_data[n7 + 1]);
                if (object == null) {
                    PsDebug.warning("edge not found between vertices v0=" + this.m_vertexInd.m_data[n7] + " and v1=" + this.m_vertexInd.m_data[n7 + 1]);
                    return false;
                }
                int[] nArray = object.getElementInd();
                n9 = -1;
                for (n8 = 0; n8 < object.getValence(); ++n8) {
                    n3 = nArray[n8];
                    n9 = object.getNeighbourLocInd(n8);
                    if (piVectorArray2[n3].m_data[n9] == -1) break;
                }
                if (piVector.m_data[n5 = (n9 + 1) % (n4 = (piVector = piVectorArray[n3]).getSize())] != n2) {
                    n6 = n5;
                    n5 = (n5 + 1) % n4;
                } else {
                    n6 = (n9 + n4 - 1) % n4;
                }
                if (piVector.m_data[n5] != n2) {
                    PsDebug.error("connectivity seems broken");
                    break;
                }
                this.m_elementInd.m_data[n7] = n3;
                this.m_neighbourLocInd.m_data[n7] = n9;
            }
            if (++n7 == n) break;
            object = piVectorArray2[n3].m_data;
            int n10 = object[n6];
            n9 = 100;
            bl = false;
            n8 = n3;
            while (n10 != -1 && !bl) {
                int n11 = this.m_geom.getOppVertexLocInd(n3, n6);
                n5 = (n11 + 1) % (n4 = (piVector = piVectorArray[n10]).getSize());
                if (piVector.m_data[n5] != n2) {
                    n6 = n5;
                    n5 = (n11 + 2) % n4;
                } else {
                    n6 = (n11 + n4 - 1) % n4;
                }
                if (piVector.m_data[n5] != n2) {
                    PsDebug.error("connectivity seems broken");
                    break;
                }
                n3 = n10;
                object = piVectorArray2[n3].m_data;
                n10 = object[n6];
                if (--n9 != 0 && n8 != n10) continue;
                bl = true;
            }
            this.m_elementInd.m_data[n7] = n3;
            this.m_neighbourLocInd.m_data[n7] = n6;
            n2 = this.m_vertexInd.m_data[n7 + 1];
            if (piVector.m_data[n5 = (n5 - 1 + n4) % n4] != n2) {
                n5 = (n5 + 2) % n4;
                n6 = (n6 + 1) % n4;
                continue;
            }
            n6 = (n6 - 1 + n4) % n4;
        }
        this.assignVertices();
        return true;
    }

    public boolean bndsh(int n) {
        int n2;
        if (this.m_numVertices < 2) {
            PsDebug.error("bndsh: bnd has less than 2 points", this);
            return false;
        }
        int n3 = this.m_numVertices;
        int n4 = n3 - 1 - n;
        for (n2 = 0; n2 <= n4; ++n2) {
            this.m_vertexInd.m_data[n3 - 1 - n2] = this.m_vertexInd.m_data[n4 - n2];
        }
        for (n2 = 1; n2 <= n4; ++n2) {
            this.m_elementInd.m_data[n3 - 1 - n2] = this.m_elementInd.m_data[n4 - n2];
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            this.m_elementInd.m_data[n2] = -1;
        }
        return true;
    }

    public static boolean bndinv(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        int n4;
        if (n + n3 > pgBndPolygon.m_numVertices || n2 < n3 - 1) {
            PsDebug.error("bndinv: invalid offsets", pgBndPolygon);
            return false;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            pgBndPolygon2.m_vertexInd.m_data[n2 - n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
        }
        for (n4 = 0; n4 < n3 - 1; ++n4) {
            pgBndPolygon2.m_elementInd.m_data[n2 - 1 - n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
        }
        return true;
    }

    public boolean invert() {
        if (this.m_numVertices < 2) {
            PsDebug.error("invert: bnd has less than 2 points", this);
            return false;
        }
        this.m_vertexInd.invert(this.m_numVertices);
        this.m_elementInd.invert(this.m_numVertices - 1);
        return true;
    }

    public static void bndcp(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        int n4;
        for (n4 = 0; n4 < n3 + 1; ++n4) {
            pgBndPolygon2.m_vertexInd.m_data[n2 + n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            pgBndPolygon2.m_elementInd.m_data[n2 + n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
        }
    }

    public static void bndcpy(int n, int n2, int n3, PgBndPolygon pgBndPolygon, PgBndPolygon pgBndPolygon2) {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            pgBndPolygon2.m_vertexInd.m_data[n2 + n4] = pgBndPolygon.m_vertexInd.m_data[n + n4];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            pgBndPolygon2.m_elementInd.m_data[n2 + n4] = pgBndPolygon.m_elementInd.m_data[n + n4];
        }
    }

    public int bndcmp(PgBndPolygon pgBndPolygon, double d) {
        if (pgBndPolygon == null) {
            PsDebug.warning("missing argument");
            return 0;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.warning("bnd's associated to different elementSets");
            return 0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.warning("bnd with less than 2 points");
            return 0;
        }
        int n = this.m_numVertices;
        PdVector[] pdVectorArray = this.m_geom.m_vertex;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray2[0]]) < d && PdVector.dist(pdVectorArray[nArray[n - 1]], pdVectorArray[nArray2[n - 1]]) < d && PdVector.dist(pdVectorArray[nArray[1]], pdVectorArray[nArray2[1]]) < d) {
            return 1;
        }
        if (PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray2[n - 1]]) < d && PdVector.dist(pdVectorArray[nArray[n - 1]], pdVectorArray[nArray2[0]]) < d && PdVector.dist(pdVectorArray[nArray[1]], pdVectorArray[nArray2[n - 2]]) < d) {
            return -1;
        }
        return 0;
    }

    public int bndtst(double d) {
        if (this.m_geom == null) {
            PsDebug.error("missing associated elementSet", this);
            return -1;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return -1;
        }
        int n = this.m_numVertices;
        int n2 = 0;
        PdVector[] pdVectorArray = this.m_geom.m_vertex;
        int[] nArray = this.m_vertexInd.m_data;
        for (int i = 1; i < n; ++i) {
            if (!(PdVector.dist(pdVectorArray[nArray[0]], pdVectorArray[nArray[i]]) < d)) continue;
            ++n2;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == n - 1) {
            return 1;
        }
        return 0;
    }

    public boolean bnd_shrink() {
        int n;
        PgBndPolygon[] pgBndPolygonArray;
        int n2;
        int n3;
        if (this.m_geom == null) {
            PsDebug.error("missing associated elementSet", this);
            return false;
        }
        if (this.m_numVertices < 2) {
            PsDebug.error("bnd has less than 2 points", this);
            return false;
        }
        int n4 = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        boolean bl = false;
        for (n3 = 0; n3 < n4 - 1; ++n3) {
            int n5;
            n2 = this.m_elementInd.m_data[n3];
            pgBndPolygonArray = this.m_geom.getElement(n2);
            PiVector piVector = this.m_geom.getNeighbour(n2);
            int n6 = pgBndPolygonArray.getSize();
            if (n6 < 3) {
                PsDebug.error("elementSet corrupt with element size < 3", this);
                return false;
            }
            int n7 = pgBndPolygonArray.getIndexOf(nArray[n3]);
            int n8 = pgBndPolygonArray.getIndexOf(nArray[n3 + 1]);
            if (n6 == 3) {
                n5 = piVector.m_data[n7];
                int n9 = piVector.m_data[n8];
                if (n5 != -1) {
                    this.m_geom.m_neighbour[n5].changeValue(n2, n9);
                }
                if (n9 != -1) {
                    this.m_geom.m_neighbour[n9].changeValue(n2, n5);
                }
                pgBndPolygonArray.setConstant(nArray[0]);
                pgBndPolygonArray.setTag(2);
                piVector.setConstant(-1);
                piVector.setTag(2);
                bl = true;
                continue;
            }
            n5 = (n7 + 1) % n6 == n8 ? n7 : n8;
            piVector.m_data[(n5 - 1 + n6) % n6] = piVector.m_data[n5];
            for (n = n5; n < n6 - 1; ++n) {
                pgBndPolygonArray.m_data[n] = pgBndPolygonArray.m_data[n + 1];
                piVector.m_data[n] = piVector.m_data[n + 1];
            }
            int[] nArray2 = piVector.getEntries();
            this.m_geom.setDimOfElement(n2, n6 - 1);
            for (n = 0; n < n6 - 1; ++n) {
                piVector.m_data[n] = nArray2[n];
            }
        }
        n2 = this.m_geom.getNumElements();
        for (n = 1; n < n4; ++n) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.m_geom.m_element[n3].changeValue(nArray[n], nArray[0]);
            }
            this.m_geom.m_vertex[nArray[n]].setTag(2);
        }
        pgBndPolygonArray = this.m_geom.m_bndList;
        for (n3 = 0; n3 < pgBndPolygonArray.length; ++n3) {
            if (pgBndPolygonArray[n3] == null || pgBndPolygonArray[n3] == this || pgBndPolygonArray[n3].hasTag(2)) continue;
            for (n = 1; n < n4; ++n) {
                pgBndPolygonArray[n3].m_vertexInd.changeValue(pgBndPolygonArray[n3].m_numVertices, nArray[n], nArray[0]);
            }
        }
        this.setTag(2);
        if (bl) {
            this.m_geom.removeMarkedElements();
        }
        return true;
    }

    public boolean bnd_id(PgBndPolygon pgBndPolygon, int n) {
        int n2;
        int n3;
        int n4;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        int n5 = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (n < 0) {
            pgBndPolygon.invert();
        }
        for (n4 = 0; n4 < n5 - 1; ++n4) {
            int n6 = this.m_elementInd.m_data[n4];
            int n7 = pgBndPolygon.m_elementInd.m_data[n4];
            n3 = this.m_geom.getNeighbourLocInd(n7, nArray2[n4], nArray2[n4 + 1]);
            this.m_geom.m_neighbour[n7].m_data[n3] = this.m_elementInd.m_data[n4];
            n3 = this.m_geom.getNeighbourLocInd(n6, nArray[n4], nArray[n4 + 1]);
            this.m_geom.m_neighbour[n6].m_data[n3] = pgBndPolygon.m_elementInd.m_data[n4];
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n2 = 0; n2 < this.m_geom.m_numElements; ++n2) {
                this.m_geom.m_element[n2].changeValue(nArray2[n4], nArray[n4]);
            }
            this.m_geom.m_vertex[nArray2[n4]].setTag(2);
        }
        PgBndPolygon[] pgBndPolygonArray = this.m_geom.m_bndList;
        for (n2 = 0; n2 < pgBndPolygonArray.length; ++n2) {
            PgBndPolygon pgBndPolygon2 = pgBndPolygonArray[n2];
            if (pgBndPolygon2 == null || pgBndPolygon2 == this || pgBndPolygon2 == pgBndPolygon || pgBndPolygon2.hasTag(2)) continue;
            n3 = pgBndPolygon2.getNumVertices();
            for (n4 = 0; n4 < n5; ++n4) {
                pgBndPolygon2.m_vertexInd.changeValue(n3, nArray2[n4], nArray[n4]);
            }
        }
        this.setTag(2);
        pgBndPolygon.setTag(2);
        return true;
    }

    public double bnd_dist(PgBndPolygon pgBndPolygon) {
        double d;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 1000.0;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 1000.0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 1000.0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 1000.0;
        }
        int n = this.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        double d2 = PdVector.sqrDist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[0]]);
        if (d2 <= (d = PdVector.sqrDist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[n - 1]]))) {
            for (int i = 1; i < n; ++i) {
                d = PdVector.sqrDist(this.m_geom.m_vertex[nArray[i]], this.m_geom.m_vertex[nArray2[i]]);
                d2 = Math.max(d2, d);
            }
            d = Math.sqrt(d2);
        } else {
            d2 = d;
            for (int i = 1; i < n; ++i) {
                d = PdVector.sqrDist(this.m_geom.m_vertex[nArray[i]], this.m_geom.m_vertex[nArray2[n - 1 - i]]);
                d2 = Math.max(d2, d);
            }
            d = -Math.sqrt(d2);
        }
        return d;
    }

    public int bnd_cmp_paste(PgBndPolygon pgBndPolygon, double d) {
        PdVector pdVector;
        PdVector pdVector2;
        PdVector pdVector3;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int n = this.m_numVertices;
        int n2 = pgBndPolygon.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        int n3 = 0;
        if (PdVector.dist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[0]]) < d) {
            n3 = 11;
            pdVector3 = this.m_geom.m_vertex[nArray[0]];
            pdVector2 = this.m_geom.m_vertex[nArray[1]];
            pdVector = this.m_geom.m_vertex[nArray2[1]];
        } else if (PdVector.dist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[n2 - 1]]) < d) {
            n3 = 12;
            pdVector3 = this.m_geom.m_vertex[nArray[0]];
            pdVector2 = this.m_geom.m_vertex[nArray[1]];
            pdVector = this.m_geom.m_vertex[nArray2[n2 - 2]];
        } else if (PdVector.dist(this.m_geom.m_vertex[nArray[n - 1]], this.m_geom.m_vertex[nArray2[0]]) < d) {
            n3 = 21;
            pdVector3 = this.m_geom.m_vertex[nArray[n - 1]];
            pdVector2 = this.m_geom.m_vertex[nArray[n - 2]];
            pdVector = this.m_geom.m_vertex[nArray2[1]];
        } else if (PdVector.dist(this.m_geom.m_vertex[nArray[n - 1]], this.m_geom.m_vertex[nArray2[n2 - 1]]) < d) {
            n3 = 22;
            pdVector3 = this.m_geom.m_vertex[nArray[n - 1]];
            pdVector2 = this.m_geom.m_vertex[nArray[n - 2]];
            pdVector = this.m_geom.m_vertex[nArray2[n2 - 2]];
        } else {
            return 0;
        }
        double d2 = PdVector.angle(pdVector3, pdVector, pdVector2);
        if (Math.abs(d2 - 180.0) > MAX_PASTE_ANGLE) {
            return 0;
        }
        return n3;
    }

    public boolean bnd_paste(PgBndPolygon pgBndPolygon, int n) {
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return false;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return false;
        }
        if (!(n == 11 || n == 12 || n == 21 || n == 22)) {
            PsDebug.error("type must be 11, 12, 21 or 22", this);
            return false;
        }
        if (n == 11 || n == 12) {
            this.invert();
        }
        if (n == 12 || n == 22) {
            pgBndPolygon.invert();
        }
        return this.merge(pgBndPolygon);
    }

    public int bnd_cmp_logic(PgBndPolygon pgBndPolygon, double d) {
        PdVector pdVector;
        PdVector pdVector2;
        PdVector pdVector3;
        double d2;
        if (pgBndPolygon == null) {
            PsDebug.error("missing argument", this);
            return 0;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.error("bnd's associated to different elementSets", this);
            return 0;
        }
        if (this.m_numVertices != pgBndPolygon.m_numVertices) {
            return 0;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.error("bnd's less than 2 points", this);
            return 0;
        }
        int n = this.m_numVertices;
        int n2 = pgBndPolygon.m_numVertices;
        int[] nArray = this.m_vertexInd.m_data;
        int[] nArray2 = pgBndPolygon.m_vertexInd.m_data;
        if (PdVector.sqrDist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[0]]) < d && PdVector.sqrDist(this.m_geom.m_vertex[nArray[n - 1]], this.m_geom.m_vertex[nArray2[n2 - 1]]) < d) {
            PdVector pdVector4 = this.m_geom.m_vertex[nArray[0]];
            PdVector pdVector5 = this.m_geom.m_vertex[nArray[1]];
            PdVector pdVector6 = this.m_geom.m_vertex[nArray2[1]];
            double d3 = PdVector.angle(pdVector4, pdVector5, pdVector6);
            if (Math.abs(d3) < MAX_LOGIC_ANGLE) {
                return 1;
            }
        } else if (PdVector.sqrDist(this.m_geom.m_vertex[nArray[0]], this.m_geom.m_vertex[nArray2[n2 - 1]]) < d && PdVector.sqrDist(this.m_geom.m_vertex[nArray[n - 1]], this.m_geom.m_vertex[nArray2[0]]) < d && Math.abs(d2 = PdVector.angle(pdVector3 = this.m_geom.m_vertex[nArray[0]], pdVector2 = this.m_geom.m_vertex[nArray[1]], pdVector = this.m_geom.m_vertex[nArray2[n2 - 2]])) < MAX_LOGIC_ANGLE) {
            return -1;
        }
        return 0;
    }

    public boolean isShowingIndividualMaterial() {
        return this.m_bShowIndividualMaterial;
    }

    public void showIndividualMaterial(boolean bl) {
        if (this.m_bShowIndividualMaterial == bl) {
            return;
        }
        this.m_bShowIndividualMaterial = bl;
        if (!this.m_bShowIndividualMaterial && this.m_geom != null) {
            this.setGlobalEdgeColor(this.m_geom.getGlobalBndColor());
            this.setGlobalEdgeSize(this.m_geom.getGlobalBndSize());
        }
    }

    public boolean merge(PgBndPolygon pgBndPolygon) {
        if (pgBndPolygon == null) {
            PsDebug.warning("missing argument", this);
            return false;
        }
        if (this.m_geom != pgBndPolygon.m_geom) {
            PsDebug.warning("bnd's associated to different elementSets", this);
            return false;
        }
        if (this.m_numVertices < 2 || pgBndPolygon.m_numVertices < 2) {
            PsDebug.warning("bnd's less than 2 points", this);
            return false;
        }
        int n = this.m_numVertices;
        int n2 = this.m_numVertices + pgBndPolygon.m_numVertices;
        super.merge(pgBndPolygon);
        this.setNumVertices(n2 - 1);
        this.m_vertexInd.copy(n, pgBndPolygon.m_vertexInd, 1, pgBndPolygon.m_numVertices - 1);
        this.m_elementInd.copy(n - 1, pgBndPolygon.m_elementInd, 0, pgBndPolygon.m_numVertices - 1);
        this.m_neighbourLocInd.copy(n - 1, pgBndPolygon.m_neighbourLocInd, 0, pgBndPolygon.m_numVertices - 1);
        return true;
    }

    public boolean blend(double d, PgGeometry pgGeometry, double d2, PgGeometry pgGeometry2) {
        double d3;
        if (!super.blend(d, pgGeometry, d2, pgGeometry2)) {
            return false;
        }
        if (!(pgGeometry instanceof PgPolygon)) {
            return false;
        }
        PgBndPolygon pgBndPolygon = (PgBndPolygon)pgGeometry;
        PgBndPolygon pgBndPolygon2 = (PgBndPolygon)pgGeometry2;
        double d4 = Math.abs(d);
        PgBndPolygon pgBndPolygon3 = d4 > (d3 = Math.abs(d2)) ? pgBndPolygon : pgBndPolygon2;
        this.m_vertexInd.copy(pgBndPolygon3.m_vertexInd);
        this.m_elementInd.copy(pgBndPolygon3.m_elementInd);
        this.m_neighbourLocInd.copy(pgBndPolygon3.m_neighbourLocInd);
        if (pgBndPolygon.m_bndConstraint == null || pgBndPolygon2.m_bndConstraint != null) {
            // empty if block
        }
        return true;
    }

    public boolean constrain() {
        if (this.m_bndConstraint == null) {
            PsDebug.notify("boundary has no constraint");
            return true;
        }
        if (this.m_geom == null) {
            PsDebug.warning("missing element set.");
            return true;
        }
        PdVector pdVector = this.m_bndConstraint.m_start;
        PdVector pdVector2 = this.m_bndConstraint.m_dir;
        PdVector pdVector3 = this.m_bndConstraint.m_vec1;
        PdVector pdVector4 = this.m_bndConstraint.m_vec2;
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        if (this.m_bndConstraint.hasShape(4)) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToLine(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector, pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(5)) {
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToPlane(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector, pdVector2);
            }
        } else if (this.m_bndConstraint.hasShape(11)) {
            double d = pdVector3.dist(pdVector);
            for (int i = 0; i < this.m_numVertices; ++i) {
                PuVectorGeom.projectPointToCircle(pdVectorArray[this.m_vertexInd.m_data[i]], pdVectorArray[this.m_vertexInd.m_data[i]], pdVector3, pdVector4, d);
            }
        } else {
            PsDebug.warning("not implemented for this shape");
            return false;
        }
        this.assignVertices();
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

