/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.CSVParser;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class AbstractConverterPlugIn
implements Serializable,
PlugInListener {
    private static final long serialVersionUID = 5698511686417862414L;
    private static final ILogger log = LoggerFactory.getLogger(AbstractConverterPlugIn.class);
    private AbstractConverterPlugIn nextPlugIn = null;
    private String name;
    private boolean connected;
    protected Vector pluginListeners;
    private transient Vector InputVector;
    private String AdvancedSerieSelector = new String("");
    private transient int[] serieSelected;

    public AbstractConverterPlugIn() {
    }

    public AbstractConverterPlugIn(String anAdvancedSerieSelector) {
        this.setAdvancedSerieSelector(anAdvancedSerieSelector);
    }

    public void convertPatterns() {
        this.apply();
        this.cascade();
    }

    protected boolean apply() {
        boolean retValue = false;
        if (this.getInputVector() != null && this.getInputVector().size() > 0) {
            retValue = this.applyOnColumns() | this.applyOnRows();
        } else {
            log.warn(this.getName() + " : Plugin has no input data to convert.");
        }
        return retValue;
    }

    protected boolean applyOnColumns() {
        boolean retValue = false;
        Pattern currPE = (Pattern)this.getInputVector().elementAt(0);
        int aSize = currPE.getArray().length;
        if (this.getAdvancedSerieSelector() != null && !this.getAdvancedSerieSelector().equals(new String(""))) {
            int[] mySerieSelected = this.getSerieSelected();
            for (int i = 0; i < mySerieSelected.length; ++i) {
                if (mySerieSelected[i] - 1 < aSize) {
                    retValue = this.convert(mySerieSelected[i] - 1) | retValue;
                    continue;
                }
                log.warn(this.getName() + " : Advanced Serie Selector contains too many serie. Check the number of columns in the appropriate input synapse.");
            }
        }
        return retValue;
    }

    protected boolean applyOnRows() {
        return false;
    }

    protected void cascade() {
        if (this.getNextPlugIn() != null) {
            AbstractConverterPlugIn myPlugIn = this.getNextPlugIn();
            myPlugIn.setInputVector(this.getInputVector());
            myPlugIn.convertPatterns();
        }
    }

    protected abstract boolean convert(int var1);

    protected double getValuePoint(int point, int serie) {
        Pattern currPE = (Pattern)this.getInputVector().elementAt(point);
        return currPE.getArray()[serie];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean aConnected) {
        this.connected = aConnected;
    }

    public synchronized void addPlugInListener(PlugInListener aListener) {
        if (!this.getPluginListeners().contains(aListener)) {
            this.getPluginListeners().add(aListener);
        }
    }

    public synchronized void removePlugInListener(PlugInListener aListener) {
        if (this.getPluginListeners().contains(aListener)) {
            this.getPluginListeners().remove(aListener);
        }
    }

    protected Vector getPluginListeners() {
        if (this.pluginListeners == null) {
            this.pluginListeners = new Vector();
        }
        return this.pluginListeners;
    }

    @Override
    public void dataChanged(PlugInEvent anEvent) {
        this.fireDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        Object[] myList;
        AbstractConverterPlugIn abstractConverterPlugIn = this;
        synchronized (abstractConverterPlugIn) {
            myList = this.getPluginListeners().toArray();
        }
        for (int i = 0; i < myList.length; ++i) {
            PlugInListener myListener = (PlugInListener)myList[i];
            if (myListener == null) continue;
            myListener.dataChanged(new PlugInEvent(this));
        }
    }

    public String getAdvancedSerieSelector() {
        return this.AdvancedSerieSelector;
    }

    public void setAdvancedSerieSelector(String aNewSerieSelector) {
        if (this.AdvancedSerieSelector == null || this.AdvancedSerieSelector.compareTo(aNewSerieSelector) != 0) {
            this.AdvancedSerieSelector = aNewSerieSelector;
            this.serieSelected = null;
            this.fireDataChanged();
        }
    }

    protected int[] getSerieSelected() {
        if (this.serieSelected == null) {
            CSVParser myParser = new CSVParser(this.getAdvancedSerieSelector(), true);
            this.serieSelected = myParser.parseInt();
        }
        return this.serieSelected;
    }

    public boolean addPlugIn(AbstractConverterPlugIn aNewPlugIn) {
        if (this.nextPlugIn == aNewPlugIn) {
            return false;
        }
        if (aNewPlugIn == null) {
            if (this.nextPlugIn != null) {
                this.nextPlugIn.setConnected(false);
            }
            this.nextPlugIn = null;
            this.fireDataChanged();
            return true;
        }
        if (aNewPlugIn.isConnected()) {
            return false;
        }
        if (this.nextPlugIn == null) {
            aNewPlugIn.setConnected(true);
            aNewPlugIn.addPlugInListener(this);
            this.nextPlugIn = aNewPlugIn;
            this.fireDataChanged();
            return true;
        }
        return this.nextPlugIn.addPlugIn(aNewPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.nextPlugIn != null) {
            this.nextPlugIn.setConnected(false);
            this.nextPlugIn.removeAllPlugIns();
            this.nextPlugIn = null;
        } else {
            this.fireDataChanged();
        }
    }

    public boolean setNextPlugin(AbstractConverterPlugIn aNewNextPlugIn) {
        if (aNewNextPlugIn == this.nextPlugIn) {
            return false;
        }
        if (aNewNextPlugIn == null) {
            this.nextPlugIn.setConnected(false);
        } else {
            if (aNewNextPlugIn.isConnected()) {
                return false;
            }
            aNewNextPlugIn.setConnected(true);
            aNewNextPlugIn.addPlugInListener(this);
        }
        this.nextPlugIn = aNewNextPlugIn;
        this.fireDataChanged();
        return true;
    }

    public AbstractConverterPlugIn getNextPlugIn() {
        return this.nextPlugIn;
    }

    public void setNextPlugIn(AbstractConverterPlugIn newNextPlugIn) {
        this.addPlugIn(newNextPlugIn);
    }

    public void setInputVector(Vector newInputVector) {
        this.InputVector = newInputVector;
    }

    protected Vector getInputVector() {
        return this.InputVector;
    }

    public TreeSet check(TreeSet checks) {
        if (this.AdvancedSerieSelector == null || this.AdvancedSerieSelector.equals(new String(""))) {
            checks.add(new NetCheck(0, "Advanced Serie Selector should be populated, e.g 1,2,4.", this));
        }
        if (this.getNextPlugIn() != null) {
            this.getNextPlugIn().check(checks);
        }
        return checks;
    }

    protected int getSerieIndexNumber(int serie) {
        CSVParser Parse = new CSVParser(this.getAdvancedSerieSelector(), true);
        int[] checker = Parse.parseInt();
        for (int i = 0; i < checker.length; ++i) {
            if (checker[i] != serie + 1) continue;
            return i;
        }
        return -1;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getAdvancedSerieSelector() == null) {
            this.setAdvancedSerieSelector(new String("1"));
        }
    }
}

