/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.helpers;

import org.joone.helpers.factory.JooneTools;
import org.joone.net.NeuralNet;

public class XOR_using_helpers {
    private static double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private static double[][] desiredArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}};
    private static boolean singleThreadMode = true;

    public static void main(String[] args) {
        try {
            NeuralNet nnet = JooneTools.create_standard(new int[]{2, 2, 1}, 2);
            nnet.getMonitor().setSingleThreadMode(singleThreadMode);
            double rmse = JooneTools.train(nnet, inputArray, desiredArray, 5000, 0.01, 200, System.out, false);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Last RMSE = " + rmse);
            System.out.println("\nResults:");
            System.out.println("|Inp 1\t|Inp 2\t|Output");
            for (int i = 0; i < 4; ++i) {
                double[] output = JooneTools.interrogate(nnet, inputArray[i]);
                System.out.print("| " + inputArray[i][0] + "\t| " + inputArray[i][1] + "\t| ");
                System.out.println(output[0]);
            }
            double testRMSE = JooneTools.test(nnet, inputArray, desiredArray);
            System.out.println("\nTest error = " + testRMSE);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

