/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.editor.som;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.joone.engine.Pattern;
import org.joone.samples.editor.som.CoordGenerator;
import org.joone.samples.editor.som.myChart;

public class ChartOutputSample
extends JFrame {
    private Vector coords;
    private boolean alone;
    String fileName = "/tmp/coords.txt";
    private JMenuItem aboutMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JMenuBar menuBar;
    private JMenuItem newMenuItem;
    private JMenuItem saveMenuItem;

    public ChartOutputSample() {
        this(false);
    }

    public ChartOutputSample(boolean main) {
        this.alone = main;
        this.initComponents();
        try {
            Iconkit kit = new Iconkit(this);
            kit = Iconkit.instance();
            Thread.sleep(3000L);
            kit = Iconkit.instance();
            if (kit == null) {
                throw new HJDError("Iconkit instance isn't set");
            }
            Image image = kit.loadImageResource("/org/joone/images/jooneIcon.gif");
        }
        catch (InterruptedException kit) {
            // empty catch block
        }
        this.coords = new Vector();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                System.out.println("x=" + e.getX() + " y=" + e.getY());
                int[] cc = new int[]{e.getX(), e.getY()};
                ChartOutputSample.this.coords.addElement(cc);
                ChartOutputSample.this.repaint();
            }
        });
        int count = 1;
        myChart chart = new myChart();
        chart.setMaxYaxis(0.2);
        chart.setMaxXaxis(1000);
        this.jPanel1.add(chart.myFrame().getContentPane());
        double[] arr = new double[]{0.1};
        Pattern patt = new Pattern();
        patt.setArray(arr);
        patt.setCount(count);
        chart.fwdPut(patt);
        this.setSize(640, 480);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ChartOutputSample.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.fileMenu.setText("File");
        this.fileMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartOutputSample.this.fileMenuActionPerformed(evt);
            }
        });
        this.newMenuItem.setText("New");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartOutputSample.this.newMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartOutputSample.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartOutputSample.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartOutputSample.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        String help1 = new String("This application allows the user to plot a figure for recognition by a Joone neural network.");
        String help2 = new String("It is intended to test a SOM or Kohonen Network by providing an image recognition example.");
        String help3 = new String("Draw a whatever figure clicking on the drawing area, and then save the figure into a file.");
        String help4 = new String("The saved file must be used as input of the figureRecognition.ser neural network.");
        JOptionPane.showMessageDialog(this, help1 + "\n" + help2 + "\n" + help3 + "\n" + help4);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        try {
            FileWriter fw = new FileWriter(this.fileName);
            for (int x = 0; x < this.coords.size(); ++x) {
                int[] cc = (int[])this.coords.elementAt(x);
                fw.write(Integer.toString(cc[0]) + ";");
                fw.write(Integer.toString(cc[1]) + "\n");
            }
            fw.close();
            System.out.println("Written " + this.coords.size() + " coords");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void newMenuItemActionPerformed(ActionEvent evt) {
        this.coords = new Vector();
        this.repaint();
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.exitTester();
    }

    private void exitForm(WindowEvent evt) {
        this.exitTester();
    }

    private void exitTester() {
        if (this.alone) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public static void main(String[] args) {
        new CoordGenerator(true).show();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        for (int x = 0; x < this.coords.size(); ++x) {
            int[] cc = (int[])this.coords.elementAt(x);
            g.fillOval(cc[0], cc[1], 3, 3);
        }
    }
}

