/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.ImageInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ImageInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ImageInputSynapse.class);
    static final long serialVersionUID = -1396287146739057882L;
    private File imageDirectory = new File(System.getProperty("user.dir"));
    private String theFileFilter = new String(".*[jJ][pP][gG]");
    private Vector FileNameList = new Vector();
    private Image[] MultiImages = null;
    private int DesiredWidth = 10;
    private int DesiredHeight = 10;
    private boolean ColourMode = true;

    public ImageInputSynapse() {
        this.calculateNewACS();
    }

    public void setFileFilter(String newFileFilter) {
        this.theFileFilter = newFileFilter;
    }

    public String getFileFilter() {
        return this.theFileFilter;
    }

    public void setImageInput(Image[] theImages) {
        this.MultiImages = theImages;
    }

    @Override
    protected void initInputStream() throws JooneRuntimeException {
        ImageInputTokenizer toks = null;
        try {
            if (this.MultiImages != null && this.MultiImages.length > 0) {
                toks = new ImageInputTokenizer(this.getDesiredWidth(), this.getDesiredHeight(), this.MultiImages, this.ColourMode);
                super.setTokens(toks);
            } else {
                this.FileNameList = new Vector();
                String[] thelist = this.imageDirectory.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches(ImageInputSynapse.this.theFileFilter);
                    }
                });
                for (int i = 0; i < thelist.length; ++i) {
                    URL theurl = new File(this.imageDirectory.getPath() + System.getProperty("file.separator") + thelist[i]).toURL();
                    this.FileNameList.add(theurl);
                }
                toks = new ImageInputTokenizer(this.getDesiredWidth(), this.getDesiredHeight(), this.FileNameList, this.ColourMode);
                super.setTokens(toks);
            }
        }
        catch (Exception ex) {
            log.error("Error initialising the input stream : " + ex.toString());
        }
    }

    public int getDesiredWidth() {
        return this.DesiredWidth;
    }

    public void setDesiredWidth(int DesiredWidth) {
        this.DesiredWidth = DesiredWidth;
        this.calculateNewACS();
    }

    public int getDesiredHeight() {
        return this.DesiredHeight;
    }

    public void setDesiredHeight(int DesiredHeight) {
        this.DesiredHeight = DesiredHeight;
        this.calculateNewACS();
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public void setImageDirectory(File imgDir) {
        File tmpDir = imgDir;
        if (tmpDir != null && !tmpDir.isDirectory()) {
            String name = tmpDir.getName();
            int pos = tmpDir.getPath().indexOf(name);
            if (pos > -1) {
                String dir = tmpDir.getPath().substring(0, pos);
                tmpDir = new File(dir);
            }
        }
        this.imageDirectory = tmpDir;
    }

    public boolean getColourMode() {
        return this.ColourMode;
    }

    public void setColourMode(boolean ColourMode) {
        this.ColourMode = ColourMode;
        this.calculateNewACS();
    }

    @Override
    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.theFileFilter.equals("")) {
            checks.add(new NetCheck(0, "No File Filter set e.g. '.*[jJ][pP][gG]'.", this));
        }
        if (this.imageDirectory == null) {
            checks.add(new NetCheck(0, "No image input directory set.", this));
        }
        return checks;
    }

    protected void calculateNewACS() {
        int tokens = this.DesiredWidth * this.DesiredHeight;
        if (this.ColourMode) {
            tokens *= 3;
        }
        this.setAdvancedColumnSelector("1-" + tokens);
    }
}

